/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary description of the cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClusterSummary implements SdkPojo, Serializable, ToCopyableBuilder<ClusterSummary.Builder, ClusterSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(ClusterSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ClusterSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<ClusterStatus> STATUS_FIELD = SdkField.<ClusterStatus> builder(MarshallingType.SDK_POJO)
            .memberName("Status").getter(getter(ClusterSummary::status)).setter(setter(Builder::status))
            .constructor(ClusterStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Integer> NORMALIZED_INSTANCE_HOURS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NormalizedInstanceHours").getter(getter(ClusterSummary::normalizedInstanceHours))
            .setter(setter(Builder::normalizedInstanceHours))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NormalizedInstanceHours").build())
            .build();

    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterArn").getter(getter(ClusterSummary::clusterArn)).setter(setter(Builder::clusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterArn").build()).build();

    private static final SdkField<String> OUTPOST_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutpostArn").getter(getter(ClusterSummary::outpostArn)).setter(setter(Builder::outpostArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            STATUS_FIELD, NORMALIZED_INSTANCE_HOURS_FIELD, CLUSTER_ARN_FIELD, OUTPOST_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final ClusterStatus status;

    private final Integer normalizedInstanceHours;

    private final String clusterArn;

    private final String outpostArn;

    private ClusterSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.status = builder.status;
        this.normalizedInstanceHours = builder.normalizedInstanceHours;
        this.clusterArn = builder.clusterArn;
        this.outpostArn = builder.outpostArn;
    }

    /**
     * <p>
     * The unique identifier for the cluster.
     * </p>
     * 
     * @return The unique identifier for the cluster.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the cluster.
     * </p>
     * 
     * @return The name of the cluster.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The details about the current status of the cluster.
     * </p>
     * 
     * @return The details about the current status of the cluster.
     */
    public final ClusterStatus status() {
        return status;
    }

    /**
     * <p>
     * An approximation of the cost of the cluster, represented in m1.small/hours. This value is incremented one time
     * for every hour an m1.small instance runs. Larger instances are weighted more, so an Amazon EC2 instance that is
     * roughly four times more expensive would result in the normalized instance hours being incremented by four. This
     * result is only an approximation and does not reflect the actual billing rate.
     * </p>
     * 
     * @return An approximation of the cost of the cluster, represented in m1.small/hours. This value is incremented one
     *         time for every hour an m1.small instance runs. Larger instances are weighted more, so an Amazon EC2
     *         instance that is roughly four times more expensive would result in the normalized instance hours being
     *         incremented by four. This result is only an approximation and does not reflect the actual billing rate.
     */
    public final Integer normalizedInstanceHours() {
        return normalizedInstanceHours;
    }

    /**
     * <p>
     * The Amazon Resource Name of the cluster.
     * </p>
     * 
     * @return The Amazon Resource Name of the cluster.
     */
    public final String clusterArn() {
        return clusterArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Outpost where the cluster is launched.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Outpost where the cluster is launched.
     */
    public final String outpostArn() {
        return outpostArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(normalizedInstanceHours());
        hashCode = 31 * hashCode + Objects.hashCode(clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(outpostArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterSummary)) {
            return false;
        }
        ClusterSummary other = (ClusterSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(status(), other.status())
                && Objects.equals(normalizedInstanceHours(), other.normalizedInstanceHours())
                && Objects.equals(clusterArn(), other.clusterArn()) && Objects.equals(outpostArn(), other.outpostArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClusterSummary").add("Id", id()).add("Name", name()).add("Status", status())
                .add("NormalizedInstanceHours", normalizedInstanceHours()).add("ClusterArn", clusterArn())
                .add("OutpostArn", outpostArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "NormalizedInstanceHours":
            return Optional.ofNullable(clazz.cast(normalizedInstanceHours()));
        case "ClusterArn":
            return Optional.ofNullable(clazz.cast(clusterArn()));
        case "OutpostArn":
            return Optional.ofNullable(clazz.cast(outpostArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClusterSummary, T> g) {
        return obj -> g.apply((ClusterSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClusterSummary> {
        /**
         * <p>
         * The unique identifier for the cluster.
         * </p>
         * 
         * @param id
         *        The unique identifier for the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the cluster.
         * </p>
         * 
         * @param name
         *        The name of the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The details about the current status of the cluster.
         * </p>
         * 
         * @param status
         *        The details about the current status of the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(ClusterStatus status);

        /**
         * <p>
         * The details about the current status of the cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClusterStatus.Builder} avoiding the need
         * to create one manually via {@link ClusterStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClusterStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #status(ClusterStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link ClusterStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(ClusterStatus)
         */
        default Builder status(Consumer<ClusterStatus.Builder> status) {
            return status(ClusterStatus.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * An approximation of the cost of the cluster, represented in m1.small/hours. This value is incremented one
         * time for every hour an m1.small instance runs. Larger instances are weighted more, so an Amazon EC2 instance
         * that is roughly four times more expensive would result in the normalized instance hours being incremented by
         * four. This result is only an approximation and does not reflect the actual billing rate.
         * </p>
         * 
         * @param normalizedInstanceHours
         *        An approximation of the cost of the cluster, represented in m1.small/hours. This value is incremented
         *        one time for every hour an m1.small instance runs. Larger instances are weighted more, so an Amazon
         *        EC2 instance that is roughly four times more expensive would result in the normalized instance hours
         *        being incremented by four. This result is only an approximation and does not reflect the actual
         *        billing rate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder normalizedInstanceHours(Integer normalizedInstanceHours);

        /**
         * <p>
         * The Amazon Resource Name of the cluster.
         * </p>
         * 
         * @param clusterArn
         *        The Amazon Resource Name of the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterArn(String clusterArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Outpost where the cluster is launched.
         * </p>
         * 
         * @param outpostArn
         *        The Amazon Resource Name (ARN) of the Outpost where the cluster is launched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostArn(String outpostArn);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private ClusterStatus status;

        private Integer normalizedInstanceHours;

        private String clusterArn;

        private String outpostArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterSummary model) {
            id(model.id);
            name(model.name);
            status(model.status);
            normalizedInstanceHours(model.normalizedInstanceHours);
            clusterArn(model.clusterArn);
            outpostArn(model.outpostArn);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ClusterStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(ClusterStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(ClusterStatus status) {
            this.status = status;
            return this;
        }

        public final Integer getNormalizedInstanceHours() {
            return normalizedInstanceHours;
        }

        public final void setNormalizedInstanceHours(Integer normalizedInstanceHours) {
            this.normalizedInstanceHours = normalizedInstanceHours;
        }

        @Override
        public final Builder normalizedInstanceHours(Integer normalizedInstanceHours) {
            this.normalizedInstanceHours = normalizedInstanceHours;
            return this;
        }

        public final String getClusterArn() {
            return clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final String getOutpostArn() {
            return outpostArn;
        }

        public final void setOutpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
        }

        @Override
        public final Builder outpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
            return this;
        }

        @Override
        public ClusterSummary build() {
            return new ClusterSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
