/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for the parameters to the <code><a>CreateOutboundCrossClusterSearchConnection</a></code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateOutboundCrossClusterSearchConnectionRequest extends ElasticsearchRequest
        implements
        ToCopyableBuilder<CreateOutboundCrossClusterSearchConnectionRequest.Builder, CreateOutboundCrossClusterSearchConnectionRequest> {
    private static final SdkField<DomainInformation> SOURCE_DOMAIN_INFO_FIELD = SdkField
            .<DomainInformation> builder(MarshallingType.SDK_POJO).memberName("SourceDomainInfo")
            .getter(getter(CreateOutboundCrossClusterSearchConnectionRequest::sourceDomainInfo))
            .setter(setter(Builder::sourceDomainInfo)).constructor(DomainInformation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDomainInfo").build()).build();

    private static final SdkField<DomainInformation> DESTINATION_DOMAIN_INFO_FIELD = SdkField
            .<DomainInformation> builder(MarshallingType.SDK_POJO).memberName("DestinationDomainInfo")
            .getter(getter(CreateOutboundCrossClusterSearchConnectionRequest::destinationDomainInfo))
            .setter(setter(Builder::destinationDomainInfo)).constructor(DomainInformation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationDomainInfo").build())
            .build();

    private static final SdkField<String> CONNECTION_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionAlias").getter(getter(CreateOutboundCrossClusterSearchConnectionRequest::connectionAlias))
            .setter(setter(Builder::connectionAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionAlias").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_DOMAIN_INFO_FIELD,
            DESTINATION_DOMAIN_INFO_FIELD, CONNECTION_ALIAS_FIELD));

    private final DomainInformation sourceDomainInfo;

    private final DomainInformation destinationDomainInfo;

    private final String connectionAlias;

    private CreateOutboundCrossClusterSearchConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.sourceDomainInfo = builder.sourceDomainInfo;
        this.destinationDomainInfo = builder.destinationDomainInfo;
        this.connectionAlias = builder.connectionAlias;
    }

    /**
     * <p>
     * Specifies the <code><a>DomainInformation</a></code> for the source Elasticsearch domain.
     * </p>
     * 
     * @return Specifies the <code><a>DomainInformation</a></code> for the source Elasticsearch domain.
     */
    public final DomainInformation sourceDomainInfo() {
        return sourceDomainInfo;
    }

    /**
     * <p>
     * Specifies the <code><a>DomainInformation</a></code> for the destination Elasticsearch domain.
     * </p>
     * 
     * @return Specifies the <code><a>DomainInformation</a></code> for the destination Elasticsearch domain.
     */
    public final DomainInformation destinationDomainInfo() {
        return destinationDomainInfo;
    }

    /**
     * <p>
     * Specifies the connection alias that will be used by the customer for this connection.
     * </p>
     * 
     * @return Specifies the connection alias that will be used by the customer for this connection.
     */
    public final String connectionAlias() {
        return connectionAlias;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sourceDomainInfo());
        hashCode = 31 * hashCode + Objects.hashCode(destinationDomainInfo());
        hashCode = 31 * hashCode + Objects.hashCode(connectionAlias());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOutboundCrossClusterSearchConnectionRequest)) {
            return false;
        }
        CreateOutboundCrossClusterSearchConnectionRequest other = (CreateOutboundCrossClusterSearchConnectionRequest) obj;
        return Objects.equals(sourceDomainInfo(), other.sourceDomainInfo())
                && Objects.equals(destinationDomainInfo(), other.destinationDomainInfo())
                && Objects.equals(connectionAlias(), other.connectionAlias());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateOutboundCrossClusterSearchConnectionRequest").add("SourceDomainInfo", sourceDomainInfo())
                .add("DestinationDomainInfo", destinationDomainInfo()).add("ConnectionAlias", connectionAlias()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceDomainInfo":
            return Optional.ofNullable(clazz.cast(sourceDomainInfo()));
        case "DestinationDomainInfo":
            return Optional.ofNullable(clazz.cast(destinationDomainInfo()));
        case "ConnectionAlias":
            return Optional.ofNullable(clazz.cast(connectionAlias()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateOutboundCrossClusterSearchConnectionRequest, T> g) {
        return obj -> g.apply((CreateOutboundCrossClusterSearchConnectionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticsearchRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateOutboundCrossClusterSearchConnectionRequest> {
        /**
         * <p>
         * Specifies the <code><a>DomainInformation</a></code> for the source Elasticsearch domain.
         * </p>
         * 
         * @param sourceDomainInfo
         *        Specifies the <code><a>DomainInformation</a></code> for the source Elasticsearch domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDomainInfo(DomainInformation sourceDomainInfo);

        /**
         * <p>
         * Specifies the <code><a>DomainInformation</a></code> for the source Elasticsearch domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link DomainInformation.Builder} avoiding the
         * need to create one manually via {@link DomainInformation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DomainInformation.Builder#build()} is called immediately and its
         * result is passed to {@link #sourceDomainInfo(DomainInformation)}.
         * 
         * @param sourceDomainInfo
         *        a consumer that will call methods on {@link DomainInformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceDomainInfo(DomainInformation)
         */
        default Builder sourceDomainInfo(Consumer<DomainInformation.Builder> sourceDomainInfo) {
            return sourceDomainInfo(DomainInformation.builder().applyMutation(sourceDomainInfo).build());
        }

        /**
         * <p>
         * Specifies the <code><a>DomainInformation</a></code> for the destination Elasticsearch domain.
         * </p>
         * 
         * @param destinationDomainInfo
         *        Specifies the <code><a>DomainInformation</a></code> for the destination Elasticsearch domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationDomainInfo(DomainInformation destinationDomainInfo);

        /**
         * <p>
         * Specifies the <code><a>DomainInformation</a></code> for the destination Elasticsearch domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link DomainInformation.Builder} avoiding the
         * need to create one manually via {@link DomainInformation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DomainInformation.Builder#build()} is called immediately and its
         * result is passed to {@link #destinationDomainInfo(DomainInformation)}.
         * 
         * @param destinationDomainInfo
         *        a consumer that will call methods on {@link DomainInformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationDomainInfo(DomainInformation)
         */
        default Builder destinationDomainInfo(Consumer<DomainInformation.Builder> destinationDomainInfo) {
            return destinationDomainInfo(DomainInformation.builder().applyMutation(destinationDomainInfo).build());
        }

        /**
         * <p>
         * Specifies the connection alias that will be used by the customer for this connection.
         * </p>
         * 
         * @param connectionAlias
         *        Specifies the connection alias that will be used by the customer for this connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionAlias(String connectionAlias);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticsearchRequest.BuilderImpl implements Builder {
        private DomainInformation sourceDomainInfo;

        private DomainInformation destinationDomainInfo;

        private String connectionAlias;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOutboundCrossClusterSearchConnectionRequest model) {
            super(model);
            sourceDomainInfo(model.sourceDomainInfo);
            destinationDomainInfo(model.destinationDomainInfo);
            connectionAlias(model.connectionAlias);
        }

        public final DomainInformation.Builder getSourceDomainInfo() {
            return sourceDomainInfo != null ? sourceDomainInfo.toBuilder() : null;
        }

        public final void setSourceDomainInfo(DomainInformation.BuilderImpl sourceDomainInfo) {
            this.sourceDomainInfo = sourceDomainInfo != null ? sourceDomainInfo.build() : null;
        }

        @Override
        public final Builder sourceDomainInfo(DomainInformation sourceDomainInfo) {
            this.sourceDomainInfo = sourceDomainInfo;
            return this;
        }

        public final DomainInformation.Builder getDestinationDomainInfo() {
            return destinationDomainInfo != null ? destinationDomainInfo.toBuilder() : null;
        }

        public final void setDestinationDomainInfo(DomainInformation.BuilderImpl destinationDomainInfo) {
            this.destinationDomainInfo = destinationDomainInfo != null ? destinationDomainInfo.build() : null;
        }

        @Override
        public final Builder destinationDomainInfo(DomainInformation destinationDomainInfo) {
            this.destinationDomainInfo = destinationDomainInfo;
            return this;
        }

        public final String getConnectionAlias() {
            return connectionAlias;
        }

        public final void setConnectionAlias(String connectionAlias) {
            this.connectionAlias = connectionAlias;
        }

        @Override
        public final Builder connectionAlias(String connectionAlias) {
            this.connectionAlias = connectionAlias;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateOutboundCrossClusterSearchConnectionRequest build() {
            return new CreateOutboundCrossClusterSearchConnectionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
