/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticsearch.ElasticsearchClient;
import software.amazon.awssdk.services.elasticsearch.model.ListPackagesForDomainRequest;
import software.amazon.awssdk.services.elasticsearch.model.ListPackagesForDomainResponse;

public class ListPackagesForDomainIterable
implements SdkIterable<ListPackagesForDomainResponse> {
    private final ElasticsearchClient client;
    private final ListPackagesForDomainRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPackagesForDomainIterable(ElasticsearchClient client, ListPackagesForDomainRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListPackagesForDomainResponseFetcher();
    }

    public Iterator<ListPackagesForDomainResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListPackagesForDomainResponseFetcher
    implements SyncPageFetcher<ListPackagesForDomainResponse> {
        private ListPackagesForDomainResponseFetcher() {
        }

        public boolean hasNextPage(ListPackagesForDomainResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPackagesForDomainResponse nextPage(ListPackagesForDomainResponse previousPage) {
            if (previousPage == null) {
                return ListPackagesForDomainIterable.this.client.listPackagesForDomain(ListPackagesForDomainIterable.this.firstRequest);
            }
            return ListPackagesForDomainIterable.this.client.listPackagesForDomain((ListPackagesForDomainRequest)((Object)ListPackagesForDomainIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

