/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.ManagedActionHistoryItem;
import software.amazon.awssdk.services.elasticbeanstalk.model.ManagedActionHistoryItemsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEnvironmentManagedActionHistoryResponse
extends ElasticBeanstalkResponse
implements ToCopyableBuilder<Builder, DescribeEnvironmentManagedActionHistoryResponse> {
    private static final SdkField<List<ManagedActionHistoryItem>> MANAGED_ACTION_HISTORY_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ManagedActionHistoryItems").getter(DescribeEnvironmentManagedActionHistoryResponse.getter(DescribeEnvironmentManagedActionHistoryResponse::managedActionHistoryItems)).setter(DescribeEnvironmentManagedActionHistoryResponse.setter(Builder::managedActionHistoryItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedActionHistoryItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ManagedActionHistoryItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeEnvironmentManagedActionHistoryResponse.getter(DescribeEnvironmentManagedActionHistoryResponse::nextToken)).setter(DescribeEnvironmentManagedActionHistoryResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANAGED_ACTION_HISTORY_ITEMS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ManagedActionHistoryItem> managedActionHistoryItems;
    private final String nextToken;

    private DescribeEnvironmentManagedActionHistoryResponse(BuilderImpl builder) {
        super(builder);
        this.managedActionHistoryItems = builder.managedActionHistoryItems;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasManagedActionHistoryItems() {
        return this.managedActionHistoryItems != null && !(this.managedActionHistoryItems instanceof SdkAutoConstructList);
    }

    public final List<ManagedActionHistoryItem> managedActionHistoryItems() {
        return this.managedActionHistoryItems;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasManagedActionHistoryItems() ? this.managedActionHistoryItems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEnvironmentManagedActionHistoryResponse)) {
            return false;
        }
        DescribeEnvironmentManagedActionHistoryResponse other = (DescribeEnvironmentManagedActionHistoryResponse)((Object)obj);
        return this.hasManagedActionHistoryItems() == other.hasManagedActionHistoryItems() && Objects.equals(this.managedActionHistoryItems(), other.managedActionHistoryItems()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeEnvironmentManagedActionHistoryResponse").add("ManagedActionHistoryItems", this.hasManagedActionHistoryItems() ? this.managedActionHistoryItems() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ManagedActionHistoryItems": {
                return Optional.ofNullable(clazz.cast(this.managedActionHistoryItems()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEnvironmentManagedActionHistoryResponse, T> g) {
        return obj -> g.apply((DescribeEnvironmentManagedActionHistoryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticBeanstalkResponse.BuilderImpl
    implements Builder {
        private List<ManagedActionHistoryItem> managedActionHistoryItems = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEnvironmentManagedActionHistoryResponse model) {
            super(model);
            this.managedActionHistoryItems(model.managedActionHistoryItems);
            this.nextToken(model.nextToken);
        }

        public final List<ManagedActionHistoryItem.Builder> getManagedActionHistoryItems() {
            List<ManagedActionHistoryItem.Builder> result = ManagedActionHistoryItemsCopier.copyToBuilder(this.managedActionHistoryItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setManagedActionHistoryItems(Collection<ManagedActionHistoryItem.BuilderImpl> managedActionHistoryItems) {
            this.managedActionHistoryItems = ManagedActionHistoryItemsCopier.copyFromBuilder(managedActionHistoryItems);
        }

        @Override
        public final Builder managedActionHistoryItems(Collection<ManagedActionHistoryItem> managedActionHistoryItems) {
            this.managedActionHistoryItems = ManagedActionHistoryItemsCopier.copy(managedActionHistoryItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedActionHistoryItems(ManagedActionHistoryItem ... managedActionHistoryItems) {
            this.managedActionHistoryItems(Arrays.asList(managedActionHistoryItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedActionHistoryItems(Consumer<ManagedActionHistoryItem.Builder> ... managedActionHistoryItems) {
            this.managedActionHistoryItems(Stream.of(managedActionHistoryItems).map(c -> (ManagedActionHistoryItem)((ManagedActionHistoryItem.Builder)ManagedActionHistoryItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeEnvironmentManagedActionHistoryResponse build() {
            return new DescribeEnvironmentManagedActionHistoryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticBeanstalkResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeEnvironmentManagedActionHistoryResponse> {
        public Builder managedActionHistoryItems(Collection<ManagedActionHistoryItem> var1);

        public Builder managedActionHistoryItems(ManagedActionHistoryItem ... var1);

        public Builder managedActionHistoryItems(Consumer<ManagedActionHistoryItem.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

