/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>DescribeCacheClusters</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCacheClustersRequest extends ElastiCacheRequest implements
        ToCopyableBuilder<DescribeCacheClustersRequest.Builder, DescribeCacheClustersRequest> {
    private static final SdkField<String> CACHE_CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CacheClusterId").getter(getter(DescribeCacheClustersRequest::cacheClusterId))
            .setter(setter(Builder::cacheClusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheClusterId").build()).build();

    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxRecords").getter(getter(DescribeCacheClustersRequest::maxRecords))
            .setter(setter(Builder::maxRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeCacheClustersRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<Boolean> SHOW_CACHE_NODE_INFO_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ShowCacheNodeInfo").getter(getter(DescribeCacheClustersRequest::showCacheNodeInfo))
            .setter(setter(Builder::showCacheNodeInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShowCacheNodeInfo").build()).build();

    private static final SdkField<Boolean> SHOW_CACHE_CLUSTERS_NOT_IN_REPLICATION_GROUPS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ShowCacheClustersNotInReplicationGroups")
            .getter(getter(DescribeCacheClustersRequest::showCacheClustersNotInReplicationGroups))
            .setter(setter(Builder::showCacheClustersNotInReplicationGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ShowCacheClustersNotInReplicationGroups").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CACHE_CLUSTER_ID_FIELD,
            MAX_RECORDS_FIELD, MARKER_FIELD, SHOW_CACHE_NODE_INFO_FIELD, SHOW_CACHE_CLUSTERS_NOT_IN_REPLICATION_GROUPS_FIELD));

    private final String cacheClusterId;

    private final Integer maxRecords;

    private final String marker;

    private final Boolean showCacheNodeInfo;

    private final Boolean showCacheClustersNotInReplicationGroups;

    private DescribeCacheClustersRequest(BuilderImpl builder) {
        super(builder);
        this.cacheClusterId = builder.cacheClusterId;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
        this.showCacheNodeInfo = builder.showCacheNodeInfo;
        this.showCacheClustersNotInReplicationGroups = builder.showCacheClustersNotInReplicationGroups;
    }

    /**
     * <p>
     * The user-supplied cluster identifier. If this parameter is specified, only information about that specific
     * cluster is returned. This parameter isn't case sensitive.
     * </p>
     * 
     * @return The user-supplied cluster identifier. If this parameter is specified, only information about that
     *         specific cluster is returned. This parameter isn't case sensitive.
     */
    public final String cacheClusterId() {
        return cacheClusterId;
    }

    /**
     * <p>
     * The maximum number of records to include in the response. If more records exist than the specified
     * <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be
     * retrieved.
     * </p>
     * <p>
     * Default: 100
     * </p>
     * <p>
     * Constraints: minimum 20; maximum 100.
     * </p>
     * 
     * @return The maximum number of records to include in the response. If more records exist than the specified
     *         <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be
     *         retrieved.</p>
     *         <p>
     *         Default: 100
     *         </p>
     *         <p>
     *         Constraints: minimum 20; maximum 100.
     */
    public final Integer maxRecords() {
        return maxRecords;
    }

    /**
     * <p>
     * An optional marker returned from a prior request. Use this marker for pagination of results from this operation.
     * If this parameter is specified, the response includes only records beyond the marker, up to the value specified
     * by <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional marker returned from a prior request. Use this marker for pagination of results from this
     *         operation. If this parameter is specified, the response includes only records beyond the marker, up to
     *         the value specified by <code>MaxRecords</code>.
     */
    public final String marker() {
        return marker;
    }

    /**
     * <p>
     * An optional flag that can be included in the <code>DescribeCacheCluster</code> request to retrieve information
     * about the individual cache nodes.
     * </p>
     * 
     * @return An optional flag that can be included in the <code>DescribeCacheCluster</code> request to retrieve
     *         information about the individual cache nodes.
     */
    public final Boolean showCacheNodeInfo() {
        return showCacheNodeInfo;
    }

    /**
     * <p>
     * An optional flag that can be included in the <code>DescribeCacheCluster</code> request to show only nodes
     * (API/CLI: clusters) that are not members of a replication group. In practice, this mean Memcached and single node
     * Redis clusters.
     * </p>
     * 
     * @return An optional flag that can be included in the <code>DescribeCacheCluster</code> request to show only nodes
     *         (API/CLI: clusters) that are not members of a replication group. In practice, this mean Memcached and
     *         single node Redis clusters.
     */
    public final Boolean showCacheClustersNotInReplicationGroups() {
        return showCacheClustersNotInReplicationGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cacheClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(showCacheNodeInfo());
        hashCode = 31 * hashCode + Objects.hashCode(showCacheClustersNotInReplicationGroups());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCacheClustersRequest)) {
            return false;
        }
        DescribeCacheClustersRequest other = (DescribeCacheClustersRequest) obj;
        return Objects.equals(cacheClusterId(), other.cacheClusterId()) && Objects.equals(maxRecords(), other.maxRecords())
                && Objects.equals(marker(), other.marker()) && Objects.equals(showCacheNodeInfo(), other.showCacheNodeInfo())
                && Objects.equals(showCacheClustersNotInReplicationGroups(), other.showCacheClustersNotInReplicationGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeCacheClustersRequest").add("CacheClusterId", cacheClusterId())
                .add("MaxRecords", maxRecords()).add("Marker", marker()).add("ShowCacheNodeInfo", showCacheNodeInfo())
                .add("ShowCacheClustersNotInReplicationGroups", showCacheClustersNotInReplicationGroups()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CacheClusterId":
            return Optional.ofNullable(clazz.cast(cacheClusterId()));
        case "MaxRecords":
            return Optional.ofNullable(clazz.cast(maxRecords()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "ShowCacheNodeInfo":
            return Optional.ofNullable(clazz.cast(showCacheNodeInfo()));
        case "ShowCacheClustersNotInReplicationGroups":
            return Optional.ofNullable(clazz.cast(showCacheClustersNotInReplicationGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCacheClustersRequest, T> g) {
        return obj -> g.apply((DescribeCacheClustersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeCacheClustersRequest> {
        /**
         * <p>
         * The user-supplied cluster identifier. If this parameter is specified, only information about that specific
         * cluster is returned. This parameter isn't case sensitive.
         * </p>
         * 
         * @param cacheClusterId
         *        The user-supplied cluster identifier. If this parameter is specified, only information about that
         *        specific cluster is returned. This parameter isn't case sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheClusterId(String cacheClusterId);

        /**
         * <p>
         * The maximum number of records to include in the response. If more records exist than the specified
         * <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be
         * retrieved.
         * </p>
         * <p>
         * Default: 100
         * </p>
         * <p>
         * Constraints: minimum 20; maximum 100.
         * </p>
         * 
         * @param maxRecords
         *        The maximum number of records to include in the response. If more records exist than the specified
         *        <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can
         *        be retrieved.</p>
         *        <p>
         *        Default: 100
         *        </p>
         *        <p>
         *        Constraints: minimum 20; maximum 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);

        /**
         * <p>
         * An optional marker returned from a prior request. Use this marker for pagination of results from this
         * operation. If this parameter is specified, the response includes only records beyond the marker, up to the
         * value specified by <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        An optional marker returned from a prior request. Use this marker for pagination of results from this
         *        operation. If this parameter is specified, the response includes only records beyond the marker, up to
         *        the value specified by <code>MaxRecords</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * An optional flag that can be included in the <code>DescribeCacheCluster</code> request to retrieve
         * information about the individual cache nodes.
         * </p>
         * 
         * @param showCacheNodeInfo
         *        An optional flag that can be included in the <code>DescribeCacheCluster</code> request to retrieve
         *        information about the individual cache nodes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder showCacheNodeInfo(Boolean showCacheNodeInfo);

        /**
         * <p>
         * An optional flag that can be included in the <code>DescribeCacheCluster</code> request to show only nodes
         * (API/CLI: clusters) that are not members of a replication group. In practice, this mean Memcached and single
         * node Redis clusters.
         * </p>
         * 
         * @param showCacheClustersNotInReplicationGroups
         *        An optional flag that can be included in the <code>DescribeCacheCluster</code> request to show only
         *        nodes (API/CLI: clusters) that are not members of a replication group. In practice, this mean
         *        Memcached and single node Redis clusters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder showCacheClustersNotInReplicationGroups(Boolean showCacheClustersNotInReplicationGroups);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElastiCacheRequest.BuilderImpl implements Builder {
        private String cacheClusterId;

        private Integer maxRecords;

        private String marker;

        private Boolean showCacheNodeInfo;

        private Boolean showCacheClustersNotInReplicationGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCacheClustersRequest model) {
            super(model);
            cacheClusterId(model.cacheClusterId);
            maxRecords(model.maxRecords);
            marker(model.marker);
            showCacheNodeInfo(model.showCacheNodeInfo);
            showCacheClustersNotInReplicationGroups(model.showCacheClustersNotInReplicationGroups);
        }

        public final String getCacheClusterId() {
            return cacheClusterId;
        }

        public final void setCacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
        }

        @Override
        public final Builder cacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
            return this;
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final Boolean getShowCacheNodeInfo() {
            return showCacheNodeInfo;
        }

        public final void setShowCacheNodeInfo(Boolean showCacheNodeInfo) {
            this.showCacheNodeInfo = showCacheNodeInfo;
        }

        @Override
        public final Builder showCacheNodeInfo(Boolean showCacheNodeInfo) {
            this.showCacheNodeInfo = showCacheNodeInfo;
            return this;
        }

        public final Boolean getShowCacheClustersNotInReplicationGroups() {
            return showCacheClustersNotInReplicationGroups;
        }

        public final void setShowCacheClustersNotInReplicationGroups(Boolean showCacheClustersNotInReplicationGroups) {
            this.showCacheClustersNotInReplicationGroups = showCacheClustersNotInReplicationGroups;
        }

        @Override
        public final Builder showCacheClustersNotInReplicationGroups(Boolean showCacheClustersNotInReplicationGroups) {
            this.showCacheClustersNotInReplicationGroups = showCacheClustersNotInReplicationGroups;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeCacheClustersRequest build() {
            return new DescribeCacheClustersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
