/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.elasticache.model.AddTagsToResourceRequest;
import software.amazon.awssdk.services.elasticache.model.AddTagsToResourceResponse;
import software.amazon.awssdk.services.elasticache.model.AuthorizeCacheSecurityGroupIngressRequest;
import software.amazon.awssdk.services.elasticache.model.AuthorizeCacheSecurityGroupIngressResponse;
import software.amazon.awssdk.services.elasticache.model.BatchApplyUpdateActionRequest;
import software.amazon.awssdk.services.elasticache.model.BatchApplyUpdateActionResponse;
import software.amazon.awssdk.services.elasticache.model.BatchStopUpdateActionRequest;
import software.amazon.awssdk.services.elasticache.model.BatchStopUpdateActionResponse;
import software.amazon.awssdk.services.elasticache.model.CompleteMigrationRequest;
import software.amazon.awssdk.services.elasticache.model.CompleteMigrationResponse;
import software.amazon.awssdk.services.elasticache.model.CopySnapshotRequest;
import software.amazon.awssdk.services.elasticache.model.CopySnapshotResponse;
import software.amazon.awssdk.services.elasticache.model.CreateCacheClusterRequest;
import software.amazon.awssdk.services.elasticache.model.CreateCacheClusterResponse;
import software.amazon.awssdk.services.elasticache.model.CreateCacheParameterGroupRequest;
import software.amazon.awssdk.services.elasticache.model.CreateCacheParameterGroupResponse;
import software.amazon.awssdk.services.elasticache.model.CreateCacheSecurityGroupRequest;
import software.amazon.awssdk.services.elasticache.model.CreateCacheSecurityGroupResponse;
import software.amazon.awssdk.services.elasticache.model.CreateCacheSubnetGroupRequest;
import software.amazon.awssdk.services.elasticache.model.CreateCacheSubnetGroupResponse;
import software.amazon.awssdk.services.elasticache.model.CreateGlobalReplicationGroupRequest;
import software.amazon.awssdk.services.elasticache.model.CreateGlobalReplicationGroupResponse;
import software.amazon.awssdk.services.elasticache.model.CreateReplicationGroupRequest;
import software.amazon.awssdk.services.elasticache.model.CreateReplicationGroupResponse;
import software.amazon.awssdk.services.elasticache.model.CreateSnapshotRequest;
import software.amazon.awssdk.services.elasticache.model.CreateSnapshotResponse;
import software.amazon.awssdk.services.elasticache.model.CreateUserGroupRequest;
import software.amazon.awssdk.services.elasticache.model.CreateUserGroupResponse;
import software.amazon.awssdk.services.elasticache.model.CreateUserRequest;
import software.amazon.awssdk.services.elasticache.model.CreateUserResponse;
import software.amazon.awssdk.services.elasticache.model.DecreaseNodeGroupsInGlobalReplicationGroupRequest;
import software.amazon.awssdk.services.elasticache.model.DecreaseNodeGroupsInGlobalReplicationGroupResponse;
import software.amazon.awssdk.services.elasticache.model.DecreaseReplicaCountRequest;
import software.amazon.awssdk.services.elasticache.model.DecreaseReplicaCountResponse;
import software.amazon.awssdk.services.elasticache.model.DeleteCacheClusterRequest;
import software.amazon.awssdk.services.elasticache.model.DeleteCacheClusterResponse;
import software.amazon.awssdk.services.elasticache.model.DeleteCacheParameterGroupRequest;
import software.amazon.awssdk.services.elasticache.model.DeleteCacheParameterGroupResponse;
import software.amazon.awssdk.services.elasticache.model.DeleteCacheSecurityGroupRequest;
import software.amazon.awssdk.services.elasticache.model.DeleteCacheSecurityGroupResponse;
import software.amazon.awssdk.services.elasticache.model.DeleteCacheSubnetGroupRequest;
import software.amazon.awssdk.services.elasticache.model.DeleteCacheSubnetGroupResponse;
import software.amazon.awssdk.services.elasticache.model.DeleteGlobalReplicationGroupRequest;
import software.amazon.awssdk.services.elasticache.model.DeleteGlobalReplicationGroupResponse;
import software.amazon.awssdk.services.elasticache.model.DeleteReplicationGroupRequest;
import software.amazon.awssdk.services.elasticache.model.DeleteReplicationGroupResponse;
import software.amazon.awssdk.services.elasticache.model.DeleteSnapshotRequest;
import software.amazon.awssdk.services.elasticache.model.DeleteSnapshotResponse;
import software.amazon.awssdk.services.elasticache.model.DeleteUserGroupRequest;
import software.amazon.awssdk.services.elasticache.model.DeleteUserGroupResponse;
import software.amazon.awssdk.services.elasticache.model.DeleteUserRequest;
import software.amazon.awssdk.services.elasticache.model.DeleteUserResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheEngineVersionsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheEngineVersionsResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheParameterGroupsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheParameterGroupsResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheParametersRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheParametersResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheSecurityGroupsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheSecurityGroupsResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheSubnetGroupsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheSubnetGroupsResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeEngineDefaultParametersRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeEngineDefaultParametersResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeEventsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeEventsResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeGlobalReplicationGroupsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeGlobalReplicationGroupsResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesOfferingsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesOfferingsResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeServiceUpdatesRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeServiceUpdatesResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeSnapshotsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeSnapshotsResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeUpdateActionsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeUpdateActionsResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeUserGroupsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeUserGroupsResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeUsersRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeUsersResponse;
import software.amazon.awssdk.services.elasticache.model.DisassociateGlobalReplicationGroupRequest;
import software.amazon.awssdk.services.elasticache.model.DisassociateGlobalReplicationGroupResponse;
import software.amazon.awssdk.services.elasticache.model.FailoverGlobalReplicationGroupRequest;
import software.amazon.awssdk.services.elasticache.model.FailoverGlobalReplicationGroupResponse;
import software.amazon.awssdk.services.elasticache.model.IncreaseNodeGroupsInGlobalReplicationGroupRequest;
import software.amazon.awssdk.services.elasticache.model.IncreaseNodeGroupsInGlobalReplicationGroupResponse;
import software.amazon.awssdk.services.elasticache.model.IncreaseReplicaCountRequest;
import software.amazon.awssdk.services.elasticache.model.IncreaseReplicaCountResponse;
import software.amazon.awssdk.services.elasticache.model.ListAllowedNodeTypeModificationsRequest;
import software.amazon.awssdk.services.elasticache.model.ListAllowedNodeTypeModificationsResponse;
import software.amazon.awssdk.services.elasticache.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.elasticache.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.elasticache.model.ModifyCacheClusterRequest;
import software.amazon.awssdk.services.elasticache.model.ModifyCacheClusterResponse;
import software.amazon.awssdk.services.elasticache.model.ModifyCacheParameterGroupRequest;
import software.amazon.awssdk.services.elasticache.model.ModifyCacheParameterGroupResponse;
import software.amazon.awssdk.services.elasticache.model.ModifyCacheSubnetGroupRequest;
import software.amazon.awssdk.services.elasticache.model.ModifyCacheSubnetGroupResponse;
import software.amazon.awssdk.services.elasticache.model.ModifyGlobalReplicationGroupRequest;
import software.amazon.awssdk.services.elasticache.model.ModifyGlobalReplicationGroupResponse;
import software.amazon.awssdk.services.elasticache.model.ModifyReplicationGroupRequest;
import software.amazon.awssdk.services.elasticache.model.ModifyReplicationGroupResponse;
import software.amazon.awssdk.services.elasticache.model.ModifyReplicationGroupShardConfigurationRequest;
import software.amazon.awssdk.services.elasticache.model.ModifyReplicationGroupShardConfigurationResponse;
import software.amazon.awssdk.services.elasticache.model.ModifyUserGroupRequest;
import software.amazon.awssdk.services.elasticache.model.ModifyUserGroupResponse;
import software.amazon.awssdk.services.elasticache.model.ModifyUserRequest;
import software.amazon.awssdk.services.elasticache.model.ModifyUserResponse;
import software.amazon.awssdk.services.elasticache.model.PurchaseReservedCacheNodesOfferingRequest;
import software.amazon.awssdk.services.elasticache.model.PurchaseReservedCacheNodesOfferingResponse;
import software.amazon.awssdk.services.elasticache.model.RebalanceSlotsInGlobalReplicationGroupRequest;
import software.amazon.awssdk.services.elasticache.model.RebalanceSlotsInGlobalReplicationGroupResponse;
import software.amazon.awssdk.services.elasticache.model.RebootCacheClusterRequest;
import software.amazon.awssdk.services.elasticache.model.RebootCacheClusterResponse;
import software.amazon.awssdk.services.elasticache.model.RemoveTagsFromResourceRequest;
import software.amazon.awssdk.services.elasticache.model.RemoveTagsFromResourceResponse;
import software.amazon.awssdk.services.elasticache.model.ResetCacheParameterGroupRequest;
import software.amazon.awssdk.services.elasticache.model.ResetCacheParameterGroupResponse;
import software.amazon.awssdk.services.elasticache.model.RevokeCacheSecurityGroupIngressRequest;
import software.amazon.awssdk.services.elasticache.model.RevokeCacheSecurityGroupIngressResponse;
import software.amazon.awssdk.services.elasticache.model.StartMigrationRequest;
import software.amazon.awssdk.services.elasticache.model.StartMigrationResponse;
import software.amazon.awssdk.services.elasticache.model.TestFailoverRequest;
import software.amazon.awssdk.services.elasticache.model.TestFailoverResponse;
import software.amazon.awssdk.services.elasticache.paginators.DescribeCacheClustersPublisher;
import software.amazon.awssdk.services.elasticache.paginators.DescribeCacheEngineVersionsPublisher;
import software.amazon.awssdk.services.elasticache.paginators.DescribeCacheParameterGroupsPublisher;
import software.amazon.awssdk.services.elasticache.paginators.DescribeCacheParametersPublisher;
import software.amazon.awssdk.services.elasticache.paginators.DescribeCacheSecurityGroupsPublisher;
import software.amazon.awssdk.services.elasticache.paginators.DescribeCacheSubnetGroupsPublisher;
import software.amazon.awssdk.services.elasticache.paginators.DescribeEngineDefaultParametersPublisher;
import software.amazon.awssdk.services.elasticache.paginators.DescribeEventsPublisher;
import software.amazon.awssdk.services.elasticache.paginators.DescribeGlobalReplicationGroupsPublisher;
import software.amazon.awssdk.services.elasticache.paginators.DescribeReplicationGroupsPublisher;
import software.amazon.awssdk.services.elasticache.paginators.DescribeReservedCacheNodesOfferingsPublisher;
import software.amazon.awssdk.services.elasticache.paginators.DescribeReservedCacheNodesPublisher;
import software.amazon.awssdk.services.elasticache.paginators.DescribeServiceUpdatesPublisher;
import software.amazon.awssdk.services.elasticache.paginators.DescribeSnapshotsPublisher;
import software.amazon.awssdk.services.elasticache.paginators.DescribeUpdateActionsPublisher;
import software.amazon.awssdk.services.elasticache.paginators.DescribeUserGroupsPublisher;
import software.amazon.awssdk.services.elasticache.paginators.DescribeUsersPublisher;
import software.amazon.awssdk.services.elasticache.waiters.ElastiCacheAsyncWaiter;

/**
 * Service client for accessing Amazon ElastiCache asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <fullname>Amazon ElastiCache</fullname>
 * <p>
 * Amazon ElastiCache is a web service that makes it easier to set up, operate, and scale a distributed cache in the
 * cloud.
 * </p>
 * <p>
 * With ElastiCache, customers get all of the benefits of a high-performance, in-memory cache with less of the
 * administrative burden involved in launching and managing a distributed cache. The service makes setup, scaling, and
 * cluster failure handling much simpler than in a self-managed cache deployment.
 * </p>
 * <p>
 * In addition, through integration with Amazon CloudWatch, customers get enhanced visibility into the key performance
 * statistics associated with their cache and can receive alarms if a part of their cache runs hot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ElastiCacheAsyncClient extends AwsClient {
    String SERVICE_NAME = "elasticache";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "elasticache";

    /**
     * <p>
     * A tag is a key-value pair where the key and value are case-sensitive. You can use tags to categorize and track
     * all your ElastiCache resources, with the exception of global replication group. When you add or remove tags on
     * replication groups, those actions will be replicated to all nodes in the replication group. For more information,
     * see <a
     * href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/IAM.ResourceLevelPermissions.html">Resource
     * -level permissions</a>.
     * </p>
     * <p>
     * For example, you can use cost-allocation tags to your ElastiCache resources, Amazon generates a cost allocation
     * report as a comma-separated value (CSV) file with your usage and costs aggregated by your tags. You can apply
     * tags that represent business categories (such as cost centers, application names, or owners) to organize your
     * costs across multiple services.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Tagging.html">Using Cost Allocation Tags in
     * Amazon ElastiCache</a> in the <i>ElastiCache User Guide</i>.
     * </p>
     *
     * @param addTagsToResourceRequest
     *        Represents the input of an AddTagsToResource operation.
     * @return A Java Future containing the result of the AddTagsToResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheClusterNotFoundException The requested cluster ID does not refer to an existing cluster.</li>
     *         <li>CacheParameterGroupNotFoundException The requested cache parameter group name does not refer to an
     *         existing cache parameter group.</li>
     *         <li>CacheSecurityGroupNotFoundException The requested cache security group name does not refer to an
     *         existing cache security group.</li>
     *         <li>CacheSubnetGroupNotFoundException The requested cache subnet group name does not refer to an existing
     *         cache subnet group.</li>
     *         <li>InvalidReplicationGroupStateException The requested replication group is not in the
     *         <code>available</code> state.</li>
     *         <li>ReplicationGroupNotFoundException The specified replication group does not exist.</li>
     *         <li>ReservedCacheNodeNotFoundException The requested reserved cache node was not found.</li>
     *         <li>SnapshotNotFoundException The requested snapshot name does not refer to an existing snapshot.</li>
     *         <li>UserNotFoundException The user does not exist or could not be found.</li>
     *         <li>UserGroupNotFoundException The user group was not found or does not exist</li>
     *         <li>TagQuotaPerResourceExceededException The request cannot be processed because it would cause the
     *         resource to have more than the allowed number of tags. The maximum number of tags permitted on a resource
     *         is 50.</li>
     *         <li>InvalidArnException The requested Amazon Resource Name (ARN) does not refer to an existing resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.AddTagsToResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/AddTagsToResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AddTagsToResourceResponse> addTagsToResource(AddTagsToResourceRequest addTagsToResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A tag is a key-value pair where the key and value are case-sensitive. You can use tags to categorize and track
     * all your ElastiCache resources, with the exception of global replication group. When you add or remove tags on
     * replication groups, those actions will be replicated to all nodes in the replication group. For more information,
     * see <a
     * href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/IAM.ResourceLevelPermissions.html">Resource
     * -level permissions</a>.
     * </p>
     * <p>
     * For example, you can use cost-allocation tags to your ElastiCache resources, Amazon generates a cost allocation
     * report as a comma-separated value (CSV) file with your usage and costs aggregated by your tags. You can apply
     * tags that represent business categories (such as cost centers, application names, or owners) to organize your
     * costs across multiple services.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Tagging.html">Using Cost Allocation Tags in
     * Amazon ElastiCache</a> in the <i>ElastiCache User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddTagsToResourceRequest.Builder} avoiding the need
     * to create one manually via {@link AddTagsToResourceRequest#builder()}
     * </p>
     *
     * @param addTagsToResourceRequest
     *        A {@link Consumer} that will call methods on {@link AddTagsToResourceMessage.Builder} to create a request.
     *        Represents the input of an AddTagsToResource operation.
     * @return A Java Future containing the result of the AddTagsToResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheClusterNotFoundException The requested cluster ID does not refer to an existing cluster.</li>
     *         <li>CacheParameterGroupNotFoundException The requested cache parameter group name does not refer to an
     *         existing cache parameter group.</li>
     *         <li>CacheSecurityGroupNotFoundException The requested cache security group name does not refer to an
     *         existing cache security group.</li>
     *         <li>CacheSubnetGroupNotFoundException The requested cache subnet group name does not refer to an existing
     *         cache subnet group.</li>
     *         <li>InvalidReplicationGroupStateException The requested replication group is not in the
     *         <code>available</code> state.</li>
     *         <li>ReplicationGroupNotFoundException The specified replication group does not exist.</li>
     *         <li>ReservedCacheNodeNotFoundException The requested reserved cache node was not found.</li>
     *         <li>SnapshotNotFoundException The requested snapshot name does not refer to an existing snapshot.</li>
     *         <li>UserNotFoundException The user does not exist or could not be found.</li>
     *         <li>UserGroupNotFoundException The user group was not found or does not exist</li>
     *         <li>TagQuotaPerResourceExceededException The request cannot be processed because it would cause the
     *         resource to have more than the allowed number of tags. The maximum number of tags permitted on a resource
     *         is 50.</li>
     *         <li>InvalidArnException The requested Amazon Resource Name (ARN) does not refer to an existing resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.AddTagsToResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/AddTagsToResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AddTagsToResourceResponse> addTagsToResource(
            Consumer<AddTagsToResourceRequest.Builder> addTagsToResourceRequest) {
        return addTagsToResource(AddTagsToResourceRequest.builder().applyMutation(addTagsToResourceRequest).build());
    }

    /**
     * <p>
     * Allows network ingress to a cache security group. Applications using ElastiCache must be running on Amazon EC2,
     * and Amazon EC2 security groups are used as the authorization mechanism.
     * </p>
     * <note>
     * <p>
     * You cannot authorize ingress from an Amazon EC2 security group in one region to an ElastiCache cluster in another
     * region.
     * </p>
     * </note>
     *
     * @param authorizeCacheSecurityGroupIngressRequest
     *        Represents the input of an AuthorizeCacheSecurityGroupIngress operation.
     * @return A Java Future containing the result of the AuthorizeCacheSecurityGroupIngress operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheSecurityGroupNotFoundException The requested cache security group name does not refer to an
     *         existing cache security group.</li>
     *         <li>InvalidCacheSecurityGroupStateException The current state of the cache security group does not allow
     *         deletion.</li>
     *         <li>AuthorizationAlreadyExistsException The specified Amazon EC2 security group is already authorized for
     *         the specified cache security group.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.AuthorizeCacheSecurityGroupIngress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/AuthorizeCacheSecurityGroupIngress"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AuthorizeCacheSecurityGroupIngressResponse> authorizeCacheSecurityGroupIngress(
            AuthorizeCacheSecurityGroupIngressRequest authorizeCacheSecurityGroupIngressRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows network ingress to a cache security group. Applications using ElastiCache must be running on Amazon EC2,
     * and Amazon EC2 security groups are used as the authorization mechanism.
     * </p>
     * <note>
     * <p>
     * You cannot authorize ingress from an Amazon EC2 security group in one region to an ElastiCache cluster in another
     * region.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AuthorizeCacheSecurityGroupIngressRequest.Builder}
     * avoiding the need to create one manually via {@link AuthorizeCacheSecurityGroupIngressRequest#builder()}
     * </p>
     *
     * @param authorizeCacheSecurityGroupIngressRequest
     *        A {@link Consumer} that will call methods on {@link AuthorizeCacheSecurityGroupIngressMessage.Builder} to
     *        create a request. Represents the input of an AuthorizeCacheSecurityGroupIngress operation.
     * @return A Java Future containing the result of the AuthorizeCacheSecurityGroupIngress operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheSecurityGroupNotFoundException The requested cache security group name does not refer to an
     *         existing cache security group.</li>
     *         <li>InvalidCacheSecurityGroupStateException The current state of the cache security group does not allow
     *         deletion.</li>
     *         <li>AuthorizationAlreadyExistsException The specified Amazon EC2 security group is already authorized for
     *         the specified cache security group.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.AuthorizeCacheSecurityGroupIngress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/AuthorizeCacheSecurityGroupIngress"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AuthorizeCacheSecurityGroupIngressResponse> authorizeCacheSecurityGroupIngress(
            Consumer<AuthorizeCacheSecurityGroupIngressRequest.Builder> authorizeCacheSecurityGroupIngressRequest) {
        return authorizeCacheSecurityGroupIngress(AuthorizeCacheSecurityGroupIngressRequest.builder()
                .applyMutation(authorizeCacheSecurityGroupIngressRequest).build());
    }

    /**
     * <p>
     * Apply the service update. For more information on service updates and applying them, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/applying-updates.html">Applying Service
     * Updates</a>.
     * </p>
     *
     * @param batchApplyUpdateActionRequest
     * @return A Java Future containing the result of the BatchApplyUpdateAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUpdateNotFoundException The service update doesn't exist</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.BatchApplyUpdateAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/BatchApplyUpdateAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchApplyUpdateActionResponse> batchApplyUpdateAction(
            BatchApplyUpdateActionRequest batchApplyUpdateActionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Apply the service update. For more information on service updates and applying them, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/applying-updates.html">Applying Service
     * Updates</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchApplyUpdateActionRequest.Builder} avoiding the
     * need to create one manually via {@link BatchApplyUpdateActionRequest#builder()}
     * </p>
     *
     * @param batchApplyUpdateActionRequest
     *        A {@link Consumer} that will call methods on {@link BatchApplyUpdateActionMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchApplyUpdateAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUpdateNotFoundException The service update doesn't exist</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.BatchApplyUpdateAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/BatchApplyUpdateAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchApplyUpdateActionResponse> batchApplyUpdateAction(
            Consumer<BatchApplyUpdateActionRequest.Builder> batchApplyUpdateActionRequest) {
        return batchApplyUpdateAction(BatchApplyUpdateActionRequest.builder().applyMutation(batchApplyUpdateActionRequest)
                .build());
    }

    /**
     * <p>
     * Stop the service update. For more information on service updates and stopping them, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/stopping-self-service-updates.html">Stopping
     * Service Updates</a>.
     * </p>
     *
     * @param batchStopUpdateActionRequest
     * @return A Java Future containing the result of the BatchStopUpdateAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUpdateNotFoundException The service update doesn't exist</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.BatchStopUpdateAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/BatchStopUpdateAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchStopUpdateActionResponse> batchStopUpdateAction(
            BatchStopUpdateActionRequest batchStopUpdateActionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stop the service update. For more information on service updates and stopping them, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/stopping-self-service-updates.html">Stopping
     * Service Updates</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchStopUpdateActionRequest.Builder} avoiding the
     * need to create one manually via {@link BatchStopUpdateActionRequest#builder()}
     * </p>
     *
     * @param batchStopUpdateActionRequest
     *        A {@link Consumer} that will call methods on {@link BatchStopUpdateActionMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchStopUpdateAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUpdateNotFoundException The service update doesn't exist</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.BatchStopUpdateAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/BatchStopUpdateAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchStopUpdateActionResponse> batchStopUpdateAction(
            Consumer<BatchStopUpdateActionRequest.Builder> batchStopUpdateActionRequest) {
        return batchStopUpdateAction(BatchStopUpdateActionRequest.builder().applyMutation(batchStopUpdateActionRequest).build());
    }

    /**
     * <p>
     * Complete the migration of data.
     * </p>
     *
     * @param completeMigrationRequest
     * @return A Java Future containing the result of the CompleteMigration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReplicationGroupNotFoundException The specified replication group does not exist.</li>
     *         <li>InvalidReplicationGroupStateException The requested replication group is not in the
     *         <code>available</code> state.</li>
     *         <li>ReplicationGroupNotUnderMigrationException The designated replication group is not available for data
     *         migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.CompleteMigration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CompleteMigration" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CompleteMigrationResponse> completeMigration(CompleteMigrationRequest completeMigrationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Complete the migration of data.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CompleteMigrationRequest.Builder} avoiding the need
     * to create one manually via {@link CompleteMigrationRequest#builder()}
     * </p>
     *
     * @param completeMigrationRequest
     *        A {@link Consumer} that will call methods on {@link CompleteMigrationMessage.Builder} to create a request.
     * @return A Java Future containing the result of the CompleteMigration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReplicationGroupNotFoundException The specified replication group does not exist.</li>
     *         <li>InvalidReplicationGroupStateException The requested replication group is not in the
     *         <code>available</code> state.</li>
     *         <li>ReplicationGroupNotUnderMigrationException The designated replication group is not available for data
     *         migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.CompleteMigration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CompleteMigration" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CompleteMigrationResponse> completeMigration(
            Consumer<CompleteMigrationRequest.Builder> completeMigrationRequest) {
        return completeMigration(CompleteMigrationRequest.builder().applyMutation(completeMigrationRequest).build());
    }

    /**
     * <p>
     * Makes a copy of an existing snapshot.
     * </p>
     * <note>
     * <p>
     * This operation is valid for Redis only.
     * </p>
     * </note> <important>
     * <p>
     * Users or groups that have permissions to use the <code>CopySnapshot</code> operation can create their own Amazon
     * S3 buckets and copy snapshots to it. To control access to your snapshots, use an IAM policy to control who has
     * the ability to use the <code>CopySnapshot</code> operation. For more information about using IAM to control the
     * use of ElastiCache operations, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html">Exporting Snapshots</a>
     * and <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/IAM.html">Authentication &amp; Access
     * Control</a>.
     * </p>
     * </important>
     * <p>
     * You could receive the following error messages.
     * </p>
     * <p class="title">
     * <b>Error Messages</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Error Message:</b> The S3 bucket %s is outside of the region.
     * </p>
     * <p>
     * <b>Solution:</b> Create an Amazon S3 bucket in the same region as your snapshot. For more information, see <a
     * href=
     * "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-create-s3-bucket"
     * >Step 1: Create an Amazon S3 Bucket</a> in the ElastiCache User Guide.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Error Message:</b> The S3 bucket %s does not exist.
     * </p>
     * <p>
     * <b>Solution:</b> Create an Amazon S3 bucket in the same region as your snapshot. For more information, see <a
     * href=
     * "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-create-s3-bucket"
     * >Step 1: Create an Amazon S3 Bucket</a> in the ElastiCache User Guide.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Error Message:</b> The S3 bucket %s is not owned by the authenticated user.
     * </p>
     * <p>
     * <b>Solution:</b> Create an Amazon S3 bucket in the same region as your snapshot. For more information, see <a
     * href=
     * "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-create-s3-bucket"
     * >Step 1: Create an Amazon S3 Bucket</a> in the ElastiCache User Guide.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Error Message:</b> The authenticated user does not have sufficient permissions to perform the desired
     * activity.
     * </p>
     * <p>
     * <b>Solution:</b> Contact your system administrator to get the needed permissions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Error Message:</b> The S3 bucket %s already contains an object with key %s.
     * </p>
     * <p>
     * <b>Solution:</b> Give the <code>TargetSnapshotName</code> a new and unique value. If exporting a snapshot, you
     * could alternatively create a new Amazon S3 bucket and use this same value for <code>TargetSnapshotName</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Error Message: </b> ElastiCache has not been granted READ permissions %s on the S3 Bucket.
     * </p>
     * <p>
     * <b>Solution:</b> Add List and Read permissions on the bucket. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access"
     * >Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket</a> in the ElastiCache User Guide.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Error Message: </b> ElastiCache has not been granted WRITE permissions %s on the S3 Bucket.
     * </p>
     * <p>
     * <b>Solution:</b> Add Upload/Delete permissions on the bucket. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access"
     * >Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket</a> in the ElastiCache User Guide.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Error Message: </b> ElastiCache has not been granted READ_ACP permissions %s on the S3 Bucket.
     * </p>
     * <p>
     * <b>Solution:</b> Add View Permissions on the bucket. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access"
     * >Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket</a> in the ElastiCache User Guide.
     * </p>
     * </li>
     * </ul>
     *
     * @param copySnapshotRequest
     *        Represents the input of a <code>CopySnapshotMessage</code> operation.
     * @return A Java Future containing the result of the CopySnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SnapshotAlreadyExistsException You already have a snapshot with the given name.</li>
     *         <li>SnapshotNotFoundException The requested snapshot name does not refer to an existing snapshot.</li>
     *         <li>SnapshotQuotaExceededException The request cannot be processed because it would exceed the maximum
     *         number of snapshots.</li>
     *         <li>InvalidSnapshotStateException The current state of the snapshot does not allow the requested
     *         operation to occur.</li>
     *         <li>TagQuotaPerResourceExceededException The request cannot be processed because it would cause the
     *         resource to have more than the allowed number of tags. The maximum number of tags permitted on a resource
     *         is 50.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.CopySnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CopySnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CopySnapshotResponse> copySnapshot(CopySnapshotRequest copySnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Makes a copy of an existing snapshot.
     * </p>
     * <note>
     * <p>
     * This operation is valid for Redis only.
     * </p>
     * </note> <important>
     * <p>
     * Users or groups that have permissions to use the <code>CopySnapshot</code> operation can create their own Amazon
     * S3 buckets and copy snapshots to it. To control access to your snapshots, use an IAM policy to control who has
     * the ability to use the <code>CopySnapshot</code> operation. For more information about using IAM to control the
     * use of ElastiCache operations, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html">Exporting Snapshots</a>
     * and <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/IAM.html">Authentication &amp; Access
     * Control</a>.
     * </p>
     * </important>
     * <p>
     * You could receive the following error messages.
     * </p>
     * <p class="title">
     * <b>Error Messages</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Error Message:</b> The S3 bucket %s is outside of the region.
     * </p>
     * <p>
     * <b>Solution:</b> Create an Amazon S3 bucket in the same region as your snapshot. For more information, see <a
     * href=
     * "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-create-s3-bucket"
     * >Step 1: Create an Amazon S3 Bucket</a> in the ElastiCache User Guide.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Error Message:</b> The S3 bucket %s does not exist.
     * </p>
     * <p>
     * <b>Solution:</b> Create an Amazon S3 bucket in the same region as your snapshot. For more information, see <a
     * href=
     * "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-create-s3-bucket"
     * >Step 1: Create an Amazon S3 Bucket</a> in the ElastiCache User Guide.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Error Message:</b> The S3 bucket %s is not owned by the authenticated user.
     * </p>
     * <p>
     * <b>Solution:</b> Create an Amazon S3 bucket in the same region as your snapshot. For more information, see <a
     * href=
     * "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-create-s3-bucket"
     * >Step 1: Create an Amazon S3 Bucket</a> in the ElastiCache User Guide.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Error Message:</b> The authenticated user does not have sufficient permissions to perform the desired
     * activity.
     * </p>
     * <p>
     * <b>Solution:</b> Contact your system administrator to get the needed permissions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Error Message:</b> The S3 bucket %s already contains an object with key %s.
     * </p>
     * <p>
     * <b>Solution:</b> Give the <code>TargetSnapshotName</code> a new and unique value. If exporting a snapshot, you
     * could alternatively create a new Amazon S3 bucket and use this same value for <code>TargetSnapshotName</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Error Message: </b> ElastiCache has not been granted READ permissions %s on the S3 Bucket.
     * </p>
     * <p>
     * <b>Solution:</b> Add List and Read permissions on the bucket. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access"
     * >Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket</a> in the ElastiCache User Guide.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Error Message: </b> ElastiCache has not been granted WRITE permissions %s on the S3 Bucket.
     * </p>
     * <p>
     * <b>Solution:</b> Add Upload/Delete permissions on the bucket. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access"
     * >Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket</a> in the ElastiCache User Guide.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Error Message: </b> ElastiCache has not been granted READ_ACP permissions %s on the S3 Bucket.
     * </p>
     * <p>
     * <b>Solution:</b> Add View Permissions on the bucket. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access"
     * >Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket</a> in the ElastiCache User Guide.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CopySnapshotRequest.Builder} avoiding the need to
     * create one manually via {@link CopySnapshotRequest#builder()}
     * </p>
     *
     * @param copySnapshotRequest
     *        A {@link Consumer} that will call methods on {@link CopySnapshotMessage.Builder} to create a request.
     *        Represents the input of a <code>CopySnapshotMessage</code> operation.
     * @return A Java Future containing the result of the CopySnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SnapshotAlreadyExistsException You already have a snapshot with the given name.</li>
     *         <li>SnapshotNotFoundException The requested snapshot name does not refer to an existing snapshot.</li>
     *         <li>SnapshotQuotaExceededException The request cannot be processed because it would exceed the maximum
     *         number of snapshots.</li>
     *         <li>InvalidSnapshotStateException The current state of the snapshot does not allow the requested
     *         operation to occur.</li>
     *         <li>TagQuotaPerResourceExceededException The request cannot be processed because it would cause the
     *         resource to have more than the allowed number of tags. The maximum number of tags permitted on a resource
     *         is 50.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.CopySnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CopySnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CopySnapshotResponse> copySnapshot(Consumer<CopySnapshotRequest.Builder> copySnapshotRequest) {
        return copySnapshot(CopySnapshotRequest.builder().applyMutation(copySnapshotRequest).build());
    }

    /**
     * <p>
     * Creates a cluster. All nodes in the cluster run the same protocol-compliant cache engine software, either
     * Memcached or Redis.
     * </p>
     * <p>
     * This operation is not supported for Redis (cluster mode enabled) clusters.
     * </p>
     *
     * @param createCacheClusterRequest
     *        Represents the input of a CreateCacheCluster operation.
     * @return A Java Future containing the result of the CreateCacheCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReplicationGroupNotFoundException The specified replication group does not exist.</li>
     *         <li>InvalidReplicationGroupStateException The requested replication group is not in the
     *         <code>available</code> state.</li>
     *         <li>CacheClusterAlreadyExistsException You already have a cluster with the given identifier.</li>
     *         <li>InsufficientCacheClusterCapacityException The requested cache node type is not available in the
     *         specified Availability Zone. For more information, see <a href=
     *         "http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ErrorMessages.html#ErrorMessages.INSUFFICIENT_CACHE_CLUSTER_CAPACITY"
     *         >InsufficientCacheClusterCapacity</a> in the ElastiCache User Guide.</li>
     *         <li>CacheSecurityGroupNotFoundException The requested cache security group name does not refer to an
     *         existing cache security group.</li>
     *         <li>CacheSubnetGroupNotFoundException The requested cache subnet group name does not refer to an existing
     *         cache subnet group.</li>
     *         <li>ClusterQuotaForCustomerExceededException The request cannot be processed because it would exceed the
     *         allowed number of clusters per customer.</li>
     *         <li>NodeQuotaForClusterExceededException The request cannot be processed because it would exceed the
     *         allowed number of cache nodes in a single cluster.</li>
     *         <li>NodeQuotaForCustomerExceededException The request cannot be processed because it would exceed the
     *         allowed number of cache nodes per customer.</li>
     *         <li>CacheParameterGroupNotFoundException The requested cache parameter group name does not refer to an
     *         existing cache parameter group.</li>
     *         <li>InvalidVpcNetworkStateException The VPC network is in an invalid state.</li>
     *         <li>TagQuotaPerResourceExceededException The request cannot be processed because it would cause the
     *         resource to have more than the allowed number of tags. The maximum number of tags permitted on a resource
     *         is 50.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.CreateCacheCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CreateCacheCluster"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCacheClusterResponse> createCacheCluster(CreateCacheClusterRequest createCacheClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a cluster. All nodes in the cluster run the same protocol-compliant cache engine software, either
     * Memcached or Redis.
     * </p>
     * <p>
     * This operation is not supported for Redis (cluster mode enabled) clusters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCacheClusterRequest.Builder} avoiding the
     * need to create one manually via {@link CreateCacheClusterRequest#builder()}
     * </p>
     *
     * @param createCacheClusterRequest
     *        A {@link Consumer} that will call methods on {@link CreateCacheClusterMessage.Builder} to create a
     *        request. Represents the input of a CreateCacheCluster operation.
     * @return A Java Future containing the result of the CreateCacheCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReplicationGroupNotFoundException The specified replication group does not exist.</li>
     *         <li>InvalidReplicationGroupStateException The requested replication group is not in the
     *         <code>available</code> state.</li>
     *         <li>CacheClusterAlreadyExistsException You already have a cluster with the given identifier.</li>
     *         <li>InsufficientCacheClusterCapacityException The requested cache node type is not available in the
     *         specified Availability Zone. For more information, see <a href=
     *         "http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ErrorMessages.html#ErrorMessages.INSUFFICIENT_CACHE_CLUSTER_CAPACITY"
     *         >InsufficientCacheClusterCapacity</a> in the ElastiCache User Guide.</li>
     *         <li>CacheSecurityGroupNotFoundException The requested cache security group name does not refer to an
     *         existing cache security group.</li>
     *         <li>CacheSubnetGroupNotFoundException The requested cache subnet group name does not refer to an existing
     *         cache subnet group.</li>
     *         <li>ClusterQuotaForCustomerExceededException The request cannot be processed because it would exceed the
     *         allowed number of clusters per customer.</li>
     *         <li>NodeQuotaForClusterExceededException The request cannot be processed because it would exceed the
     *         allowed number of cache nodes in a single cluster.</li>
     *         <li>NodeQuotaForCustomerExceededException The request cannot be processed because it would exceed the
     *         allowed number of cache nodes per customer.</li>
     *         <li>CacheParameterGroupNotFoundException The requested cache parameter group name does not refer to an
     *         existing cache parameter group.</li>
     *         <li>InvalidVpcNetworkStateException The VPC network is in an invalid state.</li>
     *         <li>TagQuotaPerResourceExceededException The request cannot be processed because it would cause the
     *         resource to have more than the allowed number of tags. The maximum number of tags permitted on a resource
     *         is 50.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.CreateCacheCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CreateCacheCluster"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCacheClusterResponse> createCacheCluster(
            Consumer<CreateCacheClusterRequest.Builder> createCacheClusterRequest) {
        return createCacheCluster(CreateCacheClusterRequest.builder().applyMutation(createCacheClusterRequest).build());
    }

    /**
     * <p>
     * Creates a new Amazon ElastiCache cache parameter group. An ElastiCache cache parameter group is a collection of
     * parameters and their values that are applied to all of the nodes in any cluster or replication group using the
     * CacheParameterGroup.
     * </p>
     * <p>
     * A newly created CacheParameterGroup is an exact duplicate of the default parameter group for the
     * CacheParameterGroupFamily. To customize the newly created CacheParameterGroup you can change the values of
     * specific parameters. For more information, see:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_ModifyCacheParameterGroup.html">
     * ModifyCacheParameterGroup</a> in the ElastiCache API Reference.
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ParameterGroups.html">Parameters and
     * Parameter Groups</a> in the ElastiCache User Guide.
     * </p>
     * </li>
     * </ul>
     *
     * @param createCacheParameterGroupRequest
     *        Represents the input of a <code>CreateCacheParameterGroup</code> operation.
     * @return A Java Future containing the result of the CreateCacheParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheParameterGroupQuotaExceededException The request cannot be processed because it would exceed the
     *         maximum number of cache security groups.</li>
     *         <li>CacheParameterGroupAlreadyExistsException A cache parameter group with the requested name already
     *         exists.</li>
     *         <li>InvalidCacheParameterGroupStateException The current state of the cache parameter group does not
     *         allow the requested operation to occur.</li>
     *         <li>TagQuotaPerResourceExceededException The request cannot be processed because it would cause the
     *         resource to have more than the allowed number of tags. The maximum number of tags permitted on a resource
     *         is 50.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.CreateCacheParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CreateCacheParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCacheParameterGroupResponse> createCacheParameterGroup(
            CreateCacheParameterGroupRequest createCacheParameterGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Amazon ElastiCache cache parameter group. An ElastiCache cache parameter group is a collection of
     * parameters and their values that are applied to all of the nodes in any cluster or replication group using the
     * CacheParameterGroup.
     * </p>
     * <p>
     * A newly created CacheParameterGroup is an exact duplicate of the default parameter group for the
     * CacheParameterGroupFamily. To customize the newly created CacheParameterGroup you can change the values of
     * specific parameters. For more information, see:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_ModifyCacheParameterGroup.html">
     * ModifyCacheParameterGroup</a> in the ElastiCache API Reference.
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ParameterGroups.html">Parameters and
     * Parameter Groups</a> in the ElastiCache User Guide.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCacheParameterGroupRequest.Builder} avoiding
     * the need to create one manually via {@link CreateCacheParameterGroupRequest#builder()}
     * </p>
     *
     * @param createCacheParameterGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateCacheParameterGroupMessage.Builder} to create a
     *        request. Represents the input of a <code>CreateCacheParameterGroup</code> operation.
     * @return A Java Future containing the result of the CreateCacheParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheParameterGroupQuotaExceededException The request cannot be processed because it would exceed the
     *         maximum number of cache security groups.</li>
     *         <li>CacheParameterGroupAlreadyExistsException A cache parameter group with the requested name already
     *         exists.</li>
     *         <li>InvalidCacheParameterGroupStateException The current state of the cache parameter group does not
     *         allow the requested operation to occur.</li>
     *         <li>TagQuotaPerResourceExceededException The request cannot be processed because it would cause the
     *         resource to have more than the allowed number of tags. The maximum number of tags permitted on a resource
     *         is 50.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.CreateCacheParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CreateCacheParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCacheParameterGroupResponse> createCacheParameterGroup(
            Consumer<CreateCacheParameterGroupRequest.Builder> createCacheParameterGroupRequest) {
        return createCacheParameterGroup(CreateCacheParameterGroupRequest.builder()
                .applyMutation(createCacheParameterGroupRequest).build());
    }

    /**
     * <p>
     * Creates a new cache security group. Use a cache security group to control access to one or more clusters.
     * </p>
     * <p>
     * Cache security groups are only used when you are creating a cluster outside of an Amazon Virtual Private Cloud
     * (Amazon VPC). If you are creating a cluster inside of a VPC, use a cache subnet group instead. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_CreateCacheSubnetGroup.html"
     * >CreateCacheSubnetGroup</a>.
     * </p>
     *
     * @param createCacheSecurityGroupRequest
     *        Represents the input of a <code>CreateCacheSecurityGroup</code> operation.
     * @return A Java Future containing the result of the CreateCacheSecurityGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheSecurityGroupAlreadyExistsException A cache security group with the specified name already
     *         exists.</li>
     *         <li>CacheSecurityGroupQuotaExceededException The request cannot be processed because it would exceed the
     *         allowed number of cache security groups.</li>
     *         <li>TagQuotaPerResourceExceededException The request cannot be processed because it would cause the
     *         resource to have more than the allowed number of tags. The maximum number of tags permitted on a resource
     *         is 50.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.CreateCacheSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CreateCacheSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCacheSecurityGroupResponse> createCacheSecurityGroup(
            CreateCacheSecurityGroupRequest createCacheSecurityGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new cache security group. Use a cache security group to control access to one or more clusters.
     * </p>
     * <p>
     * Cache security groups are only used when you are creating a cluster outside of an Amazon Virtual Private Cloud
     * (Amazon VPC). If you are creating a cluster inside of a VPC, use a cache subnet group instead. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_CreateCacheSubnetGroup.html"
     * >CreateCacheSubnetGroup</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCacheSecurityGroupRequest.Builder} avoiding
     * the need to create one manually via {@link CreateCacheSecurityGroupRequest#builder()}
     * </p>
     *
     * @param createCacheSecurityGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateCacheSecurityGroupMessage.Builder} to create a
     *        request. Represents the input of a <code>CreateCacheSecurityGroup</code> operation.
     * @return A Java Future containing the result of the CreateCacheSecurityGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheSecurityGroupAlreadyExistsException A cache security group with the specified name already
     *         exists.</li>
     *         <li>CacheSecurityGroupQuotaExceededException The request cannot be processed because it would exceed the
     *         allowed number of cache security groups.</li>
     *         <li>TagQuotaPerResourceExceededException The request cannot be processed because it would cause the
     *         resource to have more than the allowed number of tags. The maximum number of tags permitted on a resource
     *         is 50.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.CreateCacheSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CreateCacheSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCacheSecurityGroupResponse> createCacheSecurityGroup(
            Consumer<CreateCacheSecurityGroupRequest.Builder> createCacheSecurityGroupRequest) {
        return createCacheSecurityGroup(CreateCacheSecurityGroupRequest.builder().applyMutation(createCacheSecurityGroupRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new cache subnet group.
     * </p>
     * <p>
     * Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon VPC).
     * </p>
     *
     * @param createCacheSubnetGroupRequest
     *        Represents the input of a <code>CreateCacheSubnetGroup</code> operation.
     * @return A Java Future containing the result of the CreateCacheSubnetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheSubnetGroupAlreadyExistsException The requested cache subnet group name is already in use by an
     *         existing cache subnet group.</li>
     *         <li>CacheSubnetGroupQuotaExceededException The request cannot be processed because it would exceed the
     *         allowed number of cache subnet groups.</li>
     *         <li>CacheSubnetQuotaExceededException The request cannot be processed because it would exceed the allowed
     *         number of subnets in a cache subnet group.</li>
     *         <li>TagQuotaPerResourceExceededException The request cannot be processed because it would cause the
     *         resource to have more than the allowed number of tags. The maximum number of tags permitted on a resource
     *         is 50.</li>
     *         <li>InvalidSubnetException An invalid subnet identifier was specified.</li>
     *         <li>SubnetNotAllowedException At least one subnet ID does not match the other subnet IDs. This mismatch
     *         typically occurs when a user sets one subnet ID to a regional Availability Zone and a different one to an
     *         outpost. Or when a user sets the subnet ID to an Outpost when not subscribed on this service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.CreateCacheSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CreateCacheSubnetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCacheSubnetGroupResponse> createCacheSubnetGroup(
            CreateCacheSubnetGroupRequest createCacheSubnetGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new cache subnet group.
     * </p>
     * <p>
     * Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon VPC).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCacheSubnetGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateCacheSubnetGroupRequest#builder()}
     * </p>
     *
     * @param createCacheSubnetGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateCacheSubnetGroupMessage.Builder} to create a
     *        request. Represents the input of a <code>CreateCacheSubnetGroup</code> operation.
     * @return A Java Future containing the result of the CreateCacheSubnetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheSubnetGroupAlreadyExistsException The requested cache subnet group name is already in use by an
     *         existing cache subnet group.</li>
     *         <li>CacheSubnetGroupQuotaExceededException The request cannot be processed because it would exceed the
     *         allowed number of cache subnet groups.</li>
     *         <li>CacheSubnetQuotaExceededException The request cannot be processed because it would exceed the allowed
     *         number of subnets in a cache subnet group.</li>
     *         <li>TagQuotaPerResourceExceededException The request cannot be processed because it would cause the
     *         resource to have more than the allowed number of tags. The maximum number of tags permitted on a resource
     *         is 50.</li>
     *         <li>InvalidSubnetException An invalid subnet identifier was specified.</li>
     *         <li>SubnetNotAllowedException At least one subnet ID does not match the other subnet IDs. This mismatch
     *         typically occurs when a user sets one subnet ID to a regional Availability Zone and a different one to an
     *         outpost. Or when a user sets the subnet ID to an Outpost when not subscribed on this service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.CreateCacheSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CreateCacheSubnetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCacheSubnetGroupResponse> createCacheSubnetGroup(
            Consumer<CreateCacheSubnetGroupRequest.Builder> createCacheSubnetGroupRequest) {
        return createCacheSubnetGroup(CreateCacheSubnetGroupRequest.builder().applyMutation(createCacheSubnetGroupRequest)
                .build());
    }

    /**
     * <p>
     * Global Datastore for Redis offers fully managed, fast, reliable and secure cross-region replication. Using Global
     * Datastore for Redis, you can create cross-region read replica clusters for ElastiCache for Redis to enable
     * low-latency reads and disaster recovery across regions. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Redis-Global-Datastore.html">Replication Across
     * Regions Using Global Datastore</a>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <b>GlobalReplicationGroupIdSuffix</b> is the name of the Global datastore.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <b>PrimaryReplicationGroupId</b> represents the name of the primary cluster that accepts writes and will
     * replicate updates to the secondary cluster.
     * </p>
     * </li>
     * </ul>
     *
     * @param createGlobalReplicationGroupRequest
     * @return A Java Future containing the result of the CreateGlobalReplicationGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReplicationGroupNotFoundException The specified replication group does not exist.</li>
     *         <li>InvalidReplicationGroupStateException The requested replication group is not in the
     *         <code>available</code> state.</li>
     *         <li>GlobalReplicationGroupAlreadyExistsException The Global datastore name already exists.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.CreateGlobalReplicationGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CreateGlobalReplicationGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateGlobalReplicationGroupResponse> createGlobalReplicationGroup(
            CreateGlobalReplicationGroupRequest createGlobalReplicationGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Global Datastore for Redis offers fully managed, fast, reliable and secure cross-region replication. Using Global
     * Datastore for Redis, you can create cross-region read replica clusters for ElastiCache for Redis to enable
     * low-latency reads and disaster recovery across regions. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Redis-Global-Datastore.html">Replication Across
     * Regions Using Global Datastore</a>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <b>GlobalReplicationGroupIdSuffix</b> is the name of the Global datastore.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <b>PrimaryReplicationGroupId</b> represents the name of the primary cluster that accepts writes and will
     * replicate updates to the secondary cluster.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGlobalReplicationGroupRequest.Builder}
     * avoiding the need to create one manually via {@link CreateGlobalReplicationGroupRequest#builder()}
     * </p>
     *
     * @param createGlobalReplicationGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateGlobalReplicationGroupMessage.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateGlobalReplicationGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReplicationGroupNotFoundException The specified replication group does not exist.</li>
     *         <li>InvalidReplicationGroupStateException The requested replication group is not in the
     *         <code>available</code> state.</li>
     *         <li>GlobalReplicationGroupAlreadyExistsException The Global datastore name already exists.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.CreateGlobalReplicationGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CreateGlobalReplicationGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateGlobalReplicationGroupResponse> createGlobalReplicationGroup(
            Consumer<CreateGlobalReplicationGroupRequest.Builder> createGlobalReplicationGroupRequest) {
        return createGlobalReplicationGroup(CreateGlobalReplicationGroupRequest.builder()
                .applyMutation(createGlobalReplicationGroupRequest).build());
    }

    /**
     * <p>
     * Creates a Redis (cluster mode disabled) or a Redis (cluster mode enabled) replication group.
     * </p>
     * <p>
     * This API can be used to create a standalone regional replication group or a secondary replication group
     * associated with a Global datastore.
     * </p>
     * <p>
     * A Redis (cluster mode disabled) replication group is a collection of clusters, where one of the clusters is a
     * read/write primary and the others are read-only replicas. Writes to the primary are asynchronously propagated to
     * the replicas.
     * </p>
     * <p>
     * A Redis cluster-mode enabled cluster is comprised of from 1 to 90 shards (API/CLI: node groups). Each shard has a
     * primary node and up to 5 read-only replica nodes. The configuration can range from 90 shards and 0 replicas to 15
     * shards and 5 replicas, which is the maximum number or replicas allowed.
     * </p>
     * <p>
     * The node or shard limit can be increased to a maximum of 500 per cluster if the Redis engine version is 5.0.6 or
     * higher. For example, you can choose to configure a 500 node cluster that ranges between 83 shards (one primary
     * and 5 replicas per shard) and 500 shards (single primary and no replicas). Make sure there are enough available
     * IP addresses to accommodate the increase. Common pitfalls include the subnets in the subnet group have too small
     * a CIDR range or the subnets are shared and heavily used by other clusters. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.Creating.html">Creating a Subnet
     * Group</a>. For versions below 5.0.6, the limit is 250 per cluster.
     * </p>
     * <p>
     * To request a limit increase, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">Amazon Service Limits</a> and choose
     * the limit type <b>Nodes per cluster per instance type</b>.
     * </p>
     * <p>
     * When a Redis (cluster mode disabled) replication group has been successfully created, you can add one or more
     * read replicas to it, up to a total of 5 read replicas. If you need to increase or decrease the number of node
     * groups (console: shards), you can avail yourself of ElastiCache for Redis' scaling. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Scaling.html">Scaling ElastiCache for Redis
     * Clusters</a> in the <i>ElastiCache User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This operation is valid for Redis only.
     * </p>
     * </note>
     *
     * @param createReplicationGroupRequest
     *        Represents the input of a <code>CreateReplicationGroup</code> operation.
     * @return A Java Future containing the result of the CreateReplicationGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheClusterNotFoundException The requested cluster ID does not refer to an existing cluster.</li>
     *         <li>InvalidCacheClusterStateException The requested cluster is not in the <code>available</code> state.</li>
     *         <li>ReplicationGroupAlreadyExistsException The specified replication group already exists.</li>
     *         <li>InvalidUserGroupStateException The user group is not in an active state.</li>
     *         <li>UserGroupNotFoundException The user group was not found or does not exist</li>
     *         <li>InsufficientCacheClusterCapacityException The requested cache node type is not available in the
     *         specified Availability Zone. For more information, see <a href=
     *         "http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ErrorMessages.html#ErrorMessages.INSUFFICIENT_CACHE_CLUSTER_CAPACITY"
     *         >InsufficientCacheClusterCapacity</a> in the ElastiCache User Guide.</li>
     *         <li>CacheSecurityGroupNotFoundException The requested cache security group name does not refer to an
     *         existing cache security group.</li>
     *         <li>CacheSubnetGroupNotFoundException The requested cache subnet group name does not refer to an existing
     *         cache subnet group.</li>
     *         <li>ClusterQuotaForCustomerExceededException The request cannot be processed because it would exceed the
     *         allowed number of clusters per customer.</li>
     *         <li>NodeQuotaForClusterExceededException The request cannot be processed because it would exceed the
     *         allowed number of cache nodes in a single cluster.</li>
     *         <li>NodeQuotaForCustomerExceededException The request cannot be processed because it would exceed the
     *         allowed number of cache nodes per customer.</li>
     *         <li>CacheParameterGroupNotFoundException The requested cache parameter group name does not refer to an
     *         existing cache parameter group.</li>
     *         <li>InvalidVpcNetworkStateException The VPC network is in an invalid state.</li>
     *         <li>TagQuotaPerResourceExceededException The request cannot be processed because it would cause the
     *         resource to have more than the allowed number of tags. The maximum number of tags permitted on a resource
     *         is 50.</li>
     *         <li>NodeGroupsPerReplicationGroupQuotaExceededException The request cannot be processed because it would
     *         exceed the maximum allowed number of node groups (shards) in a single replication group. The default
     *         maximum is 90</li>
     *         <li>GlobalReplicationGroupNotFoundException The Global datastore does not exist</li>
     *         <li>InvalidGlobalReplicationGroupStateException The Global datastore is not available or in primary-only
     *         state.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.CreateReplicationGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CreateReplicationGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateReplicationGroupResponse> createReplicationGroup(
            CreateReplicationGroupRequest createReplicationGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Redis (cluster mode disabled) or a Redis (cluster mode enabled) replication group.
     * </p>
     * <p>
     * This API can be used to create a standalone regional replication group or a secondary replication group
     * associated with a Global datastore.
     * </p>
     * <p>
     * A Redis (cluster mode disabled) replication group is a collection of clusters, where one of the clusters is a
     * read/write primary and the others are read-only replicas. Writes to the primary are asynchronously propagated to
     * the replicas.
     * </p>
     * <p>
     * A Redis cluster-mode enabled cluster is comprised of from 1 to 90 shards (API/CLI: node groups). Each shard has a
     * primary node and up to 5 read-only replica nodes. The configuration can range from 90 shards and 0 replicas to 15
     * shards and 5 replicas, which is the maximum number or replicas allowed.
     * </p>
     * <p>
     * The node or shard limit can be increased to a maximum of 500 per cluster if the Redis engine version is 5.0.6 or
     * higher. For example, you can choose to configure a 500 node cluster that ranges between 83 shards (one primary
     * and 5 replicas per shard) and 500 shards (single primary and no replicas). Make sure there are enough available
     * IP addresses to accommodate the increase. Common pitfalls include the subnets in the subnet group have too small
     * a CIDR range or the subnets are shared and heavily used by other clusters. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.Creating.html">Creating a Subnet
     * Group</a>. For versions below 5.0.6, the limit is 250 per cluster.
     * </p>
     * <p>
     * To request a limit increase, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">Amazon Service Limits</a> and choose
     * the limit type <b>Nodes per cluster per instance type</b>.
     * </p>
     * <p>
     * When a Redis (cluster mode disabled) replication group has been successfully created, you can add one or more
     * read replicas to it, up to a total of 5 read replicas. If you need to increase or decrease the number of node
     * groups (console: shards), you can avail yourself of ElastiCache for Redis' scaling. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Scaling.html">Scaling ElastiCache for Redis
     * Clusters</a> in the <i>ElastiCache User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This operation is valid for Redis only.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateReplicationGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateReplicationGroupRequest#builder()}
     * </p>
     *
     * @param createReplicationGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateReplicationGroupMessage.Builder} to create a
     *        request. Represents the input of a <code>CreateReplicationGroup</code> operation.
     * @return A Java Future containing the result of the CreateReplicationGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheClusterNotFoundException The requested cluster ID does not refer to an existing cluster.</li>
     *         <li>InvalidCacheClusterStateException The requested cluster is not in the <code>available</code> state.</li>
     *         <li>ReplicationGroupAlreadyExistsException The specified replication group already exists.</li>
     *         <li>InvalidUserGroupStateException The user group is not in an active state.</li>
     *         <li>UserGroupNotFoundException The user group was not found or does not exist</li>
     *         <li>InsufficientCacheClusterCapacityException The requested cache node type is not available in the
     *         specified Availability Zone. For more information, see <a href=
     *         "http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ErrorMessages.html#ErrorMessages.INSUFFICIENT_CACHE_CLUSTER_CAPACITY"
     *         >InsufficientCacheClusterCapacity</a> in the ElastiCache User Guide.</li>
     *         <li>CacheSecurityGroupNotFoundException The requested cache security group name does not refer to an
     *         existing cache security group.</li>
     *         <li>CacheSubnetGroupNotFoundException The requested cache subnet group name does not refer to an existing
     *         cache subnet group.</li>
     *         <li>ClusterQuotaForCustomerExceededException The request cannot be processed because it would exceed the
     *         allowed number of clusters per customer.</li>
     *         <li>NodeQuotaForClusterExceededException The request cannot be processed because it would exceed the
     *         allowed number of cache nodes in a single cluster.</li>
     *         <li>NodeQuotaForCustomerExceededException The request cannot be processed because it would exceed the
     *         allowed number of cache nodes per customer.</li>
     *         <li>CacheParameterGroupNotFoundException The requested cache parameter group name does not refer to an
     *         existing cache parameter group.</li>
     *         <li>InvalidVpcNetworkStateException The VPC network is in an invalid state.</li>
     *         <li>TagQuotaPerResourceExceededException The request cannot be processed because it would cause the
     *         resource to have more than the allowed number of tags. The maximum number of tags permitted on a resource
     *         is 50.</li>
     *         <li>NodeGroupsPerReplicationGroupQuotaExceededException The request cannot be processed because it would
     *         exceed the maximum allowed number of node groups (shards) in a single replication group. The default
     *         maximum is 90</li>
     *         <li>GlobalReplicationGroupNotFoundException The Global datastore does not exist</li>
     *         <li>InvalidGlobalReplicationGroupStateException The Global datastore is not available or in primary-only
     *         state.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.CreateReplicationGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CreateReplicationGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateReplicationGroupResponse> createReplicationGroup(
            Consumer<CreateReplicationGroupRequest.Builder> createReplicationGroupRequest) {
        return createReplicationGroup(CreateReplicationGroupRequest.builder().applyMutation(createReplicationGroupRequest)
                .build());
    }

    /**
     * <p>
     * Creates a copy of an entire cluster or replication group at a specific moment in time.
     * </p>
     * <note>
     * <p>
     * This operation is valid for Redis only.
     * </p>
     * </note>
     *
     * @param createSnapshotRequest
     *        Represents the input of a <code>CreateSnapshot</code> operation.
     * @return A Java Future containing the result of the CreateSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SnapshotAlreadyExistsException You already have a snapshot with the given name.</li>
     *         <li>CacheClusterNotFoundException The requested cluster ID does not refer to an existing cluster.</li>
     *         <li>ReplicationGroupNotFoundException The specified replication group does not exist.</li>
     *         <li>InvalidCacheClusterStateException The requested cluster is not in the <code>available</code> state.</li>
     *         <li>InvalidReplicationGroupStateException The requested replication group is not in the
     *         <code>available</code> state.</li>
     *         <li>SnapshotQuotaExceededException The request cannot be processed because it would exceed the maximum
     *         number of snapshots.</li>
     *         <li>SnapshotFeatureNotSupportedException You attempted one of the following operations:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Creating a snapshot of a Redis cluster running on a <code>cache.t1.micro</code> cache node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Creating a snapshot of a cluster that is running Memcached rather than Redis.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Neither of these are supported by ElastiCache.</li>
     *         <li>TagQuotaPerResourceExceededException The request cannot be processed because it would cause the
     *         resource to have more than the allowed number of tags. The maximum number of tags permitted on a resource
     *         is 50.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.CreateSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CreateSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateSnapshotResponse> createSnapshot(CreateSnapshotRequest createSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a copy of an entire cluster or replication group at a specific moment in time.
     * </p>
     * <note>
     * <p>
     * This operation is valid for Redis only.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSnapshotRequest.Builder} avoiding the need to
     * create one manually via {@link CreateSnapshotRequest#builder()}
     * </p>
     *
     * @param createSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link CreateSnapshotMessage.Builder} to create a request.
     *        Represents the input of a <code>CreateSnapshot</code> operation.
     * @return A Java Future containing the result of the CreateSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SnapshotAlreadyExistsException You already have a snapshot with the given name.</li>
     *         <li>CacheClusterNotFoundException The requested cluster ID does not refer to an existing cluster.</li>
     *         <li>ReplicationGroupNotFoundException The specified replication group does not exist.</li>
     *         <li>InvalidCacheClusterStateException The requested cluster is not in the <code>available</code> state.</li>
     *         <li>InvalidReplicationGroupStateException The requested replication group is not in the
     *         <code>available</code> state.</li>
     *         <li>SnapshotQuotaExceededException The request cannot be processed because it would exceed the maximum
     *         number of snapshots.</li>
     *         <li>SnapshotFeatureNotSupportedException You attempted one of the following operations:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Creating a snapshot of a Redis cluster running on a <code>cache.t1.micro</code> cache node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Creating a snapshot of a cluster that is running Memcached rather than Redis.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Neither of these are supported by ElastiCache.</li>
     *         <li>TagQuotaPerResourceExceededException The request cannot be processed because it would cause the
     *         resource to have more than the allowed number of tags. The maximum number of tags permitted on a resource
     *         is 50.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.CreateSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CreateSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateSnapshotResponse> createSnapshot(Consumer<CreateSnapshotRequest.Builder> createSnapshotRequest) {
        return createSnapshot(CreateSnapshotRequest.builder().applyMutation(createSnapshotRequest).build());
    }

    /**
     * <p>
     * For Redis engine version 6.0 onwards: Creates a Redis user. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html">Using Role Based Access
     * Control (RBAC)</a>.
     * </p>
     *
     * @param createUserRequest
     * @return A Java Future containing the result of the CreateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UserAlreadyExistsException A user with this ID already exists.</li>
     *         <li>UserQuotaExceededException The quota of users has been exceeded.</li>
     *         <li>DuplicateUserNameException A user with this username already exists.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>TagQuotaPerResourceExceededException The request cannot be processed because it would cause the
     *         resource to have more than the allowed number of tags. The maximum number of tags permitted on a resource
     *         is 50.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.CreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CreateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateUserResponse> createUser(CreateUserRequest createUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For Redis engine version 6.0 onwards: Creates a Redis user. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html">Using Role Based Access
     * Control (RBAC)</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUserRequest.Builder} avoiding the need to
     * create one manually via {@link CreateUserRequest#builder()}
     * </p>
     *
     * @param createUserRequest
     *        A {@link Consumer} that will call methods on {@link CreateUserMessage.Builder} to create a request.
     * @return A Java Future containing the result of the CreateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UserAlreadyExistsException A user with this ID already exists.</li>
     *         <li>UserQuotaExceededException The quota of users has been exceeded.</li>
     *         <li>DuplicateUserNameException A user with this username already exists.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>TagQuotaPerResourceExceededException The request cannot be processed because it would cause the
     *         resource to have more than the allowed number of tags. The maximum number of tags permitted on a resource
     *         is 50.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.CreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CreateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateUserResponse> createUser(Consumer<CreateUserRequest.Builder> createUserRequest) {
        return createUser(CreateUserRequest.builder().applyMutation(createUserRequest).build());
    }

    /**
     * <p>
     * For Redis engine version 6.0 onwards: Creates a Redis user group. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html">Using Role Based Access
     * Control (RBAC)</a>
     * </p>
     *
     * @param createUserGroupRequest
     * @return A Java Future containing the result of the CreateUserGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UserNotFoundException The user does not exist or could not be found.</li>
     *         <li>DuplicateUserNameException A user with this username already exists.</li>
     *         <li>UserGroupAlreadyExistsException The user group with this ID already exists.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>DefaultUserRequiredException You must add default user to a user group.</li>
     *         <li>UserGroupQuotaExceededException The number of users exceeds the user group limit.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>TagQuotaPerResourceExceededException The request cannot be processed because it would cause the
     *         resource to have more than the allowed number of tags. The maximum number of tags permitted on a resource
     *         is 50.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.CreateUserGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CreateUserGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateUserGroupResponse> createUserGroup(CreateUserGroupRequest createUserGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For Redis engine version 6.0 onwards: Creates a Redis user group. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html">Using Role Based Access
     * Control (RBAC)</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUserGroupRequest.Builder} avoiding the need
     * to create one manually via {@link CreateUserGroupRequest#builder()}
     * </p>
     *
     * @param createUserGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateUserGroupMessage.Builder} to create a request.
     * @return A Java Future containing the result of the CreateUserGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UserNotFoundException The user does not exist or could not be found.</li>
     *         <li>DuplicateUserNameException A user with this username already exists.</li>
     *         <li>UserGroupAlreadyExistsException The user group with this ID already exists.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>DefaultUserRequiredException You must add default user to a user group.</li>
     *         <li>UserGroupQuotaExceededException The number of users exceeds the user group limit.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>TagQuotaPerResourceExceededException The request cannot be processed because it would cause the
     *         resource to have more than the allowed number of tags. The maximum number of tags permitted on a resource
     *         is 50.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.CreateUserGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CreateUserGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateUserGroupResponse> createUserGroup(
            Consumer<CreateUserGroupRequest.Builder> createUserGroupRequest) {
        return createUserGroup(CreateUserGroupRequest.builder().applyMutation(createUserGroupRequest).build());
    }

    /**
     * <p>
     * Decreases the number of node groups in a Global datastore
     * </p>
     *
     * @param decreaseNodeGroupsInGlobalReplicationGroupRequest
     * @return A Java Future containing the result of the DecreaseNodeGroupsInGlobalReplicationGroup operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GlobalReplicationGroupNotFoundException The Global datastore does not exist</li>
     *         <li>InvalidGlobalReplicationGroupStateException The Global datastore is not available or in primary-only
     *         state.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DecreaseNodeGroupsInGlobalReplicationGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DecreaseNodeGroupsInGlobalReplicationGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DecreaseNodeGroupsInGlobalReplicationGroupResponse> decreaseNodeGroupsInGlobalReplicationGroup(
            DecreaseNodeGroupsInGlobalReplicationGroupRequest decreaseNodeGroupsInGlobalReplicationGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Decreases the number of node groups in a Global datastore
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DecreaseNodeGroupsInGlobalReplicationGroupRequest.Builder} avoiding the need to create one manually via
     * {@link DecreaseNodeGroupsInGlobalReplicationGroupRequest#builder()}
     * </p>
     *
     * @param decreaseNodeGroupsInGlobalReplicationGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DecreaseNodeGroupsInGlobalReplicationGroupMessage.Builder} to create a request.
     * @return A Java Future containing the result of the DecreaseNodeGroupsInGlobalReplicationGroup operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GlobalReplicationGroupNotFoundException The Global datastore does not exist</li>
     *         <li>InvalidGlobalReplicationGroupStateException The Global datastore is not available or in primary-only
     *         state.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DecreaseNodeGroupsInGlobalReplicationGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DecreaseNodeGroupsInGlobalReplicationGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DecreaseNodeGroupsInGlobalReplicationGroupResponse> decreaseNodeGroupsInGlobalReplicationGroup(
            Consumer<DecreaseNodeGroupsInGlobalReplicationGroupRequest.Builder> decreaseNodeGroupsInGlobalReplicationGroupRequest) {
        return decreaseNodeGroupsInGlobalReplicationGroup(DecreaseNodeGroupsInGlobalReplicationGroupRequest.builder()
                .applyMutation(decreaseNodeGroupsInGlobalReplicationGroupRequest).build());
    }

    /**
     * <p>
     * Dynamically decreases the number of replicas in a Redis (cluster mode disabled) replication group or the number
     * of replica nodes in one or more node groups (shards) of a Redis (cluster mode enabled) replication group. This
     * operation is performed with no cluster down time.
     * </p>
     *
     * @param decreaseReplicaCountRequest
     * @return A Java Future containing the result of the DecreaseReplicaCount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReplicationGroupNotFoundException The specified replication group does not exist.</li>
     *         <li>InvalidReplicationGroupStateException The requested replication group is not in the
     *         <code>available</code> state.</li>
     *         <li>InvalidCacheClusterStateException The requested cluster is not in the <code>available</code> state.</li>
     *         <li>InvalidVpcNetworkStateException The VPC network is in an invalid state.</li>
     *         <li>InsufficientCacheClusterCapacityException The requested cache node type is not available in the
     *         specified Availability Zone. For more information, see <a href=
     *         "http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ErrorMessages.html#ErrorMessages.INSUFFICIENT_CACHE_CLUSTER_CAPACITY"
     *         >InsufficientCacheClusterCapacity</a> in the ElastiCache User Guide.</li>
     *         <li>ClusterQuotaForCustomerExceededException The request cannot be processed because it would exceed the
     *         allowed number of clusters per customer.</li>
     *         <li>NodeGroupsPerReplicationGroupQuotaExceededException The request cannot be processed because it would
     *         exceed the maximum allowed number of node groups (shards) in a single replication group. The default
     *         maximum is 90</li>
     *         <li>NodeQuotaForCustomerExceededException The request cannot be processed because it would exceed the
     *         allowed number of cache nodes per customer.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>NoOperationException The operation was not performed because no changes were required.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DecreaseReplicaCount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DecreaseReplicaCount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DecreaseReplicaCountResponse> decreaseReplicaCount(
            DecreaseReplicaCountRequest decreaseReplicaCountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Dynamically decreases the number of replicas in a Redis (cluster mode disabled) replication group or the number
     * of replica nodes in one or more node groups (shards) of a Redis (cluster mode enabled) replication group. This
     * operation is performed with no cluster down time.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DecreaseReplicaCountRequest.Builder} avoiding the
     * need to create one manually via {@link DecreaseReplicaCountRequest#builder()}
     * </p>
     *
     * @param decreaseReplicaCountRequest
     *        A {@link Consumer} that will call methods on {@link DecreaseReplicaCountMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DecreaseReplicaCount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReplicationGroupNotFoundException The specified replication group does not exist.</li>
     *         <li>InvalidReplicationGroupStateException The requested replication group is not in the
     *         <code>available</code> state.</li>
     *         <li>InvalidCacheClusterStateException The requested cluster is not in the <code>available</code> state.</li>
     *         <li>InvalidVpcNetworkStateException The VPC network is in an invalid state.</li>
     *         <li>InsufficientCacheClusterCapacityException The requested cache node type is not available in the
     *         specified Availability Zone. For more information, see <a href=
     *         "http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ErrorMessages.html#ErrorMessages.INSUFFICIENT_CACHE_CLUSTER_CAPACITY"
     *         >InsufficientCacheClusterCapacity</a> in the ElastiCache User Guide.</li>
     *         <li>ClusterQuotaForCustomerExceededException The request cannot be processed because it would exceed the
     *         allowed number of clusters per customer.</li>
     *         <li>NodeGroupsPerReplicationGroupQuotaExceededException The request cannot be processed because it would
     *         exceed the maximum allowed number of node groups (shards) in a single replication group. The default
     *         maximum is 90</li>
     *         <li>NodeQuotaForCustomerExceededException The request cannot be processed because it would exceed the
     *         allowed number of cache nodes per customer.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>NoOperationException The operation was not performed because no changes were required.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DecreaseReplicaCount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DecreaseReplicaCount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DecreaseReplicaCountResponse> decreaseReplicaCount(
            Consumer<DecreaseReplicaCountRequest.Builder> decreaseReplicaCountRequest) {
        return decreaseReplicaCount(DecreaseReplicaCountRequest.builder().applyMutation(decreaseReplicaCountRequest).build());
    }

    /**
     * <p>
     * Deletes a previously provisioned cluster. <code>DeleteCacheCluster</code> deletes all associated cache nodes,
     * node endpoints and the cluster itself. When you receive a successful response from this operation, Amazon
     * ElastiCache immediately begins deleting the cluster; you cannot cancel or revert this operation.
     * </p>
     * <p>
     * This operation is not valid for:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Redis (cluster mode enabled) clusters
     * </p>
     * </li>
     * <li>
     * <p>
     * Redis (cluster mode disabled) clusters
     * </p>
     * </li>
     * <li>
     * <p>
     * A cluster that is the last read replica of a replication group
     * </p>
     * </li>
     * <li>
     * <p>
     * A cluster that is the primary node of a replication group
     * </p>
     * </li>
     * <li>
     * <p>
     * A node group (shard) that has Multi-AZ mode enabled
     * </p>
     * </li>
     * <li>
     * <p>
     * A cluster from a Redis (cluster mode enabled) replication group
     * </p>
     * </li>
     * <li>
     * <p>
     * A cluster that is not in the <code>available</code> state
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteCacheClusterRequest
     *        Represents the input of a <code>DeleteCacheCluster</code> operation.
     * @return A Java Future containing the result of the DeleteCacheCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheClusterNotFoundException The requested cluster ID does not refer to an existing cluster.</li>
     *         <li>InvalidCacheClusterStateException The requested cluster is not in the <code>available</code> state.</li>
     *         <li>SnapshotAlreadyExistsException You already have a snapshot with the given name.</li>
     *         <li>SnapshotFeatureNotSupportedException You attempted one of the following operations:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Creating a snapshot of a Redis cluster running on a <code>cache.t1.micro</code> cache node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Creating a snapshot of a cluster that is running Memcached rather than Redis.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Neither of these are supported by ElastiCache.</li>
     *         <li>SnapshotQuotaExceededException The request cannot be processed because it would exceed the maximum
     *         number of snapshots.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DeleteCacheCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteCacheCluster"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCacheClusterResponse> deleteCacheCluster(DeleteCacheClusterRequest deleteCacheClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a previously provisioned cluster. <code>DeleteCacheCluster</code> deletes all associated cache nodes,
     * node endpoints and the cluster itself. When you receive a successful response from this operation, Amazon
     * ElastiCache immediately begins deleting the cluster; you cannot cancel or revert this operation.
     * </p>
     * <p>
     * This operation is not valid for:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Redis (cluster mode enabled) clusters
     * </p>
     * </li>
     * <li>
     * <p>
     * Redis (cluster mode disabled) clusters
     * </p>
     * </li>
     * <li>
     * <p>
     * A cluster that is the last read replica of a replication group
     * </p>
     * </li>
     * <li>
     * <p>
     * A cluster that is the primary node of a replication group
     * </p>
     * </li>
     * <li>
     * <p>
     * A node group (shard) that has Multi-AZ mode enabled
     * </p>
     * </li>
     * <li>
     * <p>
     * A cluster from a Redis (cluster mode enabled) replication group
     * </p>
     * </li>
     * <li>
     * <p>
     * A cluster that is not in the <code>available</code> state
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCacheClusterRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteCacheClusterRequest#builder()}
     * </p>
     *
     * @param deleteCacheClusterRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCacheClusterMessage.Builder} to create a
     *        request. Represents the input of a <code>DeleteCacheCluster</code> operation.
     * @return A Java Future containing the result of the DeleteCacheCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheClusterNotFoundException The requested cluster ID does not refer to an existing cluster.</li>
     *         <li>InvalidCacheClusterStateException The requested cluster is not in the <code>available</code> state.</li>
     *         <li>SnapshotAlreadyExistsException You already have a snapshot with the given name.</li>
     *         <li>SnapshotFeatureNotSupportedException You attempted one of the following operations:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Creating a snapshot of a Redis cluster running on a <code>cache.t1.micro</code> cache node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Creating a snapshot of a cluster that is running Memcached rather than Redis.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Neither of these are supported by ElastiCache.</li>
     *         <li>SnapshotQuotaExceededException The request cannot be processed because it would exceed the maximum
     *         number of snapshots.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DeleteCacheCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteCacheCluster"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCacheClusterResponse> deleteCacheCluster(
            Consumer<DeleteCacheClusterRequest.Builder> deleteCacheClusterRequest) {
        return deleteCacheCluster(DeleteCacheClusterRequest.builder().applyMutation(deleteCacheClusterRequest).build());
    }

    /**
     * <p>
     * Deletes the specified cache parameter group. You cannot delete a cache parameter group if it is associated with
     * any cache clusters. You cannot delete the default cache parameter groups in your account.
     * </p>
     *
     * @param deleteCacheParameterGroupRequest
     *        Represents the input of a <code>DeleteCacheParameterGroup</code> operation.
     * @return A Java Future containing the result of the DeleteCacheParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidCacheParameterGroupStateException The current state of the cache parameter group does not
     *         allow the requested operation to occur.</li>
     *         <li>CacheParameterGroupNotFoundException The requested cache parameter group name does not refer to an
     *         existing cache parameter group.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DeleteCacheParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteCacheParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCacheParameterGroupResponse> deleteCacheParameterGroup(
            DeleteCacheParameterGroupRequest deleteCacheParameterGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified cache parameter group. You cannot delete a cache parameter group if it is associated with
     * any cache clusters. You cannot delete the default cache parameter groups in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCacheParameterGroupRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteCacheParameterGroupRequest#builder()}
     * </p>
     *
     * @param deleteCacheParameterGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCacheParameterGroupMessage.Builder} to create a
     *        request. Represents the input of a <code>DeleteCacheParameterGroup</code> operation.
     * @return A Java Future containing the result of the DeleteCacheParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidCacheParameterGroupStateException The current state of the cache parameter group does not
     *         allow the requested operation to occur.</li>
     *         <li>CacheParameterGroupNotFoundException The requested cache parameter group name does not refer to an
     *         existing cache parameter group.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DeleteCacheParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteCacheParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCacheParameterGroupResponse> deleteCacheParameterGroup(
            Consumer<DeleteCacheParameterGroupRequest.Builder> deleteCacheParameterGroupRequest) {
        return deleteCacheParameterGroup(DeleteCacheParameterGroupRequest.builder()
                .applyMutation(deleteCacheParameterGroupRequest).build());
    }

    /**
     * <p>
     * Deletes a cache security group.
     * </p>
     * <note>
     * <p>
     * You cannot delete a cache security group if it is associated with any clusters.
     * </p>
     * </note>
     *
     * @param deleteCacheSecurityGroupRequest
     *        Represents the input of a <code>DeleteCacheSecurityGroup</code> operation.
     * @return A Java Future containing the result of the DeleteCacheSecurityGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidCacheSecurityGroupStateException The current state of the cache security group does not allow
     *         deletion.</li>
     *         <li>CacheSecurityGroupNotFoundException The requested cache security group name does not refer to an
     *         existing cache security group.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DeleteCacheSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteCacheSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCacheSecurityGroupResponse> deleteCacheSecurityGroup(
            DeleteCacheSecurityGroupRequest deleteCacheSecurityGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a cache security group.
     * </p>
     * <note>
     * <p>
     * You cannot delete a cache security group if it is associated with any clusters.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCacheSecurityGroupRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteCacheSecurityGroupRequest#builder()}
     * </p>
     *
     * @param deleteCacheSecurityGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCacheSecurityGroupMessage.Builder} to create a
     *        request. Represents the input of a <code>DeleteCacheSecurityGroup</code> operation.
     * @return A Java Future containing the result of the DeleteCacheSecurityGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidCacheSecurityGroupStateException The current state of the cache security group does not allow
     *         deletion.</li>
     *         <li>CacheSecurityGroupNotFoundException The requested cache security group name does not refer to an
     *         existing cache security group.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DeleteCacheSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteCacheSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCacheSecurityGroupResponse> deleteCacheSecurityGroup(
            Consumer<DeleteCacheSecurityGroupRequest.Builder> deleteCacheSecurityGroupRequest) {
        return deleteCacheSecurityGroup(DeleteCacheSecurityGroupRequest.builder().applyMutation(deleteCacheSecurityGroupRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a cache subnet group.
     * </p>
     * <note>
     * <p>
     * You cannot delete a default cache subnet group or one that is associated with any clusters.
     * </p>
     * </note>
     *
     * @param deleteCacheSubnetGroupRequest
     *        Represents the input of a <code>DeleteCacheSubnetGroup</code> operation.
     * @return A Java Future containing the result of the DeleteCacheSubnetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheSubnetGroupInUseException The requested cache subnet group is currently in use.</li>
     *         <li>CacheSubnetGroupNotFoundException The requested cache subnet group name does not refer to an existing
     *         cache subnet group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DeleteCacheSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteCacheSubnetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCacheSubnetGroupResponse> deleteCacheSubnetGroup(
            DeleteCacheSubnetGroupRequest deleteCacheSubnetGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a cache subnet group.
     * </p>
     * <note>
     * <p>
     * You cannot delete a default cache subnet group or one that is associated with any clusters.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCacheSubnetGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteCacheSubnetGroupRequest#builder()}
     * </p>
     *
     * @param deleteCacheSubnetGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCacheSubnetGroupMessage.Builder} to create a
     *        request. Represents the input of a <code>DeleteCacheSubnetGroup</code> operation.
     * @return A Java Future containing the result of the DeleteCacheSubnetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheSubnetGroupInUseException The requested cache subnet group is currently in use.</li>
     *         <li>CacheSubnetGroupNotFoundException The requested cache subnet group name does not refer to an existing
     *         cache subnet group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DeleteCacheSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteCacheSubnetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCacheSubnetGroupResponse> deleteCacheSubnetGroup(
            Consumer<DeleteCacheSubnetGroupRequest.Builder> deleteCacheSubnetGroupRequest) {
        return deleteCacheSubnetGroup(DeleteCacheSubnetGroupRequest.builder().applyMutation(deleteCacheSubnetGroupRequest)
                .build());
    }

    /**
     * <p>
     * Deleting a Global datastore is a two-step process:
     * </p>
     * <ul>
     * <li>
     * <p>
     * First, you must <a>DisassociateGlobalReplicationGroup</a> to remove the secondary clusters in the Global
     * datastore.
     * </p>
     * </li>
     * <li>
     * <p>
     * Once the Global datastore contains only the primary cluster, you can use the
     * <code>DeleteGlobalReplicationGroup</code> API to delete the Global datastore while retainining the primary
     * cluster using <code>RetainPrimaryReplicationGroup=true</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Since the Global Datastore has only a primary cluster, you can delete the Global Datastore while retaining the
     * primary by setting <code>RetainPrimaryReplicationGroup=true</code>. The primary cluster is never deleted when
     * deleting a Global Datastore. It can only be deleted when it no longer is associated with any Global Datastore.
     * </p>
     * <p>
     * When you receive a successful response from this operation, Amazon ElastiCache immediately begins deleting the
     * selected resources; you cannot cancel or revert this operation.
     * </p>
     *
     * @param deleteGlobalReplicationGroupRequest
     * @return A Java Future containing the result of the DeleteGlobalReplicationGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GlobalReplicationGroupNotFoundException The Global datastore does not exist</li>
     *         <li>InvalidGlobalReplicationGroupStateException The Global datastore is not available or in primary-only
     *         state.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DeleteGlobalReplicationGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteGlobalReplicationGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteGlobalReplicationGroupResponse> deleteGlobalReplicationGroup(
            DeleteGlobalReplicationGroupRequest deleteGlobalReplicationGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deleting a Global datastore is a two-step process:
     * </p>
     * <ul>
     * <li>
     * <p>
     * First, you must <a>DisassociateGlobalReplicationGroup</a> to remove the secondary clusters in the Global
     * datastore.
     * </p>
     * </li>
     * <li>
     * <p>
     * Once the Global datastore contains only the primary cluster, you can use the
     * <code>DeleteGlobalReplicationGroup</code> API to delete the Global datastore while retainining the primary
     * cluster using <code>RetainPrimaryReplicationGroup=true</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Since the Global Datastore has only a primary cluster, you can delete the Global Datastore while retaining the
     * primary by setting <code>RetainPrimaryReplicationGroup=true</code>. The primary cluster is never deleted when
     * deleting a Global Datastore. It can only be deleted when it no longer is associated with any Global Datastore.
     * </p>
     * <p>
     * When you receive a successful response from this operation, Amazon ElastiCache immediately begins deleting the
     * selected resources; you cannot cancel or revert this operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGlobalReplicationGroupRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteGlobalReplicationGroupRequest#builder()}
     * </p>
     *
     * @param deleteGlobalReplicationGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteGlobalReplicationGroupMessage.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteGlobalReplicationGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GlobalReplicationGroupNotFoundException The Global datastore does not exist</li>
     *         <li>InvalidGlobalReplicationGroupStateException The Global datastore is not available or in primary-only
     *         state.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DeleteGlobalReplicationGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteGlobalReplicationGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteGlobalReplicationGroupResponse> deleteGlobalReplicationGroup(
            Consumer<DeleteGlobalReplicationGroupRequest.Builder> deleteGlobalReplicationGroupRequest) {
        return deleteGlobalReplicationGroup(DeleteGlobalReplicationGroupRequest.builder()
                .applyMutation(deleteGlobalReplicationGroupRequest).build());
    }

    /**
     * <p>
     * Deletes an existing replication group. By default, this operation deletes the entire replication group, including
     * the primary/primaries and all of the read replicas. If the replication group has only one primary, you can
     * optionally delete only the read replicas, while retaining the primary by setting
     * <code>RetainPrimaryCluster=true</code>.
     * </p>
     * <p>
     * When you receive a successful response from this operation, Amazon ElastiCache immediately begins deleting the
     * selected resources; you cannot cancel or revert this operation.
     * </p>
     * <note>
     * <p>
     * This operation is valid for Redis only.
     * </p>
     * </note>
     *
     * @param deleteReplicationGroupRequest
     *        Represents the input of a <code>DeleteReplicationGroup</code> operation.
     * @return A Java Future containing the result of the DeleteReplicationGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReplicationGroupNotFoundException The specified replication group does not exist.</li>
     *         <li>InvalidReplicationGroupStateException The requested replication group is not in the
     *         <code>available</code> state.</li>
     *         <li>SnapshotAlreadyExistsException You already have a snapshot with the given name.</li>
     *         <li>SnapshotFeatureNotSupportedException You attempted one of the following operations:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Creating a snapshot of a Redis cluster running on a <code>cache.t1.micro</code> cache node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Creating a snapshot of a cluster that is running Memcached rather than Redis.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Neither of these are supported by ElastiCache.</li>
     *         <li>SnapshotQuotaExceededException The request cannot be processed because it would exceed the maximum
     *         number of snapshots.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DeleteReplicationGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteReplicationGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteReplicationGroupResponse> deleteReplicationGroup(
            DeleteReplicationGroupRequest deleteReplicationGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing replication group. By default, this operation deletes the entire replication group, including
     * the primary/primaries and all of the read replicas. If the replication group has only one primary, you can
     * optionally delete only the read replicas, while retaining the primary by setting
     * <code>RetainPrimaryCluster=true</code>.
     * </p>
     * <p>
     * When you receive a successful response from this operation, Amazon ElastiCache immediately begins deleting the
     * selected resources; you cannot cancel or revert this operation.
     * </p>
     * <note>
     * <p>
     * This operation is valid for Redis only.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteReplicationGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteReplicationGroupRequest#builder()}
     * </p>
     *
     * @param deleteReplicationGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteReplicationGroupMessage.Builder} to create a
     *        request. Represents the input of a <code>DeleteReplicationGroup</code> operation.
     * @return A Java Future containing the result of the DeleteReplicationGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReplicationGroupNotFoundException The specified replication group does not exist.</li>
     *         <li>InvalidReplicationGroupStateException The requested replication group is not in the
     *         <code>available</code> state.</li>
     *         <li>SnapshotAlreadyExistsException You already have a snapshot with the given name.</li>
     *         <li>SnapshotFeatureNotSupportedException You attempted one of the following operations:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Creating a snapshot of a Redis cluster running on a <code>cache.t1.micro</code> cache node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Creating a snapshot of a cluster that is running Memcached rather than Redis.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Neither of these are supported by ElastiCache.</li>
     *         <li>SnapshotQuotaExceededException The request cannot be processed because it would exceed the maximum
     *         number of snapshots.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DeleteReplicationGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteReplicationGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteReplicationGroupResponse> deleteReplicationGroup(
            Consumer<DeleteReplicationGroupRequest.Builder> deleteReplicationGroupRequest) {
        return deleteReplicationGroup(DeleteReplicationGroupRequest.builder().applyMutation(deleteReplicationGroupRequest)
                .build());
    }

    /**
     * <p>
     * Deletes an existing snapshot. When you receive a successful response from this operation, ElastiCache immediately
     * begins deleting the snapshot; you cannot cancel or revert this operation.
     * </p>
     * <note>
     * <p>
     * This operation is valid for Redis only.
     * </p>
     * </note>
     *
     * @param deleteSnapshotRequest
     *        Represents the input of a <code>DeleteSnapshot</code> operation.
     * @return A Java Future containing the result of the DeleteSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SnapshotNotFoundException The requested snapshot name does not refer to an existing snapshot.</li>
     *         <li>InvalidSnapshotStateException The current state of the snapshot does not allow the requested
     *         operation to occur.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DeleteSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteSnapshotResponse> deleteSnapshot(DeleteSnapshotRequest deleteSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing snapshot. When you receive a successful response from this operation, ElastiCache immediately
     * begins deleting the snapshot; you cannot cancel or revert this operation.
     * </p>
     * <note>
     * <p>
     * This operation is valid for Redis only.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSnapshotRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteSnapshotRequest#builder()}
     * </p>
     *
     * @param deleteSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSnapshotMessage.Builder} to create a request.
     *        Represents the input of a <code>DeleteSnapshot</code> operation.
     * @return A Java Future containing the result of the DeleteSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SnapshotNotFoundException The requested snapshot name does not refer to an existing snapshot.</li>
     *         <li>InvalidSnapshotStateException The current state of the snapshot does not allow the requested
     *         operation to occur.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DeleteSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteSnapshotResponse> deleteSnapshot(Consumer<DeleteSnapshotRequest.Builder> deleteSnapshotRequest) {
        return deleteSnapshot(DeleteSnapshotRequest.builder().applyMutation(deleteSnapshotRequest).build());
    }

    /**
     * <p>
     * For Redis engine version 6.0 onwards: Deletes a user. The user will be removed from all user groups and in turn
     * removed from all replication groups. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html">Using Role Based Access
     * Control (RBAC)</a>.
     * </p>
     *
     * @param deleteUserRequest
     * @return A Java Future containing the result of the DeleteUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidUserStateException The user is not in active state.</li>
     *         <li>UserNotFoundException The user does not exist or could not be found.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>DefaultUserAssociatedToUserGroupException The default user assigned to the user group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteUserResponse> deleteUser(DeleteUserRequest deleteUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For Redis engine version 6.0 onwards: Deletes a user. The user will be removed from all user groups and in turn
     * removed from all replication groups. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html">Using Role Based Access
     * Control (RBAC)</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteUserRequest#builder()}
     * </p>
     *
     * @param deleteUserRequest
     *        A {@link Consumer} that will call methods on {@link DeleteUserMessage.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidUserStateException The user is not in active state.</li>
     *         <li>UserNotFoundException The user does not exist or could not be found.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>DefaultUserAssociatedToUserGroupException The default user assigned to the user group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteUserResponse> deleteUser(Consumer<DeleteUserRequest.Builder> deleteUserRequest) {
        return deleteUser(DeleteUserRequest.builder().applyMutation(deleteUserRequest).build());
    }

    /**
     * <p>
     * For Redis engine version 6.0 onwards: Deletes a user group. The user group must first be disassociated from the
     * replication group before it can be deleted. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html">Using Role Based Access
     * Control (RBAC)</a>.
     * </p>
     *
     * @param deleteUserGroupRequest
     * @return A Java Future containing the result of the DeleteUserGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UserGroupNotFoundException The user group was not found or does not exist</li>
     *         <li>InvalidUserGroupStateException The user group is not in an active state.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DeleteUserGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteUserGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteUserGroupResponse> deleteUserGroup(DeleteUserGroupRequest deleteUserGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For Redis engine version 6.0 onwards: Deletes a user group. The user group must first be disassociated from the
     * replication group before it can be deleted. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html">Using Role Based Access
     * Control (RBAC)</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserGroupRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteUserGroupRequest#builder()}
     * </p>
     *
     * @param deleteUserGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteUserGroupMessage.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteUserGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UserGroupNotFoundException The user group was not found or does not exist</li>
     *         <li>InvalidUserGroupStateException The user group is not in an active state.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DeleteUserGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteUserGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteUserGroupResponse> deleteUserGroup(
            Consumer<DeleteUserGroupRequest.Builder> deleteUserGroupRequest) {
        return deleteUserGroup(DeleteUserGroupRequest.builder().applyMutation(deleteUserGroupRequest).build());
    }

    /**
     * <p>
     * Returns information about all provisioned clusters if no cluster identifier is specified, or about a specific
     * cache cluster if a cluster identifier is supplied.
     * </p>
     * <p>
     * By default, abbreviated information about the clusters is returned. You can use the optional
     * <i>ShowCacheNodeInfo</i> flag to retrieve detailed information about the cache nodes associated with the
     * clusters. These details include the DNS address and port for the cache node endpoint.
     * </p>
     * <p>
     * If the cluster is in the <i>creating</i> state, only cluster-level information is displayed until all of the
     * nodes are successfully provisioned.
     * </p>
     * <p>
     * If the cluster is in the <i>deleting</i> state, only cluster-level information is displayed.
     * </p>
     * <p>
     * If cache nodes are currently being added to the cluster, node endpoint information and creation time for the
     * additional nodes are not displayed until they are completely provisioned. When the cluster state is
     * <i>available</i>, the cluster is ready for use.
     * </p>
     * <p>
     * If cache nodes are currently being removed from the cluster, no endpoint information for the removed nodes is
     * displayed.
     * </p>
     *
     * @param describeCacheClustersRequest
     *        Represents the input of a <code>DescribeCacheClusters</code> operation.
     * @return A Java Future containing the result of the DescribeCacheClusters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheClusterNotFoundException The requested cluster ID does not refer to an existing cluster.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeCacheClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheClusters"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCacheClustersResponse> describeCacheClusters(
            DescribeCacheClustersRequest describeCacheClustersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about all provisioned clusters if no cluster identifier is specified, or about a specific
     * cache cluster if a cluster identifier is supplied.
     * </p>
     * <p>
     * By default, abbreviated information about the clusters is returned. You can use the optional
     * <i>ShowCacheNodeInfo</i> flag to retrieve detailed information about the cache nodes associated with the
     * clusters. These details include the DNS address and port for the cache node endpoint.
     * </p>
     * <p>
     * If the cluster is in the <i>creating</i> state, only cluster-level information is displayed until all of the
     * nodes are successfully provisioned.
     * </p>
     * <p>
     * If the cluster is in the <i>deleting</i> state, only cluster-level information is displayed.
     * </p>
     * <p>
     * If cache nodes are currently being added to the cluster, node endpoint information and creation time for the
     * additional nodes are not displayed until they are completely provisioned. When the cluster state is
     * <i>available</i>, the cluster is ready for use.
     * </p>
     * <p>
     * If cache nodes are currently being removed from the cluster, no endpoint information for the removed nodes is
     * displayed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCacheClustersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeCacheClustersRequest#builder()}
     * </p>
     *
     * @param describeCacheClustersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeCacheClustersMessage.Builder} to create a
     *        request. Represents the input of a <code>DescribeCacheClusters</code> operation.
     * @return A Java Future containing the result of the DescribeCacheClusters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheClusterNotFoundException The requested cluster ID does not refer to an existing cluster.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeCacheClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheClusters"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCacheClustersResponse> describeCacheClusters(
            Consumer<DescribeCacheClustersRequest.Builder> describeCacheClustersRequest) {
        return describeCacheClusters(DescribeCacheClustersRequest.builder().applyMutation(describeCacheClustersRequest).build());
    }

    /**
     * <p>
     * Returns information about all provisioned clusters if no cluster identifier is specified, or about a specific
     * cache cluster if a cluster identifier is supplied.
     * </p>
     * <p>
     * By default, abbreviated information about the clusters is returned. You can use the optional
     * <i>ShowCacheNodeInfo</i> flag to retrieve detailed information about the cache nodes associated with the
     * clusters. These details include the DNS address and port for the cache node endpoint.
     * </p>
     * <p>
     * If the cluster is in the <i>creating</i> state, only cluster-level information is displayed until all of the
     * nodes are successfully provisioned.
     * </p>
     * <p>
     * If the cluster is in the <i>deleting</i> state, only cluster-level information is displayed.
     * </p>
     * <p>
     * If cache nodes are currently being added to the cluster, node endpoint information and creation time for the
     * additional nodes are not displayed until they are completely provisioned. When the cluster state is
     * <i>available</i>, the cluster is ready for use.
     * </p>
     * <p>
     * If cache nodes are currently being removed from the cluster, no endpoint information for the removed nodes is
     * displayed.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeCacheClusters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheClusterNotFoundException The requested cluster ID does not refer to an existing cluster.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeCacheClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheClusters"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCacheClustersResponse> describeCacheClusters() {
        return describeCacheClusters(DescribeCacheClustersRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about all provisioned clusters if no cluster identifier is specified, or about a specific
     * cache cluster if a cluster identifier is supplied.
     * </p>
     * <p>
     * By default, abbreviated information about the clusters is returned. You can use the optional
     * <i>ShowCacheNodeInfo</i> flag to retrieve detailed information about the cache nodes associated with the
     * clusters. These details include the DNS address and port for the cache node endpoint.
     * </p>
     * <p>
     * If the cluster is in the <i>creating</i> state, only cluster-level information is displayed until all of the
     * nodes are successfully provisioned.
     * </p>
     * <p>
     * If the cluster is in the <i>deleting</i> state, only cluster-level information is displayed.
     * </p>
     * <p>
     * If cache nodes are currently being added to the cluster, node endpoint information and creation time for the
     * additional nodes are not displayed until they are completely provisioned. When the cluster state is
     * <i>available</i>, the cluster is ready for use.
     * </p>
     * <p>
     * If cache nodes are currently being removed from the cluster, no endpoint information for the removed nodes is
     * displayed.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeCacheClusters(software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeCacheClustersPublisher publisher = client.describeCacheClustersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeCacheClustersPublisher publisher = client.describeCacheClustersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeCacheClusters(software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheClusterNotFoundException The requested cluster ID does not refer to an existing cluster.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeCacheClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheClusters"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCacheClustersPublisher describeCacheClustersPaginator() {
        return describeCacheClustersPaginator(DescribeCacheClustersRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about all provisioned clusters if no cluster identifier is specified, or about a specific
     * cache cluster if a cluster identifier is supplied.
     * </p>
     * <p>
     * By default, abbreviated information about the clusters is returned. You can use the optional
     * <i>ShowCacheNodeInfo</i> flag to retrieve detailed information about the cache nodes associated with the
     * clusters. These details include the DNS address and port for the cache node endpoint.
     * </p>
     * <p>
     * If the cluster is in the <i>creating</i> state, only cluster-level information is displayed until all of the
     * nodes are successfully provisioned.
     * </p>
     * <p>
     * If the cluster is in the <i>deleting</i> state, only cluster-level information is displayed.
     * </p>
     * <p>
     * If cache nodes are currently being added to the cluster, node endpoint information and creation time for the
     * additional nodes are not displayed until they are completely provisioned. When the cluster state is
     * <i>available</i>, the cluster is ready for use.
     * </p>
     * <p>
     * If cache nodes are currently being removed from the cluster, no endpoint information for the removed nodes is
     * displayed.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeCacheClusters(software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeCacheClustersPublisher publisher = client.describeCacheClustersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeCacheClustersPublisher publisher = client.describeCacheClustersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeCacheClusters(software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeCacheClustersRequest
     *        Represents the input of a <code>DescribeCacheClusters</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheClusterNotFoundException The requested cluster ID does not refer to an existing cluster.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeCacheClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheClusters"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCacheClustersPublisher describeCacheClustersPaginator(
            DescribeCacheClustersRequest describeCacheClustersRequest) {
        return new DescribeCacheClustersPublisher(this, describeCacheClustersRequest);
    }

    /**
     * <p>
     * Returns information about all provisioned clusters if no cluster identifier is specified, or about a specific
     * cache cluster if a cluster identifier is supplied.
     * </p>
     * <p>
     * By default, abbreviated information about the clusters is returned. You can use the optional
     * <i>ShowCacheNodeInfo</i> flag to retrieve detailed information about the cache nodes associated with the
     * clusters. These details include the DNS address and port for the cache node endpoint.
     * </p>
     * <p>
     * If the cluster is in the <i>creating</i> state, only cluster-level information is displayed until all of the
     * nodes are successfully provisioned.
     * </p>
     * <p>
     * If the cluster is in the <i>deleting</i> state, only cluster-level information is displayed.
     * </p>
     * <p>
     * If cache nodes are currently being added to the cluster, node endpoint information and creation time for the
     * additional nodes are not displayed until they are completely provisioned. When the cluster state is
     * <i>available</i>, the cluster is ready for use.
     * </p>
     * <p>
     * If cache nodes are currently being removed from the cluster, no endpoint information for the removed nodes is
     * displayed.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeCacheClusters(software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeCacheClustersPublisher publisher = client.describeCacheClustersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeCacheClustersPublisher publisher = client.describeCacheClustersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeCacheClusters(software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCacheClustersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeCacheClustersRequest#builder()}
     * </p>
     *
     * @param describeCacheClustersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeCacheClustersMessage.Builder} to create a
     *        request. Represents the input of a <code>DescribeCacheClusters</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheClusterNotFoundException The requested cluster ID does not refer to an existing cluster.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeCacheClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheClusters"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCacheClustersPublisher describeCacheClustersPaginator(
            Consumer<DescribeCacheClustersRequest.Builder> describeCacheClustersRequest) {
        return describeCacheClustersPaginator(DescribeCacheClustersRequest.builder().applyMutation(describeCacheClustersRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of the available cache engines and their versions.
     * </p>
     *
     * @param describeCacheEngineVersionsRequest
     *        Represents the input of a <code>DescribeCacheEngineVersions</code> operation.
     * @return A Java Future containing the result of the DescribeCacheEngineVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeCacheEngineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheEngineVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCacheEngineVersionsResponse> describeCacheEngineVersions(
            DescribeCacheEngineVersionsRequest describeCacheEngineVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the available cache engines and their versions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCacheEngineVersionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeCacheEngineVersionsRequest#builder()}
     * </p>
     *
     * @param describeCacheEngineVersionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeCacheEngineVersionsMessage.Builder} to create
     *        a request. Represents the input of a <code>DescribeCacheEngineVersions</code> operation.
     * @return A Java Future containing the result of the DescribeCacheEngineVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeCacheEngineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheEngineVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCacheEngineVersionsResponse> describeCacheEngineVersions(
            Consumer<DescribeCacheEngineVersionsRequest.Builder> describeCacheEngineVersionsRequest) {
        return describeCacheEngineVersions(DescribeCacheEngineVersionsRequest.builder()
                .applyMutation(describeCacheEngineVersionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the available cache engines and their versions.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeCacheEngineVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeCacheEngineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheEngineVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCacheEngineVersionsResponse> describeCacheEngineVersions() {
        return describeCacheEngineVersions(DescribeCacheEngineVersionsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of the available cache engines and their versions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeCacheEngineVersions(software.amazon.awssdk.services.elasticache.model.DescribeCacheEngineVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeCacheEngineVersionsPublisher publisher = client.describeCacheEngineVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeCacheEngineVersionsPublisher publisher = client.describeCacheEngineVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeCacheEngineVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeCacheEngineVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeCacheEngineVersions(software.amazon.awssdk.services.elasticache.model.DescribeCacheEngineVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeCacheEngineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheEngineVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCacheEngineVersionsPublisher describeCacheEngineVersionsPaginator() {
        return describeCacheEngineVersionsPaginator(DescribeCacheEngineVersionsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of the available cache engines and their versions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeCacheEngineVersions(software.amazon.awssdk.services.elasticache.model.DescribeCacheEngineVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeCacheEngineVersionsPublisher publisher = client.describeCacheEngineVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeCacheEngineVersionsPublisher publisher = client.describeCacheEngineVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeCacheEngineVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeCacheEngineVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeCacheEngineVersions(software.amazon.awssdk.services.elasticache.model.DescribeCacheEngineVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeCacheEngineVersionsRequest
     *        Represents the input of a <code>DescribeCacheEngineVersions</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeCacheEngineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheEngineVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCacheEngineVersionsPublisher describeCacheEngineVersionsPaginator(
            DescribeCacheEngineVersionsRequest describeCacheEngineVersionsRequest) {
        return new DescribeCacheEngineVersionsPublisher(this, describeCacheEngineVersionsRequest);
    }

    /**
     * <p>
     * Returns a list of the available cache engines and their versions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeCacheEngineVersions(software.amazon.awssdk.services.elasticache.model.DescribeCacheEngineVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeCacheEngineVersionsPublisher publisher = client.describeCacheEngineVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeCacheEngineVersionsPublisher publisher = client.describeCacheEngineVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeCacheEngineVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeCacheEngineVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeCacheEngineVersions(software.amazon.awssdk.services.elasticache.model.DescribeCacheEngineVersionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCacheEngineVersionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeCacheEngineVersionsRequest#builder()}
     * </p>
     *
     * @param describeCacheEngineVersionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeCacheEngineVersionsMessage.Builder} to create
     *        a request. Represents the input of a <code>DescribeCacheEngineVersions</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeCacheEngineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheEngineVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCacheEngineVersionsPublisher describeCacheEngineVersionsPaginator(
            Consumer<DescribeCacheEngineVersionsRequest.Builder> describeCacheEngineVersionsRequest) {
        return describeCacheEngineVersionsPaginator(DescribeCacheEngineVersionsRequest.builder()
                .applyMutation(describeCacheEngineVersionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of cache parameter group descriptions. If a cache parameter group name is specified, the list
     * contains only the descriptions for that group.
     * </p>
     *
     * @param describeCacheParameterGroupsRequest
     *        Represents the input of a <code>DescribeCacheParameterGroups</code> operation.
     * @return A Java Future containing the result of the DescribeCacheParameterGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheParameterGroupNotFoundException The requested cache parameter group name does not refer to an
     *         existing cache parameter group.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeCacheParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCacheParameterGroupsResponse> describeCacheParameterGroups(
            DescribeCacheParameterGroupsRequest describeCacheParameterGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of cache parameter group descriptions. If a cache parameter group name is specified, the list
     * contains only the descriptions for that group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCacheParameterGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeCacheParameterGroupsRequest#builder()}
     * </p>
     *
     * @param describeCacheParameterGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeCacheParameterGroupsMessage.Builder} to create
     *        a request. Represents the input of a <code>DescribeCacheParameterGroups</code> operation.
     * @return A Java Future containing the result of the DescribeCacheParameterGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheParameterGroupNotFoundException The requested cache parameter group name does not refer to an
     *         existing cache parameter group.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeCacheParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCacheParameterGroupsResponse> describeCacheParameterGroups(
            Consumer<DescribeCacheParameterGroupsRequest.Builder> describeCacheParameterGroupsRequest) {
        return describeCacheParameterGroups(DescribeCacheParameterGroupsRequest.builder()
                .applyMutation(describeCacheParameterGroupsRequest).build());
    }

    /**
     * <p>
     * Returns a list of cache parameter group descriptions. If a cache parameter group name is specified, the list
     * contains only the descriptions for that group.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeCacheParameterGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheParameterGroupNotFoundException The requested cache parameter group name does not refer to an
     *         existing cache parameter group.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeCacheParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCacheParameterGroupsResponse> describeCacheParameterGroups() {
        return describeCacheParameterGroups(DescribeCacheParameterGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of cache parameter group descriptions. If a cache parameter group name is specified, the list
     * contains only the descriptions for that group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeCacheParameterGroups(software.amazon.awssdk.services.elasticache.model.DescribeCacheParameterGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeCacheParameterGroupsPublisher publisher = client.describeCacheParameterGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeCacheParameterGroupsPublisher publisher = client.describeCacheParameterGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeCacheParameterGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeCacheParameterGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeCacheParameterGroups(software.amazon.awssdk.services.elasticache.model.DescribeCacheParameterGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheParameterGroupNotFoundException The requested cache parameter group name does not refer to an
     *         existing cache parameter group.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeCacheParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCacheParameterGroupsPublisher describeCacheParameterGroupsPaginator() {
        return describeCacheParameterGroupsPaginator(DescribeCacheParameterGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of cache parameter group descriptions. If a cache parameter group name is specified, the list
     * contains only the descriptions for that group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeCacheParameterGroups(software.amazon.awssdk.services.elasticache.model.DescribeCacheParameterGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeCacheParameterGroupsPublisher publisher = client.describeCacheParameterGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeCacheParameterGroupsPublisher publisher = client.describeCacheParameterGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeCacheParameterGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeCacheParameterGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeCacheParameterGroups(software.amazon.awssdk.services.elasticache.model.DescribeCacheParameterGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeCacheParameterGroupsRequest
     *        Represents the input of a <code>DescribeCacheParameterGroups</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheParameterGroupNotFoundException The requested cache parameter group name does not refer to an
     *         existing cache parameter group.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeCacheParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCacheParameterGroupsPublisher describeCacheParameterGroupsPaginator(
            DescribeCacheParameterGroupsRequest describeCacheParameterGroupsRequest) {
        return new DescribeCacheParameterGroupsPublisher(this, describeCacheParameterGroupsRequest);
    }

    /**
     * <p>
     * Returns a list of cache parameter group descriptions. If a cache parameter group name is specified, the list
     * contains only the descriptions for that group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeCacheParameterGroups(software.amazon.awssdk.services.elasticache.model.DescribeCacheParameterGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeCacheParameterGroupsPublisher publisher = client.describeCacheParameterGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeCacheParameterGroupsPublisher publisher = client.describeCacheParameterGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeCacheParameterGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeCacheParameterGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeCacheParameterGroups(software.amazon.awssdk.services.elasticache.model.DescribeCacheParameterGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCacheParameterGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeCacheParameterGroupsRequest#builder()}
     * </p>
     *
     * @param describeCacheParameterGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeCacheParameterGroupsMessage.Builder} to create
     *        a request. Represents the input of a <code>DescribeCacheParameterGroups</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheParameterGroupNotFoundException The requested cache parameter group name does not refer to an
     *         existing cache parameter group.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeCacheParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCacheParameterGroupsPublisher describeCacheParameterGroupsPaginator(
            Consumer<DescribeCacheParameterGroupsRequest.Builder> describeCacheParameterGroupsRequest) {
        return describeCacheParameterGroupsPaginator(DescribeCacheParameterGroupsRequest.builder()
                .applyMutation(describeCacheParameterGroupsRequest).build());
    }

    /**
     * <p>
     * Returns the detailed parameter list for a particular cache parameter group.
     * </p>
     *
     * @param describeCacheParametersRequest
     *        Represents the input of a <code>DescribeCacheParameters</code> operation.
     * @return A Java Future containing the result of the DescribeCacheParameters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheParameterGroupNotFoundException The requested cache parameter group name does not refer to an
     *         existing cache parameter group.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeCacheParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCacheParametersResponse> describeCacheParameters(
            DescribeCacheParametersRequest describeCacheParametersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the detailed parameter list for a particular cache parameter group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCacheParametersRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeCacheParametersRequest#builder()}
     * </p>
     *
     * @param describeCacheParametersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeCacheParametersMessage.Builder} to create a
     *        request. Represents the input of a <code>DescribeCacheParameters</code> operation.
     * @return A Java Future containing the result of the DescribeCacheParameters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheParameterGroupNotFoundException The requested cache parameter group name does not refer to an
     *         existing cache parameter group.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeCacheParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCacheParametersResponse> describeCacheParameters(
            Consumer<DescribeCacheParametersRequest.Builder> describeCacheParametersRequest) {
        return describeCacheParameters(DescribeCacheParametersRequest.builder().applyMutation(describeCacheParametersRequest)
                .build());
    }

    /**
     * <p>
     * Returns the detailed parameter list for a particular cache parameter group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeCacheParameters(software.amazon.awssdk.services.elasticache.model.DescribeCacheParametersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeCacheParametersPublisher publisher = client.describeCacheParametersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeCacheParametersPublisher publisher = client.describeCacheParametersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeCacheParametersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeCacheParametersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeCacheParameters(software.amazon.awssdk.services.elasticache.model.DescribeCacheParametersRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeCacheParametersRequest
     *        Represents the input of a <code>DescribeCacheParameters</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheParameterGroupNotFoundException The requested cache parameter group name does not refer to an
     *         existing cache parameter group.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeCacheParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCacheParametersPublisher describeCacheParametersPaginator(
            DescribeCacheParametersRequest describeCacheParametersRequest) {
        return new DescribeCacheParametersPublisher(this, describeCacheParametersRequest);
    }

    /**
     * <p>
     * Returns the detailed parameter list for a particular cache parameter group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeCacheParameters(software.amazon.awssdk.services.elasticache.model.DescribeCacheParametersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeCacheParametersPublisher publisher = client.describeCacheParametersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeCacheParametersPublisher publisher = client.describeCacheParametersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeCacheParametersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeCacheParametersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeCacheParameters(software.amazon.awssdk.services.elasticache.model.DescribeCacheParametersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCacheParametersRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeCacheParametersRequest#builder()}
     * </p>
     *
     * @param describeCacheParametersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeCacheParametersMessage.Builder} to create a
     *        request. Represents the input of a <code>DescribeCacheParameters</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheParameterGroupNotFoundException The requested cache parameter group name does not refer to an
     *         existing cache parameter group.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeCacheParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCacheParametersPublisher describeCacheParametersPaginator(
            Consumer<DescribeCacheParametersRequest.Builder> describeCacheParametersRequest) {
        return describeCacheParametersPaginator(DescribeCacheParametersRequest.builder()
                .applyMutation(describeCacheParametersRequest).build());
    }

    /**
     * <p>
     * Returns a list of cache security group descriptions. If a cache security group name is specified, the list
     * contains only the description of that group. This applicable only when you have ElastiCache in Classic setup
     * </p>
     *
     * @param describeCacheSecurityGroupsRequest
     *        Represents the input of a <code>DescribeCacheSecurityGroups</code> operation.
     * @return A Java Future containing the result of the DescribeCacheSecurityGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheSecurityGroupNotFoundException The requested cache security group name does not refer to an
     *         existing cache security group.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeCacheSecurityGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheSecurityGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCacheSecurityGroupsResponse> describeCacheSecurityGroups(
            DescribeCacheSecurityGroupsRequest describeCacheSecurityGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of cache security group descriptions. If a cache security group name is specified, the list
     * contains only the description of that group. This applicable only when you have ElastiCache in Classic setup
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCacheSecurityGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeCacheSecurityGroupsRequest#builder()}
     * </p>
     *
     * @param describeCacheSecurityGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeCacheSecurityGroupsMessage.Builder} to create
     *        a request. Represents the input of a <code>DescribeCacheSecurityGroups</code> operation.
     * @return A Java Future containing the result of the DescribeCacheSecurityGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheSecurityGroupNotFoundException The requested cache security group name does not refer to an
     *         existing cache security group.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeCacheSecurityGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheSecurityGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCacheSecurityGroupsResponse> describeCacheSecurityGroups(
            Consumer<DescribeCacheSecurityGroupsRequest.Builder> describeCacheSecurityGroupsRequest) {
        return describeCacheSecurityGroups(DescribeCacheSecurityGroupsRequest.builder()
                .applyMutation(describeCacheSecurityGroupsRequest).build());
    }

    /**
     * <p>
     * Returns a list of cache security group descriptions. If a cache security group name is specified, the list
     * contains only the description of that group. This applicable only when you have ElastiCache in Classic setup
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeCacheSecurityGroups(software.amazon.awssdk.services.elasticache.model.DescribeCacheSecurityGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeCacheSecurityGroupsPublisher publisher = client.describeCacheSecurityGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeCacheSecurityGroupsPublisher publisher = client.describeCacheSecurityGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeCacheSecurityGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeCacheSecurityGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeCacheSecurityGroups(software.amazon.awssdk.services.elasticache.model.DescribeCacheSecurityGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeCacheSecurityGroupsRequest
     *        Represents the input of a <code>DescribeCacheSecurityGroups</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheSecurityGroupNotFoundException The requested cache security group name does not refer to an
     *         existing cache security group.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeCacheSecurityGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheSecurityGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCacheSecurityGroupsPublisher describeCacheSecurityGroupsPaginator(
            DescribeCacheSecurityGroupsRequest describeCacheSecurityGroupsRequest) {
        return new DescribeCacheSecurityGroupsPublisher(this, describeCacheSecurityGroupsRequest);
    }

    /**
     * <p>
     * Returns a list of cache security group descriptions. If a cache security group name is specified, the list
     * contains only the description of that group. This applicable only when you have ElastiCache in Classic setup
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeCacheSecurityGroups(software.amazon.awssdk.services.elasticache.model.DescribeCacheSecurityGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeCacheSecurityGroupsPublisher publisher = client.describeCacheSecurityGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeCacheSecurityGroupsPublisher publisher = client.describeCacheSecurityGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeCacheSecurityGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeCacheSecurityGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeCacheSecurityGroups(software.amazon.awssdk.services.elasticache.model.DescribeCacheSecurityGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCacheSecurityGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeCacheSecurityGroupsRequest#builder()}
     * </p>
     *
     * @param describeCacheSecurityGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeCacheSecurityGroupsMessage.Builder} to create
     *        a request. Represents the input of a <code>DescribeCacheSecurityGroups</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheSecurityGroupNotFoundException The requested cache security group name does not refer to an
     *         existing cache security group.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeCacheSecurityGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheSecurityGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCacheSecurityGroupsPublisher describeCacheSecurityGroupsPaginator(
            Consumer<DescribeCacheSecurityGroupsRequest.Builder> describeCacheSecurityGroupsRequest) {
        return describeCacheSecurityGroupsPaginator(DescribeCacheSecurityGroupsRequest.builder()
                .applyMutation(describeCacheSecurityGroupsRequest).build());
    }

    /**
     * <p>
     * Returns a list of cache subnet group descriptions. If a subnet group name is specified, the list contains only
     * the description of that group. This is applicable only when you have ElastiCache in VPC setup. All ElastiCache
     * clusters now launch in VPC by default.
     * </p>
     *
     * @param describeCacheSubnetGroupsRequest
     *        Represents the input of a <code>DescribeCacheSubnetGroups</code> operation.
     * @return A Java Future containing the result of the DescribeCacheSubnetGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheSubnetGroupNotFoundException The requested cache subnet group name does not refer to an existing
     *         cache subnet group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeCacheSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheSubnetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCacheSubnetGroupsResponse> describeCacheSubnetGroups(
            DescribeCacheSubnetGroupsRequest describeCacheSubnetGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of cache subnet group descriptions. If a subnet group name is specified, the list contains only
     * the description of that group. This is applicable only when you have ElastiCache in VPC setup. All ElastiCache
     * clusters now launch in VPC by default.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCacheSubnetGroupsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeCacheSubnetGroupsRequest#builder()}
     * </p>
     *
     * @param describeCacheSubnetGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeCacheSubnetGroupsMessage.Builder} to create a
     *        request. Represents the input of a <code>DescribeCacheSubnetGroups</code> operation.
     * @return A Java Future containing the result of the DescribeCacheSubnetGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheSubnetGroupNotFoundException The requested cache subnet group name does not refer to an existing
     *         cache subnet group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeCacheSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheSubnetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCacheSubnetGroupsResponse> describeCacheSubnetGroups(
            Consumer<DescribeCacheSubnetGroupsRequest.Builder> describeCacheSubnetGroupsRequest) {
        return describeCacheSubnetGroups(DescribeCacheSubnetGroupsRequest.builder()
                .applyMutation(describeCacheSubnetGroupsRequest).build());
    }

    /**
     * <p>
     * Returns a list of cache subnet group descriptions. If a subnet group name is specified, the list contains only
     * the description of that group. This is applicable only when you have ElastiCache in VPC setup. All ElastiCache
     * clusters now launch in VPC by default.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeCacheSubnetGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheSubnetGroupNotFoundException The requested cache subnet group name does not refer to an existing
     *         cache subnet group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeCacheSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheSubnetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCacheSubnetGroupsResponse> describeCacheSubnetGroups() {
        return describeCacheSubnetGroups(DescribeCacheSubnetGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of cache subnet group descriptions. If a subnet group name is specified, the list contains only
     * the description of that group. This is applicable only when you have ElastiCache in VPC setup. All ElastiCache
     * clusters now launch in VPC by default.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeCacheSubnetGroups(software.amazon.awssdk.services.elasticache.model.DescribeCacheSubnetGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeCacheSubnetGroupsPublisher publisher = client.describeCacheSubnetGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeCacheSubnetGroupsPublisher publisher = client.describeCacheSubnetGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeCacheSubnetGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeCacheSubnetGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeCacheSubnetGroups(software.amazon.awssdk.services.elasticache.model.DescribeCacheSubnetGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheSubnetGroupNotFoundException The requested cache subnet group name does not refer to an existing
     *         cache subnet group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeCacheSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheSubnetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCacheSubnetGroupsPublisher describeCacheSubnetGroupsPaginator() {
        return describeCacheSubnetGroupsPaginator(DescribeCacheSubnetGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of cache subnet group descriptions. If a subnet group name is specified, the list contains only
     * the description of that group. This is applicable only when you have ElastiCache in VPC setup. All ElastiCache
     * clusters now launch in VPC by default.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeCacheSubnetGroups(software.amazon.awssdk.services.elasticache.model.DescribeCacheSubnetGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeCacheSubnetGroupsPublisher publisher = client.describeCacheSubnetGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeCacheSubnetGroupsPublisher publisher = client.describeCacheSubnetGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeCacheSubnetGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeCacheSubnetGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeCacheSubnetGroups(software.amazon.awssdk.services.elasticache.model.DescribeCacheSubnetGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeCacheSubnetGroupsRequest
     *        Represents the input of a <code>DescribeCacheSubnetGroups</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheSubnetGroupNotFoundException The requested cache subnet group name does not refer to an existing
     *         cache subnet group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeCacheSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheSubnetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCacheSubnetGroupsPublisher describeCacheSubnetGroupsPaginator(
            DescribeCacheSubnetGroupsRequest describeCacheSubnetGroupsRequest) {
        return new DescribeCacheSubnetGroupsPublisher(this, describeCacheSubnetGroupsRequest);
    }

    /**
     * <p>
     * Returns a list of cache subnet group descriptions. If a subnet group name is specified, the list contains only
     * the description of that group. This is applicable only when you have ElastiCache in VPC setup. All ElastiCache
     * clusters now launch in VPC by default.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeCacheSubnetGroups(software.amazon.awssdk.services.elasticache.model.DescribeCacheSubnetGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeCacheSubnetGroupsPublisher publisher = client.describeCacheSubnetGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeCacheSubnetGroupsPublisher publisher = client.describeCacheSubnetGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeCacheSubnetGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeCacheSubnetGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeCacheSubnetGroups(software.amazon.awssdk.services.elasticache.model.DescribeCacheSubnetGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCacheSubnetGroupsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeCacheSubnetGroupsRequest#builder()}
     * </p>
     *
     * @param describeCacheSubnetGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeCacheSubnetGroupsMessage.Builder} to create a
     *        request. Represents the input of a <code>DescribeCacheSubnetGroups</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheSubnetGroupNotFoundException The requested cache subnet group name does not refer to an existing
     *         cache subnet group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeCacheSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheSubnetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCacheSubnetGroupsPublisher describeCacheSubnetGroupsPaginator(
            Consumer<DescribeCacheSubnetGroupsRequest.Builder> describeCacheSubnetGroupsRequest) {
        return describeCacheSubnetGroupsPaginator(DescribeCacheSubnetGroupsRequest.builder()
                .applyMutation(describeCacheSubnetGroupsRequest).build());
    }

    /**
     * <p>
     * Returns the default engine and system parameter information for the specified cache engine.
     * </p>
     *
     * @param describeEngineDefaultParametersRequest
     *        Represents the input of a <code>DescribeEngineDefaultParameters</code> operation.
     * @return A Java Future containing the result of the DescribeEngineDefaultParameters operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeEngineDefaultParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeEngineDefaultParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEngineDefaultParametersResponse> describeEngineDefaultParameters(
            DescribeEngineDefaultParametersRequest describeEngineDefaultParametersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the default engine and system parameter information for the specified cache engine.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEngineDefaultParametersRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeEngineDefaultParametersRequest#builder()}
     * </p>
     *
     * @param describeEngineDefaultParametersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEngineDefaultParametersMessage.Builder} to
     *        create a request. Represents the input of a <code>DescribeEngineDefaultParameters</code> operation.
     * @return A Java Future containing the result of the DescribeEngineDefaultParameters operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeEngineDefaultParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeEngineDefaultParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEngineDefaultParametersResponse> describeEngineDefaultParameters(
            Consumer<DescribeEngineDefaultParametersRequest.Builder> describeEngineDefaultParametersRequest) {
        return describeEngineDefaultParameters(DescribeEngineDefaultParametersRequest.builder()
                .applyMutation(describeEngineDefaultParametersRequest).build());
    }

    /**
     * <p>
     * Returns the default engine and system parameter information for the specified cache engine.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEngineDefaultParameters(software.amazon.awssdk.services.elasticache.model.DescribeEngineDefaultParametersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeEngineDefaultParametersPublisher publisher = client.describeEngineDefaultParametersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeEngineDefaultParametersPublisher publisher = client.describeEngineDefaultParametersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeEngineDefaultParametersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeEngineDefaultParametersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEngineDefaultParameters(software.amazon.awssdk.services.elasticache.model.DescribeEngineDefaultParametersRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEngineDefaultParametersRequest
     *        Represents the input of a <code>DescribeEngineDefaultParameters</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeEngineDefaultParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeEngineDefaultParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEngineDefaultParametersPublisher describeEngineDefaultParametersPaginator(
            DescribeEngineDefaultParametersRequest describeEngineDefaultParametersRequest) {
        return new DescribeEngineDefaultParametersPublisher(this, describeEngineDefaultParametersRequest);
    }

    /**
     * <p>
     * Returns the default engine and system parameter information for the specified cache engine.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEngineDefaultParameters(software.amazon.awssdk.services.elasticache.model.DescribeEngineDefaultParametersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeEngineDefaultParametersPublisher publisher = client.describeEngineDefaultParametersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeEngineDefaultParametersPublisher publisher = client.describeEngineDefaultParametersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeEngineDefaultParametersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeEngineDefaultParametersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEngineDefaultParameters(software.amazon.awssdk.services.elasticache.model.DescribeEngineDefaultParametersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEngineDefaultParametersRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeEngineDefaultParametersRequest#builder()}
     * </p>
     *
     * @param describeEngineDefaultParametersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEngineDefaultParametersMessage.Builder} to
     *        create a request. Represents the input of a <code>DescribeEngineDefaultParameters</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeEngineDefaultParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeEngineDefaultParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEngineDefaultParametersPublisher describeEngineDefaultParametersPaginator(
            Consumer<DescribeEngineDefaultParametersRequest.Builder> describeEngineDefaultParametersRequest) {
        return describeEngineDefaultParametersPaginator(DescribeEngineDefaultParametersRequest.builder()
                .applyMutation(describeEngineDefaultParametersRequest).build());
    }

    /**
     * <p>
     * Returns events related to clusters, cache security groups, and cache parameter groups. You can obtain events
     * specific to a particular cluster, cache security group, or cache parameter group by providing the name as a
     * parameter.
     * </p>
     * <p>
     * By default, only the events occurring within the last hour are returned; however, you can retrieve up to 14 days'
     * worth of events if necessary.
     * </p>
     *
     * @param describeEventsRequest
     *        Represents the input of a <code>DescribeEvents</code> operation.
     * @return A Java Future containing the result of the DescribeEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeEvents" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeEventsResponse> describeEvents(DescribeEventsRequest describeEventsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns events related to clusters, cache security groups, and cache parameter groups. You can obtain events
     * specific to a particular cluster, cache security group, or cache parameter group by providing the name as a
     * parameter.
     * </p>
     * <p>
     * By default, only the events occurring within the last hour are returned; however, you can retrieve up to 14 days'
     * worth of events if necessary.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeEventsRequest#builder()}
     * </p>
     *
     * @param describeEventsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEventsMessage.Builder} to create a request.
     *        Represents the input of a <code>DescribeEvents</code> operation.
     * @return A Java Future containing the result of the DescribeEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeEvents" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeEventsResponse> describeEvents(Consumer<DescribeEventsRequest.Builder> describeEventsRequest) {
        return describeEvents(DescribeEventsRequest.builder().applyMutation(describeEventsRequest).build());
    }

    /**
     * <p>
     * Returns events related to clusters, cache security groups, and cache parameter groups. You can obtain events
     * specific to a particular cluster, cache security group, or cache parameter group by providing the name as a
     * parameter.
     * </p>
     * <p>
     * By default, only the events occurring within the last hour are returned; however, you can retrieve up to 14 days'
     * worth of events if necessary.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeEvents" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeEventsResponse> describeEvents() {
        return describeEvents(DescribeEventsRequest.builder().build());
    }

    /**
     * <p>
     * Returns events related to clusters, cache security groups, and cache parameter groups. You can obtain events
     * specific to a particular cluster, cache security group, or cache parameter group by providing the name as a
     * parameter.
     * </p>
     * <p>
     * By default, only the events occurring within the last hour are returned; however, you can retrieve up to 14 days'
     * worth of events if necessary.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEvents(software.amazon.awssdk.services.elasticache.model.DescribeEventsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeEventsPublisher publisher = client.describeEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeEventsPublisher publisher = client.describeEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEvents(software.amazon.awssdk.services.elasticache.model.DescribeEventsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeEvents" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeEventsPublisher describeEventsPaginator() {
        return describeEventsPaginator(DescribeEventsRequest.builder().build());
    }

    /**
     * <p>
     * Returns events related to clusters, cache security groups, and cache parameter groups. You can obtain events
     * specific to a particular cluster, cache security group, or cache parameter group by providing the name as a
     * parameter.
     * </p>
     * <p>
     * By default, only the events occurring within the last hour are returned; however, you can retrieve up to 14 days'
     * worth of events if necessary.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEvents(software.amazon.awssdk.services.elasticache.model.DescribeEventsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeEventsPublisher publisher = client.describeEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeEventsPublisher publisher = client.describeEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEvents(software.amazon.awssdk.services.elasticache.model.DescribeEventsRequest)} operation.</b>
     * </p>
     *
     * @param describeEventsRequest
     *        Represents the input of a <code>DescribeEvents</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeEvents" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeEventsPublisher describeEventsPaginator(DescribeEventsRequest describeEventsRequest) {
        return new DescribeEventsPublisher(this, describeEventsRequest);
    }

    /**
     * <p>
     * Returns events related to clusters, cache security groups, and cache parameter groups. You can obtain events
     * specific to a particular cluster, cache security group, or cache parameter group by providing the name as a
     * parameter.
     * </p>
     * <p>
     * By default, only the events occurring within the last hour are returned; however, you can retrieve up to 14 days'
     * worth of events if necessary.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEvents(software.amazon.awssdk.services.elasticache.model.DescribeEventsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeEventsPublisher publisher = client.describeEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeEventsPublisher publisher = client.describeEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEvents(software.amazon.awssdk.services.elasticache.model.DescribeEventsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeEventsRequest#builder()}
     * </p>
     *
     * @param describeEventsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEventsMessage.Builder} to create a request.
     *        Represents the input of a <code>DescribeEvents</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeEvents" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeEventsPublisher describeEventsPaginator(Consumer<DescribeEventsRequest.Builder> describeEventsRequest) {
        return describeEventsPaginator(DescribeEventsRequest.builder().applyMutation(describeEventsRequest).build());
    }

    /**
     * <p>
     * Returns information about a particular global replication group. If no identifier is specified, returns
     * information about all Global datastores.
     * </p>
     *
     * @param describeGlobalReplicationGroupsRequest
     * @return A Java Future containing the result of the DescribeGlobalReplicationGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GlobalReplicationGroupNotFoundException The Global datastore does not exist</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeGlobalReplicationGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeGlobalReplicationGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeGlobalReplicationGroupsResponse> describeGlobalReplicationGroups(
            DescribeGlobalReplicationGroupsRequest describeGlobalReplicationGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a particular global replication group. If no identifier is specified, returns
     * information about all Global datastores.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGlobalReplicationGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeGlobalReplicationGroupsRequest#builder()}
     * </p>
     *
     * @param describeGlobalReplicationGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeGlobalReplicationGroupsMessage.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeGlobalReplicationGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GlobalReplicationGroupNotFoundException The Global datastore does not exist</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeGlobalReplicationGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeGlobalReplicationGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeGlobalReplicationGroupsResponse> describeGlobalReplicationGroups(
            Consumer<DescribeGlobalReplicationGroupsRequest.Builder> describeGlobalReplicationGroupsRequest) {
        return describeGlobalReplicationGroups(DescribeGlobalReplicationGroupsRequest.builder()
                .applyMutation(describeGlobalReplicationGroupsRequest).build());
    }

    /**
     * <p>
     * Returns information about a particular global replication group. If no identifier is specified, returns
     * information about all Global datastores.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeGlobalReplicationGroups(software.amazon.awssdk.services.elasticache.model.DescribeGlobalReplicationGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeGlobalReplicationGroupsPublisher publisher = client.describeGlobalReplicationGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeGlobalReplicationGroupsPublisher publisher = client.describeGlobalReplicationGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeGlobalReplicationGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeGlobalReplicationGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeGlobalReplicationGroups(software.amazon.awssdk.services.elasticache.model.DescribeGlobalReplicationGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeGlobalReplicationGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GlobalReplicationGroupNotFoundException The Global datastore does not exist</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeGlobalReplicationGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeGlobalReplicationGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeGlobalReplicationGroupsPublisher describeGlobalReplicationGroupsPaginator(
            DescribeGlobalReplicationGroupsRequest describeGlobalReplicationGroupsRequest) {
        return new DescribeGlobalReplicationGroupsPublisher(this, describeGlobalReplicationGroupsRequest);
    }

    /**
     * <p>
     * Returns information about a particular global replication group. If no identifier is specified, returns
     * information about all Global datastores.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeGlobalReplicationGroups(software.amazon.awssdk.services.elasticache.model.DescribeGlobalReplicationGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeGlobalReplicationGroupsPublisher publisher = client.describeGlobalReplicationGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeGlobalReplicationGroupsPublisher publisher = client.describeGlobalReplicationGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeGlobalReplicationGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeGlobalReplicationGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeGlobalReplicationGroups(software.amazon.awssdk.services.elasticache.model.DescribeGlobalReplicationGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGlobalReplicationGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeGlobalReplicationGroupsRequest#builder()}
     * </p>
     *
     * @param describeGlobalReplicationGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeGlobalReplicationGroupsMessage.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GlobalReplicationGroupNotFoundException The Global datastore does not exist</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeGlobalReplicationGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeGlobalReplicationGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeGlobalReplicationGroupsPublisher describeGlobalReplicationGroupsPaginator(
            Consumer<DescribeGlobalReplicationGroupsRequest.Builder> describeGlobalReplicationGroupsRequest) {
        return describeGlobalReplicationGroupsPaginator(DescribeGlobalReplicationGroupsRequest.builder()
                .applyMutation(describeGlobalReplicationGroupsRequest).build());
    }

    /**
     * <p>
     * Returns information about a particular replication group. If no identifier is specified,
     * <code>DescribeReplicationGroups</code> returns information about all replication groups.
     * </p>
     * <note>
     * <p>
     * This operation is valid for Redis only.
     * </p>
     * </note>
     *
     * @param describeReplicationGroupsRequest
     *        Represents the input of a <code>DescribeReplicationGroups</code> operation.
     * @return A Java Future containing the result of the DescribeReplicationGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReplicationGroupNotFoundException The specified replication group does not exist.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeReplicationGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeReplicationGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeReplicationGroupsResponse> describeReplicationGroups(
            DescribeReplicationGroupsRequest describeReplicationGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a particular replication group. If no identifier is specified,
     * <code>DescribeReplicationGroups</code> returns information about all replication groups.
     * </p>
     * <note>
     * <p>
     * This operation is valid for Redis only.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReplicationGroupsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeReplicationGroupsRequest#builder()}
     * </p>
     *
     * @param describeReplicationGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeReplicationGroupsMessage.Builder} to create a
     *        request. Represents the input of a <code>DescribeReplicationGroups</code> operation.
     * @return A Java Future containing the result of the DescribeReplicationGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReplicationGroupNotFoundException The specified replication group does not exist.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeReplicationGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeReplicationGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeReplicationGroupsResponse> describeReplicationGroups(
            Consumer<DescribeReplicationGroupsRequest.Builder> describeReplicationGroupsRequest) {
        return describeReplicationGroups(DescribeReplicationGroupsRequest.builder()
                .applyMutation(describeReplicationGroupsRequest).build());
    }

    /**
     * <p>
     * Returns information about a particular replication group. If no identifier is specified,
     * <code>DescribeReplicationGroups</code> returns information about all replication groups.
     * </p>
     * <note>
     * <p>
     * This operation is valid for Redis only.
     * </p>
     * </note>
     *
     * @return A Java Future containing the result of the DescribeReplicationGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReplicationGroupNotFoundException The specified replication group does not exist.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeReplicationGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeReplicationGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeReplicationGroupsResponse> describeReplicationGroups() {
        return describeReplicationGroups(DescribeReplicationGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about a particular replication group. If no identifier is specified,
     * <code>DescribeReplicationGroups</code> returns information about all replication groups.
     * </p>
     * <note>
     * <p>
     * This operation is valid for Redis only.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeReplicationGroups(software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeReplicationGroupsPublisher publisher = client.describeReplicationGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeReplicationGroupsPublisher publisher = client.describeReplicationGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationGroups(software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReplicationGroupNotFoundException The specified replication group does not exist.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeReplicationGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeReplicationGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationGroupsPublisher describeReplicationGroupsPaginator() {
        return describeReplicationGroupsPaginator(DescribeReplicationGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about a particular replication group. If no identifier is specified,
     * <code>DescribeReplicationGroups</code> returns information about all replication groups.
     * </p>
     * <note>
     * <p>
     * This operation is valid for Redis only.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeReplicationGroups(software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeReplicationGroupsPublisher publisher = client.describeReplicationGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeReplicationGroupsPublisher publisher = client.describeReplicationGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationGroups(software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReplicationGroupsRequest
     *        Represents the input of a <code>DescribeReplicationGroups</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReplicationGroupNotFoundException The specified replication group does not exist.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeReplicationGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeReplicationGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationGroupsPublisher describeReplicationGroupsPaginator(
            DescribeReplicationGroupsRequest describeReplicationGroupsRequest) {
        return new DescribeReplicationGroupsPublisher(this, describeReplicationGroupsRequest);
    }

    /**
     * <p>
     * Returns information about a particular replication group. If no identifier is specified,
     * <code>DescribeReplicationGroups</code> returns information about all replication groups.
     * </p>
     * <note>
     * <p>
     * This operation is valid for Redis only.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeReplicationGroups(software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeReplicationGroupsPublisher publisher = client.describeReplicationGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeReplicationGroupsPublisher publisher = client.describeReplicationGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationGroups(software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReplicationGroupsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeReplicationGroupsRequest#builder()}
     * </p>
     *
     * @param describeReplicationGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeReplicationGroupsMessage.Builder} to create a
     *        request. Represents the input of a <code>DescribeReplicationGroups</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReplicationGroupNotFoundException The specified replication group does not exist.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeReplicationGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeReplicationGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationGroupsPublisher describeReplicationGroupsPaginator(
            Consumer<DescribeReplicationGroupsRequest.Builder> describeReplicationGroupsRequest) {
        return describeReplicationGroupsPaginator(DescribeReplicationGroupsRequest.builder()
                .applyMutation(describeReplicationGroupsRequest).build());
    }

    /**
     * <p>
     * Returns information about reserved cache nodes for this account, or about a specified reserved cache node.
     * </p>
     *
     * @param describeReservedCacheNodesRequest
     *        Represents the input of a <code>DescribeReservedCacheNodes</code> operation.
     * @return A Java Future containing the result of the DescribeReservedCacheNodes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReservedCacheNodeNotFoundException The requested reserved cache node was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeReservedCacheNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeReservedCacheNodes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeReservedCacheNodesResponse> describeReservedCacheNodes(
            DescribeReservedCacheNodesRequest describeReservedCacheNodesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about reserved cache nodes for this account, or about a specified reserved cache node.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReservedCacheNodesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeReservedCacheNodesRequest#builder()}
     * </p>
     *
     * @param describeReservedCacheNodesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeReservedCacheNodesMessage.Builder} to create a
     *        request. Represents the input of a <code>DescribeReservedCacheNodes</code> operation.
     * @return A Java Future containing the result of the DescribeReservedCacheNodes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReservedCacheNodeNotFoundException The requested reserved cache node was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeReservedCacheNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeReservedCacheNodes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeReservedCacheNodesResponse> describeReservedCacheNodes(
            Consumer<DescribeReservedCacheNodesRequest.Builder> describeReservedCacheNodesRequest) {
        return describeReservedCacheNodes(DescribeReservedCacheNodesRequest.builder()
                .applyMutation(describeReservedCacheNodesRequest).build());
    }

    /**
     * <p>
     * Returns information about reserved cache nodes for this account, or about a specified reserved cache node.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeReservedCacheNodes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReservedCacheNodeNotFoundException The requested reserved cache node was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeReservedCacheNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeReservedCacheNodes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeReservedCacheNodesResponse> describeReservedCacheNodes() {
        return describeReservedCacheNodes(DescribeReservedCacheNodesRequest.builder().build());
    }

    /**
     * <p>
     * Lists available reserved cache node offerings.
     * </p>
     *
     * @param describeReservedCacheNodesOfferingsRequest
     *        Represents the input of a <code>DescribeReservedCacheNodesOfferings</code> operation.
     * @return A Java Future containing the result of the DescribeReservedCacheNodesOfferings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReservedCacheNodesOfferingNotFoundException The requested cache node offering does not exist.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeReservedCacheNodesOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeReservedCacheNodesOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeReservedCacheNodesOfferingsResponse> describeReservedCacheNodesOfferings(
            DescribeReservedCacheNodesOfferingsRequest describeReservedCacheNodesOfferingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists available reserved cache node offerings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReservedCacheNodesOfferingsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeReservedCacheNodesOfferingsRequest#builder()}
     * </p>
     *
     * @param describeReservedCacheNodesOfferingsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeReservedCacheNodesOfferingsMessage.Builder} to
     *        create a request. Represents the input of a <code>DescribeReservedCacheNodesOfferings</code> operation.
     * @return A Java Future containing the result of the DescribeReservedCacheNodesOfferings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReservedCacheNodesOfferingNotFoundException The requested cache node offering does not exist.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeReservedCacheNodesOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeReservedCacheNodesOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeReservedCacheNodesOfferingsResponse> describeReservedCacheNodesOfferings(
            Consumer<DescribeReservedCacheNodesOfferingsRequest.Builder> describeReservedCacheNodesOfferingsRequest) {
        return describeReservedCacheNodesOfferings(DescribeReservedCacheNodesOfferingsRequest.builder()
                .applyMutation(describeReservedCacheNodesOfferingsRequest).build());
    }

    /**
     * <p>
     * Lists available reserved cache node offerings.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeReservedCacheNodesOfferings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReservedCacheNodesOfferingNotFoundException The requested cache node offering does not exist.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeReservedCacheNodesOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeReservedCacheNodesOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeReservedCacheNodesOfferingsResponse> describeReservedCacheNodesOfferings() {
        return describeReservedCacheNodesOfferings(DescribeReservedCacheNodesOfferingsRequest.builder().build());
    }

    /**
     * <p>
     * Lists available reserved cache node offerings.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReservedCacheNodesOfferings(software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesOfferingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeReservedCacheNodesOfferingsPublisher publisher = client.describeReservedCacheNodesOfferingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeReservedCacheNodesOfferingsPublisher publisher = client.describeReservedCacheNodesOfferingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesOfferingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesOfferingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedCacheNodesOfferings(software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesOfferingsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReservedCacheNodesOfferingNotFoundException The requested cache node offering does not exist.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeReservedCacheNodesOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeReservedCacheNodesOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReservedCacheNodesOfferingsPublisher describeReservedCacheNodesOfferingsPaginator() {
        return describeReservedCacheNodesOfferingsPaginator(DescribeReservedCacheNodesOfferingsRequest.builder().build());
    }

    /**
     * <p>
     * Lists available reserved cache node offerings.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReservedCacheNodesOfferings(software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesOfferingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeReservedCacheNodesOfferingsPublisher publisher = client.describeReservedCacheNodesOfferingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeReservedCacheNodesOfferingsPublisher publisher = client.describeReservedCacheNodesOfferingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesOfferingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesOfferingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedCacheNodesOfferings(software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesOfferingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReservedCacheNodesOfferingsRequest
     *        Represents the input of a <code>DescribeReservedCacheNodesOfferings</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReservedCacheNodesOfferingNotFoundException The requested cache node offering does not exist.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeReservedCacheNodesOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeReservedCacheNodesOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReservedCacheNodesOfferingsPublisher describeReservedCacheNodesOfferingsPaginator(
            DescribeReservedCacheNodesOfferingsRequest describeReservedCacheNodesOfferingsRequest) {
        return new DescribeReservedCacheNodesOfferingsPublisher(this, describeReservedCacheNodesOfferingsRequest);
    }

    /**
     * <p>
     * Lists available reserved cache node offerings.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReservedCacheNodesOfferings(software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesOfferingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeReservedCacheNodesOfferingsPublisher publisher = client.describeReservedCacheNodesOfferingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeReservedCacheNodesOfferingsPublisher publisher = client.describeReservedCacheNodesOfferingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesOfferingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesOfferingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedCacheNodesOfferings(software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesOfferingsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReservedCacheNodesOfferingsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeReservedCacheNodesOfferingsRequest#builder()}
     * </p>
     *
     * @param describeReservedCacheNodesOfferingsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeReservedCacheNodesOfferingsMessage.Builder} to
     *        create a request. Represents the input of a <code>DescribeReservedCacheNodesOfferings</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReservedCacheNodesOfferingNotFoundException The requested cache node offering does not exist.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeReservedCacheNodesOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeReservedCacheNodesOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReservedCacheNodesOfferingsPublisher describeReservedCacheNodesOfferingsPaginator(
            Consumer<DescribeReservedCacheNodesOfferingsRequest.Builder> describeReservedCacheNodesOfferingsRequest) {
        return describeReservedCacheNodesOfferingsPaginator(DescribeReservedCacheNodesOfferingsRequest.builder()
                .applyMutation(describeReservedCacheNodesOfferingsRequest).build());
    }

    /**
     * <p>
     * Returns information about reserved cache nodes for this account, or about a specified reserved cache node.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReservedCacheNodes(software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeReservedCacheNodesPublisher publisher = client.describeReservedCacheNodesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeReservedCacheNodesPublisher publisher = client.describeReservedCacheNodesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedCacheNodes(software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReservedCacheNodeNotFoundException The requested reserved cache node was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeReservedCacheNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeReservedCacheNodes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReservedCacheNodesPublisher describeReservedCacheNodesPaginator() {
        return describeReservedCacheNodesPaginator(DescribeReservedCacheNodesRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about reserved cache nodes for this account, or about a specified reserved cache node.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReservedCacheNodes(software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeReservedCacheNodesPublisher publisher = client.describeReservedCacheNodesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeReservedCacheNodesPublisher publisher = client.describeReservedCacheNodesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedCacheNodes(software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReservedCacheNodesRequest
     *        Represents the input of a <code>DescribeReservedCacheNodes</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReservedCacheNodeNotFoundException The requested reserved cache node was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeReservedCacheNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeReservedCacheNodes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReservedCacheNodesPublisher describeReservedCacheNodesPaginator(
            DescribeReservedCacheNodesRequest describeReservedCacheNodesRequest) {
        return new DescribeReservedCacheNodesPublisher(this, describeReservedCacheNodesRequest);
    }

    /**
     * <p>
     * Returns information about reserved cache nodes for this account, or about a specified reserved cache node.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReservedCacheNodes(software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeReservedCacheNodesPublisher publisher = client.describeReservedCacheNodesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeReservedCacheNodesPublisher publisher = client.describeReservedCacheNodesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedCacheNodes(software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReservedCacheNodesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeReservedCacheNodesRequest#builder()}
     * </p>
     *
     * @param describeReservedCacheNodesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeReservedCacheNodesMessage.Builder} to create a
     *        request. Represents the input of a <code>DescribeReservedCacheNodes</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReservedCacheNodeNotFoundException The requested reserved cache node was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeReservedCacheNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeReservedCacheNodes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReservedCacheNodesPublisher describeReservedCacheNodesPaginator(
            Consumer<DescribeReservedCacheNodesRequest.Builder> describeReservedCacheNodesRequest) {
        return describeReservedCacheNodesPaginator(DescribeReservedCacheNodesRequest.builder()
                .applyMutation(describeReservedCacheNodesRequest).build());
    }

    /**
     * <p>
     * Returns details of the service updates
     * </p>
     *
     * @param describeServiceUpdatesRequest
     * @return A Java Future containing the result of the DescribeServiceUpdates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUpdateNotFoundException The service update doesn't exist</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeServiceUpdates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeServiceUpdates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeServiceUpdatesResponse> describeServiceUpdates(
            DescribeServiceUpdatesRequest describeServiceUpdatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details of the service updates
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeServiceUpdatesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeServiceUpdatesRequest#builder()}
     * </p>
     *
     * @param describeServiceUpdatesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeServiceUpdatesMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeServiceUpdates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUpdateNotFoundException The service update doesn't exist</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeServiceUpdates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeServiceUpdates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeServiceUpdatesResponse> describeServiceUpdates(
            Consumer<DescribeServiceUpdatesRequest.Builder> describeServiceUpdatesRequest) {
        return describeServiceUpdates(DescribeServiceUpdatesRequest.builder().applyMutation(describeServiceUpdatesRequest)
                .build());
    }

    /**
     * <p>
     * Returns details of the service updates
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeServiceUpdates(software.amazon.awssdk.services.elasticache.model.DescribeServiceUpdatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeServiceUpdatesPublisher publisher = client.describeServiceUpdatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeServiceUpdatesPublisher publisher = client.describeServiceUpdatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeServiceUpdatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeServiceUpdatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeServiceUpdates(software.amazon.awssdk.services.elasticache.model.DescribeServiceUpdatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeServiceUpdatesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUpdateNotFoundException The service update doesn't exist</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeServiceUpdates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeServiceUpdates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeServiceUpdatesPublisher describeServiceUpdatesPaginator(
            DescribeServiceUpdatesRequest describeServiceUpdatesRequest) {
        return new DescribeServiceUpdatesPublisher(this, describeServiceUpdatesRequest);
    }

    /**
     * <p>
     * Returns details of the service updates
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeServiceUpdates(software.amazon.awssdk.services.elasticache.model.DescribeServiceUpdatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeServiceUpdatesPublisher publisher = client.describeServiceUpdatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeServiceUpdatesPublisher publisher = client.describeServiceUpdatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeServiceUpdatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeServiceUpdatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeServiceUpdates(software.amazon.awssdk.services.elasticache.model.DescribeServiceUpdatesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeServiceUpdatesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeServiceUpdatesRequest#builder()}
     * </p>
     *
     * @param describeServiceUpdatesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeServiceUpdatesMessage.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUpdateNotFoundException The service update doesn't exist</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeServiceUpdates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeServiceUpdates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeServiceUpdatesPublisher describeServiceUpdatesPaginator(
            Consumer<DescribeServiceUpdatesRequest.Builder> describeServiceUpdatesRequest) {
        return describeServiceUpdatesPaginator(DescribeServiceUpdatesRequest.builder()
                .applyMutation(describeServiceUpdatesRequest).build());
    }

    /**
     * <p>
     * Returns information about cluster or replication group snapshots. By default, <code>DescribeSnapshots</code>
     * lists all of your snapshots; it can optionally describe a single snapshot, or just the snapshots associated with
     * a particular cache cluster.
     * </p>
     * <note>
     * <p>
     * This operation is valid for Redis only.
     * </p>
     * </note>
     *
     * @param describeSnapshotsRequest
     *        Represents the input of a <code>DescribeSnapshotsMessage</code> operation.
     * @return A Java Future containing the result of the DescribeSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheClusterNotFoundException The requested cluster ID does not refer to an existing cluster.</li>
     *         <li>SnapshotNotFoundException The requested snapshot name does not refer to an existing snapshot.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeSnapshots" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeSnapshotsResponse> describeSnapshots(DescribeSnapshotsRequest describeSnapshotsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about cluster or replication group snapshots. By default, <code>DescribeSnapshots</code>
     * lists all of your snapshots; it can optionally describe a single snapshot, or just the snapshots associated with
     * a particular cache cluster.
     * </p>
     * <note>
     * <p>
     * This operation is valid for Redis only.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSnapshotsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeSnapshotsRequest#builder()}
     * </p>
     *
     * @param describeSnapshotsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSnapshotsMessage.Builder} to create a request.
     *        Represents the input of a <code>DescribeSnapshotsMessage</code> operation.
     * @return A Java Future containing the result of the DescribeSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheClusterNotFoundException The requested cluster ID does not refer to an existing cluster.</li>
     *         <li>SnapshotNotFoundException The requested snapshot name does not refer to an existing snapshot.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeSnapshots" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeSnapshotsResponse> describeSnapshots(
            Consumer<DescribeSnapshotsRequest.Builder> describeSnapshotsRequest) {
        return describeSnapshots(DescribeSnapshotsRequest.builder().applyMutation(describeSnapshotsRequest).build());
    }

    /**
     * <p>
     * Returns information about cluster or replication group snapshots. By default, <code>DescribeSnapshots</code>
     * lists all of your snapshots; it can optionally describe a single snapshot, or just the snapshots associated with
     * a particular cache cluster.
     * </p>
     * <note>
     * <p>
     * This operation is valid for Redis only.
     * </p>
     * </note>
     *
     * @return A Java Future containing the result of the DescribeSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheClusterNotFoundException The requested cluster ID does not refer to an existing cluster.</li>
     *         <li>SnapshotNotFoundException The requested snapshot name does not refer to an existing snapshot.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeSnapshots" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeSnapshotsResponse> describeSnapshots() {
        return describeSnapshots(DescribeSnapshotsRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about cluster or replication group snapshots. By default, <code>DescribeSnapshots</code>
     * lists all of your snapshots; it can optionally describe a single snapshot, or just the snapshots associated with
     * a particular cache cluster.
     * </p>
     * <note>
     * <p>
     * This operation is valid for Redis only.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeSnapshots(software.amazon.awssdk.services.elasticache.model.DescribeSnapshotsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeSnapshotsPublisher publisher = client.describeSnapshotsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeSnapshotsPublisher publisher = client.describeSnapshotsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeSnapshotsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeSnapshotsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSnapshots(software.amazon.awssdk.services.elasticache.model.DescribeSnapshotsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheClusterNotFoundException The requested cluster ID does not refer to an existing cluster.</li>
     *         <li>SnapshotNotFoundException The requested snapshot name does not refer to an existing snapshot.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeSnapshots" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeSnapshotsPublisher describeSnapshotsPaginator() {
        return describeSnapshotsPaginator(DescribeSnapshotsRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about cluster or replication group snapshots. By default, <code>DescribeSnapshots</code>
     * lists all of your snapshots; it can optionally describe a single snapshot, or just the snapshots associated with
     * a particular cache cluster.
     * </p>
     * <note>
     * <p>
     * This operation is valid for Redis only.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeSnapshots(software.amazon.awssdk.services.elasticache.model.DescribeSnapshotsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeSnapshotsPublisher publisher = client.describeSnapshotsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeSnapshotsPublisher publisher = client.describeSnapshotsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeSnapshotsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeSnapshotsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSnapshots(software.amazon.awssdk.services.elasticache.model.DescribeSnapshotsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeSnapshotsRequest
     *        Represents the input of a <code>DescribeSnapshotsMessage</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheClusterNotFoundException The requested cluster ID does not refer to an existing cluster.</li>
     *         <li>SnapshotNotFoundException The requested snapshot name does not refer to an existing snapshot.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeSnapshots" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeSnapshotsPublisher describeSnapshotsPaginator(DescribeSnapshotsRequest describeSnapshotsRequest) {
        return new DescribeSnapshotsPublisher(this, describeSnapshotsRequest);
    }

    /**
     * <p>
     * Returns information about cluster or replication group snapshots. By default, <code>DescribeSnapshots</code>
     * lists all of your snapshots; it can optionally describe a single snapshot, or just the snapshots associated with
     * a particular cache cluster.
     * </p>
     * <note>
     * <p>
     * This operation is valid for Redis only.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeSnapshots(software.amazon.awssdk.services.elasticache.model.DescribeSnapshotsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeSnapshotsPublisher publisher = client.describeSnapshotsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeSnapshotsPublisher publisher = client.describeSnapshotsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeSnapshotsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeSnapshotsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSnapshots(software.amazon.awssdk.services.elasticache.model.DescribeSnapshotsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSnapshotsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeSnapshotsRequest#builder()}
     * </p>
     *
     * @param describeSnapshotsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSnapshotsMessage.Builder} to create a request.
     *        Represents the input of a <code>DescribeSnapshotsMessage</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheClusterNotFoundException The requested cluster ID does not refer to an existing cluster.</li>
     *         <li>SnapshotNotFoundException The requested snapshot name does not refer to an existing snapshot.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeSnapshots" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeSnapshotsPublisher describeSnapshotsPaginator(
            Consumer<DescribeSnapshotsRequest.Builder> describeSnapshotsRequest) {
        return describeSnapshotsPaginator(DescribeSnapshotsRequest.builder().applyMutation(describeSnapshotsRequest).build());
    }

    /**
     * <p>
     * Returns details of the update actions
     * </p>
     *
     * @param describeUpdateActionsRequest
     * @return A Java Future containing the result of the DescribeUpdateActions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeUpdateActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeUpdateActions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeUpdateActionsResponse> describeUpdateActions(
            DescribeUpdateActionsRequest describeUpdateActionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details of the update actions
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUpdateActionsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeUpdateActionsRequest#builder()}
     * </p>
     *
     * @param describeUpdateActionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeUpdateActionsMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeUpdateActions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeUpdateActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeUpdateActions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeUpdateActionsResponse> describeUpdateActions(
            Consumer<DescribeUpdateActionsRequest.Builder> describeUpdateActionsRequest) {
        return describeUpdateActions(DescribeUpdateActionsRequest.builder().applyMutation(describeUpdateActionsRequest).build());
    }

    /**
     * <p>
     * Returns details of the update actions
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeUpdateActions(software.amazon.awssdk.services.elasticache.model.DescribeUpdateActionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeUpdateActionsPublisher publisher = client.describeUpdateActionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeUpdateActionsPublisher publisher = client.describeUpdateActionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeUpdateActionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeUpdateActionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeUpdateActions(software.amazon.awssdk.services.elasticache.model.DescribeUpdateActionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeUpdateActionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeUpdateActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeUpdateActions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeUpdateActionsPublisher describeUpdateActionsPaginator(
            DescribeUpdateActionsRequest describeUpdateActionsRequest) {
        return new DescribeUpdateActionsPublisher(this, describeUpdateActionsRequest);
    }

    /**
     * <p>
     * Returns details of the update actions
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeUpdateActions(software.amazon.awssdk.services.elasticache.model.DescribeUpdateActionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeUpdateActionsPublisher publisher = client.describeUpdateActionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeUpdateActionsPublisher publisher = client.describeUpdateActionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeUpdateActionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeUpdateActionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeUpdateActions(software.amazon.awssdk.services.elasticache.model.DescribeUpdateActionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUpdateActionsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeUpdateActionsRequest#builder()}
     * </p>
     *
     * @param describeUpdateActionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeUpdateActionsMessage.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeUpdateActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeUpdateActions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeUpdateActionsPublisher describeUpdateActionsPaginator(
            Consumer<DescribeUpdateActionsRequest.Builder> describeUpdateActionsRequest) {
        return describeUpdateActionsPaginator(DescribeUpdateActionsRequest.builder().applyMutation(describeUpdateActionsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of user groups.
     * </p>
     *
     * @param describeUserGroupsRequest
     * @return A Java Future containing the result of the DescribeUserGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UserGroupNotFoundException The user group was not found or does not exist</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeUserGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeUserGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeUserGroupsResponse> describeUserGroups(DescribeUserGroupsRequest describeUserGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of user groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUserGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeUserGroupsRequest#builder()}
     * </p>
     *
     * @param describeUserGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeUserGroupsMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeUserGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UserGroupNotFoundException The user group was not found or does not exist</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeUserGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeUserGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeUserGroupsResponse> describeUserGroups(
            Consumer<DescribeUserGroupsRequest.Builder> describeUserGroupsRequest) {
        return describeUserGroups(DescribeUserGroupsRequest.builder().applyMutation(describeUserGroupsRequest).build());
    }

    /**
     * <p>
     * Returns a list of user groups.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeUserGroups(software.amazon.awssdk.services.elasticache.model.DescribeUserGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeUserGroupsPublisher publisher = client.describeUserGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeUserGroupsPublisher publisher = client.describeUserGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeUserGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeUserGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeUserGroups(software.amazon.awssdk.services.elasticache.model.DescribeUserGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeUserGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UserGroupNotFoundException The user group was not found or does not exist</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeUserGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeUserGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeUserGroupsPublisher describeUserGroupsPaginator(DescribeUserGroupsRequest describeUserGroupsRequest) {
        return new DescribeUserGroupsPublisher(this, describeUserGroupsRequest);
    }

    /**
     * <p>
     * Returns a list of user groups.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeUserGroups(software.amazon.awssdk.services.elasticache.model.DescribeUserGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeUserGroupsPublisher publisher = client.describeUserGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeUserGroupsPublisher publisher = client.describeUserGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeUserGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeUserGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeUserGroups(software.amazon.awssdk.services.elasticache.model.DescribeUserGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUserGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeUserGroupsRequest#builder()}
     * </p>
     *
     * @param describeUserGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeUserGroupsMessage.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UserGroupNotFoundException The user group was not found or does not exist</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeUserGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeUserGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeUserGroupsPublisher describeUserGroupsPaginator(
            Consumer<DescribeUserGroupsRequest.Builder> describeUserGroupsRequest) {
        return describeUserGroupsPaginator(DescribeUserGroupsRequest.builder().applyMutation(describeUserGroupsRequest).build());
    }

    /**
     * <p>
     * Returns a list of users.
     * </p>
     *
     * @param describeUsersRequest
     * @return A Java Future containing the result of the DescribeUsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UserNotFoundException The user does not exist or could not be found.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeUsersResponse> describeUsers(DescribeUsersRequest describeUsersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of users.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUsersRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeUsersRequest#builder()}
     * </p>
     *
     * @param describeUsersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeUsersMessage.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeUsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UserNotFoundException The user does not exist or could not be found.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeUsersResponse> describeUsers(Consumer<DescribeUsersRequest.Builder> describeUsersRequest) {
        return describeUsers(DescribeUsersRequest.builder().applyMutation(describeUsersRequest).build());
    }

    /**
     * <p>
     * Returns a list of users.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeUsers(software.amazon.awssdk.services.elasticache.model.DescribeUsersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeUsersPublisher publisher = client.describeUsersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeUsersPublisher publisher = client.describeUsersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeUsersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeUsersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeUsers(software.amazon.awssdk.services.elasticache.model.DescribeUsersRequest)} operation.</b>
     * </p>
     *
     * @param describeUsersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UserNotFoundException The user does not exist or could not be found.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeUsersPublisher describeUsersPaginator(DescribeUsersRequest describeUsersRequest) {
        return new DescribeUsersPublisher(this, describeUsersRequest);
    }

    /**
     * <p>
     * Returns a list of users.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeUsers(software.amazon.awssdk.services.elasticache.model.DescribeUsersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeUsersPublisher publisher = client.describeUsersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeUsersPublisher publisher = client.describeUsersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeUsersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeUsersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeUsers(software.amazon.awssdk.services.elasticache.model.DescribeUsersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUsersRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeUsersRequest#builder()}
     * </p>
     *
     * @param describeUsersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeUsersMessage.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UserNotFoundException The user does not exist or could not be found.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeUsersPublisher describeUsersPaginator(Consumer<DescribeUsersRequest.Builder> describeUsersRequest) {
        return describeUsersPaginator(DescribeUsersRequest.builder().applyMutation(describeUsersRequest).build());
    }

    /**
     * <p>
     * Remove a secondary cluster from the Global datastore using the Global datastore name. The secondary cluster will
     * no longer receive updates from the primary cluster, but will remain as a standalone cluster in that Amazon
     * region.
     * </p>
     *
     * @param disassociateGlobalReplicationGroupRequest
     * @return A Java Future containing the result of the DisassociateGlobalReplicationGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GlobalReplicationGroupNotFoundException The Global datastore does not exist</li>
     *         <li>InvalidGlobalReplicationGroupStateException The Global datastore is not available or in primary-only
     *         state.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DisassociateGlobalReplicationGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DisassociateGlobalReplicationGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateGlobalReplicationGroupResponse> disassociateGlobalReplicationGroup(
            DisassociateGlobalReplicationGroupRequest disassociateGlobalReplicationGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove a secondary cluster from the Global datastore using the Global datastore name. The secondary cluster will
     * no longer receive updates from the primary cluster, but will remain as a standalone cluster in that Amazon
     * region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateGlobalReplicationGroupRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateGlobalReplicationGroupRequest#builder()}
     * </p>
     *
     * @param disassociateGlobalReplicationGroupRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateGlobalReplicationGroupMessage.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisassociateGlobalReplicationGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GlobalReplicationGroupNotFoundException The Global datastore does not exist</li>
     *         <li>InvalidGlobalReplicationGroupStateException The Global datastore is not available or in primary-only
     *         state.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DisassociateGlobalReplicationGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DisassociateGlobalReplicationGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateGlobalReplicationGroupResponse> disassociateGlobalReplicationGroup(
            Consumer<DisassociateGlobalReplicationGroupRequest.Builder> disassociateGlobalReplicationGroupRequest) {
        return disassociateGlobalReplicationGroup(DisassociateGlobalReplicationGroupRequest.builder()
                .applyMutation(disassociateGlobalReplicationGroupRequest).build());
    }

    /**
     * <p>
     * Used to failover the primary region to a secondary region. The secondary region will become primary, and all
     * other clusters will become secondary.
     * </p>
     *
     * @param failoverGlobalReplicationGroupRequest
     * @return A Java Future containing the result of the FailoverGlobalReplicationGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GlobalReplicationGroupNotFoundException The Global datastore does not exist</li>
     *         <li>InvalidGlobalReplicationGroupStateException The Global datastore is not available or in primary-only
     *         state.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.FailoverGlobalReplicationGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/FailoverGlobalReplicationGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<FailoverGlobalReplicationGroupResponse> failoverGlobalReplicationGroup(
            FailoverGlobalReplicationGroupRequest failoverGlobalReplicationGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used to failover the primary region to a secondary region. The secondary region will become primary, and all
     * other clusters will become secondary.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link FailoverGlobalReplicationGroupRequest.Builder}
     * avoiding the need to create one manually via {@link FailoverGlobalReplicationGroupRequest#builder()}
     * </p>
     *
     * @param failoverGlobalReplicationGroupRequest
     *        A {@link Consumer} that will call methods on {@link FailoverGlobalReplicationGroupMessage.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the FailoverGlobalReplicationGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GlobalReplicationGroupNotFoundException The Global datastore does not exist</li>
     *         <li>InvalidGlobalReplicationGroupStateException The Global datastore is not available or in primary-only
     *         state.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.FailoverGlobalReplicationGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/FailoverGlobalReplicationGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<FailoverGlobalReplicationGroupResponse> failoverGlobalReplicationGroup(
            Consumer<FailoverGlobalReplicationGroupRequest.Builder> failoverGlobalReplicationGroupRequest) {
        return failoverGlobalReplicationGroup(FailoverGlobalReplicationGroupRequest.builder()
                .applyMutation(failoverGlobalReplicationGroupRequest).build());
    }

    /**
     * <p>
     * Increase the number of node groups in the Global datastore
     * </p>
     *
     * @param increaseNodeGroupsInGlobalReplicationGroupRequest
     * @return A Java Future containing the result of the IncreaseNodeGroupsInGlobalReplicationGroup operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GlobalReplicationGroupNotFoundException The Global datastore does not exist</li>
     *         <li>InvalidGlobalReplicationGroupStateException The Global datastore is not available or in primary-only
     *         state.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.IncreaseNodeGroupsInGlobalReplicationGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/IncreaseNodeGroupsInGlobalReplicationGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<IncreaseNodeGroupsInGlobalReplicationGroupResponse> increaseNodeGroupsInGlobalReplicationGroup(
            IncreaseNodeGroupsInGlobalReplicationGroupRequest increaseNodeGroupsInGlobalReplicationGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Increase the number of node groups in the Global datastore
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link IncreaseNodeGroupsInGlobalReplicationGroupRequest.Builder} avoiding the need to create one manually via
     * {@link IncreaseNodeGroupsInGlobalReplicationGroupRequest#builder()}
     * </p>
     *
     * @param increaseNodeGroupsInGlobalReplicationGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link IncreaseNodeGroupsInGlobalReplicationGroupMessage.Builder} to create a request.
     * @return A Java Future containing the result of the IncreaseNodeGroupsInGlobalReplicationGroup operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GlobalReplicationGroupNotFoundException The Global datastore does not exist</li>
     *         <li>InvalidGlobalReplicationGroupStateException The Global datastore is not available or in primary-only
     *         state.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.IncreaseNodeGroupsInGlobalReplicationGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/IncreaseNodeGroupsInGlobalReplicationGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<IncreaseNodeGroupsInGlobalReplicationGroupResponse> increaseNodeGroupsInGlobalReplicationGroup(
            Consumer<IncreaseNodeGroupsInGlobalReplicationGroupRequest.Builder> increaseNodeGroupsInGlobalReplicationGroupRequest) {
        return increaseNodeGroupsInGlobalReplicationGroup(IncreaseNodeGroupsInGlobalReplicationGroupRequest.builder()
                .applyMutation(increaseNodeGroupsInGlobalReplicationGroupRequest).build());
    }

    /**
     * <p>
     * Dynamically increases the number of replicas in a Redis (cluster mode disabled) replication group or the number
     * of replica nodes in one or more node groups (shards) of a Redis (cluster mode enabled) replication group. This
     * operation is performed with no cluster down time.
     * </p>
     *
     * @param increaseReplicaCountRequest
     * @return A Java Future containing the result of the IncreaseReplicaCount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReplicationGroupNotFoundException The specified replication group does not exist.</li>
     *         <li>InvalidReplicationGroupStateException The requested replication group is not in the
     *         <code>available</code> state.</li>
     *         <li>InvalidCacheClusterStateException The requested cluster is not in the <code>available</code> state.</li>
     *         <li>InvalidVpcNetworkStateException The VPC network is in an invalid state.</li>
     *         <li>InsufficientCacheClusterCapacityException The requested cache node type is not available in the
     *         specified Availability Zone. For more information, see <a href=
     *         "http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ErrorMessages.html#ErrorMessages.INSUFFICIENT_CACHE_CLUSTER_CAPACITY"
     *         >InsufficientCacheClusterCapacity</a> in the ElastiCache User Guide.</li>
     *         <li>ClusterQuotaForCustomerExceededException The request cannot be processed because it would exceed the
     *         allowed number of clusters per customer.</li>
     *         <li>NodeGroupsPerReplicationGroupQuotaExceededException The request cannot be processed because it would
     *         exceed the maximum allowed number of node groups (shards) in a single replication group. The default
     *         maximum is 90</li>
     *         <li>NodeQuotaForCustomerExceededException The request cannot be processed because it would exceed the
     *         allowed number of cache nodes per customer.</li>
     *         <li>NoOperationException The operation was not performed because no changes were required.</li>
     *         <li>InvalidKmsKeyException The KMS key supplied is not valid.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.IncreaseReplicaCount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/IncreaseReplicaCount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<IncreaseReplicaCountResponse> increaseReplicaCount(
            IncreaseReplicaCountRequest increaseReplicaCountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Dynamically increases the number of replicas in a Redis (cluster mode disabled) replication group or the number
     * of replica nodes in one or more node groups (shards) of a Redis (cluster mode enabled) replication group. This
     * operation is performed with no cluster down time.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link IncreaseReplicaCountRequest.Builder} avoiding the
     * need to create one manually via {@link IncreaseReplicaCountRequest#builder()}
     * </p>
     *
     * @param increaseReplicaCountRequest
     *        A {@link Consumer} that will call methods on {@link IncreaseReplicaCountMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the IncreaseReplicaCount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReplicationGroupNotFoundException The specified replication group does not exist.</li>
     *         <li>InvalidReplicationGroupStateException The requested replication group is not in the
     *         <code>available</code> state.</li>
     *         <li>InvalidCacheClusterStateException The requested cluster is not in the <code>available</code> state.</li>
     *         <li>InvalidVpcNetworkStateException The VPC network is in an invalid state.</li>
     *         <li>InsufficientCacheClusterCapacityException The requested cache node type is not available in the
     *         specified Availability Zone. For more information, see <a href=
     *         "http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ErrorMessages.html#ErrorMessages.INSUFFICIENT_CACHE_CLUSTER_CAPACITY"
     *         >InsufficientCacheClusterCapacity</a> in the ElastiCache User Guide.</li>
     *         <li>ClusterQuotaForCustomerExceededException The request cannot be processed because it would exceed the
     *         allowed number of clusters per customer.</li>
     *         <li>NodeGroupsPerReplicationGroupQuotaExceededException The request cannot be processed because it would
     *         exceed the maximum allowed number of node groups (shards) in a single replication group. The default
     *         maximum is 90</li>
     *         <li>NodeQuotaForCustomerExceededException The request cannot be processed because it would exceed the
     *         allowed number of cache nodes per customer.</li>
     *         <li>NoOperationException The operation was not performed because no changes were required.</li>
     *         <li>InvalidKmsKeyException The KMS key supplied is not valid.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.IncreaseReplicaCount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/IncreaseReplicaCount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<IncreaseReplicaCountResponse> increaseReplicaCount(
            Consumer<IncreaseReplicaCountRequest.Builder> increaseReplicaCountRequest) {
        return increaseReplicaCount(IncreaseReplicaCountRequest.builder().applyMutation(increaseReplicaCountRequest).build());
    }

    /**
     * <p>
     * Lists all available node types that you can scale your Redis cluster's or replication group's current node type.
     * </p>
     * <p>
     * When you use the <code>ModifyCacheCluster</code> or <code>ModifyReplicationGroup</code> operations to scale your
     * cluster or replication group, the value of the <code>CacheNodeType</code> parameter must be one of the node types
     * returned by this operation.
     * </p>
     *
     * @param listAllowedNodeTypeModificationsRequest
     *        The input parameters for the <code>ListAllowedNodeTypeModifications</code> operation.
     * @return A Java Future containing the result of the ListAllowedNodeTypeModifications operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheClusterNotFoundException The requested cluster ID does not refer to an existing cluster.</li>
     *         <li>ReplicationGroupNotFoundException The specified replication group does not exist.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.ListAllowedNodeTypeModifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ListAllowedNodeTypeModifications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAllowedNodeTypeModificationsResponse> listAllowedNodeTypeModifications(
            ListAllowedNodeTypeModificationsRequest listAllowedNodeTypeModificationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all available node types that you can scale your Redis cluster's or replication group's current node type.
     * </p>
     * <p>
     * When you use the <code>ModifyCacheCluster</code> or <code>ModifyReplicationGroup</code> operations to scale your
     * cluster or replication group, the value of the <code>CacheNodeType</code> parameter must be one of the node types
     * returned by this operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAllowedNodeTypeModificationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListAllowedNodeTypeModificationsRequest#builder()}
     * </p>
     *
     * @param listAllowedNodeTypeModificationsRequest
     *        A {@link Consumer} that will call methods on {@link ListAllowedNodeTypeModificationsMessage.Builder} to
     *        create a request. The input parameters for the <code>ListAllowedNodeTypeModifications</code> operation.
     * @return A Java Future containing the result of the ListAllowedNodeTypeModifications operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheClusterNotFoundException The requested cluster ID does not refer to an existing cluster.</li>
     *         <li>ReplicationGroupNotFoundException The specified replication group does not exist.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.ListAllowedNodeTypeModifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ListAllowedNodeTypeModifications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAllowedNodeTypeModificationsResponse> listAllowedNodeTypeModifications(
            Consumer<ListAllowedNodeTypeModificationsRequest.Builder> listAllowedNodeTypeModificationsRequest) {
        return listAllowedNodeTypeModifications(ListAllowedNodeTypeModificationsRequest.builder()
                .applyMutation(listAllowedNodeTypeModificationsRequest).build());
    }

    /**
     * <p>
     * Lists all tags currently on a named resource.
     * </p>
     * <p>
     * A tag is a key-value pair where the key and value are case-sensitive. You can use tags to categorize and track
     * all your ElastiCache resources, with the exception of global replication group. When you add or remove tags on
     * replication groups, those actions will be replicated to all nodes in the replication group. For more information,
     * see <a
     * href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/IAM.ResourceLevelPermissions.html">Resource
     * -level permissions</a>.
     * </p>
     * <p>
     * If the cluster is not in the <i>available</i> state, <code>ListTagsForResource</code> returns an error.
     * </p>
     *
     * @param listTagsForResourceRequest
     *        The input parameters for the <code>ListTagsForResource</code> operation.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheClusterNotFoundException The requested cluster ID does not refer to an existing cluster.</li>
     *         <li>CacheParameterGroupNotFoundException The requested cache parameter group name does not refer to an
     *         existing cache parameter group.</li>
     *         <li>CacheSecurityGroupNotFoundException The requested cache security group name does not refer to an
     *         existing cache security group.</li>
     *         <li>CacheSubnetGroupNotFoundException The requested cache subnet group name does not refer to an existing
     *         cache subnet group.</li>
     *         <li>InvalidReplicationGroupStateException The requested replication group is not in the
     *         <code>available</code> state.</li>
     *         <li>ReplicationGroupNotFoundException The specified replication group does not exist.</li>
     *         <li>ReservedCacheNodeNotFoundException The requested reserved cache node was not found.</li>
     *         <li>SnapshotNotFoundException The requested snapshot name does not refer to an existing snapshot.</li>
     *         <li>UserNotFoundException The user does not exist or could not be found.</li>
     *         <li>UserGroupNotFoundException The user group was not found or does not exist</li>
     *         <li>InvalidArnException The requested Amazon Resource Name (ARN) does not refer to an existing resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags currently on a named resource.
     * </p>
     * <p>
     * A tag is a key-value pair where the key and value are case-sensitive. You can use tags to categorize and track
     * all your ElastiCache resources, with the exception of global replication group. When you add or remove tags on
     * replication groups, those actions will be replicated to all nodes in the replication group. For more information,
     * see <a
     * href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/IAM.ResourceLevelPermissions.html">Resource
     * -level permissions</a>.
     * </p>
     * <p>
     * If the cluster is not in the <i>available</i> state, <code>ListTagsForResource</code> returns an error.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceMessage.Builder} to create a
     *        request. The input parameters for the <code>ListTagsForResource</code> operation.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheClusterNotFoundException The requested cluster ID does not refer to an existing cluster.</li>
     *         <li>CacheParameterGroupNotFoundException The requested cache parameter group name does not refer to an
     *         existing cache parameter group.</li>
     *         <li>CacheSecurityGroupNotFoundException The requested cache security group name does not refer to an
     *         existing cache security group.</li>
     *         <li>CacheSubnetGroupNotFoundException The requested cache subnet group name does not refer to an existing
     *         cache subnet group.</li>
     *         <li>InvalidReplicationGroupStateException The requested replication group is not in the
     *         <code>available</code> state.</li>
     *         <li>ReplicationGroupNotFoundException The specified replication group does not exist.</li>
     *         <li>ReservedCacheNodeNotFoundException The requested reserved cache node was not found.</li>
     *         <li>SnapshotNotFoundException The requested snapshot name does not refer to an existing snapshot.</li>
     *         <li>UserNotFoundException The user does not exist or could not be found.</li>
     *         <li>UserGroupNotFoundException The user group was not found or does not exist</li>
     *         <li>InvalidArnException The requested Amazon Resource Name (ARN) does not refer to an existing resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Modifies the settings for a cluster. You can use this operation to change one or more cluster configuration
     * parameters by specifying the parameters and the new values.
     * </p>
     *
     * @param modifyCacheClusterRequest
     *        Represents the input of a <code>ModifyCacheCluster</code> operation.
     * @return A Java Future containing the result of the ModifyCacheCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidCacheClusterStateException The requested cluster is not in the <code>available</code> state.</li>
     *         <li>InvalidCacheSecurityGroupStateException The current state of the cache security group does not allow
     *         deletion.</li>
     *         <li>InsufficientCacheClusterCapacityException The requested cache node type is not available in the
     *         specified Availability Zone. For more information, see <a href=
     *         "http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ErrorMessages.html#ErrorMessages.INSUFFICIENT_CACHE_CLUSTER_CAPACITY"
     *         >InsufficientCacheClusterCapacity</a> in the ElastiCache User Guide.</li>
     *         <li>CacheClusterNotFoundException The requested cluster ID does not refer to an existing cluster.</li>
     *         <li>NodeQuotaForClusterExceededException The request cannot be processed because it would exceed the
     *         allowed number of cache nodes in a single cluster.</li>
     *         <li>NodeQuotaForCustomerExceededException The request cannot be processed because it would exceed the
     *         allowed number of cache nodes per customer.</li>
     *         <li>CacheSecurityGroupNotFoundException The requested cache security group name does not refer to an
     *         existing cache security group.</li>
     *         <li>CacheParameterGroupNotFoundException The requested cache parameter group name does not refer to an
     *         existing cache parameter group.</li>
     *         <li>InvalidVpcNetworkStateException The VPC network is in an invalid state.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.ModifyCacheCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ModifyCacheCluster"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyCacheClusterResponse> modifyCacheCluster(ModifyCacheClusterRequest modifyCacheClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the settings for a cluster. You can use this operation to change one or more cluster configuration
     * parameters by specifying the parameters and the new values.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyCacheClusterRequest.Builder} avoiding the
     * need to create one manually via {@link ModifyCacheClusterRequest#builder()}
     * </p>
     *
     * @param modifyCacheClusterRequest
     *        A {@link Consumer} that will call methods on {@link ModifyCacheClusterMessage.Builder} to create a
     *        request. Represents the input of a <code>ModifyCacheCluster</code> operation.
     * @return A Java Future containing the result of the ModifyCacheCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidCacheClusterStateException The requested cluster is not in the <code>available</code> state.</li>
     *         <li>InvalidCacheSecurityGroupStateException The current state of the cache security group does not allow
     *         deletion.</li>
     *         <li>InsufficientCacheClusterCapacityException The requested cache node type is not available in the
     *         specified Availability Zone. For more information, see <a href=
     *         "http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ErrorMessages.html#ErrorMessages.INSUFFICIENT_CACHE_CLUSTER_CAPACITY"
     *         >InsufficientCacheClusterCapacity</a> in the ElastiCache User Guide.</li>
     *         <li>CacheClusterNotFoundException The requested cluster ID does not refer to an existing cluster.</li>
     *         <li>NodeQuotaForClusterExceededException The request cannot be processed because it would exceed the
     *         allowed number of cache nodes in a single cluster.</li>
     *         <li>NodeQuotaForCustomerExceededException The request cannot be processed because it would exceed the
     *         allowed number of cache nodes per customer.</li>
     *         <li>CacheSecurityGroupNotFoundException The requested cache security group name does not refer to an
     *         existing cache security group.</li>
     *         <li>CacheParameterGroupNotFoundException The requested cache parameter group name does not refer to an
     *         existing cache parameter group.</li>
     *         <li>InvalidVpcNetworkStateException The VPC network is in an invalid state.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.ModifyCacheCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ModifyCacheCluster"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyCacheClusterResponse> modifyCacheCluster(
            Consumer<ModifyCacheClusterRequest.Builder> modifyCacheClusterRequest) {
        return modifyCacheCluster(ModifyCacheClusterRequest.builder().applyMutation(modifyCacheClusterRequest).build());
    }

    /**
     * <p>
     * Modifies the parameters of a cache parameter group. You can modify up to 20 parameters in a single request by
     * submitting a list parameter name and value pairs.
     * </p>
     *
     * @param modifyCacheParameterGroupRequest
     *        Represents the input of a <code>ModifyCacheParameterGroup</code> operation.
     * @return A Java Future containing the result of the ModifyCacheParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheParameterGroupNotFoundException The requested cache parameter group name does not refer to an
     *         existing cache parameter group.</li>
     *         <li>InvalidCacheParameterGroupStateException The current state of the cache parameter group does not
     *         allow the requested operation to occur.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>InvalidGlobalReplicationGroupStateException The Global datastore is not available or in primary-only
     *         state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.ModifyCacheParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ModifyCacheParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyCacheParameterGroupResponse> modifyCacheParameterGroup(
            ModifyCacheParameterGroupRequest modifyCacheParameterGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the parameters of a cache parameter group. You can modify up to 20 parameters in a single request by
     * submitting a list parameter name and value pairs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyCacheParameterGroupRequest.Builder} avoiding
     * the need to create one manually via {@link ModifyCacheParameterGroupRequest#builder()}
     * </p>
     *
     * @param modifyCacheParameterGroupRequest
     *        A {@link Consumer} that will call methods on {@link ModifyCacheParameterGroupMessage.Builder} to create a
     *        request. Represents the input of a <code>ModifyCacheParameterGroup</code> operation.
     * @return A Java Future containing the result of the ModifyCacheParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheParameterGroupNotFoundException The requested cache parameter group name does not refer to an
     *         existing cache parameter group.</li>
     *         <li>InvalidCacheParameterGroupStateException The current state of the cache parameter group does not
     *         allow the requested operation to occur.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>InvalidGlobalReplicationGroupStateException The Global datastore is not available or in primary-only
     *         state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.ModifyCacheParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ModifyCacheParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyCacheParameterGroupResponse> modifyCacheParameterGroup(
            Consumer<ModifyCacheParameterGroupRequest.Builder> modifyCacheParameterGroupRequest) {
        return modifyCacheParameterGroup(ModifyCacheParameterGroupRequest.builder()
                .applyMutation(modifyCacheParameterGroupRequest).build());
    }

    /**
     * <p>
     * Modifies an existing cache subnet group.
     * </p>
     *
     * @param modifyCacheSubnetGroupRequest
     *        Represents the input of a <code>ModifyCacheSubnetGroup</code> operation.
     * @return A Java Future containing the result of the ModifyCacheSubnetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheSubnetGroupNotFoundException The requested cache subnet group name does not refer to an existing
     *         cache subnet group.</li>
     *         <li>CacheSubnetQuotaExceededException The request cannot be processed because it would exceed the allowed
     *         number of subnets in a cache subnet group.</li>
     *         <li>SubnetInUseException The requested subnet is being used by another cache subnet group.</li>
     *         <li>InvalidSubnetException An invalid subnet identifier was specified.</li>
     *         <li>SubnetNotAllowedException At least one subnet ID does not match the other subnet IDs. This mismatch
     *         typically occurs when a user sets one subnet ID to a regional Availability Zone and a different one to an
     *         outpost. Or when a user sets the subnet ID to an Outpost when not subscribed on this service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.ModifyCacheSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ModifyCacheSubnetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyCacheSubnetGroupResponse> modifyCacheSubnetGroup(
            ModifyCacheSubnetGroupRequest modifyCacheSubnetGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies an existing cache subnet group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyCacheSubnetGroupRequest.Builder} avoiding the
     * need to create one manually via {@link ModifyCacheSubnetGroupRequest#builder()}
     * </p>
     *
     * @param modifyCacheSubnetGroupRequest
     *        A {@link Consumer} that will call methods on {@link ModifyCacheSubnetGroupMessage.Builder} to create a
     *        request. Represents the input of a <code>ModifyCacheSubnetGroup</code> operation.
     * @return A Java Future containing the result of the ModifyCacheSubnetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheSubnetGroupNotFoundException The requested cache subnet group name does not refer to an existing
     *         cache subnet group.</li>
     *         <li>CacheSubnetQuotaExceededException The request cannot be processed because it would exceed the allowed
     *         number of subnets in a cache subnet group.</li>
     *         <li>SubnetInUseException The requested subnet is being used by another cache subnet group.</li>
     *         <li>InvalidSubnetException An invalid subnet identifier was specified.</li>
     *         <li>SubnetNotAllowedException At least one subnet ID does not match the other subnet IDs. This mismatch
     *         typically occurs when a user sets one subnet ID to a regional Availability Zone and a different one to an
     *         outpost. Or when a user sets the subnet ID to an Outpost when not subscribed on this service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.ModifyCacheSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ModifyCacheSubnetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyCacheSubnetGroupResponse> modifyCacheSubnetGroup(
            Consumer<ModifyCacheSubnetGroupRequest.Builder> modifyCacheSubnetGroupRequest) {
        return modifyCacheSubnetGroup(ModifyCacheSubnetGroupRequest.builder().applyMutation(modifyCacheSubnetGroupRequest)
                .build());
    }

    /**
     * <p>
     * Modifies the settings for a Global datastore.
     * </p>
     *
     * @param modifyGlobalReplicationGroupRequest
     * @return A Java Future containing the result of the ModifyGlobalReplicationGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GlobalReplicationGroupNotFoundException The Global datastore does not exist</li>
     *         <li>InvalidGlobalReplicationGroupStateException The Global datastore is not available or in primary-only
     *         state.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.ModifyGlobalReplicationGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ModifyGlobalReplicationGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyGlobalReplicationGroupResponse> modifyGlobalReplicationGroup(
            ModifyGlobalReplicationGroupRequest modifyGlobalReplicationGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the settings for a Global datastore.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyGlobalReplicationGroupRequest.Builder}
     * avoiding the need to create one manually via {@link ModifyGlobalReplicationGroupRequest#builder()}
     * </p>
     *
     * @param modifyGlobalReplicationGroupRequest
     *        A {@link Consumer} that will call methods on {@link ModifyGlobalReplicationGroupMessage.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ModifyGlobalReplicationGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GlobalReplicationGroupNotFoundException The Global datastore does not exist</li>
     *         <li>InvalidGlobalReplicationGroupStateException The Global datastore is not available or in primary-only
     *         state.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.ModifyGlobalReplicationGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ModifyGlobalReplicationGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyGlobalReplicationGroupResponse> modifyGlobalReplicationGroup(
            Consumer<ModifyGlobalReplicationGroupRequest.Builder> modifyGlobalReplicationGroupRequest) {
        return modifyGlobalReplicationGroup(ModifyGlobalReplicationGroupRequest.builder()
                .applyMutation(modifyGlobalReplicationGroupRequest).build());
    }

    /**
     * <p>
     * Modifies the settings for a replication group.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/scaling-redis-cluster-mode-enabled.html">
     * Scaling for Amazon ElastiCache for Redis (cluster mode enabled)</a> in the ElastiCache User Guide
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_ModifyReplicationGroupShardConfiguration.html"
     * >ModifyReplicationGroupShardConfiguration</a> in the ElastiCache API Reference
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * This operation is valid for Redis only.
     * </p>
     * </note>
     *
     * @param modifyReplicationGroupRequest
     *        Represents the input of a <code>ModifyReplicationGroups</code> operation.
     * @return A Java Future containing the result of the ModifyReplicationGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReplicationGroupNotFoundException The specified replication group does not exist.</li>
     *         <li>InvalidReplicationGroupStateException The requested replication group is not in the
     *         <code>available</code> state.</li>
     *         <li>InvalidUserGroupStateException The user group is not in an active state.</li>
     *         <li>UserGroupNotFoundException The user group was not found or does not exist</li>
     *         <li>InvalidCacheClusterStateException The requested cluster is not in the <code>available</code> state.</li>
     *         <li>InvalidCacheSecurityGroupStateException The current state of the cache security group does not allow
     *         deletion.</li>
     *         <li>InsufficientCacheClusterCapacityException The requested cache node type is not available in the
     *         specified Availability Zone. For more information, see <a href=
     *         "http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ErrorMessages.html#ErrorMessages.INSUFFICIENT_CACHE_CLUSTER_CAPACITY"
     *         >InsufficientCacheClusterCapacity</a> in the ElastiCache User Guide.</li>
     *         <li>CacheClusterNotFoundException The requested cluster ID does not refer to an existing cluster.</li>
     *         <li>NodeQuotaForClusterExceededException The request cannot be processed because it would exceed the
     *         allowed number of cache nodes in a single cluster.</li>
     *         <li>NodeQuotaForCustomerExceededException The request cannot be processed because it would exceed the
     *         allowed number of cache nodes per customer.</li>
     *         <li>CacheSecurityGroupNotFoundException The requested cache security group name does not refer to an
     *         existing cache security group.</li>
     *         <li>CacheParameterGroupNotFoundException The requested cache parameter group name does not refer to an
     *         existing cache parameter group.</li>
     *         <li>InvalidVpcNetworkStateException The VPC network is in an invalid state.</li>
     *         <li>InvalidKmsKeyException The KMS key supplied is not valid.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.ModifyReplicationGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ModifyReplicationGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyReplicationGroupResponse> modifyReplicationGroup(
            ModifyReplicationGroupRequest modifyReplicationGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the settings for a replication group.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/scaling-redis-cluster-mode-enabled.html">
     * Scaling for Amazon ElastiCache for Redis (cluster mode enabled)</a> in the ElastiCache User Guide
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_ModifyReplicationGroupShardConfiguration.html"
     * >ModifyReplicationGroupShardConfiguration</a> in the ElastiCache API Reference
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * This operation is valid for Redis only.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyReplicationGroupRequest.Builder} avoiding the
     * need to create one manually via {@link ModifyReplicationGroupRequest#builder()}
     * </p>
     *
     * @param modifyReplicationGroupRequest
     *        A {@link Consumer} that will call methods on {@link ModifyReplicationGroupMessage.Builder} to create a
     *        request. Represents the input of a <code>ModifyReplicationGroups</code> operation.
     * @return A Java Future containing the result of the ModifyReplicationGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReplicationGroupNotFoundException The specified replication group does not exist.</li>
     *         <li>InvalidReplicationGroupStateException The requested replication group is not in the
     *         <code>available</code> state.</li>
     *         <li>InvalidUserGroupStateException The user group is not in an active state.</li>
     *         <li>UserGroupNotFoundException The user group was not found or does not exist</li>
     *         <li>InvalidCacheClusterStateException The requested cluster is not in the <code>available</code> state.</li>
     *         <li>InvalidCacheSecurityGroupStateException The current state of the cache security group does not allow
     *         deletion.</li>
     *         <li>InsufficientCacheClusterCapacityException The requested cache node type is not available in the
     *         specified Availability Zone. For more information, see <a href=
     *         "http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ErrorMessages.html#ErrorMessages.INSUFFICIENT_CACHE_CLUSTER_CAPACITY"
     *         >InsufficientCacheClusterCapacity</a> in the ElastiCache User Guide.</li>
     *         <li>CacheClusterNotFoundException The requested cluster ID does not refer to an existing cluster.</li>
     *         <li>NodeQuotaForClusterExceededException The request cannot be processed because it would exceed the
     *         allowed number of cache nodes in a single cluster.</li>
     *         <li>NodeQuotaForCustomerExceededException The request cannot be processed because it would exceed the
     *         allowed number of cache nodes per customer.</li>
     *         <li>CacheSecurityGroupNotFoundException The requested cache security group name does not refer to an
     *         existing cache security group.</li>
     *         <li>CacheParameterGroupNotFoundException The requested cache parameter group name does not refer to an
     *         existing cache parameter group.</li>
     *         <li>InvalidVpcNetworkStateException The VPC network is in an invalid state.</li>
     *         <li>InvalidKmsKeyException The KMS key supplied is not valid.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.ModifyReplicationGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ModifyReplicationGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyReplicationGroupResponse> modifyReplicationGroup(
            Consumer<ModifyReplicationGroupRequest.Builder> modifyReplicationGroupRequest) {
        return modifyReplicationGroup(ModifyReplicationGroupRequest.builder().applyMutation(modifyReplicationGroupRequest)
                .build());
    }

    /**
     * <p>
     * Modifies a replication group's shards (node groups) by allowing you to add shards, remove shards, or rebalance
     * the keyspaces among existing shards.
     * </p>
     *
     * @param modifyReplicationGroupShardConfigurationRequest
     *        Represents the input for a <code>ModifyReplicationGroupShardConfiguration</code> operation.
     * @return A Java Future containing the result of the ModifyReplicationGroupShardConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReplicationGroupNotFoundException The specified replication group does not exist.</li>
     *         <li>InvalidReplicationGroupStateException The requested replication group is not in the
     *         <code>available</code> state.</li>
     *         <li>InvalidCacheClusterStateException The requested cluster is not in the <code>available</code> state.</li>
     *         <li>InvalidVpcNetworkStateException The VPC network is in an invalid state.</li>
     *         <li>InsufficientCacheClusterCapacityException The requested cache node type is not available in the
     *         specified Availability Zone. For more information, see <a href=
     *         "http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ErrorMessages.html#ErrorMessages.INSUFFICIENT_CACHE_CLUSTER_CAPACITY"
     *         >InsufficientCacheClusterCapacity</a> in the ElastiCache User Guide.</li>
     *         <li>NodeGroupsPerReplicationGroupQuotaExceededException The request cannot be processed because it would
     *         exceed the maximum allowed number of node groups (shards) in a single replication group. The default
     *         maximum is 90</li>
     *         <li>NodeQuotaForCustomerExceededException The request cannot be processed because it would exceed the
     *         allowed number of cache nodes per customer.</li>
     *         <li>InvalidKmsKeyException The KMS key supplied is not valid.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.ModifyReplicationGroupShardConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ModifyReplicationGroupShardConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyReplicationGroupShardConfigurationResponse> modifyReplicationGroupShardConfiguration(
            ModifyReplicationGroupShardConfigurationRequest modifyReplicationGroupShardConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies a replication group's shards (node groups) by allowing you to add shards, remove shards, or rebalance
     * the keyspaces among existing shards.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ModifyReplicationGroupShardConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link ModifyReplicationGroupShardConfigurationRequest#builder()}
     * </p>
     *
     * @param modifyReplicationGroupShardConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link ModifyReplicationGroupShardConfigurationMessage.Builder} to create a request. Represents the input
     *        for a <code>ModifyReplicationGroupShardConfiguration</code> operation.
     * @return A Java Future containing the result of the ModifyReplicationGroupShardConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReplicationGroupNotFoundException The specified replication group does not exist.</li>
     *         <li>InvalidReplicationGroupStateException The requested replication group is not in the
     *         <code>available</code> state.</li>
     *         <li>InvalidCacheClusterStateException The requested cluster is not in the <code>available</code> state.</li>
     *         <li>InvalidVpcNetworkStateException The VPC network is in an invalid state.</li>
     *         <li>InsufficientCacheClusterCapacityException The requested cache node type is not available in the
     *         specified Availability Zone. For more information, see <a href=
     *         "http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ErrorMessages.html#ErrorMessages.INSUFFICIENT_CACHE_CLUSTER_CAPACITY"
     *         >InsufficientCacheClusterCapacity</a> in the ElastiCache User Guide.</li>
     *         <li>NodeGroupsPerReplicationGroupQuotaExceededException The request cannot be processed because it would
     *         exceed the maximum allowed number of node groups (shards) in a single replication group. The default
     *         maximum is 90</li>
     *         <li>NodeQuotaForCustomerExceededException The request cannot be processed because it would exceed the
     *         allowed number of cache nodes per customer.</li>
     *         <li>InvalidKmsKeyException The KMS key supplied is not valid.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.ModifyReplicationGroupShardConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ModifyReplicationGroupShardConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyReplicationGroupShardConfigurationResponse> modifyReplicationGroupShardConfiguration(
            Consumer<ModifyReplicationGroupShardConfigurationRequest.Builder> modifyReplicationGroupShardConfigurationRequest) {
        return modifyReplicationGroupShardConfiguration(ModifyReplicationGroupShardConfigurationRequest.builder()
                .applyMutation(modifyReplicationGroupShardConfigurationRequest).build());
    }

    /**
     * <p>
     * Changes user password(s) and/or access string.
     * </p>
     *
     * @param modifyUserRequest
     * @return A Java Future containing the result of the ModifyUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UserNotFoundException The user does not exist or could not be found.</li>
     *         <li>InvalidUserStateException The user is not in active state.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.ModifyUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ModifyUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ModifyUserResponse> modifyUser(ModifyUserRequest modifyUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes user password(s) and/or access string.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyUserRequest.Builder} avoiding the need to
     * create one manually via {@link ModifyUserRequest#builder()}
     * </p>
     *
     * @param modifyUserRequest
     *        A {@link Consumer} that will call methods on {@link ModifyUserMessage.Builder} to create a request.
     * @return A Java Future containing the result of the ModifyUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UserNotFoundException The user does not exist or could not be found.</li>
     *         <li>InvalidUserStateException The user is not in active state.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.ModifyUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ModifyUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ModifyUserResponse> modifyUser(Consumer<ModifyUserRequest.Builder> modifyUserRequest) {
        return modifyUser(ModifyUserRequest.builder().applyMutation(modifyUserRequest).build());
    }

    /**
     * <p>
     * Changes the list of users that belong to the user group.
     * </p>
     *
     * @param modifyUserGroupRequest
     * @return A Java Future containing the result of the ModifyUserGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UserGroupNotFoundException The user group was not found or does not exist</li>
     *         <li>UserNotFoundException The user does not exist or could not be found.</li>
     *         <li>DuplicateUserNameException A user with this username already exists.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>DefaultUserRequiredException You must add default user to a user group.</li>
     *         <li>InvalidUserGroupStateException The user group is not in an active state.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.ModifyUserGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ModifyUserGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ModifyUserGroupResponse> modifyUserGroup(ModifyUserGroupRequest modifyUserGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes the list of users that belong to the user group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyUserGroupRequest.Builder} avoiding the need
     * to create one manually via {@link ModifyUserGroupRequest#builder()}
     * </p>
     *
     * @param modifyUserGroupRequest
     *        A {@link Consumer} that will call methods on {@link ModifyUserGroupMessage.Builder} to create a request.
     * @return A Java Future containing the result of the ModifyUserGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UserGroupNotFoundException The user group was not found or does not exist</li>
     *         <li>UserNotFoundException The user does not exist or could not be found.</li>
     *         <li>DuplicateUserNameException A user with this username already exists.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>DefaultUserRequiredException You must add default user to a user group.</li>
     *         <li>InvalidUserGroupStateException The user group is not in an active state.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.ModifyUserGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ModifyUserGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ModifyUserGroupResponse> modifyUserGroup(
            Consumer<ModifyUserGroupRequest.Builder> modifyUserGroupRequest) {
        return modifyUserGroup(ModifyUserGroupRequest.builder().applyMutation(modifyUserGroupRequest).build());
    }

    /**
     * <p>
     * Allows you to purchase a reserved cache node offering. Reserved nodes are not eligible for cancellation and are
     * non-refundable. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/reserved-nodes.html">Managing Costs with
     * Reserved Nodes</a> for Redis or <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/reserved-nodes.html">Managing Costs with
     * Reserved Nodes</a> for Memcached.
     * </p>
     *
     * @param purchaseReservedCacheNodesOfferingRequest
     *        Represents the input of a <code>PurchaseReservedCacheNodesOffering</code> operation.
     * @return A Java Future containing the result of the PurchaseReservedCacheNodesOffering operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReservedCacheNodesOfferingNotFoundException The requested cache node offering does not exist.</li>
     *         <li>ReservedCacheNodeAlreadyExistsException You already have a reservation with the given identifier.</li>
     *         <li>ReservedCacheNodeQuotaExceededException The request cannot be processed because it would exceed the
     *         user's cache node quota.</li>
     *         <li>TagQuotaPerResourceExceededException The request cannot be processed because it would cause the
     *         resource to have more than the allowed number of tags. The maximum number of tags permitted on a resource
     *         is 50.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.PurchaseReservedCacheNodesOffering
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/PurchaseReservedCacheNodesOffering"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PurchaseReservedCacheNodesOfferingResponse> purchaseReservedCacheNodesOffering(
            PurchaseReservedCacheNodesOfferingRequest purchaseReservedCacheNodesOfferingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows you to purchase a reserved cache node offering. Reserved nodes are not eligible for cancellation and are
     * non-refundable. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/reserved-nodes.html">Managing Costs with
     * Reserved Nodes</a> for Redis or <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/reserved-nodes.html">Managing Costs with
     * Reserved Nodes</a> for Memcached.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PurchaseReservedCacheNodesOfferingRequest.Builder}
     * avoiding the need to create one manually via {@link PurchaseReservedCacheNodesOfferingRequest#builder()}
     * </p>
     *
     * @param purchaseReservedCacheNodesOfferingRequest
     *        A {@link Consumer} that will call methods on {@link PurchaseReservedCacheNodesOfferingMessage.Builder} to
     *        create a request. Represents the input of a <code>PurchaseReservedCacheNodesOffering</code> operation.
     * @return A Java Future containing the result of the PurchaseReservedCacheNodesOffering operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReservedCacheNodesOfferingNotFoundException The requested cache node offering does not exist.</li>
     *         <li>ReservedCacheNodeAlreadyExistsException You already have a reservation with the given identifier.</li>
     *         <li>ReservedCacheNodeQuotaExceededException The request cannot be processed because it would exceed the
     *         user's cache node quota.</li>
     *         <li>TagQuotaPerResourceExceededException The request cannot be processed because it would cause the
     *         resource to have more than the allowed number of tags. The maximum number of tags permitted on a resource
     *         is 50.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.PurchaseReservedCacheNodesOffering
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/PurchaseReservedCacheNodesOffering"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PurchaseReservedCacheNodesOfferingResponse> purchaseReservedCacheNodesOffering(
            Consumer<PurchaseReservedCacheNodesOfferingRequest.Builder> purchaseReservedCacheNodesOfferingRequest) {
        return purchaseReservedCacheNodesOffering(PurchaseReservedCacheNodesOfferingRequest.builder()
                .applyMutation(purchaseReservedCacheNodesOfferingRequest).build());
    }

    /**
     * <p>
     * Redistribute slots to ensure uniform distribution across existing shards in the cluster.
     * </p>
     *
     * @param rebalanceSlotsInGlobalReplicationGroupRequest
     * @return A Java Future containing the result of the RebalanceSlotsInGlobalReplicationGroup operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GlobalReplicationGroupNotFoundException The Global datastore does not exist</li>
     *         <li>InvalidGlobalReplicationGroupStateException The Global datastore is not available or in primary-only
     *         state.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.RebalanceSlotsInGlobalReplicationGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/RebalanceSlotsInGlobalReplicationGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RebalanceSlotsInGlobalReplicationGroupResponse> rebalanceSlotsInGlobalReplicationGroup(
            RebalanceSlotsInGlobalReplicationGroupRequest rebalanceSlotsInGlobalReplicationGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Redistribute slots to ensure uniform distribution across existing shards in the cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link RebalanceSlotsInGlobalReplicationGroupRequest.Builder} avoiding the need to create one manually via
     * {@link RebalanceSlotsInGlobalReplicationGroupRequest#builder()}
     * </p>
     *
     * @param rebalanceSlotsInGlobalReplicationGroupRequest
     *        A {@link Consumer} that will call methods on {@link RebalanceSlotsInGlobalReplicationGroupMessage.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the RebalanceSlotsInGlobalReplicationGroup operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GlobalReplicationGroupNotFoundException The Global datastore does not exist</li>
     *         <li>InvalidGlobalReplicationGroupStateException The Global datastore is not available or in primary-only
     *         state.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.RebalanceSlotsInGlobalReplicationGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/RebalanceSlotsInGlobalReplicationGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RebalanceSlotsInGlobalReplicationGroupResponse> rebalanceSlotsInGlobalReplicationGroup(
            Consumer<RebalanceSlotsInGlobalReplicationGroupRequest.Builder> rebalanceSlotsInGlobalReplicationGroupRequest) {
        return rebalanceSlotsInGlobalReplicationGroup(RebalanceSlotsInGlobalReplicationGroupRequest.builder()
                .applyMutation(rebalanceSlotsInGlobalReplicationGroupRequest).build());
    }

    /**
     * <p>
     * Reboots some, or all, of the cache nodes within a provisioned cluster. This operation applies any modified cache
     * parameter groups to the cluster. The reboot operation takes place as soon as possible, and results in a momentary
     * outage to the cluster. During the reboot, the cluster status is set to REBOOTING.
     * </p>
     * <p>
     * The reboot causes the contents of the cache (for each cache node being rebooted) to be lost.
     * </p>
     * <p>
     * When the reboot is complete, a cluster event is created.
     * </p>
     * <p>
     * Rebooting a cluster is currently supported on Memcached and Redis (cluster mode disabled) clusters. Rebooting is
     * not supported on Redis (cluster mode enabled) clusters.
     * </p>
     * <p>
     * If you make changes to parameters that require a Redis (cluster mode enabled) cluster reboot for the changes to
     * be applied, see <a
     * href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/nodes.rebooting.html">Rebooting a Cluster</a>
     * for an alternate process.
     * </p>
     *
     * @param rebootCacheClusterRequest
     *        Represents the input of a <code>RebootCacheCluster</code> operation.
     * @return A Java Future containing the result of the RebootCacheCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidCacheClusterStateException The requested cluster is not in the <code>available</code> state.</li>
     *         <li>CacheClusterNotFoundException The requested cluster ID does not refer to an existing cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.RebootCacheCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/RebootCacheCluster"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RebootCacheClusterResponse> rebootCacheCluster(RebootCacheClusterRequest rebootCacheClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Reboots some, or all, of the cache nodes within a provisioned cluster. This operation applies any modified cache
     * parameter groups to the cluster. The reboot operation takes place as soon as possible, and results in a momentary
     * outage to the cluster. During the reboot, the cluster status is set to REBOOTING.
     * </p>
     * <p>
     * The reboot causes the contents of the cache (for each cache node being rebooted) to be lost.
     * </p>
     * <p>
     * When the reboot is complete, a cluster event is created.
     * </p>
     * <p>
     * Rebooting a cluster is currently supported on Memcached and Redis (cluster mode disabled) clusters. Rebooting is
     * not supported on Redis (cluster mode enabled) clusters.
     * </p>
     * <p>
     * If you make changes to parameters that require a Redis (cluster mode enabled) cluster reboot for the changes to
     * be applied, see <a
     * href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/nodes.rebooting.html">Rebooting a Cluster</a>
     * for an alternate process.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RebootCacheClusterRequest.Builder} avoiding the
     * need to create one manually via {@link RebootCacheClusterRequest#builder()}
     * </p>
     *
     * @param rebootCacheClusterRequest
     *        A {@link Consumer} that will call methods on {@link RebootCacheClusterMessage.Builder} to create a
     *        request. Represents the input of a <code>RebootCacheCluster</code> operation.
     * @return A Java Future containing the result of the RebootCacheCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidCacheClusterStateException The requested cluster is not in the <code>available</code> state.</li>
     *         <li>CacheClusterNotFoundException The requested cluster ID does not refer to an existing cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.RebootCacheCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/RebootCacheCluster"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RebootCacheClusterResponse> rebootCacheCluster(
            Consumer<RebootCacheClusterRequest.Builder> rebootCacheClusterRequest) {
        return rebootCacheCluster(RebootCacheClusterRequest.builder().applyMutation(rebootCacheClusterRequest).build());
    }

    /**
     * <p>
     * Removes the tags identified by the <code>TagKeys</code> list from the named resource. A tag is a key-value pair
     * where the key and value are case-sensitive. You can use tags to categorize and track all your ElastiCache
     * resources, with the exception of global replication group. When you add or remove tags on replication groups,
     * those actions will be replicated to all nodes in the replication group. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/IAM.ResourceLevelPermissions.html"
     * >Resource-level permissions</a>.
     * </p>
     *
     * @param removeTagsFromResourceRequest
     *        Represents the input of a <code>RemoveTagsFromResource</code> operation.
     * @return A Java Future containing the result of the RemoveTagsFromResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheClusterNotFoundException The requested cluster ID does not refer to an existing cluster.</li>
     *         <li>CacheParameterGroupNotFoundException The requested cache parameter group name does not refer to an
     *         existing cache parameter group.</li>
     *         <li>CacheSecurityGroupNotFoundException The requested cache security group name does not refer to an
     *         existing cache security group.</li>
     *         <li>CacheSubnetGroupNotFoundException The requested cache subnet group name does not refer to an existing
     *         cache subnet group.</li>
     *         <li>InvalidReplicationGroupStateException The requested replication group is not in the
     *         <code>available</code> state.</li>
     *         <li>ReplicationGroupNotFoundException The specified replication group does not exist.</li>
     *         <li>ReservedCacheNodeNotFoundException The requested reserved cache node was not found.</li>
     *         <li>SnapshotNotFoundException The requested snapshot name does not refer to an existing snapshot.</li>
     *         <li>UserNotFoundException The user does not exist or could not be found.</li>
     *         <li>UserGroupNotFoundException The user group was not found or does not exist</li>
     *         <li>InvalidArnException The requested Amazon Resource Name (ARN) does not refer to an existing resource.</li>
     *         <li>TagNotFoundException The requested tag was not found on this resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.RemoveTagsFromResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/RemoveTagsFromResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveTagsFromResourceResponse> removeTagsFromResource(
            RemoveTagsFromResourceRequest removeTagsFromResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the tags identified by the <code>TagKeys</code> list from the named resource. A tag is a key-value pair
     * where the key and value are case-sensitive. You can use tags to categorize and track all your ElastiCache
     * resources, with the exception of global replication group. When you add or remove tags on replication groups,
     * those actions will be replicated to all nodes in the replication group. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/IAM.ResourceLevelPermissions.html"
     * >Resource-level permissions</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveTagsFromResourceRequest.Builder} avoiding the
     * need to create one manually via {@link RemoveTagsFromResourceRequest#builder()}
     * </p>
     *
     * @param removeTagsFromResourceRequest
     *        A {@link Consumer} that will call methods on {@link RemoveTagsFromResourceMessage.Builder} to create a
     *        request. Represents the input of a <code>RemoveTagsFromResource</code> operation.
     * @return A Java Future containing the result of the RemoveTagsFromResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheClusterNotFoundException The requested cluster ID does not refer to an existing cluster.</li>
     *         <li>CacheParameterGroupNotFoundException The requested cache parameter group name does not refer to an
     *         existing cache parameter group.</li>
     *         <li>CacheSecurityGroupNotFoundException The requested cache security group name does not refer to an
     *         existing cache security group.</li>
     *         <li>CacheSubnetGroupNotFoundException The requested cache subnet group name does not refer to an existing
     *         cache subnet group.</li>
     *         <li>InvalidReplicationGroupStateException The requested replication group is not in the
     *         <code>available</code> state.</li>
     *         <li>ReplicationGroupNotFoundException The specified replication group does not exist.</li>
     *         <li>ReservedCacheNodeNotFoundException The requested reserved cache node was not found.</li>
     *         <li>SnapshotNotFoundException The requested snapshot name does not refer to an existing snapshot.</li>
     *         <li>UserNotFoundException The user does not exist or could not be found.</li>
     *         <li>UserGroupNotFoundException The user group was not found or does not exist</li>
     *         <li>InvalidArnException The requested Amazon Resource Name (ARN) does not refer to an existing resource.</li>
     *         <li>TagNotFoundException The requested tag was not found on this resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.RemoveTagsFromResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/RemoveTagsFromResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveTagsFromResourceResponse> removeTagsFromResource(
            Consumer<RemoveTagsFromResourceRequest.Builder> removeTagsFromResourceRequest) {
        return removeTagsFromResource(RemoveTagsFromResourceRequest.builder().applyMutation(removeTagsFromResourceRequest)
                .build());
    }

    /**
     * <p>
     * Modifies the parameters of a cache parameter group to the engine or system default value. You can reset specific
     * parameters by submitting a list of parameter names. To reset the entire cache parameter group, specify the
     * <code>ResetAllParameters</code> and <code>CacheParameterGroupName</code> parameters.
     * </p>
     *
     * @param resetCacheParameterGroupRequest
     *        Represents the input of a <code>ResetCacheParameterGroup</code> operation.
     * @return A Java Future containing the result of the ResetCacheParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidCacheParameterGroupStateException The current state of the cache parameter group does not
     *         allow the requested operation to occur.</li>
     *         <li>CacheParameterGroupNotFoundException The requested cache parameter group name does not refer to an
     *         existing cache parameter group.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>InvalidGlobalReplicationGroupStateException The Global datastore is not available or in primary-only
     *         state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.ResetCacheParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ResetCacheParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ResetCacheParameterGroupResponse> resetCacheParameterGroup(
            ResetCacheParameterGroupRequest resetCacheParameterGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the parameters of a cache parameter group to the engine or system default value. You can reset specific
     * parameters by submitting a list of parameter names. To reset the entire cache parameter group, specify the
     * <code>ResetAllParameters</code> and <code>CacheParameterGroupName</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResetCacheParameterGroupRequest.Builder} avoiding
     * the need to create one manually via {@link ResetCacheParameterGroupRequest#builder()}
     * </p>
     *
     * @param resetCacheParameterGroupRequest
     *        A {@link Consumer} that will call methods on {@link ResetCacheParameterGroupMessage.Builder} to create a
     *        request. Represents the input of a <code>ResetCacheParameterGroup</code> operation.
     * @return A Java Future containing the result of the ResetCacheParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidCacheParameterGroupStateException The current state of the cache parameter group does not
     *         allow the requested operation to occur.</li>
     *         <li>CacheParameterGroupNotFoundException The requested cache parameter group name does not refer to an
     *         existing cache parameter group.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>InvalidGlobalReplicationGroupStateException The Global datastore is not available or in primary-only
     *         state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.ResetCacheParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ResetCacheParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ResetCacheParameterGroupResponse> resetCacheParameterGroup(
            Consumer<ResetCacheParameterGroupRequest.Builder> resetCacheParameterGroupRequest) {
        return resetCacheParameterGroup(ResetCacheParameterGroupRequest.builder().applyMutation(resetCacheParameterGroupRequest)
                .build());
    }

    /**
     * <p>
     * Revokes ingress from a cache security group. Use this operation to disallow access from an Amazon EC2 security
     * group that had been previously authorized.
     * </p>
     *
     * @param revokeCacheSecurityGroupIngressRequest
     *        Represents the input of a <code>RevokeCacheSecurityGroupIngress</code> operation.
     * @return A Java Future containing the result of the RevokeCacheSecurityGroupIngress operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheSecurityGroupNotFoundException The requested cache security group name does not refer to an
     *         existing cache security group.</li>
     *         <li>AuthorizationNotFoundException The specified Amazon EC2 security group is not authorized for the
     *         specified cache security group.</li>
     *         <li>InvalidCacheSecurityGroupStateException The current state of the cache security group does not allow
     *         deletion.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.RevokeCacheSecurityGroupIngress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/RevokeCacheSecurityGroupIngress"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RevokeCacheSecurityGroupIngressResponse> revokeCacheSecurityGroupIngress(
            RevokeCacheSecurityGroupIngressRequest revokeCacheSecurityGroupIngressRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Revokes ingress from a cache security group. Use this operation to disallow access from an Amazon EC2 security
     * group that had been previously authorized.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RevokeCacheSecurityGroupIngressRequest.Builder}
     * avoiding the need to create one manually via {@link RevokeCacheSecurityGroupIngressRequest#builder()}
     * </p>
     *
     * @param revokeCacheSecurityGroupIngressRequest
     *        A {@link Consumer} that will call methods on {@link RevokeCacheSecurityGroupIngressMessage.Builder} to
     *        create a request. Represents the input of a <code>RevokeCacheSecurityGroupIngress</code> operation.
     * @return A Java Future containing the result of the RevokeCacheSecurityGroupIngress operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheSecurityGroupNotFoundException The requested cache security group name does not refer to an
     *         existing cache security group.</li>
     *         <li>AuthorizationNotFoundException The specified Amazon EC2 security group is not authorized for the
     *         specified cache security group.</li>
     *         <li>InvalidCacheSecurityGroupStateException The current state of the cache security group does not allow
     *         deletion.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.RevokeCacheSecurityGroupIngress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/RevokeCacheSecurityGroupIngress"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RevokeCacheSecurityGroupIngressResponse> revokeCacheSecurityGroupIngress(
            Consumer<RevokeCacheSecurityGroupIngressRequest.Builder> revokeCacheSecurityGroupIngressRequest) {
        return revokeCacheSecurityGroupIngress(RevokeCacheSecurityGroupIngressRequest.builder()
                .applyMutation(revokeCacheSecurityGroupIngressRequest).build());
    }

    /**
     * <p>
     * Start the migration of data.
     * </p>
     *
     * @param startMigrationRequest
     * @return A Java Future containing the result of the StartMigration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReplicationGroupNotFoundException The specified replication group does not exist.</li>
     *         <li>InvalidReplicationGroupStateException The requested replication group is not in the
     *         <code>available</code> state.</li>
     *         <li>ReplicationGroupAlreadyUnderMigrationException The targeted replication group is not available.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.StartMigration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/StartMigration" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartMigrationResponse> startMigration(StartMigrationRequest startMigrationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Start the migration of data.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartMigrationRequest.Builder} avoiding the need to
     * create one manually via {@link StartMigrationRequest#builder()}
     * </p>
     *
     * @param startMigrationRequest
     *        A {@link Consumer} that will call methods on {@link StartMigrationMessage.Builder} to create a request.
     * @return A Java Future containing the result of the StartMigration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReplicationGroupNotFoundException The specified replication group does not exist.</li>
     *         <li>InvalidReplicationGroupStateException The requested replication group is not in the
     *         <code>available</code> state.</li>
     *         <li>ReplicationGroupAlreadyUnderMigrationException The targeted replication group is not available.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.StartMigration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/StartMigration" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartMigrationResponse> startMigration(Consumer<StartMigrationRequest.Builder> startMigrationRequest) {
        return startMigration(StartMigrationRequest.builder().applyMutation(startMigrationRequest).build());
    }

    /**
     * <p>
     * Represents the input of a <code>TestFailover</code> operation which test automatic failover on a specified node
     * group (called shard in the console) in a replication group (called cluster in the console).
     * </p>
     * <p>
     * This API is designed for testing the behavior of your application in case of ElastiCache failover. It is not
     * designed to be an operational tool for initiating a failover to overcome a problem you may have with the cluster.
     * Moreover, in certain conditions such as large-scale operational events, Amazon may block this API.
     * </p>
     * <p class="title">
     * <b>Note the following</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * A customer can use this operation to test automatic failover on up to 5 shards (called node groups in the
     * ElastiCache API and Amazon CLI) in any rolling 24-hour period.
     * </p>
     * </li>
     * <li>
     * <p>
     * If calling this operation on shards in different clusters (called replication groups in the API and CLI), the
     * calls can be made concurrently.
     * </p>
     * <p>
     * </p></li>
     * <li>
     * <p>
     * If calling this operation multiple times on different shards in the same Redis (cluster mode enabled) replication
     * group, the first node replacement must complete before a subsequent call can be made.
     * </p>
     * </li>
     * <li>
     * <p>
     * To determine whether the node replacement is complete you can check Events using the Amazon ElastiCache console,
     * the Amazon CLI, or the ElastiCache API. Look for the following automatic failover related events, listed here in
     * order of occurrance:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Replication group message: <code>Test Failover API called for node group &lt;node-group-id&gt;</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Cache cluster message:
     * <code>Failover from primary node &lt;primary-node-id&gt; to replica node &lt;node-id&gt; completed</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Replication group message:
     * <code>Failover from primary node &lt;primary-node-id&gt; to replica node &lt;node-id&gt; completed</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Cache cluster message: <code>Recovering cache nodes &lt;node-id&gt;</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Cache cluster message: <code>Finished recovery for cache nodes &lt;node-id&gt;</code>
     * </p>
     * </li>
     * </ol>
     * <p>
     * For more information see:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ECEvents.Viewing.html">Viewing ElastiCache
     * Events</a> in the <i>ElastiCache User Guide</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_DescribeEvents.html">DescribeEvents
     * </a> in the ElastiCache API Reference
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * Also see, <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html#auto-failover-test">Testing
     * Multi-AZ </a> in the <i>ElastiCache User Guide</i>.
     * </p>
     *
     * @param testFailoverRequest
     * @return A Java Future containing the result of the TestFailover operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApiCallRateForCustomerExceededException The customer has exceeded the allowed rate of API calls.</li>
     *         <li>InvalidCacheClusterStateException The requested cluster is not in the <code>available</code> state.</li>
     *         <li>InvalidReplicationGroupStateException The requested replication group is not in the
     *         <code>available</code> state.</li>
     *         <li>NodeGroupNotFoundException The node group specified by the <code>NodeGroupId</code> parameter could
     *         not be found. Please verify that the node group exists and that you spelled the <code>NodeGroupId</code>
     *         value correctly.</li>
     *         <li>ReplicationGroupNotFoundException The specified replication group does not exist.</li>
     *         <li>TestFailoverNotAvailableException The <code>TestFailover</code> action is not available.</li>
     *         <li>InvalidKmsKeyException The KMS key supplied is not valid.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.TestFailover
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/TestFailover" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TestFailoverResponse> testFailover(TestFailoverRequest testFailoverRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Represents the input of a <code>TestFailover</code> operation which test automatic failover on a specified node
     * group (called shard in the console) in a replication group (called cluster in the console).
     * </p>
     * <p>
     * This API is designed for testing the behavior of your application in case of ElastiCache failover. It is not
     * designed to be an operational tool for initiating a failover to overcome a problem you may have with the cluster.
     * Moreover, in certain conditions such as large-scale operational events, Amazon may block this API.
     * </p>
     * <p class="title">
     * <b>Note the following</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * A customer can use this operation to test automatic failover on up to 5 shards (called node groups in the
     * ElastiCache API and Amazon CLI) in any rolling 24-hour period.
     * </p>
     * </li>
     * <li>
     * <p>
     * If calling this operation on shards in different clusters (called replication groups in the API and CLI), the
     * calls can be made concurrently.
     * </p>
     * <p>
     * </p></li>
     * <li>
     * <p>
     * If calling this operation multiple times on different shards in the same Redis (cluster mode enabled) replication
     * group, the first node replacement must complete before a subsequent call can be made.
     * </p>
     * </li>
     * <li>
     * <p>
     * To determine whether the node replacement is complete you can check Events using the Amazon ElastiCache console,
     * the Amazon CLI, or the ElastiCache API. Look for the following automatic failover related events, listed here in
     * order of occurrance:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Replication group message: <code>Test Failover API called for node group &lt;node-group-id&gt;</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Cache cluster message:
     * <code>Failover from primary node &lt;primary-node-id&gt; to replica node &lt;node-id&gt; completed</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Replication group message:
     * <code>Failover from primary node &lt;primary-node-id&gt; to replica node &lt;node-id&gt; completed</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Cache cluster message: <code>Recovering cache nodes &lt;node-id&gt;</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Cache cluster message: <code>Finished recovery for cache nodes &lt;node-id&gt;</code>
     * </p>
     * </li>
     * </ol>
     * <p>
     * For more information see:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ECEvents.Viewing.html">Viewing ElastiCache
     * Events</a> in the <i>ElastiCache User Guide</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_DescribeEvents.html">DescribeEvents
     * </a> in the ElastiCache API Reference
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * Also see, <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html#auto-failover-test">Testing
     * Multi-AZ </a> in the <i>ElastiCache User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TestFailoverRequest.Builder} avoiding the need to
     * create one manually via {@link TestFailoverRequest#builder()}
     * </p>
     *
     * @param testFailoverRequest
     *        A {@link Consumer} that will call methods on {@link TestFailoverMessage.Builder} to create a request.
     * @return A Java Future containing the result of the TestFailover operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApiCallRateForCustomerExceededException The customer has exceeded the allowed rate of API calls.</li>
     *         <li>InvalidCacheClusterStateException The requested cluster is not in the <code>available</code> state.</li>
     *         <li>InvalidReplicationGroupStateException The requested replication group is not in the
     *         <code>available</code> state.</li>
     *         <li>NodeGroupNotFoundException The node group specified by the <code>NodeGroupId</code> parameter could
     *         not be found. Please verify that the node group exists and that you spelled the <code>NodeGroupId</code>
     *         value correctly.</li>
     *         <li>ReplicationGroupNotFoundException The specified replication group does not exist.</li>
     *         <li>TestFailoverNotAvailableException The <code>TestFailover</code> action is not available.</li>
     *         <li>InvalidKmsKeyException The KMS key supplied is not valid.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.TestFailover
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/TestFailover" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TestFailoverResponse> testFailover(Consumer<TestFailoverRequest.Builder> testFailoverRequest) {
        return testFailover(TestFailoverRequest.builder().applyMutation(testFailoverRequest).build());
    }

    /**
     * Create an instance of {@link ElastiCacheAsyncWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link ElastiCacheAsyncWaiter}
     */
    default ElastiCacheAsyncWaiter waiter() {
        throw new UnsupportedOperationException();
    }

    @Override
    default ElastiCacheServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link ElastiCacheAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ElastiCacheAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ElastiCacheAsyncClient}.
     */
    static ElastiCacheAsyncClientBuilder builder() {
        return new DefaultElastiCacheAsyncClientBuilder();
    }
}
