/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecs.model.ContainerInstanceStatus;
import software.amazon.awssdk.services.ecs.model.EcsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListContainerInstancesRequest
extends EcsRequest
implements ToCopyableBuilder<Builder, ListContainerInstancesRequest> {
    private static final SdkField<String> CLUSTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cluster").getter(ListContainerInstancesRequest.getter(ListContainerInstancesRequest::cluster)).setter(ListContainerInstancesRequest.setter(Builder::cluster)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()}).build();
    private static final SdkField<String> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("filter").getter(ListContainerInstancesRequest.getter(ListContainerInstancesRequest::filter)).setter(ListContainerInstancesRequest.setter(Builder::filter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListContainerInstancesRequest.getter(ListContainerInstancesRequest::nextToken)).setter(ListContainerInstancesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListContainerInstancesRequest.getter(ListContainerInstancesRequest::maxResults)).setter(ListContainerInstancesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ListContainerInstancesRequest.getter(ListContainerInstancesRequest::statusAsString)).setter(ListContainerInstancesRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_FIELD, FILTER_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, STATUS_FIELD));
    private final String cluster;
    private final String filter;
    private final String nextToken;
    private final Integer maxResults;
    private final String status;

    private ListContainerInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.cluster = builder.cluster;
        this.filter = builder.filter;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.status = builder.status;
    }

    public final String cluster() {
        return this.cluster;
    }

    public final String filter() {
        return this.filter;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final ContainerInstanceStatus status() {
        return ContainerInstanceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cluster());
        hashCode = 31 * hashCode + Objects.hashCode(this.filter());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListContainerInstancesRequest)) {
            return false;
        }
        ListContainerInstancesRequest other = (ListContainerInstancesRequest)((Object)obj);
        return Objects.equals(this.cluster(), other.cluster()) && Objects.equals(this.filter(), other.filter()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListContainerInstancesRequest").add("Cluster", (Object)this.cluster()).add("Filter", (Object)this.filter()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cluster": {
                return Optional.ofNullable(clazz.cast(this.cluster()));
            }
            case "filter": {
                return Optional.ofNullable(clazz.cast(this.filter()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListContainerInstancesRequest, T> g) {
        return obj -> g.apply((ListContainerInstancesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcsRequest.BuilderImpl
    implements Builder {
        private String cluster;
        private String filter;
        private String nextToken;
        private Integer maxResults;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ListContainerInstancesRequest model) {
            super(model);
            this.cluster(model.cluster);
            this.filter(model.filter);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.status(model.status);
        }

        public final String getCluster() {
            return this.cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        public final String getFilter() {
            return this.filter;
        }

        @Override
        public final Builder filter(String filter) {
            this.filter = filter;
            return this;
        }

        public final void setFilter(String filter) {
            this.filter = filter;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ContainerInstanceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListContainerInstancesRequest build() {
            return new ListContainerInstancesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EcsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListContainerInstancesRequest> {
        public Builder cluster(String var1);

        public Builder filter(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder status(String var1);

        public Builder status(ContainerInstanceStatus var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

