/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum FirelensConfigurationType {
    FLUENTD("fluentd"),
    FLUENTBIT("fluentbit"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private FirelensConfigurationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FirelensConfigurationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(FirelensConfigurationType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FirelensConfigurationType> knownValues() {
        return Stream.of(FirelensConfigurationType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

