/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecr.model.ImageScanFindingsSummary;
import software.amazon.awssdk.services.ecr.model.ImageScanStatus;
import software.amazon.awssdk.services.ecr.model.ImageTagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImageDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImageDetail> {
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("registryId").getter(ImageDetail.getter(ImageDetail::registryId)).setter(ImageDetail.setter(Builder::registryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()}).build();
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryName").getter(ImageDetail.getter(ImageDetail::repositoryName)).setter(ImageDetail.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()}).build();
    private static final SdkField<String> IMAGE_DIGEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageDigest").getter(ImageDetail.getter(ImageDetail::imageDigest)).setter(ImageDetail.setter(Builder::imageDigest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageDigest").build()}).build();
    private static final SdkField<List<String>> IMAGE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("imageTags").getter(ImageDetail.getter(ImageDetail::imageTags)).setter(ImageDetail.setter(Builder::imageTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> IMAGE_SIZE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("imageSizeInBytes").getter(ImageDetail.getter(ImageDetail::imageSizeInBytes)).setter(ImageDetail.setter(Builder::imageSizeInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageSizeInBytes").build()}).build();
    private static final SdkField<Instant> IMAGE_PUSHED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("imagePushedAt").getter(ImageDetail.getter(ImageDetail::imagePushedAt)).setter(ImageDetail.setter(Builder::imagePushedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imagePushedAt").build()}).build();
    private static final SdkField<ImageScanStatus> IMAGE_SCAN_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("imageScanStatus").getter(ImageDetail.getter(ImageDetail::imageScanStatus)).setter(ImageDetail.setter(Builder::imageScanStatus)).constructor(ImageScanStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageScanStatus").build()}).build();
    private static final SdkField<ImageScanFindingsSummary> IMAGE_SCAN_FINDINGS_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("imageScanFindingsSummary").getter(ImageDetail.getter(ImageDetail::imageScanFindingsSummary)).setter(ImageDetail.setter(Builder::imageScanFindingsSummary)).constructor(ImageScanFindingsSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageScanFindingsSummary").build()}).build();
    private static final SdkField<String> IMAGE_MANIFEST_MEDIA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageManifestMediaType").getter(ImageDetail.getter(ImageDetail::imageManifestMediaType)).setter(ImageDetail.setter(Builder::imageManifestMediaType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageManifestMediaType").build()}).build();
    private static final SdkField<String> ARTIFACT_MEDIA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("artifactMediaType").getter(ImageDetail.getter(ImageDetail::artifactMediaType)).setter(ImageDetail.setter(Builder::artifactMediaType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("artifactMediaType").build()}).build();
    private static final SdkField<Instant> LAST_RECORDED_PULL_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastRecordedPullTime").getter(ImageDetail.getter(ImageDetail::lastRecordedPullTime)).setter(ImageDetail.setter(Builder::lastRecordedPullTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastRecordedPullTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD, REPOSITORY_NAME_FIELD, IMAGE_DIGEST_FIELD, IMAGE_TAGS_FIELD, IMAGE_SIZE_IN_BYTES_FIELD, IMAGE_PUSHED_AT_FIELD, IMAGE_SCAN_STATUS_FIELD, IMAGE_SCAN_FINDINGS_SUMMARY_FIELD, IMAGE_MANIFEST_MEDIA_TYPE_FIELD, ARTIFACT_MEDIA_TYPE_FIELD, LAST_RECORDED_PULL_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String registryId;
    private final String repositoryName;
    private final String imageDigest;
    private final List<String> imageTags;
    private final Long imageSizeInBytes;
    private final Instant imagePushedAt;
    private final ImageScanStatus imageScanStatus;
    private final ImageScanFindingsSummary imageScanFindingsSummary;
    private final String imageManifestMediaType;
    private final String artifactMediaType;
    private final Instant lastRecordedPullTime;

    private ImageDetail(BuilderImpl builder) {
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.imageDigest = builder.imageDigest;
        this.imageTags = builder.imageTags;
        this.imageSizeInBytes = builder.imageSizeInBytes;
        this.imagePushedAt = builder.imagePushedAt;
        this.imageScanStatus = builder.imageScanStatus;
        this.imageScanFindingsSummary = builder.imageScanFindingsSummary;
        this.imageManifestMediaType = builder.imageManifestMediaType;
        this.artifactMediaType = builder.artifactMediaType;
        this.lastRecordedPullTime = builder.lastRecordedPullTime;
    }

    public final String registryId() {
        return this.registryId;
    }

    public final String repositoryName() {
        return this.repositoryName;
    }

    public final String imageDigest() {
        return this.imageDigest;
    }

    public final boolean hasImageTags() {
        return this.imageTags != null && !(this.imageTags instanceof SdkAutoConstructList);
    }

    public final List<String> imageTags() {
        return this.imageTags;
    }

    public final Long imageSizeInBytes() {
        return this.imageSizeInBytes;
    }

    public final Instant imagePushedAt() {
        return this.imagePushedAt;
    }

    public final ImageScanStatus imageScanStatus() {
        return this.imageScanStatus;
    }

    public final ImageScanFindingsSummary imageScanFindingsSummary() {
        return this.imageScanFindingsSummary;
    }

    public final String imageManifestMediaType() {
        return this.imageManifestMediaType;
    }

    public final String artifactMediaType() {
        return this.artifactMediaType;
    }

    public final Instant lastRecordedPullTime() {
        return this.lastRecordedPullTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.registryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageDigest());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImageTags() ? this.imageTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.imageSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.imagePushedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageScanStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageScanFindingsSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageManifestMediaType());
        hashCode = 31 * hashCode + Objects.hashCode(this.artifactMediaType());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastRecordedPullTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageDetail)) {
            return false;
        }
        ImageDetail other = (ImageDetail)obj;
        return Objects.equals(this.registryId(), other.registryId()) && Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.imageDigest(), other.imageDigest()) && this.hasImageTags() == other.hasImageTags() && Objects.equals(this.imageTags(), other.imageTags()) && Objects.equals(this.imageSizeInBytes(), other.imageSizeInBytes()) && Objects.equals(this.imagePushedAt(), other.imagePushedAt()) && Objects.equals(this.imageScanStatus(), other.imageScanStatus()) && Objects.equals(this.imageScanFindingsSummary(), other.imageScanFindingsSummary()) && Objects.equals(this.imageManifestMediaType(), other.imageManifestMediaType()) && Objects.equals(this.artifactMediaType(), other.artifactMediaType()) && Objects.equals(this.lastRecordedPullTime(), other.lastRecordedPullTime());
    }

    public final String toString() {
        return ToString.builder((String)"ImageDetail").add("RegistryId", (Object)this.registryId()).add("RepositoryName", (Object)this.repositoryName()).add("ImageDigest", (Object)this.imageDigest()).add("ImageTags", this.hasImageTags() ? this.imageTags() : null).add("ImageSizeInBytes", (Object)this.imageSizeInBytes()).add("ImagePushedAt", (Object)this.imagePushedAt()).add("ImageScanStatus", (Object)this.imageScanStatus()).add("ImageScanFindingsSummary", (Object)this.imageScanFindingsSummary()).add("ImageManifestMediaType", (Object)this.imageManifestMediaType()).add("ArtifactMediaType", (Object)this.artifactMediaType()).add("LastRecordedPullTime", (Object)this.lastRecordedPullTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "registryId": {
                return Optional.ofNullable(clazz.cast(this.registryId()));
            }
            case "repositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
            case "imageDigest": {
                return Optional.ofNullable(clazz.cast(this.imageDigest()));
            }
            case "imageTags": {
                return Optional.ofNullable(clazz.cast(this.imageTags()));
            }
            case "imageSizeInBytes": {
                return Optional.ofNullable(clazz.cast(this.imageSizeInBytes()));
            }
            case "imagePushedAt": {
                return Optional.ofNullable(clazz.cast(this.imagePushedAt()));
            }
            case "imageScanStatus": {
                return Optional.ofNullable(clazz.cast(this.imageScanStatus()));
            }
            case "imageScanFindingsSummary": {
                return Optional.ofNullable(clazz.cast(this.imageScanFindingsSummary()));
            }
            case "imageManifestMediaType": {
                return Optional.ofNullable(clazz.cast(this.imageManifestMediaType()));
            }
            case "artifactMediaType": {
                return Optional.ofNullable(clazz.cast(this.artifactMediaType()));
            }
            case "lastRecordedPullTime": {
                return Optional.ofNullable(clazz.cast(this.lastRecordedPullTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImageDetail, T> g) {
        return obj -> g.apply((ImageDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String registryId;
        private String repositoryName;
        private String imageDigest;
        private List<String> imageTags = DefaultSdkAutoConstructList.getInstance();
        private Long imageSizeInBytes;
        private Instant imagePushedAt;
        private ImageScanStatus imageScanStatus;
        private ImageScanFindingsSummary imageScanFindingsSummary;
        private String imageManifestMediaType;
        private String artifactMediaType;
        private Instant lastRecordedPullTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageDetail model) {
            this.registryId(model.registryId);
            this.repositoryName(model.repositoryName);
            this.imageDigest(model.imageDigest);
            this.imageTags(model.imageTags);
            this.imageSizeInBytes(model.imageSizeInBytes);
            this.imagePushedAt(model.imagePushedAt);
            this.imageScanStatus(model.imageScanStatus);
            this.imageScanFindingsSummary(model.imageScanFindingsSummary);
            this.imageManifestMediaType(model.imageManifestMediaType);
            this.artifactMediaType(model.artifactMediaType);
            this.lastRecordedPullTime(model.lastRecordedPullTime);
        }

        public final String getRegistryId() {
            return this.registryId;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getImageDigest() {
            return this.imageDigest;
        }

        public final void setImageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
        }

        @Override
        public final Builder imageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
            return this;
        }

        public final Collection<String> getImageTags() {
            if (this.imageTags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.imageTags;
        }

        public final void setImageTags(Collection<String> imageTags) {
            this.imageTags = ImageTagListCopier.copy(imageTags);
        }

        @Override
        public final Builder imageTags(Collection<String> imageTags) {
            this.imageTags = ImageTagListCopier.copy(imageTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageTags(String ... imageTags) {
            this.imageTags(Arrays.asList(imageTags));
            return this;
        }

        public final Long getImageSizeInBytes() {
            return this.imageSizeInBytes;
        }

        public final void setImageSizeInBytes(Long imageSizeInBytes) {
            this.imageSizeInBytes = imageSizeInBytes;
        }

        @Override
        public final Builder imageSizeInBytes(Long imageSizeInBytes) {
            this.imageSizeInBytes = imageSizeInBytes;
            return this;
        }

        public final Instant getImagePushedAt() {
            return this.imagePushedAt;
        }

        public final void setImagePushedAt(Instant imagePushedAt) {
            this.imagePushedAt = imagePushedAt;
        }

        @Override
        public final Builder imagePushedAt(Instant imagePushedAt) {
            this.imagePushedAt = imagePushedAt;
            return this;
        }

        public final ImageScanStatus.Builder getImageScanStatus() {
            return this.imageScanStatus != null ? this.imageScanStatus.toBuilder() : null;
        }

        public final void setImageScanStatus(ImageScanStatus.BuilderImpl imageScanStatus) {
            this.imageScanStatus = imageScanStatus != null ? imageScanStatus.build() : null;
        }

        @Override
        public final Builder imageScanStatus(ImageScanStatus imageScanStatus) {
            this.imageScanStatus = imageScanStatus;
            return this;
        }

        public final ImageScanFindingsSummary.Builder getImageScanFindingsSummary() {
            return this.imageScanFindingsSummary != null ? this.imageScanFindingsSummary.toBuilder() : null;
        }

        public final void setImageScanFindingsSummary(ImageScanFindingsSummary.BuilderImpl imageScanFindingsSummary) {
            this.imageScanFindingsSummary = imageScanFindingsSummary != null ? imageScanFindingsSummary.build() : null;
        }

        @Override
        public final Builder imageScanFindingsSummary(ImageScanFindingsSummary imageScanFindingsSummary) {
            this.imageScanFindingsSummary = imageScanFindingsSummary;
            return this;
        }

        public final String getImageManifestMediaType() {
            return this.imageManifestMediaType;
        }

        public final void setImageManifestMediaType(String imageManifestMediaType) {
            this.imageManifestMediaType = imageManifestMediaType;
        }

        @Override
        public final Builder imageManifestMediaType(String imageManifestMediaType) {
            this.imageManifestMediaType = imageManifestMediaType;
            return this;
        }

        public final String getArtifactMediaType() {
            return this.artifactMediaType;
        }

        public final void setArtifactMediaType(String artifactMediaType) {
            this.artifactMediaType = artifactMediaType;
        }

        @Override
        public final Builder artifactMediaType(String artifactMediaType) {
            this.artifactMediaType = artifactMediaType;
            return this;
        }

        public final Instant getLastRecordedPullTime() {
            return this.lastRecordedPullTime;
        }

        public final void setLastRecordedPullTime(Instant lastRecordedPullTime) {
            this.lastRecordedPullTime = lastRecordedPullTime;
        }

        @Override
        public final Builder lastRecordedPullTime(Instant lastRecordedPullTime) {
            this.lastRecordedPullTime = lastRecordedPullTime;
            return this;
        }

        public ImageDetail build() {
            return new ImageDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImageDetail> {
        public Builder registryId(String var1);

        public Builder repositoryName(String var1);

        public Builder imageDigest(String var1);

        public Builder imageTags(Collection<String> var1);

        public Builder imageTags(String ... var1);

        public Builder imageSizeInBytes(Long var1);

        public Builder imagePushedAt(Instant var1);

        public Builder imageScanStatus(ImageScanStatus var1);

        default public Builder imageScanStatus(Consumer<ImageScanStatus.Builder> imageScanStatus) {
            return this.imageScanStatus((ImageScanStatus)((ImageScanStatus.Builder)ImageScanStatus.builder().applyMutation(imageScanStatus)).build());
        }

        public Builder imageScanFindingsSummary(ImageScanFindingsSummary var1);

        default public Builder imageScanFindingsSummary(Consumer<ImageScanFindingsSummary.Builder> imageScanFindingsSummary) {
            return this.imageScanFindingsSummary((ImageScanFindingsSummary)((ImageScanFindingsSummary.Builder)ImageScanFindingsSummary.builder().applyMutation(imageScanFindingsSummary)).build());
        }

        public Builder imageManifestMediaType(String var1);

        public Builder artifactMediaType(String var1);

        public Builder lastRecordedPullTime(Instant var1);
    }
}

