/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.streams;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dynamodb.streams.DefaultDynamoDbStreamsAsyncClient;
import software.amazon.awssdk.services.dynamodb.streams.DefaultDynamoDbStreamsBaseClientBuilder;
import software.amazon.awssdk.services.dynamodb.streams.DynamoDbStreamsAsyncClient;
import software.amazon.awssdk.services.dynamodb.streams.DynamoDbStreamsAsyncClientBuilder;
import software.amazon.awssdk.services.dynamodb.streams.DynamoDbStreamsServiceClientConfiguration;
import software.amazon.awssdk.services.dynamodb.streams.endpoints.DynamoDbStreamsEndpointProvider;

@SdkInternalApi
final class DefaultDynamoDbStreamsAsyncClientBuilder
extends DefaultDynamoDbStreamsBaseClientBuilder<DynamoDbStreamsAsyncClientBuilder, DynamoDbStreamsAsyncClient>
implements DynamoDbStreamsAsyncClientBuilder {
    DefaultDynamoDbStreamsAsyncClientBuilder() {
    }

    @Override
    public DefaultDynamoDbStreamsAsyncClientBuilder endpointProvider(DynamoDbStreamsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final DynamoDbStreamsAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultDynamoDbStreamsAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        DynamoDbStreamsServiceClientConfiguration serviceClientConfiguration = DynamoDbStreamsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultDynamoDbStreamsAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

