/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dynamodb.model.CreateReplicaAction;
import software.amazon.awssdk.services.dynamodb.model.DeleteReplicaAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplicaUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReplicaUpdate> {
    private static final SdkField<CreateReplicaAction> CREATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Create").getter(ReplicaUpdate.getter(ReplicaUpdate::create)).setter(ReplicaUpdate.setter(Builder::create)).constructor(CreateReplicaAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Create").build()}).build();
    private static final SdkField<DeleteReplicaAction> DELETE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Delete").getter(ReplicaUpdate.getter(ReplicaUpdate::delete)).setter(ReplicaUpdate.setter(Builder::delete)).constructor(DeleteReplicaAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Delete").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_FIELD, DELETE_FIELD));
    private static final long serialVersionUID = 1L;
    private final CreateReplicaAction create;
    private final DeleteReplicaAction delete;

    private ReplicaUpdate(BuilderImpl builder) {
        this.create = builder.create;
        this.delete = builder.delete;
    }

    public final CreateReplicaAction create() {
        return this.create;
    }

    public final DeleteReplicaAction delete() {
        return this.delete;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.create());
        hashCode = 31 * hashCode + Objects.hashCode(this.delete());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicaUpdate)) {
            return false;
        }
        ReplicaUpdate other = (ReplicaUpdate)obj;
        return Objects.equals(this.create(), other.create()) && Objects.equals(this.delete(), other.delete());
    }

    public final String toString() {
        return ToString.builder((String)"ReplicaUpdate").add("Create", (Object)this.create()).add("Delete", (Object)this.delete()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Create": {
                return Optional.ofNullable(clazz.cast(this.create()));
            }
            case "Delete": {
                return Optional.ofNullable(clazz.cast(this.delete()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplicaUpdate, T> g) {
        return obj -> g.apply((ReplicaUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CreateReplicaAction create;
        private DeleteReplicaAction delete;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicaUpdate model) {
            this.create(model.create);
            this.delete(model.delete);
        }

        public final CreateReplicaAction.Builder getCreate() {
            return this.create != null ? this.create.toBuilder() : null;
        }

        public final void setCreate(CreateReplicaAction.BuilderImpl create) {
            this.create = create != null ? create.build() : null;
        }

        @Override
        @Transient
        public final Builder create(CreateReplicaAction create) {
            this.create = create;
            return this;
        }

        public final DeleteReplicaAction.Builder getDelete() {
            return this.delete != null ? this.delete.toBuilder() : null;
        }

        public final void setDelete(DeleteReplicaAction.BuilderImpl delete) {
            this.delete = delete != null ? delete.build() : null;
        }

        @Override
        @Transient
        public final Builder delete(DeleteReplicaAction delete) {
            this.delete = delete;
            return this;
        }

        public ReplicaUpdate build() {
            return new ReplicaUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReplicaUpdate> {
        public Builder create(CreateReplicaAction var1);

        default public Builder create(Consumer<CreateReplicaAction.Builder> create) {
            return this.create((CreateReplicaAction)((CreateReplicaAction.Builder)CreateReplicaAction.builder().applyMutation(create)).build());
        }

        public Builder delete(DeleteReplicaAction var1);

        default public Builder delete(Consumer<DeleteReplicaAction.Builder> delete) {
            return this.delete((DeleteReplicaAction)((DeleteReplicaAction.Builder)DeleteReplicaAction.builder().applyMutation(delete)).build());
        }
    }
}

