/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.operations;

import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedClientExtension;
import software.amazon.awssdk.enhanced.dynamodb.OperationContext;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.internal.TransformIterable;
import software.amazon.awssdk.enhanced.dynamodb.model.Page;
import software.amazon.awssdk.enhanced.dynamodb.model.PageIterable;
import software.amazon.awssdk.enhanced.dynamodb.model.PagePublisher;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;

@SdkInternalApi
public interface PaginatedOperation<ItemT, RequestT, ResponseT> {
    public RequestT generateRequest(TableSchema<ItemT> var1, OperationContext var2, DynamoDbEnhancedClientExtension var3);

    public Function<RequestT, SdkIterable<ResponseT>> serviceCall(DynamoDbClient var1);

    public Function<RequestT, SdkPublisher<ResponseT>> asyncServiceCall(DynamoDbAsyncClient var1);

    public Page<ItemT> transformResponse(ResponseT var1, TableSchema<ItemT> var2, OperationContext var3, DynamoDbEnhancedClientExtension var4);

    default public PageIterable<ItemT> execute(TableSchema<ItemT> tableSchema, OperationContext context, DynamoDbEnhancedClientExtension extension, DynamoDbClient dynamoDbClient) {
        RequestT request = this.generateRequest(tableSchema, context, extension);
        SdkIterable<ResponseT> response = this.serviceCall(dynamoDbClient).apply(request);
        TransformIterable<Object, Page> pageIterables = TransformIterable.of(response, r -> this.transformResponse(r, tableSchema, context, extension));
        return PageIterable.create(pageIterables);
    }

    default public PagePublisher<ItemT> executeAsync(TableSchema<ItemT> tableSchema, OperationContext context, DynamoDbEnhancedClientExtension extension, DynamoDbAsyncClient dynamoDbAsyncClient) {
        RequestT request = this.generateRequest(tableSchema, context, extension);
        SdkPublisher<ResponseT> response = this.asyncServiceCall(dynamoDbAsyncClient).apply(request);
        return PagePublisher.create(response.map(r -> this.transformResponse(r, tableSchema, context, extension)));
    }
}

