/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.immutable;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Optional;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.internal.immutable.ImmutablePropertyDescriptor;

@SdkInternalApi
public class ImmutableInfo<T> {
    private final Class<T> immutableClass;
    private final Class<?> builderClass;
    private final Method staticBuilderMethod;
    private final Method buildMethod;
    private final Collection<ImmutablePropertyDescriptor> propertyDescriptors;

    private ImmutableInfo(Builder<T> b) {
        this.immutableClass = ((Builder)b).immutableClass;
        this.builderClass = ((Builder)b).builderClass;
        this.staticBuilderMethod = ((Builder)b).staticBuilderMethod;
        this.buildMethod = ((Builder)b).buildMethod;
        this.propertyDescriptors = ((Builder)b).propertyDescriptors;
    }

    public Class<T> immutableClass() {
        return this.immutableClass;
    }

    public Class<?> builderClass() {
        return this.builderClass;
    }

    public Optional<Method> staticBuilderMethod() {
        return Optional.ofNullable(this.staticBuilderMethod);
    }

    public Method buildMethod() {
        return this.buildMethod;
    }

    public Collection<ImmutablePropertyDescriptor> propertyDescriptors() {
        return this.propertyDescriptors;
    }

    public static <T> Builder<T> builder(Class<T> immutableClass) {
        return new Builder(immutableClass);
    }

    @NotThreadSafe
    public static final class Builder<T> {
        private final Class<T> immutableClass;
        private Class<?> builderClass;
        private Method staticBuilderMethod;
        private Method buildMethod;
        private Collection<ImmutablePropertyDescriptor> propertyDescriptors;

        private Builder(Class<T> immutableClass) {
            this.immutableClass = immutableClass;
        }

        public Builder<T> builderClass(Class<?> builderClass) {
            this.builderClass = builderClass;
            return this;
        }

        public Builder<T> staticBuilderMethod(Method builderMethod) {
            this.staticBuilderMethod = builderMethod;
            return this;
        }

        public Builder<T> buildMethod(Method buildMethod) {
            this.buildMethod = buildMethod;
            return this;
        }

        public Builder<T> propertyDescriptors(Collection<ImmutablePropertyDescriptor> propertyDescriptors) {
            this.propertyDescriptors = propertyDescriptors;
            return this;
        }

        public ImmutableInfo<T> build() {
            return new ImmutableInfo(this);
        }
    }
}

