/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.model;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.services.dynamodb.model.Projection;
import software.amazon.awssdk.utils.Validate;

@SdkPublicApi
@ThreadSafe
public final class EnhancedLocalSecondaryIndex {
    private final String indexName;
    private final Projection projection;

    private EnhancedLocalSecondaryIndex(Builder builder) {
        this.indexName = (String)Validate.paramNotBlank((CharSequence)builder.indexName, (String)"indexName");
        this.projection = builder.projection;
    }

    public static EnhancedLocalSecondaryIndex create(String indexName, Projection projection) {
        return EnhancedLocalSecondaryIndex.builder().indexName(indexName).projection(projection).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return EnhancedLocalSecondaryIndex.builder().indexName(this.indexName).projection(this.projection);
    }

    public String indexName() {
        return this.indexName;
    }

    public Projection projection() {
        return this.projection;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnhancedLocalSecondaryIndex that = (EnhancedLocalSecondaryIndex)o;
        if (this.indexName != null ? !this.indexName.equals(that.indexName) : that.indexName != null) {
            return false;
        }
        return this.projection != null ? this.projection.equals((Object)that.projection) : that.projection == null;
    }

    public int hashCode() {
        int result = this.indexName != null ? this.indexName.hashCode() : 0;
        result = 31 * result + (this.projection != null ? this.projection.hashCode() : 0);
        return result;
    }

    @NotThreadSafe
    public static final class Builder {
        private String indexName;
        private Projection projection;

        private Builder() {
        }

        public Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public Builder projection(Projection projection) {
            this.projection = projection;
            return this;
        }

        public Builder projection(Consumer<Projection.Builder> projection) {
            Projection.Builder builder = Projection.builder();
            projection.accept(builder);
            return this.projection((Projection)builder.build());
        }

        public EnhancedLocalSecondaryIndex build() {
            return new EnhancedLocalSecondaryIndex(this);
        }
    }
}

