/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.operations;

import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedClientExtension;
import software.amazon.awssdk.enhanced.dynamodb.Key;
import software.amazon.awssdk.enhanced.dynamodb.OperationContext;
import software.amazon.awssdk.enhanced.dynamodb.TableMetadata;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.internal.EnhancedClientUtils;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.BatchableReadOperation;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.OperationName;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.TableOperation;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.TransactableReadOperation;
import software.amazon.awssdk.enhanced.dynamodb.model.GetItemEnhancedRequest;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.Get;
import software.amazon.awssdk.services.dynamodb.model.GetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.GetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.TransactGetItem;

@SdkInternalApi
public class GetItemOperation<T>
implements TableOperation<T, GetItemRequest, GetItemResponse, T>,
BatchableReadOperation,
TransactableReadOperation<T> {
    private final GetItemEnhancedRequest request;

    private GetItemOperation(GetItemEnhancedRequest request) {
        this.request = request;
    }

    public static <T> GetItemOperation<T> create(GetItemEnhancedRequest request) {
        return new GetItemOperation<T>(request);
    }

    @Override
    public Boolean consistentRead() {
        return this.request.consistentRead();
    }

    @Override
    public Key key() {
        return this.request.key();
    }

    @Override
    public OperationName operationName() {
        return OperationName.GET_ITEM;
    }

    @Override
    public GetItemRequest generateRequest(TableSchema<T> tableSchema, OperationContext context, DynamoDbEnhancedClientExtension extension) {
        if (!TableMetadata.primaryIndexName().equals(context.indexName())) {
            throw new IllegalArgumentException("GetItem cannot be executed against a secondary index.");
        }
        return (GetItemRequest)GetItemRequest.builder().tableName(context.tableName()).key(this.request.key().keyMap(tableSchema, context.indexName())).consistentRead(this.request.consistentRead()).build();
    }

    @Override
    public T transformResponse(GetItemResponse response, TableSchema<T> tableSchema, OperationContext context, DynamoDbEnhancedClientExtension extension) {
        return EnhancedClientUtils.readAndTransformSingleItem(response.item(), tableSchema, context, extension);
    }

    @Override
    public Function<GetItemRequest, GetItemResponse> serviceCall(DynamoDbClient dynamoDbClient) {
        return arg_0 -> ((DynamoDbClient)dynamoDbClient).getItem(arg_0);
    }

    @Override
    public Function<GetItemRequest, CompletableFuture<GetItemResponse>> asyncServiceCall(DynamoDbAsyncClient dynamoDbAsyncClient) {
        return arg_0 -> ((DynamoDbAsyncClient)dynamoDbAsyncClient).getItem(arg_0);
    }

    @Override
    public TransactGetItem generateTransactGetItem(TableSchema<T> tableSchema, OperationContext operationContext, DynamoDbEnhancedClientExtension dynamoDbEnhancedClientExtension) {
        return (TransactGetItem)TransactGetItem.builder().get((Get)Get.builder().tableName(operationContext.tableName()).key(this.request.key().keyMap(tableSchema, operationContext.indexName())).build()).build();
    }
}

