/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.drs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReverseReplicationResponse extends DrsResponse implements
        ToCopyableBuilder<ReverseReplicationResponse.Builder, ReverseReplicationResponse> {
    private static final SdkField<String> REVERSED_DIRECTION_SOURCE_SERVER_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("reversedDirectionSourceServerArn")
            .getter(getter(ReverseReplicationResponse::reversedDirectionSourceServerArn))
            .setter(setter(Builder::reversedDirectionSourceServerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reversedDirectionSourceServerArn")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(REVERSED_DIRECTION_SOURCE_SERVER_ARN_FIELD));

    private final String reversedDirectionSourceServerArn;

    private ReverseReplicationResponse(BuilderImpl builder) {
        super(builder);
        this.reversedDirectionSourceServerArn = builder.reversedDirectionSourceServerArn;
    }

    /**
     * <p>
     * ARN of created SourceServer.
     * </p>
     * 
     * @return ARN of created SourceServer.
     */
    public final String reversedDirectionSourceServerArn() {
        return reversedDirectionSourceServerArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(reversedDirectionSourceServerArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReverseReplicationResponse)) {
            return false;
        }
        ReverseReplicationResponse other = (ReverseReplicationResponse) obj;
        return Objects.equals(reversedDirectionSourceServerArn(), other.reversedDirectionSourceServerArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReverseReplicationResponse")
                .add("ReversedDirectionSourceServerArn", reversedDirectionSourceServerArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "reversedDirectionSourceServerArn":
            return Optional.ofNullable(clazz.cast(reversedDirectionSourceServerArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReverseReplicationResponse, T> g) {
        return obj -> g.apply((ReverseReplicationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DrsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ReverseReplicationResponse> {
        /**
         * <p>
         * ARN of created SourceServer.
         * </p>
         * 
         * @param reversedDirectionSourceServerArn
         *        ARN of created SourceServer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reversedDirectionSourceServerArn(String reversedDirectionSourceServerArn);
    }

    static final class BuilderImpl extends DrsResponse.BuilderImpl implements Builder {
        private String reversedDirectionSourceServerArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ReverseReplicationResponse model) {
            super(model);
            reversedDirectionSourceServerArn(model.reversedDirectionSourceServerArn);
        }

        public final String getReversedDirectionSourceServerArn() {
            return reversedDirectionSourceServerArn;
        }

        public final void setReversedDirectionSourceServerArn(String reversedDirectionSourceServerArn) {
            this.reversedDirectionSourceServerArn = reversedDirectionSourceServerArn;
        }

        @Override
        public final Builder reversedDirectionSourceServerArn(String reversedDirectionSourceServerArn) {
            this.reversedDirectionSourceServerArn = reversedDirectionSourceServerArn;
            return this;
        }

        @Override
        public ReverseReplicationResponse build() {
            return new ReverseReplicationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
