/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.drs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A job is an asynchronous workflow.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Job implements SdkPojo, Serializable, ToCopyableBuilder<Job.Builder, Job> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(Job::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> CREATION_DATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("creationDateTime").getter(getter(Job::creationDateTime)).setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<String> END_DATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("endDateTime").getter(getter(Job::endDateTime)).setter(setter(Builder::endDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endDateTime").build()).build();

    private static final SdkField<String> INITIATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("initiatedBy").getter(getter(Job::initiatedByAsString)).setter(setter(Builder::initiatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initiatedBy").build()).build();

    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobID")
            .getter(getter(Job::jobID)).setter(setter(Builder::jobID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobID").build()).build();

    private static final SdkField<List<ParticipatingResource>> PARTICIPATING_RESOURCES_FIELD = SdkField
            .<List<ParticipatingResource>> builder(MarshallingType.LIST)
            .memberName("participatingResources")
            .getter(getter(Job::participatingResources))
            .setter(setter(Builder::participatingResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("participatingResources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ParticipatingResource> builder(MarshallingType.SDK_POJO)
                                            .constructor(ParticipatingResource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ParticipatingServer>> PARTICIPATING_SERVERS_FIELD = SdkField
            .<List<ParticipatingServer>> builder(MarshallingType.LIST)
            .memberName("participatingServers")
            .getter(getter(Job::participatingServers))
            .setter(setter(Builder::participatingServers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("participatingServers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ParticipatingServer> builder(MarshallingType.SDK_POJO)
                                            .constructor(ParticipatingServer::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(Job::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(Job::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(Job::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CREATION_DATE_TIME_FIELD, END_DATE_TIME_FIELD, INITIATED_BY_FIELD, JOB_ID_FIELD, PARTICIPATING_RESOURCES_FIELD,
            PARTICIPATING_SERVERS_FIELD, STATUS_FIELD, TAGS_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String creationDateTime;

    private final String endDateTime;

    private final String initiatedBy;

    private final String jobID;

    private final List<ParticipatingResource> participatingResources;

    private final List<ParticipatingServer> participatingServers;

    private final String status;

    private final Map<String, String> tags;

    private final String type;

    private Job(BuilderImpl builder) {
        this.arn = builder.arn;
        this.creationDateTime = builder.creationDateTime;
        this.endDateTime = builder.endDateTime;
        this.initiatedBy = builder.initiatedBy;
        this.jobID = builder.jobID;
        this.participatingResources = builder.participatingResources;
        this.participatingServers = builder.participatingServers;
        this.status = builder.status;
        this.tags = builder.tags;
        this.type = builder.type;
    }

    /**
     * <p>
     * The ARN of a Job.
     * </p>
     * 
     * @return The ARN of a Job.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The date and time of when the Job was created.
     * </p>
     * 
     * @return The date and time of when the Job was created.
     */
    public final String creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * The date and time of when the Job ended.
     * </p>
     * 
     * @return The date and time of when the Job ended.
     */
    public final String endDateTime() {
        return endDateTime;
    }

    /**
     * <p>
     * A string representing who initiated the Job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #initiatedBy} will
     * return {@link InitiatedBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #initiatedByAsString}.
     * </p>
     * 
     * @return A string representing who initiated the Job.
     * @see InitiatedBy
     */
    public final InitiatedBy initiatedBy() {
        return InitiatedBy.fromValue(initiatedBy);
    }

    /**
     * <p>
     * A string representing who initiated the Job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #initiatedBy} will
     * return {@link InitiatedBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #initiatedByAsString}.
     * </p>
     * 
     * @return A string representing who initiated the Job.
     * @see InitiatedBy
     */
    public final String initiatedByAsString() {
        return initiatedBy;
    }

    /**
     * <p>
     * The ID of the Job.
     * </p>
     * 
     * @return The ID of the Job.
     */
    public final String jobID() {
        return jobID;
    }

    /**
     * For responses, this returns true if the service returned a value for the ParticipatingResources property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasParticipatingResources() {
        return participatingResources != null && !(participatingResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of resources that the Job is acting upon.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParticipatingResources} method.
     * </p>
     * 
     * @return A list of resources that the Job is acting upon.
     */
    public final List<ParticipatingResource> participatingResources() {
        return participatingResources;
    }

    /**
     * For responses, this returns true if the service returned a value for the ParticipatingServers property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasParticipatingServers() {
        return participatingServers != null && !(participatingServers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of servers that the Job is acting upon.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParticipatingServers} method.
     * </p>
     * 
     * @return A list of servers that the Job is acting upon.
     */
    public final List<ParticipatingServer> participatingServers() {
        return participatingServers;
    }

    /**
     * <p>
     * The status of the Job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Job.
     * @see JobStatus
     */
    public final JobStatus status() {
        return JobStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the Job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Job.
     * @see JobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of tags associated with the Job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of tags associated with the Job.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The type of the Job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link JobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the Job.
     * @see JobType
     */
    public final JobType type() {
        return JobType.fromValue(type);
    }

    /**
     * <p>
     * The type of the Job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link JobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the Job.
     * @see JobType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(endDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(initiatedByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(jobID());
        hashCode = 31 * hashCode + Objects.hashCode(hasParticipatingResources() ? participatingResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasParticipatingServers() ? participatingServers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Job)) {
            return false;
        }
        Job other = (Job) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(endDateTime(), other.endDateTime())
                && Objects.equals(initiatedByAsString(), other.initiatedByAsString()) && Objects.equals(jobID(), other.jobID())
                && hasParticipatingResources() == other.hasParticipatingResources()
                && Objects.equals(participatingResources(), other.participatingResources())
                && hasParticipatingServers() == other.hasParticipatingServers()
                && Objects.equals(participatingServers(), other.participatingServers())
                && Objects.equals(statusAsString(), other.statusAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Job").add("Arn", arn()).add("CreationDateTime", creationDateTime())
                .add("EndDateTime", endDateTime()).add("InitiatedBy", initiatedByAsString()).add("JobID", jobID())
                .add("ParticipatingResources", hasParticipatingResources() ? participatingResources() : null)
                .add("ParticipatingServers", hasParticipatingServers() ? participatingServers() : null)
                .add("Status", statusAsString()).add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "endDateTime":
            return Optional.ofNullable(clazz.cast(endDateTime()));
        case "initiatedBy":
            return Optional.ofNullable(clazz.cast(initiatedByAsString()));
        case "jobID":
            return Optional.ofNullable(clazz.cast(jobID()));
        case "participatingResources":
            return Optional.ofNullable(clazz.cast(participatingResources()));
        case "participatingServers":
            return Optional.ofNullable(clazz.cast(participatingServers()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Job, T> g) {
        return obj -> g.apply((Job) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Job> {
        /**
         * <p>
         * The ARN of a Job.
         * </p>
         * 
         * @param arn
         *        The ARN of a Job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The date and time of when the Job was created.
         * </p>
         * 
         * @param creationDateTime
         *        The date and time of when the Job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(String creationDateTime);

        /**
         * <p>
         * The date and time of when the Job ended.
         * </p>
         * 
         * @param endDateTime
         *        The date and time of when the Job ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endDateTime(String endDateTime);

        /**
         * <p>
         * A string representing who initiated the Job.
         * </p>
         * 
         * @param initiatedBy
         *        A string representing who initiated the Job.
         * @see InitiatedBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InitiatedBy
         */
        Builder initiatedBy(String initiatedBy);

        /**
         * <p>
         * A string representing who initiated the Job.
         * </p>
         * 
         * @param initiatedBy
         *        A string representing who initiated the Job.
         * @see InitiatedBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InitiatedBy
         */
        Builder initiatedBy(InitiatedBy initiatedBy);

        /**
         * <p>
         * The ID of the Job.
         * </p>
         * 
         * @param jobID
         *        The ID of the Job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobID(String jobID);

        /**
         * <p>
         * A list of resources that the Job is acting upon.
         * </p>
         * 
         * @param participatingResources
         *        A list of resources that the Job is acting upon.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder participatingResources(Collection<ParticipatingResource> participatingResources);

        /**
         * <p>
         * A list of resources that the Job is acting upon.
         * </p>
         * 
         * @param participatingResources
         *        A list of resources that the Job is acting upon.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder participatingResources(ParticipatingResource... participatingResources);

        /**
         * <p>
         * A list of resources that the Job is acting upon.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.drs.model.ParticipatingResource.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.drs.model.ParticipatingResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.drs.model.ParticipatingResource.Builder#build()} is called immediately
         * and its result is passed to {@link #participatingResources(List<ParticipatingResource>)}.
         * 
         * @param participatingResources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.drs.model.ParticipatingResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #participatingResources(java.util.Collection<ParticipatingResource>)
         */
        Builder participatingResources(Consumer<ParticipatingResource.Builder>... participatingResources);

        /**
         * <p>
         * A list of servers that the Job is acting upon.
         * </p>
         * 
         * @param participatingServers
         *        A list of servers that the Job is acting upon.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder participatingServers(Collection<ParticipatingServer> participatingServers);

        /**
         * <p>
         * A list of servers that the Job is acting upon.
         * </p>
         * 
         * @param participatingServers
         *        A list of servers that the Job is acting upon.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder participatingServers(ParticipatingServer... participatingServers);

        /**
         * <p>
         * A list of servers that the Job is acting upon.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.drs.model.ParticipatingServer.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.drs.model.ParticipatingServer#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.drs.model.ParticipatingServer.Builder#build()} is called immediately
         * and its result is passed to {@link #participatingServers(List<ParticipatingServer>)}.
         * 
         * @param participatingServers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.drs.model.ParticipatingServer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #participatingServers(java.util.Collection<ParticipatingServer>)
         */
        Builder participatingServers(Consumer<ParticipatingServer.Builder>... participatingServers);

        /**
         * <p>
         * The status of the Job.
         * </p>
         * 
         * @param status
         *        The status of the Job.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the Job.
         * </p>
         * 
         * @param status
         *        The status of the Job.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder status(JobStatus status);

        /**
         * <p>
         * A list of tags associated with the Job.
         * </p>
         * 
         * @param tags
         *        A list of tags associated with the Job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The type of the Job.
         * </p>
         * 
         * @param type
         *        The type of the Job.
         * @see JobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the Job.
         * </p>
         * 
         * @param type
         *        The type of the Job.
         * @see JobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobType
         */
        Builder type(JobType type);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String creationDateTime;

        private String endDateTime;

        private String initiatedBy;

        private String jobID;

        private List<ParticipatingResource> participatingResources = DefaultSdkAutoConstructList.getInstance();

        private List<ParticipatingServer> participatingServers = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(Job model) {
            arn(model.arn);
            creationDateTime(model.creationDateTime);
            endDateTime(model.endDateTime);
            initiatedBy(model.initiatedBy);
            jobID(model.jobID);
            participatingResources(model.participatingResources);
            participatingServers(model.participatingServers);
            status(model.status);
            tags(model.tags);
            type(model.type);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(String creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(String creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final String getEndDateTime() {
            return endDateTime;
        }

        public final void setEndDateTime(String endDateTime) {
            this.endDateTime = endDateTime;
        }

        @Override
        public final Builder endDateTime(String endDateTime) {
            this.endDateTime = endDateTime;
            return this;
        }

        public final String getInitiatedBy() {
            return initiatedBy;
        }

        public final void setInitiatedBy(String initiatedBy) {
            this.initiatedBy = initiatedBy;
        }

        @Override
        public final Builder initiatedBy(String initiatedBy) {
            this.initiatedBy = initiatedBy;
            return this;
        }

        @Override
        public final Builder initiatedBy(InitiatedBy initiatedBy) {
            this.initiatedBy(initiatedBy == null ? null : initiatedBy.toString());
            return this;
        }

        public final String getJobID() {
            return jobID;
        }

        public final void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @Override
        public final Builder jobID(String jobID) {
            this.jobID = jobID;
            return this;
        }

        public final List<ParticipatingResource.Builder> getParticipatingResources() {
            List<ParticipatingResource.Builder> result = ParticipatingResourcesCopier.copyToBuilder(this.participatingResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParticipatingResources(Collection<ParticipatingResource.BuilderImpl> participatingResources) {
            this.participatingResources = ParticipatingResourcesCopier.copyFromBuilder(participatingResources);
        }

        @Override
        public final Builder participatingResources(Collection<ParticipatingResource> participatingResources) {
            this.participatingResources = ParticipatingResourcesCopier.copy(participatingResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder participatingResources(ParticipatingResource... participatingResources) {
            participatingResources(Arrays.asList(participatingResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder participatingResources(Consumer<ParticipatingResource.Builder>... participatingResources) {
            participatingResources(Stream.of(participatingResources)
                    .map(c -> ParticipatingResource.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ParticipatingServer.Builder> getParticipatingServers() {
            List<ParticipatingServer.Builder> result = ParticipatingServersCopier.copyToBuilder(this.participatingServers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParticipatingServers(Collection<ParticipatingServer.BuilderImpl> participatingServers) {
            this.participatingServers = ParticipatingServersCopier.copyFromBuilder(participatingServers);
        }

        @Override
        public final Builder participatingServers(Collection<ParticipatingServer> participatingServers) {
            this.participatingServers = ParticipatingServersCopier.copy(participatingServers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder participatingServers(ParticipatingServer... participatingServers) {
            participatingServers(Arrays.asList(participatingServers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder participatingServers(Consumer<ParticipatingServer.Builder>... participatingServers) {
            participatingServers(Stream.of(participatingServers).map(c -> ParticipatingServer.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(JobType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public Job build() {
            return new Job(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
