/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.docdbelastic.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.docdbelastic.model.Auth;
import software.amazon.awssdk.services.docdbelastic.model.Status;
import software.amazon.awssdk.services.docdbelastic.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Cluster
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Cluster> {
    private static final SdkField<String> ADMIN_USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("adminUserName").getter(Cluster.getter(Cluster::adminUserName)).setter(Cluster.setter(Builder::adminUserName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adminUserName").build()}).build();
    private static final SdkField<String> AUTH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authType").getter(Cluster.getter(Cluster::authTypeAsString)).setter(Cluster.setter(Builder::authType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authType").build()}).build();
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterArn").getter(Cluster.getter(Cluster::clusterArn)).setter(Cluster.setter(Builder::clusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterArn").build()}).build();
    private static final SdkField<String> CLUSTER_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterEndpoint").getter(Cluster.getter(Cluster::clusterEndpoint)).setter(Cluster.setter(Builder::clusterEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterEndpoint").build()}).build();
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterName").getter(Cluster.getter(Cluster::clusterName)).setter(Cluster.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()}).build();
    private static final SdkField<String> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createTime").getter(Cluster.getter(Cluster::createTime)).setter(Cluster.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyId").getter(Cluster.getter(Cluster::kmsKeyId)).setter(Cluster.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()}).build();
    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("preferredMaintenanceWindow").getter(Cluster.getter(Cluster::preferredMaintenanceWindow)).setter(Cluster.setter(Builder::preferredMaintenanceWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preferredMaintenanceWindow").build()}).build();
    private static final SdkField<Integer> SHARD_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("shardCapacity").getter(Cluster.getter(Cluster::shardCapacity)).setter(Cluster.setter(Builder::shardCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shardCapacity").build()}).build();
    private static final SdkField<Integer> SHARD_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("shardCount").getter(Cluster.getter(Cluster::shardCount)).setter(Cluster.setter(Builder::shardCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shardCount").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(Cluster.getter(Cluster::statusAsString)).setter(Cluster.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("subnetIds").getter(Cluster.getter(Cluster::subnetIds)).setter(Cluster.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("vpcSecurityGroupIds").getter(Cluster.getter(Cluster::vpcSecurityGroupIds)).setter(Cluster.setter(Builder::vpcSecurityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcSecurityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADMIN_USER_NAME_FIELD, AUTH_TYPE_FIELD, CLUSTER_ARN_FIELD, CLUSTER_ENDPOINT_FIELD, CLUSTER_NAME_FIELD, CREATE_TIME_FIELD, KMS_KEY_ID_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, SHARD_CAPACITY_FIELD, SHARD_COUNT_FIELD, STATUS_FIELD, SUBNET_IDS_FIELD, VPC_SECURITY_GROUP_IDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String adminUserName;
    private final String authType;
    private final String clusterArn;
    private final String clusterEndpoint;
    private final String clusterName;
    private final String createTime;
    private final String kmsKeyId;
    private final String preferredMaintenanceWindow;
    private final Integer shardCapacity;
    private final Integer shardCount;
    private final String status;
    private final List<String> subnetIds;
    private final List<String> vpcSecurityGroupIds;

    private Cluster(BuilderImpl builder) {
        this.adminUserName = builder.adminUserName;
        this.authType = builder.authType;
        this.clusterArn = builder.clusterArn;
        this.clusterEndpoint = builder.clusterEndpoint;
        this.clusterName = builder.clusterName;
        this.createTime = builder.createTime;
        this.kmsKeyId = builder.kmsKeyId;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.shardCapacity = builder.shardCapacity;
        this.shardCount = builder.shardCount;
        this.status = builder.status;
        this.subnetIds = builder.subnetIds;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
    }

    public final String adminUserName() {
        return this.adminUserName;
    }

    public final Auth authType() {
        return Auth.fromValue(this.authType);
    }

    public final String authTypeAsString() {
        return this.authType;
    }

    public final String clusterArn() {
        return this.clusterArn;
    }

    public final String clusterEndpoint() {
        return this.clusterEndpoint;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final String createTime() {
        return this.createTime;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public final Integer shardCapacity() {
        return this.shardCapacity;
    }

    public final Integer shardCount() {
        return this.shardCount;
    }

    public final Status status() {
        return Status.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasSubnetIds() {
        return this.subnetIds != null && !(this.subnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> subnetIds() {
        return this.subnetIds;
    }

    public final boolean hasVpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds != null && !(this.vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> vpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.adminUserName());
        hashCode = 31 * hashCode + Objects.hashCode(this.authTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.shardCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.shardCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetIds() ? this.subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcSecurityGroupIds() ? this.vpcSecurityGroupIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cluster)) {
            return false;
        }
        Cluster other = (Cluster)obj;
        return Objects.equals(this.adminUserName(), other.adminUserName()) && Objects.equals(this.authTypeAsString(), other.authTypeAsString()) && Objects.equals(this.clusterArn(), other.clusterArn()) && Objects.equals(this.clusterEndpoint(), other.clusterEndpoint()) && Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.preferredMaintenanceWindow(), other.preferredMaintenanceWindow()) && Objects.equals(this.shardCapacity(), other.shardCapacity()) && Objects.equals(this.shardCount(), other.shardCount()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasSubnetIds() == other.hasSubnetIds() && Objects.equals(this.subnetIds(), other.subnetIds()) && this.hasVpcSecurityGroupIds() == other.hasVpcSecurityGroupIds() && Objects.equals(this.vpcSecurityGroupIds(), other.vpcSecurityGroupIds());
    }

    public final String toString() {
        return ToString.builder((String)"Cluster").add("AdminUserName", (Object)this.adminUserName()).add("AuthType", (Object)this.authTypeAsString()).add("ClusterArn", (Object)this.clusterArn()).add("ClusterEndpoint", (Object)this.clusterEndpoint()).add("ClusterName", (Object)this.clusterName()).add("CreateTime", (Object)this.createTime()).add("KmsKeyId", (Object)this.kmsKeyId()).add("PreferredMaintenanceWindow", (Object)this.preferredMaintenanceWindow()).add("ShardCapacity", (Object)this.shardCapacity()).add("ShardCount", (Object)this.shardCount()).add("Status", (Object)this.statusAsString()).add("SubnetIds", this.hasSubnetIds() ? this.subnetIds() : null).add("VpcSecurityGroupIds", this.hasVpcSecurityGroupIds() ? this.vpcSecurityGroupIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "adminUserName": {
                return Optional.ofNullable(clazz.cast(this.adminUserName()));
            }
            case "authType": {
                return Optional.ofNullable(clazz.cast(this.authTypeAsString()));
            }
            case "clusterArn": {
                return Optional.ofNullable(clazz.cast(this.clusterArn()));
            }
            case "clusterEndpoint": {
                return Optional.ofNullable(clazz.cast(this.clusterEndpoint()));
            }
            case "clusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "kmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "preferredMaintenanceWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredMaintenanceWindow()));
            }
            case "shardCapacity": {
                return Optional.ofNullable(clazz.cast(this.shardCapacity()));
            }
            case "shardCount": {
                return Optional.ofNullable(clazz.cast(this.shardCount()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "subnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
            case "vpcSecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.vpcSecurityGroupIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Cluster, T> g) {
        return obj -> g.apply((Cluster)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String adminUserName;
        private String authType;
        private String clusterArn;
        private String clusterEndpoint;
        private String clusterName;
        private String createTime;
        private String kmsKeyId;
        private String preferredMaintenanceWindow;
        private Integer shardCapacity;
        private Integer shardCount;
        private String status;
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Cluster model) {
            this.adminUserName(model.adminUserName);
            this.authType(model.authType);
            this.clusterArn(model.clusterArn);
            this.clusterEndpoint(model.clusterEndpoint);
            this.clusterName(model.clusterName);
            this.createTime(model.createTime);
            this.kmsKeyId(model.kmsKeyId);
            this.preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.shardCapacity(model.shardCapacity);
            this.shardCount(model.shardCount);
            this.status(model.status);
            this.subnetIds(model.subnetIds);
            this.vpcSecurityGroupIds(model.vpcSecurityGroupIds);
        }

        public final String getAdminUserName() {
            return this.adminUserName;
        }

        public final void setAdminUserName(String adminUserName) {
            this.adminUserName = adminUserName;
        }

        @Override
        public final Builder adminUserName(String adminUserName) {
            this.adminUserName = adminUserName;
            return this;
        }

        public final String getAuthType() {
            return this.authType;
        }

        public final void setAuthType(String authType) {
            this.authType = authType;
        }

        @Override
        public final Builder authType(String authType) {
            this.authType = authType;
            return this;
        }

        @Override
        public final Builder authType(Auth authType) {
            this.authType(authType == null ? null : authType.toString());
            return this;
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final String getClusterEndpoint() {
            return this.clusterEndpoint;
        }

        public final void setClusterEndpoint(String clusterEndpoint) {
            this.clusterEndpoint = clusterEndpoint;
        }

        @Override
        public final Builder clusterEndpoint(String clusterEndpoint) {
            this.clusterEndpoint = clusterEndpoint;
            return this;
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(String createTime) {
            this.createTime = createTime;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final Integer getShardCapacity() {
            return this.shardCapacity;
        }

        public final void setShardCapacity(Integer shardCapacity) {
            this.shardCapacity = shardCapacity;
        }

        @Override
        public final Builder shardCapacity(Integer shardCapacity) {
            this.shardCapacity = shardCapacity;
            return this;
        }

        public final Integer getShardCount() {
            return this.shardCount;
        }

        public final void setShardCount(Integer shardCount) {
            this.shardCount = shardCount;
        }

        @Override
        public final Builder shardCount(Integer shardCount) {
            this.shardCount = shardCount;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (this.subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringListCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            if (this.vpcSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.vpcSecurityGroupIds;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = StringListCopier.copy(vpcSecurityGroupIds);
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = StringListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String ... vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public Cluster build() {
            return new Cluster(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Cluster> {
        public Builder adminUserName(String var1);

        public Builder authType(String var1);

        public Builder authType(Auth var1);

        public Builder clusterArn(String var1);

        public Builder clusterEndpoint(String var1);

        public Builder clusterName(String var1);

        public Builder createTime(String var1);

        public Builder kmsKeyId(String var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder shardCapacity(Integer var1);

        public Builder shardCount(Integer var1);

        public Builder status(String var1);

        public Builder status(Status var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder vpcSecurityGroupIds(Collection<String> var1);

        public Builder vpcSecurityGroupIds(String ... var1);
    }
}

