/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.docdb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A certificate authority (CA) certificate for an Amazon Web Services account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Certificate implements SdkPojo, Serializable, ToCopyableBuilder<Certificate.Builder, Certificate> {
    private static final SdkField<String> CERTIFICATE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CertificateIdentifier").getter(getter(Certificate::certificateIdentifier))
            .setter(setter(Builder::certificateIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateIdentifier").build())
            .build();

    private static final SdkField<String> CERTIFICATE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CertificateType").getter(getter(Certificate::certificateType)).setter(setter(Builder::certificateType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateType").build()).build();

    private static final SdkField<String> THUMBPRINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Thumbprint").getter(getter(Certificate::thumbprint)).setter(setter(Builder::thumbprint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Thumbprint").build()).build();

    private static final SdkField<Instant> VALID_FROM_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ValidFrom").getter(getter(Certificate::validFrom)).setter(setter(Builder::validFrom))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidFrom").build()).build();

    private static final SdkField<Instant> VALID_TILL_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ValidTill").getter(getter(Certificate::validTill)).setter(setter(Builder::validTill))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidTill").build()).build();

    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CertificateArn").getter(getter(Certificate::certificateArn)).setter(setter(Builder::certificateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_IDENTIFIER_FIELD,
            CERTIFICATE_TYPE_FIELD, THUMBPRINT_FIELD, VALID_FROM_FIELD, VALID_TILL_FIELD, CERTIFICATE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String certificateIdentifier;

    private final String certificateType;

    private final String thumbprint;

    private final Instant validFrom;

    private final Instant validTill;

    private final String certificateArn;

    private Certificate(BuilderImpl builder) {
        this.certificateIdentifier = builder.certificateIdentifier;
        this.certificateType = builder.certificateType;
        this.thumbprint = builder.thumbprint;
        this.validFrom = builder.validFrom;
        this.validTill = builder.validTill;
        this.certificateArn = builder.certificateArn;
    }

    /**
     * <p>
     * The unique key that identifies a certificate.
     * </p>
     * <p>
     * Example: <code>rds-ca-2019</code>
     * </p>
     * 
     * @return The unique key that identifies a certificate.</p>
     *         <p>
     *         Example: <code>rds-ca-2019</code>
     */
    public final String certificateIdentifier() {
        return certificateIdentifier;
    }

    /**
     * <p>
     * The type of the certificate.
     * </p>
     * <p>
     * Example: <code>CA</code>
     * </p>
     * 
     * @return The type of the certificate.</p>
     *         <p>
     *         Example: <code>CA</code>
     */
    public final String certificateType() {
        return certificateType;
    }

    /**
     * <p>
     * The thumbprint of the certificate.
     * </p>
     * 
     * @return The thumbprint of the certificate.
     */
    public final String thumbprint() {
        return thumbprint;
    }

    /**
     * <p>
     * The starting date-time from which the certificate is valid.
     * </p>
     * <p>
     * Example: <code>2019-07-31T17:57:09Z</code>
     * </p>
     * 
     * @return The starting date-time from which the certificate is valid.</p>
     *         <p>
     *         Example: <code>2019-07-31T17:57:09Z</code>
     */
    public final Instant validFrom() {
        return validFrom;
    }

    /**
     * <p>
     * The date-time after which the certificate is no longer valid.
     * </p>
     * <p>
     * Example: <code>2024-07-31T17:57:09Z</code>
     * </p>
     * 
     * @return The date-time after which the certificate is no longer valid.</p>
     *         <p>
     *         Example: <code>2024-07-31T17:57:09Z</code>
     */
    public final Instant validTill() {
        return validTill;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the certificate.
     * </p>
     * <p>
     * Example: <code>arn:aws:rds:us-east-1::cert:rds-ca-2019</code>
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the certificate.</p>
     *         <p>
     *         Example: <code>arn:aws:rds:us-east-1::cert:rds-ca-2019</code>
     */
    public final String certificateArn() {
        return certificateArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(certificateIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(certificateType());
        hashCode = 31 * hashCode + Objects.hashCode(thumbprint());
        hashCode = 31 * hashCode + Objects.hashCode(validFrom());
        hashCode = 31 * hashCode + Objects.hashCode(validTill());
        hashCode = 31 * hashCode + Objects.hashCode(certificateArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Certificate)) {
            return false;
        }
        Certificate other = (Certificate) obj;
        return Objects.equals(certificateIdentifier(), other.certificateIdentifier())
                && Objects.equals(certificateType(), other.certificateType()) && Objects.equals(thumbprint(), other.thumbprint())
                && Objects.equals(validFrom(), other.validFrom()) && Objects.equals(validTill(), other.validTill())
                && Objects.equals(certificateArn(), other.certificateArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Certificate").add("CertificateIdentifier", certificateIdentifier())
                .add("CertificateType", certificateType()).add("Thumbprint", thumbprint()).add("ValidFrom", validFrom())
                .add("ValidTill", validTill()).add("CertificateArn", certificateArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CertificateIdentifier":
            return Optional.ofNullable(clazz.cast(certificateIdentifier()));
        case "CertificateType":
            return Optional.ofNullable(clazz.cast(certificateType()));
        case "Thumbprint":
            return Optional.ofNullable(clazz.cast(thumbprint()));
        case "ValidFrom":
            return Optional.ofNullable(clazz.cast(validFrom()));
        case "ValidTill":
            return Optional.ofNullable(clazz.cast(validTill()));
        case "CertificateArn":
            return Optional.ofNullable(clazz.cast(certificateArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Certificate, T> g) {
        return obj -> g.apply((Certificate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Certificate> {
        /**
         * <p>
         * The unique key that identifies a certificate.
         * </p>
         * <p>
         * Example: <code>rds-ca-2019</code>
         * </p>
         * 
         * @param certificateIdentifier
         *        The unique key that identifies a certificate.</p>
         *        <p>
         *        Example: <code>rds-ca-2019</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateIdentifier(String certificateIdentifier);

        /**
         * <p>
         * The type of the certificate.
         * </p>
         * <p>
         * Example: <code>CA</code>
         * </p>
         * 
         * @param certificateType
         *        The type of the certificate.</p>
         *        <p>
         *        Example: <code>CA</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateType(String certificateType);

        /**
         * <p>
         * The thumbprint of the certificate.
         * </p>
         * 
         * @param thumbprint
         *        The thumbprint of the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thumbprint(String thumbprint);

        /**
         * <p>
         * The starting date-time from which the certificate is valid.
         * </p>
         * <p>
         * Example: <code>2019-07-31T17:57:09Z</code>
         * </p>
         * 
         * @param validFrom
         *        The starting date-time from which the certificate is valid.</p>
         *        <p>
         *        Example: <code>2019-07-31T17:57:09Z</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validFrom(Instant validFrom);

        /**
         * <p>
         * The date-time after which the certificate is no longer valid.
         * </p>
         * <p>
         * Example: <code>2024-07-31T17:57:09Z</code>
         * </p>
         * 
         * @param validTill
         *        The date-time after which the certificate is no longer valid.</p>
         *        <p>
         *        Example: <code>2024-07-31T17:57:09Z</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validTill(Instant validTill);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the certificate.
         * </p>
         * <p>
         * Example: <code>arn:aws:rds:us-east-1::cert:rds-ca-2019</code>
         * </p>
         * 
         * @param certificateArn
         *        The Amazon Resource Name (ARN) for the certificate.</p>
         *        <p>
         *        Example: <code>arn:aws:rds:us-east-1::cert:rds-ca-2019</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateArn(String certificateArn);
    }

    static final class BuilderImpl implements Builder {
        private String certificateIdentifier;

        private String certificateType;

        private String thumbprint;

        private Instant validFrom;

        private Instant validTill;

        private String certificateArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Certificate model) {
            certificateIdentifier(model.certificateIdentifier);
            certificateType(model.certificateType);
            thumbprint(model.thumbprint);
            validFrom(model.validFrom);
            validTill(model.validTill);
            certificateArn(model.certificateArn);
        }

        public final String getCertificateIdentifier() {
            return certificateIdentifier;
        }

        public final void setCertificateIdentifier(String certificateIdentifier) {
            this.certificateIdentifier = certificateIdentifier;
        }

        @Override
        public final Builder certificateIdentifier(String certificateIdentifier) {
            this.certificateIdentifier = certificateIdentifier;
            return this;
        }

        public final String getCertificateType() {
            return certificateType;
        }

        public final void setCertificateType(String certificateType) {
            this.certificateType = certificateType;
        }

        @Override
        public final Builder certificateType(String certificateType) {
            this.certificateType = certificateType;
            return this;
        }

        public final String getThumbprint() {
            return thumbprint;
        }

        public final void setThumbprint(String thumbprint) {
            this.thumbprint = thumbprint;
        }

        @Override
        public final Builder thumbprint(String thumbprint) {
            this.thumbprint = thumbprint;
            return this;
        }

        public final Instant getValidFrom() {
            return validFrom;
        }

        public final void setValidFrom(Instant validFrom) {
            this.validFrom = validFrom;
        }

        @Override
        public final Builder validFrom(Instant validFrom) {
            this.validFrom = validFrom;
            return this;
        }

        public final Instant getValidTill() {
            return validTill;
        }

        public final void setValidTill(Instant validTill) {
            this.validTill = validTill;
        }

        @Override
        public final Builder validTill(Instant validTill) {
            this.validTill = validTill;
            return this;
        }

        public final String getCertificateArn() {
            return certificateArn;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        @Override
        public Certificate build() {
            return new Certificate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
