/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an AD Connector directory.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DirectoryConnectSettingsDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<DirectoryConnectSettingsDescription.Builder, DirectoryConnectSettingsDescription> {
    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(DirectoryConnectSettingsDescription::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SubnetIds")
            .getter(getter(DirectoryConnectSettingsDescription::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CUSTOMER_USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomerUserName").getter(getter(DirectoryConnectSettingsDescription::customerUserName))
            .setter(setter(Builder::customerUserName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerUserName").build()).build();

    private static final SdkField<String> SECURITY_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecurityGroupId").getter(getter(DirectoryConnectSettingsDescription::securityGroupId))
            .setter(setter(Builder::securityGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupId").build()).build();

    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AvailabilityZones")
            .getter(getter(DirectoryConnectSettingsDescription::availabilityZones))
            .setter(setter(Builder::availabilityZones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> CONNECT_IPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ConnectIps")
            .getter(getter(DirectoryConnectSettingsDescription::connectIps))
            .setter(setter(Builder::connectIps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectIps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_ID_FIELD,
            SUBNET_IDS_FIELD, CUSTOMER_USER_NAME_FIELD, SECURITY_GROUP_ID_FIELD, AVAILABILITY_ZONES_FIELD, CONNECT_IPS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String vpcId;

    private final List<String> subnetIds;

    private final String customerUserName;

    private final String securityGroupId;

    private final List<String> availabilityZones;

    private final List<String> connectIps;

    private DirectoryConnectSettingsDescription(BuilderImpl builder) {
        this.vpcId = builder.vpcId;
        this.subnetIds = builder.subnetIds;
        this.customerUserName = builder.customerUserName;
        this.securityGroupId = builder.securityGroupId;
        this.availabilityZones = builder.availabilityZones;
        this.connectIps = builder.connectIps;
    }

    /**
     * <p>
     * The identifier of the VPC that the AD Connector is in.
     * </p>
     * 
     * @return The identifier of the VPC that the AD Connector is in.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubnetIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of subnet identifiers in the VPC that the AD Connector is in.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnetIds} method.
     * </p>
     * 
     * @return A list of subnet identifiers in the VPC that the AD Connector is in.
     */
    public final List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * <p>
     * The user name of the service account in your self-managed directory.
     * </p>
     * 
     * @return The user name of the service account in your self-managed directory.
     */
    public final String customerUserName() {
        return customerUserName;
    }

    /**
     * <p>
     * The security group identifier for the AD Connector directory.
     * </p>
     * 
     * @return The security group identifier for the AD Connector directory.
     */
    public final String securityGroupId() {
        return securityGroupId;
    }

    /**
     * For responses, this returns true if the service returned a value for the AvailabilityZones property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAvailabilityZones() {
        return availabilityZones != null && !(availabilityZones instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the Availability Zones that the directory is in.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAvailabilityZones} method.
     * </p>
     * 
     * @return A list of the Availability Zones that the directory is in.
     */
    public final List<String> availabilityZones() {
        return availabilityZones;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConnectIps property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasConnectIps() {
        return connectIps != null && !(connectIps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IP addresses of the AD Connector servers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConnectIps} method.
     * </p>
     * 
     * @return The IP addresses of the AD Connector servers.
     */
    public final List<String> connectIps() {
        return connectIps;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetIds() ? subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(customerUserName());
        hashCode = 31 * hashCode + Objects.hashCode(securityGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAvailabilityZones() ? availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasConnectIps() ? connectIps() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DirectoryConnectSettingsDescription)) {
            return false;
        }
        DirectoryConnectSettingsDescription other = (DirectoryConnectSettingsDescription) obj;
        return Objects.equals(vpcId(), other.vpcId()) && hasSubnetIds() == other.hasSubnetIds()
                && Objects.equals(subnetIds(), other.subnetIds()) && Objects.equals(customerUserName(), other.customerUserName())
                && Objects.equals(securityGroupId(), other.securityGroupId())
                && hasAvailabilityZones() == other.hasAvailabilityZones()
                && Objects.equals(availabilityZones(), other.availabilityZones()) && hasConnectIps() == other.hasConnectIps()
                && Objects.equals(connectIps(), other.connectIps());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DirectoryConnectSettingsDescription").add("VpcId", vpcId())
                .add("SubnetIds", hasSubnetIds() ? subnetIds() : null).add("CustomerUserName", customerUserName())
                .add("SecurityGroupId", securityGroupId())
                .add("AvailabilityZones", hasAvailabilityZones() ? availabilityZones() : null)
                .add("ConnectIps", hasConnectIps() ? connectIps() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "SubnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        case "CustomerUserName":
            return Optional.ofNullable(clazz.cast(customerUserName()));
        case "SecurityGroupId":
            return Optional.ofNullable(clazz.cast(securityGroupId()));
        case "AvailabilityZones":
            return Optional.ofNullable(clazz.cast(availabilityZones()));
        case "ConnectIps":
            return Optional.ofNullable(clazz.cast(connectIps()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DirectoryConnectSettingsDescription, T> g) {
        return obj -> g.apply((DirectoryConnectSettingsDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DirectoryConnectSettingsDescription> {
        /**
         * <p>
         * The identifier of the VPC that the AD Connector is in.
         * </p>
         * 
         * @param vpcId
         *        The identifier of the VPC that the AD Connector is in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * A list of subnet identifiers in the VPC that the AD Connector is in.
         * </p>
         * 
         * @param subnetIds
         *        A list of subnet identifiers in the VPC that the AD Connector is in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * A list of subnet identifiers in the VPC that the AD Connector is in.
         * </p>
         * 
         * @param subnetIds
         *        A list of subnet identifiers in the VPC that the AD Connector is in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * <p>
         * The user name of the service account in your self-managed directory.
         * </p>
         * 
         * @param customerUserName
         *        The user name of the service account in your self-managed directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerUserName(String customerUserName);

        /**
         * <p>
         * The security group identifier for the AD Connector directory.
         * </p>
         * 
         * @param securityGroupId
         *        The security group identifier for the AD Connector directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupId(String securityGroupId);

        /**
         * <p>
         * A list of the Availability Zones that the directory is in.
         * </p>
         * 
         * @param availabilityZones
         *        A list of the Availability Zones that the directory is in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(Collection<String> availabilityZones);

        /**
         * <p>
         * A list of the Availability Zones that the directory is in.
         * </p>
         * 
         * @param availabilityZones
         *        A list of the Availability Zones that the directory is in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(String... availabilityZones);

        /**
         * <p>
         * The IP addresses of the AD Connector servers.
         * </p>
         * 
         * @param connectIps
         *        The IP addresses of the AD Connector servers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectIps(Collection<String> connectIps);

        /**
         * <p>
         * The IP addresses of the AD Connector servers.
         * </p>
         * 
         * @param connectIps
         *        The IP addresses of the AD Connector servers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectIps(String... connectIps);
    }

    static final class BuilderImpl implements Builder {
        private String vpcId;

        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private String customerUserName;

        private String securityGroupId;

        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();

        private List<String> connectIps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DirectoryConnectSettingsDescription model) {
            vpcId(model.vpcId);
            subnetIds(model.subnetIds);
            customerUserName(model.customerUserName);
            securityGroupId(model.securityGroupId);
            availabilityZones(model.availabilityZones);
            connectIps(model.connectIps);
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final String getCustomerUserName() {
            return customerUserName;
        }

        public final void setCustomerUserName(String customerUserName) {
            this.customerUserName = customerUserName;
        }

        @Override
        public final Builder customerUserName(String customerUserName) {
            this.customerUserName = customerUserName;
            return this;
        }

        public final String getSecurityGroupId() {
            return securityGroupId;
        }

        public final void setSecurityGroupId(String securityGroupId) {
            this.securityGroupId = securityGroupId;
        }

        @Override
        public final Builder securityGroupId(String securityGroupId) {
            this.securityGroupId = securityGroupId;
            return this;
        }

        public final Collection<String> getAvailabilityZones() {
            if (availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return availabilityZones;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String... availabilityZones) {
            availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final Collection<String> getConnectIps() {
            if (connectIps instanceof SdkAutoConstructList) {
                return null;
            }
            return connectIps;
        }

        public final void setConnectIps(Collection<String> connectIps) {
            this.connectIps = IpAddrsCopier.copy(connectIps);
        }

        @Override
        public final Builder connectIps(Collection<String> connectIps) {
            this.connectIps = IpAddrsCopier.copy(connectIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectIps(String... connectIps) {
            connectIps(Arrays.asList(connectIps));
            return this;
        }

        @Override
        public DirectoryConnectSettingsDescription build() {
            return new DirectoryConnectSettingsDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
