/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LDAPSType {
    CLIENT("Client"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LDAPSType> VALUE_MAP;
    private final String value;

    private LDAPSType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LDAPSType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LDAPSType> knownValues() {
        EnumSet<LDAPSType> knownValues = EnumSet.allOf(LDAPSType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LDAPSType.class, LDAPSType::toString);
    }
}

