/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateVirtualInterfaceAttributesRequest extends DirectConnectRequest implements
        ToCopyableBuilder<UpdateVirtualInterfaceAttributesRequest.Builder, UpdateVirtualInterfaceAttributesRequest> {
    private static final SdkField<String> VIRTUAL_INTERFACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("virtualInterfaceId").getter(getter(UpdateVirtualInterfaceAttributesRequest::virtualInterfaceId))
            .setter(setter(Builder::virtualInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualInterfaceId").build())
            .build();

    private static final SdkField<Integer> MTU_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("mtu")
            .getter(getter(UpdateVirtualInterfaceAttributesRequest::mtu)).setter(setter(Builder::mtu))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mtu").build()).build();

    private static final SdkField<Boolean> ENABLE_SITE_LINK_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enableSiteLink").getter(getter(UpdateVirtualInterfaceAttributesRequest::enableSiteLink))
            .setter(setter(Builder::enableSiteLink))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableSiteLink").build()).build();

    private static final SdkField<String> VIRTUAL_INTERFACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("virtualInterfaceName").getter(getter(UpdateVirtualInterfaceAttributesRequest::virtualInterfaceName))
            .setter(setter(Builder::virtualInterfaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualInterfaceName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIRTUAL_INTERFACE_ID_FIELD,
            MTU_FIELD, ENABLE_SITE_LINK_FIELD, VIRTUAL_INTERFACE_NAME_FIELD));

    private final String virtualInterfaceId;

    private final Integer mtu;

    private final Boolean enableSiteLink;

    private final String virtualInterfaceName;

    private UpdateVirtualInterfaceAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.virtualInterfaceId = builder.virtualInterfaceId;
        this.mtu = builder.mtu;
        this.enableSiteLink = builder.enableSiteLink;
        this.virtualInterfaceName = builder.virtualInterfaceName;
    }

    /**
     * <p>
     * The ID of the virtual private interface.
     * </p>
     * 
     * @return The ID of the virtual private interface.
     */
    public final String virtualInterfaceId() {
        return virtualInterfaceId;
    }

    /**
     * <p>
     * The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500.
     * </p>
     * 
     * @return The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value
     *         is 1500.
     */
    public final Integer mtu() {
        return mtu;
    }

    /**
     * <p>
     * Indicates whether to enable or disable SiteLink.
     * </p>
     * 
     * @return Indicates whether to enable or disable SiteLink.
     */
    public final Boolean enableSiteLink() {
        return enableSiteLink;
    }

    /**
     * <p>
     * The name of the virtual private interface.
     * </p>
     * 
     * @return The name of the virtual private interface.
     */
    public final String virtualInterfaceName() {
        return virtualInterfaceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(virtualInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(mtu());
        hashCode = 31 * hashCode + Objects.hashCode(enableSiteLink());
        hashCode = 31 * hashCode + Objects.hashCode(virtualInterfaceName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateVirtualInterfaceAttributesRequest)) {
            return false;
        }
        UpdateVirtualInterfaceAttributesRequest other = (UpdateVirtualInterfaceAttributesRequest) obj;
        return Objects.equals(virtualInterfaceId(), other.virtualInterfaceId()) && Objects.equals(mtu(), other.mtu())
                && Objects.equals(enableSiteLink(), other.enableSiteLink())
                && Objects.equals(virtualInterfaceName(), other.virtualInterfaceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateVirtualInterfaceAttributesRequest").add("VirtualInterfaceId", virtualInterfaceId())
                .add("Mtu", mtu()).add("EnableSiteLink", enableSiteLink()).add("VirtualInterfaceName", virtualInterfaceName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "virtualInterfaceId":
            return Optional.ofNullable(clazz.cast(virtualInterfaceId()));
        case "mtu":
            return Optional.ofNullable(clazz.cast(mtu()));
        case "enableSiteLink":
            return Optional.ofNullable(clazz.cast(enableSiteLink()));
        case "virtualInterfaceName":
            return Optional.ofNullable(clazz.cast(virtualInterfaceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateVirtualInterfaceAttributesRequest, T> g) {
        return obj -> g.apply((UpdateVirtualInterfaceAttributesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectConnectRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateVirtualInterfaceAttributesRequest> {
        /**
         * <p>
         * The ID of the virtual private interface.
         * </p>
         * 
         * @param virtualInterfaceId
         *        The ID of the virtual private interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualInterfaceId(String virtualInterfaceId);

        /**
         * <p>
         * The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is
         * 1500.
         * </p>
         * 
         * @param mtu
         *        The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default
         *        value is 1500.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mtu(Integer mtu);

        /**
         * <p>
         * Indicates whether to enable or disable SiteLink.
         * </p>
         * 
         * @param enableSiteLink
         *        Indicates whether to enable or disable SiteLink.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableSiteLink(Boolean enableSiteLink);

        /**
         * <p>
         * The name of the virtual private interface.
         * </p>
         * 
         * @param virtualInterfaceName
         *        The name of the virtual private interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualInterfaceName(String virtualInterfaceName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DirectConnectRequest.BuilderImpl implements Builder {
        private String virtualInterfaceId;

        private Integer mtu;

        private Boolean enableSiteLink;

        private String virtualInterfaceName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateVirtualInterfaceAttributesRequest model) {
            super(model);
            virtualInterfaceId(model.virtualInterfaceId);
            mtu(model.mtu);
            enableSiteLink(model.enableSiteLink);
            virtualInterfaceName(model.virtualInterfaceName);
        }

        public final String getVirtualInterfaceId() {
            return virtualInterfaceId;
        }

        public final void setVirtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
        }

        @Override
        public final Builder virtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
            return this;
        }

        public final Integer getMtu() {
            return mtu;
        }

        public final void setMtu(Integer mtu) {
            this.mtu = mtu;
        }

        @Override
        public final Builder mtu(Integer mtu) {
            this.mtu = mtu;
            return this;
        }

        public final Boolean getEnableSiteLink() {
            return enableSiteLink;
        }

        public final void setEnableSiteLink(Boolean enableSiteLink) {
            this.enableSiteLink = enableSiteLink;
        }

        @Override
        public final Builder enableSiteLink(Boolean enableSiteLink) {
            this.enableSiteLink = enableSiteLink;
            return this;
        }

        public final String getVirtualInterfaceName() {
            return virtualInterfaceName;
        }

        public final void setVirtualInterfaceName(String virtualInterfaceName) {
            this.virtualInterfaceName = virtualInterfaceName;
        }

        @Override
        public final Builder virtualInterfaceName(String virtualInterfaceName) {
            this.virtualInterfaceName = virtualInterfaceName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateVirtualInterfaceAttributesRequest build() {
            return new UpdateVirtualInterfaceAttributesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
