/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateMacSecKeyRequest extends DirectConnectRequest implements
        ToCopyableBuilder<AssociateMacSecKeyRequest.Builder, AssociateMacSecKeyRequest> {
    private static final SdkField<String> CONNECTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectionId").getter(getter(AssociateMacSecKeyRequest::connectionId))
            .setter(setter(Builder::connectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionId").build()).build();

    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("secretARN").getter(getter(AssociateMacSecKeyRequest::secretARN)).setter(setter(Builder::secretARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretARN").build()).build();

    private static final SdkField<String> CKN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ckn")
            .getter(getter(AssociateMacSecKeyRequest::ckn)).setter(setter(Builder::ckn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ckn").build()).build();

    private static final SdkField<String> CAK_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("cak")
            .getter(getter(AssociateMacSecKeyRequest::cak)).setter(setter(Builder::cak))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cak").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_ID_FIELD,
            SECRET_ARN_FIELD, CKN_FIELD, CAK_FIELD));

    private final String connectionId;

    private final String secretARN;

    private final String ckn;

    private final String cak;

    private AssociateMacSecKeyRequest(BuilderImpl builder) {
        super(builder);
        this.connectionId = builder.connectionId;
        this.secretARN = builder.secretARN;
        this.ckn = builder.ckn;
        this.cak = builder.cak;
    }

    /**
     * <p>
     * The ID of the dedicated connection (dxcon-xxxx), or the ID of the LAG (dxlag-xxxx).
     * </p>
     * <p>
     * You can use <a>DescribeConnections</a> or <a>DescribeLags</a> to retrieve connection ID.
     * </p>
     * 
     * @return The ID of the dedicated connection (dxcon-xxxx), or the ID of the LAG (dxlag-xxxx).</p>
     *         <p>
     *         You can use <a>DescribeConnections</a> or <a>DescribeLags</a> to retrieve connection ID.
     */
    public final String connectionId() {
        return connectionId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the MAC Security (MACsec) secret key to associate with the dedicated
     * connection.
     * </p>
     * <p>
     * You can use <a>DescribeConnections</a> or <a>DescribeLags</a> to retrieve the MAC Security (MACsec) secret key.
     * </p>
     * <p>
     * If you use this request parameter, you do not use the <code>ckn</code> and <code>cak</code> request parameters.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the MAC Security (MACsec) secret key to associate with the dedicated
     *         connection.</p>
     *         <p>
     *         You can use <a>DescribeConnections</a> or <a>DescribeLags</a> to retrieve the MAC Security (MACsec)
     *         secret key.
     *         </p>
     *         <p>
     *         If you use this request parameter, you do not use the <code>ckn</code> and <code>cak</code> request
     *         parameters.
     */
    public final String secretARN() {
        return secretARN;
    }

    /**
     * <p>
     * The MAC Security (MACsec) CKN to associate with the dedicated connection.
     * </p>
     * <p>
     * You can create the CKN/CAK pair using an industry standard tool.
     * </p>
     * <p>
     * The valid values are 64 hexadecimal characters (0-9, A-E).
     * </p>
     * <p>
     * If you use this request parameter, you must use the <code>cak</code> request parameter and not use the
     * <code>secretARN</code> request parameter.
     * </p>
     * 
     * @return The MAC Security (MACsec) CKN to associate with the dedicated connection.</p>
     *         <p>
     *         You can create the CKN/CAK pair using an industry standard tool.
     *         </p>
     *         <p>
     *         The valid values are 64 hexadecimal characters (0-9, A-E).
     *         </p>
     *         <p>
     *         If you use this request parameter, you must use the <code>cak</code> request parameter and not use the
     *         <code>secretARN</code> request parameter.
     */
    public final String ckn() {
        return ckn;
    }

    /**
     * <p>
     * The MAC Security (MACsec) CAK to associate with the dedicated connection.
     * </p>
     * <p>
     * You can create the CKN/CAK pair using an industry standard tool.
     * </p>
     * <p>
     * The valid values are 64 hexadecimal characters (0-9, A-E).
     * </p>
     * <p>
     * If you use this request parameter, you must use the <code>ckn</code> request parameter and not use the
     * <code>secretARN</code> request parameter.
     * </p>
     * 
     * @return The MAC Security (MACsec) CAK to associate with the dedicated connection.</p>
     *         <p>
     *         You can create the CKN/CAK pair using an industry standard tool.
     *         </p>
     *         <p>
     *         The valid values are 64 hexadecimal characters (0-9, A-E).
     *         </p>
     *         <p>
     *         If you use this request parameter, you must use the <code>ckn</code> request parameter and not use the
     *         <code>secretARN</code> request parameter.
     */
    public final String cak() {
        return cak;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(secretARN());
        hashCode = 31 * hashCode + Objects.hashCode(ckn());
        hashCode = 31 * hashCode + Objects.hashCode(cak());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateMacSecKeyRequest)) {
            return false;
        }
        AssociateMacSecKeyRequest other = (AssociateMacSecKeyRequest) obj;
        return Objects.equals(connectionId(), other.connectionId()) && Objects.equals(secretARN(), other.secretARN())
                && Objects.equals(ckn(), other.ckn()) && Objects.equals(cak(), other.cak());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateMacSecKeyRequest").add("ConnectionId", connectionId()).add("SecretARN", secretARN())
                .add("Ckn", ckn()).add("Cak", cak()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connectionId":
            return Optional.ofNullable(clazz.cast(connectionId()));
        case "secretARN":
            return Optional.ofNullable(clazz.cast(secretARN()));
        case "ckn":
            return Optional.ofNullable(clazz.cast(ckn()));
        case "cak":
            return Optional.ofNullable(clazz.cast(cak()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateMacSecKeyRequest, T> g) {
        return obj -> g.apply((AssociateMacSecKeyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, AssociateMacSecKeyRequest> {
        /**
         * <p>
         * The ID of the dedicated connection (dxcon-xxxx), or the ID of the LAG (dxlag-xxxx).
         * </p>
         * <p>
         * You can use <a>DescribeConnections</a> or <a>DescribeLags</a> to retrieve connection ID.
         * </p>
         * 
         * @param connectionId
         *        The ID of the dedicated connection (dxcon-xxxx), or the ID of the LAG (dxlag-xxxx).</p>
         *        <p>
         *        You can use <a>DescribeConnections</a> or <a>DescribeLags</a> to retrieve connection ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionId(String connectionId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the MAC Security (MACsec) secret key to associate with the dedicated
         * connection.
         * </p>
         * <p>
         * You can use <a>DescribeConnections</a> or <a>DescribeLags</a> to retrieve the MAC Security (MACsec) secret
         * key.
         * </p>
         * <p>
         * If you use this request parameter, you do not use the <code>ckn</code> and <code>cak</code> request
         * parameters.
         * </p>
         * 
         * @param secretARN
         *        The Amazon Resource Name (ARN) of the MAC Security (MACsec) secret key to associate with the dedicated
         *        connection.</p>
         *        <p>
         *        You can use <a>DescribeConnections</a> or <a>DescribeLags</a> to retrieve the MAC Security (MACsec)
         *        secret key.
         *        </p>
         *        <p>
         *        If you use this request parameter, you do not use the <code>ckn</code> and <code>cak</code> request
         *        parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretARN(String secretARN);

        /**
         * <p>
         * The MAC Security (MACsec) CKN to associate with the dedicated connection.
         * </p>
         * <p>
         * You can create the CKN/CAK pair using an industry standard tool.
         * </p>
         * <p>
         * The valid values are 64 hexadecimal characters (0-9, A-E).
         * </p>
         * <p>
         * If you use this request parameter, you must use the <code>cak</code> request parameter and not use the
         * <code>secretARN</code> request parameter.
         * </p>
         * 
         * @param ckn
         *        The MAC Security (MACsec) CKN to associate with the dedicated connection.</p>
         *        <p>
         *        You can create the CKN/CAK pair using an industry standard tool.
         *        </p>
         *        <p>
         *        The valid values are 64 hexadecimal characters (0-9, A-E).
         *        </p>
         *        <p>
         *        If you use this request parameter, you must use the <code>cak</code> request parameter and not use the
         *        <code>secretARN</code> request parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ckn(String ckn);

        /**
         * <p>
         * The MAC Security (MACsec) CAK to associate with the dedicated connection.
         * </p>
         * <p>
         * You can create the CKN/CAK pair using an industry standard tool.
         * </p>
         * <p>
         * The valid values are 64 hexadecimal characters (0-9, A-E).
         * </p>
         * <p>
         * If you use this request parameter, you must use the <code>ckn</code> request parameter and not use the
         * <code>secretARN</code> request parameter.
         * </p>
         * 
         * @param cak
         *        The MAC Security (MACsec) CAK to associate with the dedicated connection.</p>
         *        <p>
         *        You can create the CKN/CAK pair using an industry standard tool.
         *        </p>
         *        <p>
         *        The valid values are 64 hexadecimal characters (0-9, A-E).
         *        </p>
         *        <p>
         *        If you use this request parameter, you must use the <code>ckn</code> request parameter and not use the
         *        <code>secretARN</code> request parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cak(String cak);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DirectConnectRequest.BuilderImpl implements Builder {
        private String connectionId;

        private String secretARN;

        private String ckn;

        private String cak;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateMacSecKeyRequest model) {
            super(model);
            connectionId(model.connectionId);
            secretARN(model.secretARN);
            ckn(model.ckn);
            cak(model.cak);
        }

        public final String getConnectionId() {
            return connectionId;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final String getSecretARN() {
            return secretARN;
        }

        public final void setSecretARN(String secretARN) {
            this.secretARN = secretARN;
        }

        @Override
        public final Builder secretARN(String secretARN) {
            this.secretARN = secretARN;
            return this;
        }

        public final String getCkn() {
            return ckn;
        }

        public final void setCkn(String ckn) {
            this.ckn = ckn;
        }

        @Override
        public final Builder ckn(String ckn) {
            this.ckn = ckn;
            return this;
        }

        public final String getCak() {
            return cak;
        }

        public final void setCak(String cak) {
            this.cak = cak;
        }

        @Override
        public final Builder cak(String cak) {
            this.cak = cak;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateMacSecKeyRequest build() {
            return new AssociateMacSecKeyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
