/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListVirtualInterfaceTestHistoryRequest extends DirectConnectRequest implements
        ToCopyableBuilder<ListVirtualInterfaceTestHistoryRequest.Builder, ListVirtualInterfaceTestHistoryRequest> {
    private static final SdkField<String> TEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("testId")
            .getter(getter(ListVirtualInterfaceTestHistoryRequest::testId)).setter(setter(Builder::testId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testId").build()).build();

    private static final SdkField<String> VIRTUAL_INTERFACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("virtualInterfaceId").getter(getter(ListVirtualInterfaceTestHistoryRequest::virtualInterfaceId))
            .setter(setter(Builder::virtualInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualInterfaceId").build())
            .build();

    private static final SdkField<List<String>> BGP_PEERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("bgpPeers")
            .getter(getter(ListVirtualInterfaceTestHistoryRequest::bgpPeers))
            .setter(setter(Builder::bgpPeers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bgpPeers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ListVirtualInterfaceTestHistoryRequest::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListVirtualInterfaceTestHistoryRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListVirtualInterfaceTestHistoryRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_ID_FIELD,
            VIRTUAL_INTERFACE_ID_FIELD, BGP_PEERS_FIELD, STATUS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String testId;

    private final String virtualInterfaceId;

    private final List<String> bgpPeers;

    private final String status;

    private final Integer maxResults;

    private final String nextToken;

    private ListVirtualInterfaceTestHistoryRequest(BuilderImpl builder) {
        super(builder);
        this.testId = builder.testId;
        this.virtualInterfaceId = builder.virtualInterfaceId;
        this.bgpPeers = builder.bgpPeers;
        this.status = builder.status;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The ID of the virtual interface failover test.
     * </p>
     * 
     * @return The ID of the virtual interface failover test.
     */
    public final String testId() {
        return testId;
    }

    /**
     * <p>
     * The ID of the virtual interface that was tested.
     * </p>
     * 
     * @return The ID of the virtual interface that was tested.
     */
    public final String virtualInterfaceId() {
        return virtualInterfaceId;
    }

    /**
     * For responses, this returns true if the service returned a value for the BgpPeers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasBgpPeers() {
        return bgpPeers != null && !(bgpPeers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The BGP peers that were placed in the DOWN state during the virtual interface failover test.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBgpPeers} method.
     * </p>
     * 
     * @return The BGP peers that were placed in the DOWN state during the virtual interface failover test.
     */
    public final List<String> bgpPeers() {
        return bgpPeers;
    }

    /**
     * <p>
     * The status of the virtual interface failover test.
     * </p>
     * 
     * @return The status of the virtual interface failover test.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The maximum number of results to return with a single call. To retrieve the remaining results, make another call
     * with the returned <code>nextToken</code> value.
     * </p>
     * <p>
     * If <code>MaxResults</code> is given a value larger than 100, only 100 results are returned.
     * </p>
     * 
     * @return The maximum number of results to return with a single call. To retrieve the remaining results, make
     *         another call with the returned <code>nextToken</code> value.</p>
     *         <p>
     *         If <code>MaxResults</code> is given a value larger than 100, only 100 results are returned.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next page of results.
     * </p>
     * 
     * @return The token for the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(testId());
        hashCode = 31 * hashCode + Objects.hashCode(virtualInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(hasBgpPeers() ? bgpPeers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVirtualInterfaceTestHistoryRequest)) {
            return false;
        }
        ListVirtualInterfaceTestHistoryRequest other = (ListVirtualInterfaceTestHistoryRequest) obj;
        return Objects.equals(testId(), other.testId()) && Objects.equals(virtualInterfaceId(), other.virtualInterfaceId())
                && hasBgpPeers() == other.hasBgpPeers() && Objects.equals(bgpPeers(), other.bgpPeers())
                && Objects.equals(status(), other.status()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListVirtualInterfaceTestHistoryRequest").add("TestId", testId())
                .add("VirtualInterfaceId", virtualInterfaceId()).add("BgpPeers", hasBgpPeers() ? bgpPeers() : null)
                .add("Status", status()).add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "testId":
            return Optional.ofNullable(clazz.cast(testId()));
        case "virtualInterfaceId":
            return Optional.ofNullable(clazz.cast(virtualInterfaceId()));
        case "bgpPeers":
            return Optional.ofNullable(clazz.cast(bgpPeers()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListVirtualInterfaceTestHistoryRequest, T> g) {
        return obj -> g.apply((ListVirtualInterfaceTestHistoryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectConnectRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListVirtualInterfaceTestHistoryRequest> {
        /**
         * <p>
         * The ID of the virtual interface failover test.
         * </p>
         * 
         * @param testId
         *        The ID of the virtual interface failover test.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testId(String testId);

        /**
         * <p>
         * The ID of the virtual interface that was tested.
         * </p>
         * 
         * @param virtualInterfaceId
         *        The ID of the virtual interface that was tested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualInterfaceId(String virtualInterfaceId);

        /**
         * <p>
         * The BGP peers that were placed in the DOWN state during the virtual interface failover test.
         * </p>
         * 
         * @param bgpPeers
         *        The BGP peers that were placed in the DOWN state during the virtual interface failover test.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bgpPeers(Collection<String> bgpPeers);

        /**
         * <p>
         * The BGP peers that were placed in the DOWN state during the virtual interface failover test.
         * </p>
         * 
         * @param bgpPeers
         *        The BGP peers that were placed in the DOWN state during the virtual interface failover test.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bgpPeers(String... bgpPeers);

        /**
         * <p>
         * The status of the virtual interface failover test.
         * </p>
         * 
         * @param status
         *        The status of the virtual interface failover test.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The maximum number of results to return with a single call. To retrieve the remaining results, make another
         * call with the returned <code>nextToken</code> value.
         * </p>
         * <p>
         * If <code>MaxResults</code> is given a value larger than 100, only 100 results are returned.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return with a single call. To retrieve the remaining results, make
         *        another call with the returned <code>nextToken</code> value.</p>
         *        <p>
         *        If <code>MaxResults</code> is given a value larger than 100, only 100 results are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DirectConnectRequest.BuilderImpl implements Builder {
        private String testId;

        private String virtualInterfaceId;

        private List<String> bgpPeers = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListVirtualInterfaceTestHistoryRequest model) {
            super(model);
            testId(model.testId);
            virtualInterfaceId(model.virtualInterfaceId);
            bgpPeers(model.bgpPeers);
            status(model.status);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getTestId() {
            return testId;
        }

        public final void setTestId(String testId) {
            this.testId = testId;
        }

        @Override
        public final Builder testId(String testId) {
            this.testId = testId;
            return this;
        }

        public final String getVirtualInterfaceId() {
            return virtualInterfaceId;
        }

        public final void setVirtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
        }

        @Override
        public final Builder virtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
            return this;
        }

        public final Collection<String> getBgpPeers() {
            if (bgpPeers instanceof SdkAutoConstructList) {
                return null;
            }
            return bgpPeers;
        }

        public final void setBgpPeers(Collection<String> bgpPeers) {
            this.bgpPeers = BGPPeerIdListCopier.copy(bgpPeers);
        }

        @Override
        public final Builder bgpPeers(Collection<String> bgpPeers) {
            this.bgpPeers = BGPPeerIdListCopier.copy(bgpPeers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bgpPeers(String... bgpPeers) {
            bgpPeers(Arrays.asList(bgpPeers));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListVirtualInterfaceTestHistoryRequest build() {
            return new ListVirtualInterfaceTestHistoryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
