/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directconnect.model.DirectConnectRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDirectConnectGatewayAssociationsRequest
extends DirectConnectRequest
implements ToCopyableBuilder<Builder, DescribeDirectConnectGatewayAssociationsRequest> {
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("associationId").getter(DescribeDirectConnectGatewayAssociationsRequest.getter(DescribeDirectConnectGatewayAssociationsRequest::associationId)).setter(DescribeDirectConnectGatewayAssociationsRequest.setter(Builder::associationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationId").build()}).build();
    private static final SdkField<String> ASSOCIATED_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("associatedGatewayId").getter(DescribeDirectConnectGatewayAssociationsRequest.getter(DescribeDirectConnectGatewayAssociationsRequest::associatedGatewayId)).setter(DescribeDirectConnectGatewayAssociationsRequest.setter(Builder::associatedGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedGatewayId").build()}).build();
    private static final SdkField<String> DIRECT_CONNECT_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("directConnectGatewayId").getter(DescribeDirectConnectGatewayAssociationsRequest.getter(DescribeDirectConnectGatewayAssociationsRequest::directConnectGatewayId)).setter(DescribeDirectConnectGatewayAssociationsRequest.setter(Builder::directConnectGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directConnectGatewayId").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(DescribeDirectConnectGatewayAssociationsRequest.getter(DescribeDirectConnectGatewayAssociationsRequest::maxResults)).setter(DescribeDirectConnectGatewayAssociationsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeDirectConnectGatewayAssociationsRequest.getter(DescribeDirectConnectGatewayAssociationsRequest::nextToken)).setter(DescribeDirectConnectGatewayAssociationsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<String> VIRTUAL_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("virtualGatewayId").getter(DescribeDirectConnectGatewayAssociationsRequest.getter(DescribeDirectConnectGatewayAssociationsRequest::virtualGatewayId)).setter(DescribeDirectConnectGatewayAssociationsRequest.setter(Builder::virtualGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualGatewayId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_ID_FIELD, ASSOCIATED_GATEWAY_ID_FIELD, DIRECT_CONNECT_GATEWAY_ID_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, VIRTUAL_GATEWAY_ID_FIELD));
    private final String associationId;
    private final String associatedGatewayId;
    private final String directConnectGatewayId;
    private final Integer maxResults;
    private final String nextToken;
    private final String virtualGatewayId;

    private DescribeDirectConnectGatewayAssociationsRequest(BuilderImpl builder) {
        super(builder);
        this.associationId = builder.associationId;
        this.associatedGatewayId = builder.associatedGatewayId;
        this.directConnectGatewayId = builder.directConnectGatewayId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.virtualGatewayId = builder.virtualGatewayId;
    }

    public final String associationId() {
        return this.associationId;
    }

    public final String associatedGatewayId() {
        return this.associatedGatewayId;
    }

    public final String directConnectGatewayId() {
        return this.directConnectGatewayId;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String virtualGatewayId() {
        return this.virtualGatewayId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.associationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.associatedGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.directConnectGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualGatewayId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDirectConnectGatewayAssociationsRequest)) {
            return false;
        }
        DescribeDirectConnectGatewayAssociationsRequest other = (DescribeDirectConnectGatewayAssociationsRequest)((Object)obj);
        return Objects.equals(this.associationId(), other.associationId()) && Objects.equals(this.associatedGatewayId(), other.associatedGatewayId()) && Objects.equals(this.directConnectGatewayId(), other.directConnectGatewayId()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.virtualGatewayId(), other.virtualGatewayId());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDirectConnectGatewayAssociationsRequest").add("AssociationId", (Object)this.associationId()).add("AssociatedGatewayId", (Object)this.associatedGatewayId()).add("DirectConnectGatewayId", (Object)this.directConnectGatewayId()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("VirtualGatewayId", (Object)this.virtualGatewayId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "associationId": {
                return Optional.ofNullable(clazz.cast(this.associationId()));
            }
            case "associatedGatewayId": {
                return Optional.ofNullable(clazz.cast(this.associatedGatewayId()));
            }
            case "directConnectGatewayId": {
                return Optional.ofNullable(clazz.cast(this.directConnectGatewayId()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "virtualGatewayId": {
                return Optional.ofNullable(clazz.cast(this.virtualGatewayId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDirectConnectGatewayAssociationsRequest, T> g) {
        return obj -> g.apply((DescribeDirectConnectGatewayAssociationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectConnectRequest.BuilderImpl
    implements Builder {
        private String associationId;
        private String associatedGatewayId;
        private String directConnectGatewayId;
        private Integer maxResults;
        private String nextToken;
        private String virtualGatewayId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDirectConnectGatewayAssociationsRequest model) {
            super(model);
            this.associationId(model.associationId);
            this.associatedGatewayId(model.associatedGatewayId);
            this.directConnectGatewayId(model.directConnectGatewayId);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.virtualGatewayId(model.virtualGatewayId);
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final String getAssociatedGatewayId() {
            return this.associatedGatewayId;
        }

        public final void setAssociatedGatewayId(String associatedGatewayId) {
            this.associatedGatewayId = associatedGatewayId;
        }

        @Override
        public final Builder associatedGatewayId(String associatedGatewayId) {
            this.associatedGatewayId = associatedGatewayId;
            return this;
        }

        public final String getDirectConnectGatewayId() {
            return this.directConnectGatewayId;
        }

        public final void setDirectConnectGatewayId(String directConnectGatewayId) {
            this.directConnectGatewayId = directConnectGatewayId;
        }

        @Override
        public final Builder directConnectGatewayId(String directConnectGatewayId) {
            this.directConnectGatewayId = directConnectGatewayId;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getVirtualGatewayId() {
            return this.virtualGatewayId;
        }

        public final void setVirtualGatewayId(String virtualGatewayId) {
            this.virtualGatewayId = virtualGatewayId;
        }

        @Override
        public final Builder virtualGatewayId(String virtualGatewayId) {
            this.virtualGatewayId = virtualGatewayId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeDirectConnectGatewayAssociationsRequest build() {
            return new DescribeDirectConnectGatewayAssociationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DirectConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDirectConnectGatewayAssociationsRequest> {
        public Builder associationId(String var1);

        public Builder associatedGatewayId(String var1);

        public Builder directConnectGatewayId(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder virtualGatewayId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

