/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.detective.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDatasourcePackagesRequest extends DetectiveRequest implements
        ToCopyableBuilder<UpdateDatasourcePackagesRequest.Builder, UpdateDatasourcePackagesRequest> {
    private static final SdkField<String> GRAPH_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GraphArn").getter(getter(UpdateDatasourcePackagesRequest::graphArn)).setter(setter(Builder::graphArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GraphArn").build()).build();

    private static final SdkField<List<String>> DATASOURCE_PACKAGES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DatasourcePackages")
            .getter(getter(UpdateDatasourcePackagesRequest::datasourcePackagesAsStrings))
            .setter(setter(Builder::datasourcePackagesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasourcePackages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRAPH_ARN_FIELD,
            DATASOURCE_PACKAGES_FIELD));

    private final String graphArn;

    private final List<String> datasourcePackages;

    private UpdateDatasourcePackagesRequest(BuilderImpl builder) {
        super(builder);
        this.graphArn = builder.graphArn;
        this.datasourcePackages = builder.datasourcePackages;
    }

    /**
     * <p>
     * The ARN of the behavior graph.
     * </p>
     * 
     * @return The ARN of the behavior graph.
     */
    public final String graphArn() {
        return graphArn;
    }

    /**
     * <p>
     * The data source package start for the behavior graph.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDatasourcePackages} method.
     * </p>
     * 
     * @return The data source package start for the behavior graph.
     */
    public final List<DatasourcePackage> datasourcePackages() {
        return DatasourcePackageListCopier.copyStringToEnum(datasourcePackages);
    }

    /**
     * For responses, this returns true if the service returned a value for the DatasourcePackages property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDatasourcePackages() {
        return datasourcePackages != null && !(datasourcePackages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The data source package start for the behavior graph.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDatasourcePackages} method.
     * </p>
     * 
     * @return The data source package start for the behavior graph.
     */
    public final List<String> datasourcePackagesAsStrings() {
        return datasourcePackages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(graphArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasDatasourcePackages() ? datasourcePackagesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDatasourcePackagesRequest)) {
            return false;
        }
        UpdateDatasourcePackagesRequest other = (UpdateDatasourcePackagesRequest) obj;
        return Objects.equals(graphArn(), other.graphArn()) && hasDatasourcePackages() == other.hasDatasourcePackages()
                && Objects.equals(datasourcePackagesAsStrings(), other.datasourcePackagesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDatasourcePackagesRequest").add("GraphArn", graphArn())
                .add("DatasourcePackages", hasDatasourcePackages() ? datasourcePackagesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GraphArn":
            return Optional.ofNullable(clazz.cast(graphArn()));
        case "DatasourcePackages":
            return Optional.ofNullable(clazz.cast(datasourcePackagesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDatasourcePackagesRequest, T> g) {
        return obj -> g.apply((UpdateDatasourcePackagesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DetectiveRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDatasourcePackagesRequest> {
        /**
         * <p>
         * The ARN of the behavior graph.
         * </p>
         * 
         * @param graphArn
         *        The ARN of the behavior graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder graphArn(String graphArn);

        /**
         * <p>
         * The data source package start for the behavior graph.
         * </p>
         * 
         * @param datasourcePackages
         *        The data source package start for the behavior graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasourcePackagesWithStrings(Collection<String> datasourcePackages);

        /**
         * <p>
         * The data source package start for the behavior graph.
         * </p>
         * 
         * @param datasourcePackages
         *        The data source package start for the behavior graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasourcePackagesWithStrings(String... datasourcePackages);

        /**
         * <p>
         * The data source package start for the behavior graph.
         * </p>
         * 
         * @param datasourcePackages
         *        The data source package start for the behavior graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasourcePackages(Collection<DatasourcePackage> datasourcePackages);

        /**
         * <p>
         * The data source package start for the behavior graph.
         * </p>
         * 
         * @param datasourcePackages
         *        The data source package start for the behavior graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasourcePackages(DatasourcePackage... datasourcePackages);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DetectiveRequest.BuilderImpl implements Builder {
        private String graphArn;

        private List<String> datasourcePackages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDatasourcePackagesRequest model) {
            super(model);
            graphArn(model.graphArn);
            datasourcePackagesWithStrings(model.datasourcePackages);
        }

        public final String getGraphArn() {
            return graphArn;
        }

        public final void setGraphArn(String graphArn) {
            this.graphArn = graphArn;
        }

        @Override
        public final Builder graphArn(String graphArn) {
            this.graphArn = graphArn;
            return this;
        }

        public final Collection<String> getDatasourcePackages() {
            if (datasourcePackages instanceof SdkAutoConstructList) {
                return null;
            }
            return datasourcePackages;
        }

        public final void setDatasourcePackages(Collection<String> datasourcePackages) {
            this.datasourcePackages = DatasourcePackageListCopier.copy(datasourcePackages);
        }

        @Override
        public final Builder datasourcePackagesWithStrings(Collection<String> datasourcePackages) {
            this.datasourcePackages = DatasourcePackageListCopier.copy(datasourcePackages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasourcePackagesWithStrings(String... datasourcePackages) {
            datasourcePackagesWithStrings(Arrays.asList(datasourcePackages));
            return this;
        }

        @Override
        public final Builder datasourcePackages(Collection<DatasourcePackage> datasourcePackages) {
            this.datasourcePackages = DatasourcePackageListCopier.copyEnumToString(datasourcePackages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasourcePackages(DatasourcePackage... datasourcePackages) {
            datasourcePackages(Arrays.asList(datasourcePackages));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDatasourcePackagesRequest build() {
            return new UpdateDatasourcePackagesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
