/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The topic of the notification.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Topic implements SdkPojo, Serializable, ToCopyableBuilder<Topic.Builder, Topic> {
    private static final SdkField<NotificationResource> RESOURCE_FIELD = SdkField
            .<NotificationResource> builder(MarshallingType.SDK_POJO).memberName("resource").getter(getter(Topic::resource))
            .setter(setter(Builder::resource)).constructor(NotificationResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("role")
            .getter(getter(Topic::roleAsString)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("role").build()).build();

    private static final SdkField<String> SUBJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("subject")
            .getter(getter(Topic::subject)).setter(setter(Builder::subject))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subject").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_FIELD, ROLE_FIELD,
            SUBJECT_FIELD));

    private static final long serialVersionUID = 1L;

    private final NotificationResource resource;

    private final String role;

    private final String subject;

    private Topic(BuilderImpl builder) {
        this.resource = builder.resource;
        this.role = builder.role;
        this.subject = builder.subject;
    }

    /**
     * Returns the value of the Resource property for this object.
     * 
     * @return The value of the Resource property for this object.
     */
    public final NotificationResource resource() {
        return resource;
    }

    /**
     * <p>
     * The role of the resource mentioned in a notification.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #role} will return
     * {@link NotificationRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleAsString}.
     * </p>
     * 
     * @return The role of the resource mentioned in a notification.
     * @see NotificationRole
     */
    public final NotificationRole role() {
        return NotificationRole.fromValue(role);
    }

    /**
     * <p>
     * The role of the resource mentioned in a notification.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #role} will return
     * {@link NotificationRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleAsString}.
     * </p>
     * 
     * @return The role of the resource mentioned in a notification.
     * @see NotificationRole
     */
    public final String roleAsString() {
        return role;
    }

    /**
     * <p>
     * The subject of the resource mentioned in a notification.
     * </p>
     * 
     * @return The subject of the resource mentioned in a notification.
     */
    public final String subject() {
        return subject;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        hashCode = 31 * hashCode + Objects.hashCode(roleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(subject());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Topic)) {
            return false;
        }
        Topic other = (Topic) obj;
        return Objects.equals(resource(), other.resource()) && Objects.equals(roleAsString(), other.roleAsString())
                && Objects.equals(subject(), other.subject());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Topic").add("Resource", resource()).add("Role", roleAsString()).add("Subject", subject())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resource":
            return Optional.ofNullable(clazz.cast(resource()));
        case "role":
            return Optional.ofNullable(clazz.cast(roleAsString()));
        case "subject":
            return Optional.ofNullable(clazz.cast(subject()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Topic, T> g) {
        return obj -> g.apply((Topic) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Topic> {
        /**
         * Sets the value of the Resource property for this object.
         *
         * @param resource
         *        The new value for the Resource property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(NotificationResource resource);

        /**
         * Sets the value of the Resource property for this object.
         *
         * This is a convenience method that creates an instance of the {@link NotificationResource.Builder} avoiding
         * the need to create one manually via {@link NotificationResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NotificationResource.Builder#build()} is called immediately and
         * its result is passed to {@link #resource(NotificationResource)}.
         * 
         * @param resource
         *        a consumer that will call methods on {@link NotificationResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resource(NotificationResource)
         */
        default Builder resource(Consumer<NotificationResource.Builder> resource) {
            return resource(NotificationResource.builder().applyMutation(resource).build());
        }

        /**
         * <p>
         * The role of the resource mentioned in a notification.
         * </p>
         * 
         * @param role
         *        The role of the resource mentioned in a notification.
         * @see NotificationRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationRole
         */
        Builder role(String role);

        /**
         * <p>
         * The role of the resource mentioned in a notification.
         * </p>
         * 
         * @param role
         *        The role of the resource mentioned in a notification.
         * @see NotificationRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationRole
         */
        Builder role(NotificationRole role);

        /**
         * <p>
         * The subject of the resource mentioned in a notification.
         * </p>
         * 
         * @param subject
         *        The subject of the resource mentioned in a notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subject(String subject);
    }

    static final class BuilderImpl implements Builder {
        private NotificationResource resource;

        private String role;

        private String subject;

        private BuilderImpl() {
        }

        private BuilderImpl(Topic model) {
            resource(model.resource);
            role(model.role);
            subject(model.subject);
        }

        public final NotificationResource.Builder getResource() {
            return resource != null ? resource.toBuilder() : null;
        }

        public final void setResource(NotificationResource.BuilderImpl resource) {
            this.resource = resource != null ? resource.build() : null;
        }

        @Override
        public final Builder resource(NotificationResource resource) {
            this.resource = resource;
            return this;
        }

        public final String getRole() {
            return role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        @Override
        public final Builder role(NotificationRole role) {
            this.role(role == null ? null : role.toString());
            return this;
        }

        public final String getSubject() {
            return subject;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        @Override
        public Topic build() {
            return new Topic(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
