/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of the subscription request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SubscriptionRequestSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<SubscriptionRequestSummary.Builder, SubscriptionRequestSummary> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(SubscriptionRequestSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(SubscriptionRequestSummary::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<String> DECISION_COMMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("decisionComment").getter(getter(SubscriptionRequestSummary::decisionComment))
            .setter(setter(Builder::decisionComment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decisionComment").build()).build();

    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainId").getter(getter(SubscriptionRequestSummary::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(SubscriptionRequestSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> REQUEST_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("requestReason").getter(getter(SubscriptionRequestSummary::requestReason))
            .setter(setter(Builder::requestReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestReason").build()).build();

    private static final SdkField<String> REVIEWER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("reviewerId").getter(getter(SubscriptionRequestSummary::reviewerId)).setter(setter(Builder::reviewerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reviewerId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(SubscriptionRequestSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<List<SubscribedListing>> SUBSCRIBED_LISTINGS_FIELD = SdkField
            .<List<SubscribedListing>> builder(MarshallingType.LIST)
            .memberName("subscribedListings")
            .getter(getter(SubscriptionRequestSummary::subscribedListings))
            .setter(setter(Builder::subscribedListings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscribedListings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SubscribedListing> builder(MarshallingType.SDK_POJO)
                                            .constructor(SubscribedListing::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SubscribedPrincipal>> SUBSCRIBED_PRINCIPALS_FIELD = SdkField
            .<List<SubscribedPrincipal>> builder(MarshallingType.LIST)
            .memberName("subscribedPrincipals")
            .getter(getter(SubscriptionRequestSummary::subscribedPrincipals))
            .setter(setter(Builder::subscribedPrincipals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscribedPrincipals").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SubscribedPrincipal> builder(MarshallingType.SDK_POJO)
                                            .constructor(SubscribedPrincipal::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(SubscriptionRequestSummary::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("updatedBy").getter(getter(SubscriptionRequestSummary::updatedBy)).setter(setter(Builder::updatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            CREATED_BY_FIELD, DECISION_COMMENT_FIELD, DOMAIN_ID_FIELD, ID_FIELD, REQUEST_REASON_FIELD, REVIEWER_ID_FIELD,
            STATUS_FIELD, SUBSCRIBED_LISTINGS_FIELD, SUBSCRIBED_PRINCIPALS_FIELD, UPDATED_AT_FIELD, UPDATED_BY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant createdAt;

    private final String createdBy;

    private final String decisionComment;

    private final String domainId;

    private final String id;

    private final String requestReason;

    private final String reviewerId;

    private final String status;

    private final List<SubscribedListing> subscribedListings;

    private final List<SubscribedPrincipal> subscribedPrincipals;

    private final Instant updatedAt;

    private final String updatedBy;

    private SubscriptionRequestSummary(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.decisionComment = builder.decisionComment;
        this.domainId = builder.domainId;
        this.id = builder.id;
        this.requestReason = builder.requestReason;
        this.reviewerId = builder.reviewerId;
        this.status = builder.status;
        this.subscribedListings = builder.subscribedListings;
        this.subscribedPrincipals = builder.subscribedPrincipals;
        this.updatedAt = builder.updatedAt;
        this.updatedBy = builder.updatedBy;
    }

    /**
     * <p>
     * The timestamp of when a subscription request was created.
     * </p>
     * 
     * @return The timestamp of when a subscription request was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The Amazon DataZone user who created the subscription request.
     * </p>
     * 
     * @return The Amazon DataZone user who created the subscription request.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The decision comment of the subscription request.
     * </p>
     * 
     * @return The decision comment of the subscription request.
     */
    public final String decisionComment() {
        return decisionComment;
    }

    /**
     * <p>
     * The identifier of the Amazon DataZone domain in which a subscription request exists.
     * </p>
     * 
     * @return The identifier of the Amazon DataZone domain in which a subscription request exists.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The identifier of the subscription request.
     * </p>
     * 
     * @return The identifier of the subscription request.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The reason for the subscription request.
     * </p>
     * 
     * @return The reason for the subscription request.
     */
    public final String requestReason() {
        return requestReason;
    }

    /**
     * <p>
     * The identifier of the subscription request reviewer.
     * </p>
     * 
     * @return The identifier of the subscription request reviewer.
     */
    public final String reviewerId() {
        return reviewerId;
    }

    /**
     * <p>
     * The status of the subscription request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SubscriptionRequestStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the subscription request.
     * @see SubscriptionRequestStatus
     */
    public final SubscriptionRequestStatus status() {
        return SubscriptionRequestStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the subscription request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SubscriptionRequestStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the subscription request.
     * @see SubscriptionRequestStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubscribedListings property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSubscribedListings() {
        return subscribedListings != null && !(subscribedListings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The listings included in the subscription request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubscribedListings} method.
     * </p>
     * 
     * @return The listings included in the subscription request.
     */
    public final List<SubscribedListing> subscribedListings() {
        return subscribedListings;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubscribedPrincipals property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSubscribedPrincipals() {
        return subscribedPrincipals != null && !(subscribedPrincipals instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The principals included in the subscription request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubscribedPrincipals} method.
     * </p>
     * 
     * @return The principals included in the subscription request.
     */
    public final List<SubscribedPrincipal> subscribedPrincipals() {
        return subscribedPrincipals;
    }

    /**
     * <p>
     * The timestamp of when the subscription request was updated.
     * </p>
     * 
     * @return The timestamp of when the subscription request was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The identifier of the Amazon DataZone user who updated the subscription request.
     * </p>
     * 
     * @return The identifier of the Amazon DataZone user who updated the subscription request.
     */
    public final String updatedBy() {
        return updatedBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(decisionComment());
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(requestReason());
        hashCode = 31 * hashCode + Objects.hashCode(reviewerId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubscribedListings() ? subscribedListings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSubscribedPrincipals() ? subscribedPrincipals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedBy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubscriptionRequestSummary)) {
            return false;
        }
        SubscriptionRequestSummary other = (SubscriptionRequestSummary) obj;
        return Objects.equals(createdAt(), other.createdAt()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(decisionComment(), other.decisionComment()) && Objects.equals(domainId(), other.domainId())
                && Objects.equals(id(), other.id()) && Objects.equals(requestReason(), other.requestReason())
                && Objects.equals(reviewerId(), other.reviewerId()) && Objects.equals(statusAsString(), other.statusAsString())
                && hasSubscribedListings() == other.hasSubscribedListings()
                && Objects.equals(subscribedListings(), other.subscribedListings())
                && hasSubscribedPrincipals() == other.hasSubscribedPrincipals()
                && Objects.equals(subscribedPrincipals(), other.subscribedPrincipals())
                && Objects.equals(updatedAt(), other.updatedAt()) && Objects.equals(updatedBy(), other.updatedBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SubscriptionRequestSummary").add("CreatedAt", createdAt()).add("CreatedBy", createdBy())
                .add("DecisionComment", decisionComment() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DomainId", domainId()).add("Id", id())
                .add("RequestReason", requestReason() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ReviewerId", reviewerId()).add("Status", statusAsString())
                .add("SubscribedListings", hasSubscribedListings() ? subscribedListings() : null)
                .add("SubscribedPrincipals", hasSubscribedPrincipals() ? subscribedPrincipals() : null)
                .add("UpdatedAt", updatedAt()).add("UpdatedBy", updatedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "decisionComment":
            return Optional.ofNullable(clazz.cast(decisionComment()));
        case "domainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "requestReason":
            return Optional.ofNullable(clazz.cast(requestReason()));
        case "reviewerId":
            return Optional.ofNullable(clazz.cast(reviewerId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "subscribedListings":
            return Optional.ofNullable(clazz.cast(subscribedListings()));
        case "subscribedPrincipals":
            return Optional.ofNullable(clazz.cast(subscribedPrincipals()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "updatedBy":
            return Optional.ofNullable(clazz.cast(updatedBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SubscriptionRequestSummary, T> g) {
        return obj -> g.apply((SubscriptionRequestSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SubscriptionRequestSummary> {
        /**
         * <p>
         * The timestamp of when a subscription request was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp of when a subscription request was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The Amazon DataZone user who created the subscription request.
         * </p>
         * 
         * @param createdBy
         *        The Amazon DataZone user who created the subscription request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The decision comment of the subscription request.
         * </p>
         * 
         * @param decisionComment
         *        The decision comment of the subscription request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decisionComment(String decisionComment);

        /**
         * <p>
         * The identifier of the Amazon DataZone domain in which a subscription request exists.
         * </p>
         * 
         * @param domainId
         *        The identifier of the Amazon DataZone domain in which a subscription request exists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The identifier of the subscription request.
         * </p>
         * 
         * @param id
         *        The identifier of the subscription request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The reason for the subscription request.
         * </p>
         * 
         * @param requestReason
         *        The reason for the subscription request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestReason(String requestReason);

        /**
         * <p>
         * The identifier of the subscription request reviewer.
         * </p>
         * 
         * @param reviewerId
         *        The identifier of the subscription request reviewer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reviewerId(String reviewerId);

        /**
         * <p>
         * The status of the subscription request.
         * </p>
         * 
         * @param status
         *        The status of the subscription request.
         * @see SubscriptionRequestStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubscriptionRequestStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the subscription request.
         * </p>
         * 
         * @param status
         *        The status of the subscription request.
         * @see SubscriptionRequestStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubscriptionRequestStatus
         */
        Builder status(SubscriptionRequestStatus status);

        /**
         * <p>
         * The listings included in the subscription request.
         * </p>
         * 
         * @param subscribedListings
         *        The listings included in the subscription request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscribedListings(Collection<SubscribedListing> subscribedListings);

        /**
         * <p>
         * The listings included in the subscription request.
         * </p>
         * 
         * @param subscribedListings
         *        The listings included in the subscription request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscribedListings(SubscribedListing... subscribedListings);

        /**
         * <p>
         * The listings included in the subscription request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.SubscribedListing.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.datazone.model.SubscribedListing#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.SubscribedListing.Builder#build()} is called
         * immediately and its result is passed to {@link #subscribedListings(List<SubscribedListing>)}.
         * 
         * @param subscribedListings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.SubscribedListing.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subscribedListings(java.util.Collection<SubscribedListing>)
         */
        Builder subscribedListings(Consumer<SubscribedListing.Builder>... subscribedListings);

        /**
         * <p>
         * The principals included in the subscription request.
         * </p>
         * 
         * @param subscribedPrincipals
         *        The principals included in the subscription request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscribedPrincipals(Collection<SubscribedPrincipal> subscribedPrincipals);

        /**
         * <p>
         * The principals included in the subscription request.
         * </p>
         * 
         * @param subscribedPrincipals
         *        The principals included in the subscription request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscribedPrincipals(SubscribedPrincipal... subscribedPrincipals);

        /**
         * <p>
         * The principals included in the subscription request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.SubscribedPrincipal.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.datazone.model.SubscribedPrincipal#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.SubscribedPrincipal.Builder#build()} is called
         * immediately and its result is passed to {@link #subscribedPrincipals(List<SubscribedPrincipal>)}.
         * 
         * @param subscribedPrincipals
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.SubscribedPrincipal.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subscribedPrincipals(java.util.Collection<SubscribedPrincipal>)
         */
        Builder subscribedPrincipals(Consumer<SubscribedPrincipal.Builder>... subscribedPrincipals);

        /**
         * <p>
         * The timestamp of when the subscription request was updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp of when the subscription request was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The identifier of the Amazon DataZone user who updated the subscription request.
         * </p>
         * 
         * @param updatedBy
         *        The identifier of the Amazon DataZone user who updated the subscription request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedBy(String updatedBy);
    }

    static final class BuilderImpl implements Builder {
        private Instant createdAt;

        private String createdBy;

        private String decisionComment;

        private String domainId;

        private String id;

        private String requestReason;

        private String reviewerId;

        private String status;

        private List<SubscribedListing> subscribedListings = DefaultSdkAutoConstructList.getInstance();

        private List<SubscribedPrincipal> subscribedPrincipals = DefaultSdkAutoConstructList.getInstance();

        private Instant updatedAt;

        private String updatedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(SubscriptionRequestSummary model) {
            createdAt(model.createdAt);
            createdBy(model.createdBy);
            decisionComment(model.decisionComment);
            domainId(model.domainId);
            id(model.id);
            requestReason(model.requestReason);
            reviewerId(model.reviewerId);
            status(model.status);
            subscribedListings(model.subscribedListings);
            subscribedPrincipals(model.subscribedPrincipals);
            updatedAt(model.updatedAt);
            updatedBy(model.updatedBy);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getDecisionComment() {
            return decisionComment;
        }

        public final void setDecisionComment(String decisionComment) {
            this.decisionComment = decisionComment;
        }

        @Override
        public final Builder decisionComment(String decisionComment) {
            this.decisionComment = decisionComment;
            return this;
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getRequestReason() {
            return requestReason;
        }

        public final void setRequestReason(String requestReason) {
            this.requestReason = requestReason;
        }

        @Override
        public final Builder requestReason(String requestReason) {
            this.requestReason = requestReason;
            return this;
        }

        public final String getReviewerId() {
            return reviewerId;
        }

        public final void setReviewerId(String reviewerId) {
            this.reviewerId = reviewerId;
        }

        @Override
        public final Builder reviewerId(String reviewerId) {
            this.reviewerId = reviewerId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SubscriptionRequestStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<SubscribedListing.Builder> getSubscribedListings() {
            List<SubscribedListing.Builder> result = SubscriptionRequestSummarySubscribedListingsListCopier
                    .copyToBuilder(this.subscribedListings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubscribedListings(Collection<SubscribedListing.BuilderImpl> subscribedListings) {
            this.subscribedListings = SubscriptionRequestSummarySubscribedListingsListCopier.copyFromBuilder(subscribedListings);
        }

        @Override
        public final Builder subscribedListings(Collection<SubscribedListing> subscribedListings) {
            this.subscribedListings = SubscriptionRequestSummarySubscribedListingsListCopier.copy(subscribedListings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribedListings(SubscribedListing... subscribedListings) {
            subscribedListings(Arrays.asList(subscribedListings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribedListings(Consumer<SubscribedListing.Builder>... subscribedListings) {
            subscribedListings(Stream.of(subscribedListings).map(c -> SubscribedListing.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<SubscribedPrincipal.Builder> getSubscribedPrincipals() {
            List<SubscribedPrincipal.Builder> result = SubscriptionRequestSummarySubscribedPrincipalsListCopier
                    .copyToBuilder(this.subscribedPrincipals);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubscribedPrincipals(Collection<SubscribedPrincipal.BuilderImpl> subscribedPrincipals) {
            this.subscribedPrincipals = SubscriptionRequestSummarySubscribedPrincipalsListCopier
                    .copyFromBuilder(subscribedPrincipals);
        }

        @Override
        public final Builder subscribedPrincipals(Collection<SubscribedPrincipal> subscribedPrincipals) {
            this.subscribedPrincipals = SubscriptionRequestSummarySubscribedPrincipalsListCopier.copy(subscribedPrincipals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribedPrincipals(SubscribedPrincipal... subscribedPrincipals) {
            subscribedPrincipals(Arrays.asList(subscribedPrincipals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribedPrincipals(Consumer<SubscribedPrincipal.Builder>... subscribedPrincipals) {
            subscribedPrincipals(Stream.of(subscribedPrincipals).map(c -> SubscribedPrincipal.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getUpdatedBy() {
            return updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        @Override
        public SubscriptionRequestSummary build() {
            return new SubscriptionRequestSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
