/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The asset statistics from the data source run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RunStatisticsForAssets implements SdkPojo, Serializable,
        ToCopyableBuilder<RunStatisticsForAssets.Builder, RunStatisticsForAssets> {
    private static final SdkField<Integer> ADDED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("added")
            .getter(getter(RunStatisticsForAssets::added)).setter(setter(Builder::added))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("added").build()).build();

    private static final SdkField<Integer> FAILED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("failed").getter(getter(RunStatisticsForAssets::failed)).setter(setter(Builder::failed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failed").build()).build();

    private static final SdkField<Integer> SKIPPED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("skipped").getter(getter(RunStatisticsForAssets::skipped)).setter(setter(Builder::skipped))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("skipped").build()).build();

    private static final SdkField<Integer> UNCHANGED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("unchanged").getter(getter(RunStatisticsForAssets::unchanged)).setter(setter(Builder::unchanged))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unchanged").build()).build();

    private static final SdkField<Integer> UPDATED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("updated").getter(getter(RunStatisticsForAssets::updated)).setter(setter(Builder::updated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updated").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDED_FIELD, FAILED_FIELD,
            SKIPPED_FIELD, UNCHANGED_FIELD, UPDATED_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer added;

    private final Integer failed;

    private final Integer skipped;

    private final Integer unchanged;

    private final Integer updated;

    private RunStatisticsForAssets(BuilderImpl builder) {
        this.added = builder.added;
        this.failed = builder.failed;
        this.skipped = builder.skipped;
        this.unchanged = builder.unchanged;
        this.updated = builder.updated;
    }

    /**
     * <p>
     * The <code>added</code> statistic for the data source run.
     * </p>
     * 
     * @return The <code>added</code> statistic for the data source run.
     */
    public final Integer added() {
        return added;
    }

    /**
     * <p>
     * The <code>failed</code> statistic for the data source run.
     * </p>
     * 
     * @return The <code>failed</code> statistic for the data source run.
     */
    public final Integer failed() {
        return failed;
    }

    /**
     * <p>
     * The <code>skipped</code> statistic for the data source run.
     * </p>
     * 
     * @return The <code>skipped</code> statistic for the data source run.
     */
    public final Integer skipped() {
        return skipped;
    }

    /**
     * <p>
     * The <code>unchanged</code> statistic for the data source run.
     * </p>
     * 
     * @return The <code>unchanged</code> statistic for the data source run.
     */
    public final Integer unchanged() {
        return unchanged;
    }

    /**
     * <p>
     * The <code>updated</code> statistic for the data source run.
     * </p>
     * 
     * @return The <code>updated</code> statistic for the data source run.
     */
    public final Integer updated() {
        return updated;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(added());
        hashCode = 31 * hashCode + Objects.hashCode(failed());
        hashCode = 31 * hashCode + Objects.hashCode(skipped());
        hashCode = 31 * hashCode + Objects.hashCode(unchanged());
        hashCode = 31 * hashCode + Objects.hashCode(updated());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunStatisticsForAssets)) {
            return false;
        }
        RunStatisticsForAssets other = (RunStatisticsForAssets) obj;
        return Objects.equals(added(), other.added()) && Objects.equals(failed(), other.failed())
                && Objects.equals(skipped(), other.skipped()) && Objects.equals(unchanged(), other.unchanged())
                && Objects.equals(updated(), other.updated());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RunStatisticsForAssets").add("Added", added()).add("Failed", failed()).add("Skipped", skipped())
                .add("Unchanged", unchanged()).add("Updated", updated()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "added":
            return Optional.ofNullable(clazz.cast(added()));
        case "failed":
            return Optional.ofNullable(clazz.cast(failed()));
        case "skipped":
            return Optional.ofNullable(clazz.cast(skipped()));
        case "unchanged":
            return Optional.ofNullable(clazz.cast(unchanged()));
        case "updated":
            return Optional.ofNullable(clazz.cast(updated()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RunStatisticsForAssets, T> g) {
        return obj -> g.apply((RunStatisticsForAssets) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RunStatisticsForAssets> {
        /**
         * <p>
         * The <code>added</code> statistic for the data source run.
         * </p>
         * 
         * @param added
         *        The <code>added</code> statistic for the data source run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder added(Integer added);

        /**
         * <p>
         * The <code>failed</code> statistic for the data source run.
         * </p>
         * 
         * @param failed
         *        The <code>failed</code> statistic for the data source run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failed(Integer failed);

        /**
         * <p>
         * The <code>skipped</code> statistic for the data source run.
         * </p>
         * 
         * @param skipped
         *        The <code>skipped</code> statistic for the data source run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skipped(Integer skipped);

        /**
         * <p>
         * The <code>unchanged</code> statistic for the data source run.
         * </p>
         * 
         * @param unchanged
         *        The <code>unchanged</code> statistic for the data source run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unchanged(Integer unchanged);

        /**
         * <p>
         * The <code>updated</code> statistic for the data source run.
         * </p>
         * 
         * @param updated
         *        The <code>updated</code> statistic for the data source run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updated(Integer updated);
    }

    static final class BuilderImpl implements Builder {
        private Integer added;

        private Integer failed;

        private Integer skipped;

        private Integer unchanged;

        private Integer updated;

        private BuilderImpl() {
        }

        private BuilderImpl(RunStatisticsForAssets model) {
            added(model.added);
            failed(model.failed);
            skipped(model.skipped);
            unchanged(model.unchanged);
            updated(model.updated);
        }

        public final Integer getAdded() {
            return added;
        }

        public final void setAdded(Integer added) {
            this.added = added;
        }

        @Override
        public final Builder added(Integer added) {
            this.added = added;
            return this;
        }

        public final Integer getFailed() {
            return failed;
        }

        public final void setFailed(Integer failed) {
            this.failed = failed;
        }

        @Override
        public final Builder failed(Integer failed) {
            this.failed = failed;
            return this;
        }

        public final Integer getSkipped() {
            return skipped;
        }

        public final void setSkipped(Integer skipped) {
            this.skipped = skipped;
        }

        @Override
        public final Builder skipped(Integer skipped) {
            this.skipped = skipped;
            return this;
        }

        public final Integer getUnchanged() {
            return unchanged;
        }

        public final void setUnchanged(Integer unchanged) {
            this.unchanged = unchanged;
        }

        @Override
        public final Builder unchanged(Integer unchanged) {
            this.unchanged = unchanged;
            return this;
        }

        public final Integer getUpdated() {
            return updated;
        }

        public final void setUpdated(Integer updated) {
            this.updated = updated;
        }

        @Override
        public final Builder updated(Integer updated) {
            this.updated = updated;
            return this;
        }

        @Override
        public RunStatisticsForAssets build() {
            return new RunStatisticsForAssets(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
