/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEnvironmentBlueprintResponse extends DataZoneResponse implements
        ToCopyableBuilder<GetEnvironmentBlueprintResponse.Builder, GetEnvironmentBlueprintResponse> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(GetEnvironmentBlueprintResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<DeploymentProperties> DEPLOYMENT_PROPERTIES_FIELD = SdkField
            .<DeploymentProperties> builder(MarshallingType.SDK_POJO).memberName("deploymentProperties")
            .getter(getter(GetEnvironmentBlueprintResponse::deploymentProperties)).setter(setter(Builder::deploymentProperties))
            .constructor(DeploymentProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentProperties").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetEnvironmentBlueprintResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<String>> GLOSSARY_TERMS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("glossaryTerms")
            .getter(getter(GetEnvironmentBlueprintResponse::glossaryTerms))
            .setter(setter(Builder::glossaryTerms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glossaryTerms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetEnvironmentBlueprintResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetEnvironmentBlueprintResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> PROVIDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("provider").getter(getter(GetEnvironmentBlueprintResponse::provider)).setter(setter(Builder::provider))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provider").build()).build();

    private static final SdkField<ProvisioningProperties> PROVISIONING_PROPERTIES_FIELD = SdkField
            .<ProvisioningProperties> builder(MarshallingType.SDK_POJO).memberName("provisioningProperties")
            .getter(getter(GetEnvironmentBlueprintResponse::provisioningProperties))
            .setter(setter(Builder::provisioningProperties)).constructor(ProvisioningProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisioningProperties").build())
            .build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(GetEnvironmentBlueprintResponse::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<List<CustomParameter>> USER_PARAMETERS_FIELD = SdkField
            .<List<CustomParameter>> builder(MarshallingType.LIST)
            .memberName("userParameters")
            .getter(getter(GetEnvironmentBlueprintResponse::userParameters))
            .setter(setter(Builder::userParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CustomParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CustomParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            DEPLOYMENT_PROPERTIES_FIELD, DESCRIPTION_FIELD, GLOSSARY_TERMS_FIELD, ID_FIELD, NAME_FIELD, PROVIDER_FIELD,
            PROVISIONING_PROPERTIES_FIELD, UPDATED_AT_FIELD, USER_PARAMETERS_FIELD));

    private final Instant createdAt;

    private final DeploymentProperties deploymentProperties;

    private final String description;

    private final List<String> glossaryTerms;

    private final String id;

    private final String name;

    private final String provider;

    private final ProvisioningProperties provisioningProperties;

    private final Instant updatedAt;

    private final List<CustomParameter> userParameters;

    private GetEnvironmentBlueprintResponse(BuilderImpl builder) {
        super(builder);
        this.createdAt = builder.createdAt;
        this.deploymentProperties = builder.deploymentProperties;
        this.description = builder.description;
        this.glossaryTerms = builder.glossaryTerms;
        this.id = builder.id;
        this.name = builder.name;
        this.provider = builder.provider;
        this.provisioningProperties = builder.provisioningProperties;
        this.updatedAt = builder.updatedAt;
        this.userParameters = builder.userParameters;
    }

    /**
     * <p>
     * A timestamp of when this blueprint was created.
     * </p>
     * 
     * @return A timestamp of when this blueprint was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The deployment properties of this Amazon DataZone blueprint.
     * </p>
     * 
     * @return The deployment properties of this Amazon DataZone blueprint.
     */
    public final DeploymentProperties deploymentProperties() {
        return deploymentProperties;
    }

    /**
     * <p>
     * The description of this Amazon DataZone blueprint.
     * </p>
     * 
     * @return The description of this Amazon DataZone blueprint.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the GlossaryTerms property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGlossaryTerms() {
        return glossaryTerms != null && !(glossaryTerms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The glossary terms attached to this Amazon DataZone blueprint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGlossaryTerms} method.
     * </p>
     * 
     * @return The glossary terms attached to this Amazon DataZone blueprint.
     */
    public final List<String> glossaryTerms() {
        return glossaryTerms;
    }

    /**
     * <p>
     * The ID of this Amazon DataZone blueprint.
     * </p>
     * 
     * @return The ID of this Amazon DataZone blueprint.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of this Amazon DataZone blueprint.
     * </p>
     * 
     * @return The name of this Amazon DataZone blueprint.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The provider of this Amazon DataZone blueprint.
     * </p>
     * 
     * @return The provider of this Amazon DataZone blueprint.
     */
    public final String provider() {
        return provider;
    }

    /**
     * <p>
     * The provisioning properties of this Amazon DataZone blueprint.
     * </p>
     * 
     * @return The provisioning properties of this Amazon DataZone blueprint.
     */
    public final ProvisioningProperties provisioningProperties() {
        return provisioningProperties;
    }

    /**
     * <p>
     * The timestamp of when this blueprint was updated.
     * </p>
     * 
     * @return The timestamp of when this blueprint was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserParameters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUserParameters() {
        return userParameters != null && !(userParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The user parameters of this blueprint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserParameters} method.
     * </p>
     * 
     * @return The user parameters of this blueprint.
     */
    public final List<CustomParameter> userParameters() {
        return userParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentProperties());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasGlossaryTerms() ? glossaryTerms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(provider());
        hashCode = 31 * hashCode + Objects.hashCode(provisioningProperties());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasUserParameters() ? userParameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEnvironmentBlueprintResponse)) {
            return false;
        }
        GetEnvironmentBlueprintResponse other = (GetEnvironmentBlueprintResponse) obj;
        return Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(deploymentProperties(), other.deploymentProperties())
                && Objects.equals(description(), other.description()) && hasGlossaryTerms() == other.hasGlossaryTerms()
                && Objects.equals(glossaryTerms(), other.glossaryTerms()) && Objects.equals(id(), other.id())
                && Objects.equals(name(), other.name()) && Objects.equals(provider(), other.provider())
                && Objects.equals(provisioningProperties(), other.provisioningProperties())
                && Objects.equals(updatedAt(), other.updatedAt()) && hasUserParameters() == other.hasUserParameters()
                && Objects.equals(userParameters(), other.userParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetEnvironmentBlueprintResponse").add("CreatedAt", createdAt())
                .add("DeploymentProperties", deploymentProperties())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("GlossaryTerms", hasGlossaryTerms() ? glossaryTerms() : null).add("Id", id()).add("Name", name())
                .add("Provider", provider()).add("ProvisioningProperties", provisioningProperties())
                .add("UpdatedAt", updatedAt()).add("UserParameters", hasUserParameters() ? userParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "deploymentProperties":
            return Optional.ofNullable(clazz.cast(deploymentProperties()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "glossaryTerms":
            return Optional.ofNullable(clazz.cast(glossaryTerms()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "provider":
            return Optional.ofNullable(clazz.cast(provider()));
        case "provisioningProperties":
            return Optional.ofNullable(clazz.cast(provisioningProperties()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "userParameters":
            return Optional.ofNullable(clazz.cast(userParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEnvironmentBlueprintResponse, T> g) {
        return obj -> g.apply((GetEnvironmentBlueprintResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetEnvironmentBlueprintResponse> {
        /**
         * <p>
         * A timestamp of when this blueprint was created.
         * </p>
         * 
         * @param createdAt
         *        A timestamp of when this blueprint was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The deployment properties of this Amazon DataZone blueprint.
         * </p>
         * 
         * @param deploymentProperties
         *        The deployment properties of this Amazon DataZone blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentProperties(DeploymentProperties deploymentProperties);

        /**
         * <p>
         * The deployment properties of this Amazon DataZone blueprint.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeploymentProperties.Builder} avoiding
         * the need to create one manually via {@link DeploymentProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeploymentProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #deploymentProperties(DeploymentProperties)}.
         * 
         * @param deploymentProperties
         *        a consumer that will call methods on {@link DeploymentProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentProperties(DeploymentProperties)
         */
        default Builder deploymentProperties(Consumer<DeploymentProperties.Builder> deploymentProperties) {
            return deploymentProperties(DeploymentProperties.builder().applyMutation(deploymentProperties).build());
        }

        /**
         * <p>
         * The description of this Amazon DataZone blueprint.
         * </p>
         * 
         * @param description
         *        The description of this Amazon DataZone blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The glossary terms attached to this Amazon DataZone blueprint.
         * </p>
         * 
         * @param glossaryTerms
         *        The glossary terms attached to this Amazon DataZone blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glossaryTerms(Collection<String> glossaryTerms);

        /**
         * <p>
         * The glossary terms attached to this Amazon DataZone blueprint.
         * </p>
         * 
         * @param glossaryTerms
         *        The glossary terms attached to this Amazon DataZone blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glossaryTerms(String... glossaryTerms);

        /**
         * <p>
         * The ID of this Amazon DataZone blueprint.
         * </p>
         * 
         * @param id
         *        The ID of this Amazon DataZone blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of this Amazon DataZone blueprint.
         * </p>
         * 
         * @param name
         *        The name of this Amazon DataZone blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The provider of this Amazon DataZone blueprint.
         * </p>
         * 
         * @param provider
         *        The provider of this Amazon DataZone blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provider(String provider);

        /**
         * <p>
         * The provisioning properties of this Amazon DataZone blueprint.
         * </p>
         * 
         * @param provisioningProperties
         *        The provisioning properties of this Amazon DataZone blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningProperties(ProvisioningProperties provisioningProperties);

        /**
         * <p>
         * The provisioning properties of this Amazon DataZone blueprint.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProvisioningProperties.Builder} avoiding
         * the need to create one manually via {@link ProvisioningProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProvisioningProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #provisioningProperties(ProvisioningProperties)}.
         * 
         * @param provisioningProperties
         *        a consumer that will call methods on {@link ProvisioningProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisioningProperties(ProvisioningProperties)
         */
        default Builder provisioningProperties(Consumer<ProvisioningProperties.Builder> provisioningProperties) {
            return provisioningProperties(ProvisioningProperties.builder().applyMutation(provisioningProperties).build());
        }

        /**
         * <p>
         * The timestamp of when this blueprint was updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp of when this blueprint was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The user parameters of this blueprint.
         * </p>
         * 
         * @param userParameters
         *        The user parameters of this blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userParameters(Collection<CustomParameter> userParameters);

        /**
         * <p>
         * The user parameters of this blueprint.
         * </p>
         * 
         * @param userParameters
         *        The user parameters of this blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userParameters(CustomParameter... userParameters);

        /**
         * <p>
         * The user parameters of this blueprint.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.CustomParameter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.datazone.model.CustomParameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.CustomParameter.Builder#build()} is called immediately
         * and its result is passed to {@link #userParameters(List<CustomParameter>)}.
         * 
         * @param userParameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.CustomParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userParameters(java.util.Collection<CustomParameter>)
         */
        Builder userParameters(Consumer<CustomParameter.Builder>... userParameters);
    }

    static final class BuilderImpl extends DataZoneResponse.BuilderImpl implements Builder {
        private Instant createdAt;

        private DeploymentProperties deploymentProperties;

        private String description;

        private List<String> glossaryTerms = DefaultSdkAutoConstructList.getInstance();

        private String id;

        private String name;

        private String provider;

        private ProvisioningProperties provisioningProperties;

        private Instant updatedAt;

        private List<CustomParameter> userParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetEnvironmentBlueprintResponse model) {
            super(model);
            createdAt(model.createdAt);
            deploymentProperties(model.deploymentProperties);
            description(model.description);
            glossaryTerms(model.glossaryTerms);
            id(model.id);
            name(model.name);
            provider(model.provider);
            provisioningProperties(model.provisioningProperties);
            updatedAt(model.updatedAt);
            userParameters(model.userParameters);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final DeploymentProperties.Builder getDeploymentProperties() {
            return deploymentProperties != null ? deploymentProperties.toBuilder() : null;
        }

        public final void setDeploymentProperties(DeploymentProperties.BuilderImpl deploymentProperties) {
            this.deploymentProperties = deploymentProperties != null ? deploymentProperties.build() : null;
        }

        @Override
        public final Builder deploymentProperties(DeploymentProperties deploymentProperties) {
            this.deploymentProperties = deploymentProperties;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getGlossaryTerms() {
            if (glossaryTerms instanceof SdkAutoConstructList) {
                return null;
            }
            return glossaryTerms;
        }

        public final void setGlossaryTerms(Collection<String> glossaryTerms) {
            this.glossaryTerms = GlossaryTermsCopier.copy(glossaryTerms);
        }

        @Override
        public final Builder glossaryTerms(Collection<String> glossaryTerms) {
            this.glossaryTerms = GlossaryTermsCopier.copy(glossaryTerms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder glossaryTerms(String... glossaryTerms) {
            glossaryTerms(Arrays.asList(glossaryTerms));
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProvider() {
            return provider;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        @Override
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public final ProvisioningProperties.Builder getProvisioningProperties() {
            return provisioningProperties != null ? provisioningProperties.toBuilder() : null;
        }

        public final void setProvisioningProperties(ProvisioningProperties.BuilderImpl provisioningProperties) {
            this.provisioningProperties = provisioningProperties != null ? provisioningProperties.build() : null;
        }

        @Override
        public final Builder provisioningProperties(ProvisioningProperties provisioningProperties) {
            this.provisioningProperties = provisioningProperties;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final List<CustomParameter.Builder> getUserParameters() {
            List<CustomParameter.Builder> result = CustomParameterListCopier.copyToBuilder(this.userParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserParameters(Collection<CustomParameter.BuilderImpl> userParameters) {
            this.userParameters = CustomParameterListCopier.copyFromBuilder(userParameters);
        }

        @Override
        public final Builder userParameters(Collection<CustomParameter> userParameters) {
            this.userParameters = CustomParameterListCopier.copy(userParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userParameters(CustomParameter... userParameters) {
            userParameters(Arrays.asList(userParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userParameters(Consumer<CustomParameter.Builder>... userParameters) {
            userParameters(Stream.of(userParameters).map(c -> CustomParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetEnvironmentBlueprintResponse build() {
            return new GetEnvironmentBlueprintResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
