/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDataSourceRunResponse extends DataZoneResponse implements
        ToCopyableBuilder<GetDataSourceRunResponse.Builder, GetDataSourceRunResponse> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(GetDataSourceRunResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> DATA_SOURCE_CONFIGURATION_SNAPSHOT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("dataSourceConfigurationSnapshot")
            .getter(getter(GetDataSourceRunResponse::dataSourceConfigurationSnapshot))
            .setter(setter(Builder::dataSourceConfigurationSnapshot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceConfigurationSnapshot")
                    .build()).build();

    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataSourceId").getter(getter(GetDataSourceRunResponse::dataSourceId))
            .setter(setter(Builder::dataSourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceId").build()).build();

    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainId").getter(getter(GetDataSourceRunResponse::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()).build();

    private static final SdkField<DataSourceErrorMessage> ERROR_MESSAGE_FIELD = SdkField
            .<DataSourceErrorMessage> builder(MarshallingType.SDK_POJO).memberName("errorMessage")
            .getter(getter(GetDataSourceRunResponse::errorMessage)).setter(setter(Builder::errorMessage))
            .constructor(DataSourceErrorMessage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetDataSourceRunResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> PROJECT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectId").getter(getter(GetDataSourceRunResponse::projectId)).setter(setter(Builder::projectId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectId").build()).build();

    private static final SdkField<RunStatisticsForAssets> RUN_STATISTICS_FOR_ASSETS_FIELD = SdkField
            .<RunStatisticsForAssets> builder(MarshallingType.SDK_POJO).memberName("runStatisticsForAssets")
            .getter(getter(GetDataSourceRunResponse::runStatisticsForAssets)).setter(setter(Builder::runStatisticsForAssets))
            .constructor(RunStatisticsForAssets::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runStatisticsForAssets").build())
            .build();

    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("startedAt")
            .getter(getter(GetDataSourceRunResponse::startedAt))
            .setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetDataSourceRunResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> STOPPED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("stoppedAt")
            .getter(getter(GetDataSourceRunResponse::stoppedAt))
            .setter(setter(Builder::stoppedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stoppedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(GetDataSourceRunResponse::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(GetDataSourceRunResponse::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            DATA_SOURCE_CONFIGURATION_SNAPSHOT_FIELD, DATA_SOURCE_ID_FIELD, DOMAIN_ID_FIELD, ERROR_MESSAGE_FIELD, ID_FIELD,
            PROJECT_ID_FIELD, RUN_STATISTICS_FOR_ASSETS_FIELD, STARTED_AT_FIELD, STATUS_FIELD, STOPPED_AT_FIELD, TYPE_FIELD,
            UPDATED_AT_FIELD));

    private final Instant createdAt;

    private final String dataSourceConfigurationSnapshot;

    private final String dataSourceId;

    private final String domainId;

    private final DataSourceErrorMessage errorMessage;

    private final String id;

    private final String projectId;

    private final RunStatisticsForAssets runStatisticsForAssets;

    private final Instant startedAt;

    private final String status;

    private final Instant stoppedAt;

    private final String type;

    private final Instant updatedAt;

    private GetDataSourceRunResponse(BuilderImpl builder) {
        super(builder);
        this.createdAt = builder.createdAt;
        this.dataSourceConfigurationSnapshot = builder.dataSourceConfigurationSnapshot;
        this.dataSourceId = builder.dataSourceId;
        this.domainId = builder.domainId;
        this.errorMessage = builder.errorMessage;
        this.id = builder.id;
        this.projectId = builder.projectId;
        this.runStatisticsForAssets = builder.runStatisticsForAssets;
        this.startedAt = builder.startedAt;
        this.status = builder.status;
        this.stoppedAt = builder.stoppedAt;
        this.type = builder.type;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The timestamp of when the data source run was created.
     * </p>
     * 
     * @return The timestamp of when the data source run was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The configuration snapshot of the data source run.
     * </p>
     * 
     * @return The configuration snapshot of the data source run.
     */
    public final String dataSourceConfigurationSnapshot() {
        return dataSourceConfigurationSnapshot;
    }

    /**
     * <p>
     * The ID of the data source for this data source run.
     * </p>
     * 
     * @return The ID of the data source for this data source run.
     */
    public final String dataSourceId() {
        return dataSourceId;
    }

    /**
     * <p>
     * The ID of the domain in which this data source run was performed.
     * </p>
     * 
     * @return The ID of the domain in which this data source run was performed.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * Specifies the error message that is returned if the operation cannot be successfully completed.
     * </p>
     * 
     * @return Specifies the error message that is returned if the operation cannot be successfully completed.
     */
    public final DataSourceErrorMessage errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * The ID of the data source run.
     * </p>
     * 
     * @return The ID of the data source run.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The ID of the project in which this data source run occured.
     * </p>
     * 
     * @return The ID of the project in which this data source run occured.
     */
    public final String projectId() {
        return projectId;
    }

    /**
     * <p>
     * The asset statistics from this data source run.
     * </p>
     * 
     * @return The asset statistics from this data source run.
     */
    public final RunStatisticsForAssets runStatisticsForAssets() {
        return runStatisticsForAssets;
    }

    /**
     * <p>
     * The timestamp of when this data source run started.
     * </p>
     * 
     * @return The timestamp of when this data source run started.
     */
    public final Instant startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * The status of this data source run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DataSourceRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of this data source run.
     * @see DataSourceRunStatus
     */
    public final DataSourceRunStatus status() {
        return DataSourceRunStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of this data source run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DataSourceRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of this data source run.
     * @see DataSourceRunStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The timestamp of when this data source run stopped.
     * </p>
     * 
     * @return The timestamp of when this data source run stopped.
     */
    public final Instant stoppedAt() {
        return stoppedAt;
    }

    /**
     * <p>
     * The type of this data source run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DataSourceRunType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of this data source run.
     * @see DataSourceRunType
     */
    public final DataSourceRunType type() {
        return DataSourceRunType.fromValue(type);
    }

    /**
     * <p>
     * The type of this data source run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DataSourceRunType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of this data source run.
     * @see DataSourceRunType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The timestamp of when this data source run was updated.
     * </p>
     * 
     * @return The timestamp of when this data source run was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceConfigurationSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(projectId());
        hashCode = 31 * hashCode + Objects.hashCode(runStatisticsForAssets());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stoppedAt());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataSourceRunResponse)) {
            return false;
        }
        GetDataSourceRunResponse other = (GetDataSourceRunResponse) obj;
        return Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(dataSourceConfigurationSnapshot(), other.dataSourceConfigurationSnapshot())
                && Objects.equals(dataSourceId(), other.dataSourceId()) && Objects.equals(domainId(), other.domainId())
                && Objects.equals(errorMessage(), other.errorMessage()) && Objects.equals(id(), other.id())
                && Objects.equals(projectId(), other.projectId())
                && Objects.equals(runStatisticsForAssets(), other.runStatisticsForAssets())
                && Objects.equals(startedAt(), other.startedAt()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(stoppedAt(), other.stoppedAt()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDataSourceRunResponse").add("CreatedAt", createdAt())
                .add("DataSourceConfigurationSnapshot", dataSourceConfigurationSnapshot()).add("DataSourceId", dataSourceId())
                .add("DomainId", domainId()).add("ErrorMessage", errorMessage()).add("Id", id()).add("ProjectId", projectId())
                .add("RunStatisticsForAssets", runStatisticsForAssets()).add("StartedAt", startedAt())
                .add("Status", statusAsString()).add("StoppedAt", stoppedAt()).add("Type", typeAsString())
                .add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "dataSourceConfigurationSnapshot":
            return Optional.ofNullable(clazz.cast(dataSourceConfigurationSnapshot()));
        case "dataSourceId":
            return Optional.ofNullable(clazz.cast(dataSourceId()));
        case "domainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "projectId":
            return Optional.ofNullable(clazz.cast(projectId()));
        case "runStatisticsForAssets":
            return Optional.ofNullable(clazz.cast(runStatisticsForAssets()));
        case "startedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "stoppedAt":
            return Optional.ofNullable(clazz.cast(stoppedAt()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDataSourceRunResponse, T> g) {
        return obj -> g.apply((GetDataSourceRunResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDataSourceRunResponse> {
        /**
         * <p>
         * The timestamp of when the data source run was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp of when the data source run was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The configuration snapshot of the data source run.
         * </p>
         * 
         * @param dataSourceConfigurationSnapshot
         *        The configuration snapshot of the data source run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceConfigurationSnapshot(String dataSourceConfigurationSnapshot);

        /**
         * <p>
         * The ID of the data source for this data source run.
         * </p>
         * 
         * @param dataSourceId
         *        The ID of the data source for this data source run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceId(String dataSourceId);

        /**
         * <p>
         * The ID of the domain in which this data source run was performed.
         * </p>
         * 
         * @param domainId
         *        The ID of the domain in which this data source run was performed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * Specifies the error message that is returned if the operation cannot be successfully completed.
         * </p>
         * 
         * @param errorMessage
         *        Specifies the error message that is returned if the operation cannot be successfully completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(DataSourceErrorMessage errorMessage);

        /**
         * <p>
         * Specifies the error message that is returned if the operation cannot be successfully completed.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSourceErrorMessage.Builder} avoiding
         * the need to create one manually via {@link DataSourceErrorMessage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSourceErrorMessage.Builder#build()} is called immediately and
         * its result is passed to {@link #errorMessage(DataSourceErrorMessage)}.
         * 
         * @param errorMessage
         *        a consumer that will call methods on {@link DataSourceErrorMessage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorMessage(DataSourceErrorMessage)
         */
        default Builder errorMessage(Consumer<DataSourceErrorMessage.Builder> errorMessage) {
            return errorMessage(DataSourceErrorMessage.builder().applyMutation(errorMessage).build());
        }

        /**
         * <p>
         * The ID of the data source run.
         * </p>
         * 
         * @param id
         *        The ID of the data source run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ID of the project in which this data source run occured.
         * </p>
         * 
         * @param projectId
         *        The ID of the project in which this data source run occured.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectId(String projectId);

        /**
         * <p>
         * The asset statistics from this data source run.
         * </p>
         * 
         * @param runStatisticsForAssets
         *        The asset statistics from this data source run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runStatisticsForAssets(RunStatisticsForAssets runStatisticsForAssets);

        /**
         * <p>
         * The asset statistics from this data source run.
         * </p>
         * This is a convenience method that creates an instance of the {@link RunStatisticsForAssets.Builder} avoiding
         * the need to create one manually via {@link RunStatisticsForAssets#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RunStatisticsForAssets.Builder#build()} is called immediately and
         * its result is passed to {@link #runStatisticsForAssets(RunStatisticsForAssets)}.
         * 
         * @param runStatisticsForAssets
         *        a consumer that will call methods on {@link RunStatisticsForAssets.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #runStatisticsForAssets(RunStatisticsForAssets)
         */
        default Builder runStatisticsForAssets(Consumer<RunStatisticsForAssets.Builder> runStatisticsForAssets) {
            return runStatisticsForAssets(RunStatisticsForAssets.builder().applyMutation(runStatisticsForAssets).build());
        }

        /**
         * <p>
         * The timestamp of when this data source run started.
         * </p>
         * 
         * @param startedAt
         *        The timestamp of when this data source run started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Instant startedAt);

        /**
         * <p>
         * The status of this data source run.
         * </p>
         * 
         * @param status
         *        The status of this data source run.
         * @see DataSourceRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceRunStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of this data source run.
         * </p>
         * 
         * @param status
         *        The status of this data source run.
         * @see DataSourceRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceRunStatus
         */
        Builder status(DataSourceRunStatus status);

        /**
         * <p>
         * The timestamp of when this data source run stopped.
         * </p>
         * 
         * @param stoppedAt
         *        The timestamp of when this data source run stopped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stoppedAt(Instant stoppedAt);

        /**
         * <p>
         * The type of this data source run.
         * </p>
         * 
         * @param type
         *        The type of this data source run.
         * @see DataSourceRunType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceRunType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of this data source run.
         * </p>
         * 
         * @param type
         *        The type of this data source run.
         * @see DataSourceRunType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceRunType
         */
        Builder type(DataSourceRunType type);

        /**
         * <p>
         * The timestamp of when this data source run was updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp of when this data source run was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl extends DataZoneResponse.BuilderImpl implements Builder {
        private Instant createdAt;

        private String dataSourceConfigurationSnapshot;

        private String dataSourceId;

        private String domainId;

        private DataSourceErrorMessage errorMessage;

        private String id;

        private String projectId;

        private RunStatisticsForAssets runStatisticsForAssets;

        private Instant startedAt;

        private String status;

        private Instant stoppedAt;

        private String type;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataSourceRunResponse model) {
            super(model);
            createdAt(model.createdAt);
            dataSourceConfigurationSnapshot(model.dataSourceConfigurationSnapshot);
            dataSourceId(model.dataSourceId);
            domainId(model.domainId);
            errorMessage(model.errorMessage);
            id(model.id);
            projectId(model.projectId);
            runStatisticsForAssets(model.runStatisticsForAssets);
            startedAt(model.startedAt);
            status(model.status);
            stoppedAt(model.stoppedAt);
            type(model.type);
            updatedAt(model.updatedAt);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDataSourceConfigurationSnapshot() {
            return dataSourceConfigurationSnapshot;
        }

        public final void setDataSourceConfigurationSnapshot(String dataSourceConfigurationSnapshot) {
            this.dataSourceConfigurationSnapshot = dataSourceConfigurationSnapshot;
        }

        @Override
        public final Builder dataSourceConfigurationSnapshot(String dataSourceConfigurationSnapshot) {
            this.dataSourceConfigurationSnapshot = dataSourceConfigurationSnapshot;
            return this;
        }

        public final String getDataSourceId() {
            return dataSourceId;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final DataSourceErrorMessage.Builder getErrorMessage() {
            return errorMessage != null ? errorMessage.toBuilder() : null;
        }

        public final void setErrorMessage(DataSourceErrorMessage.BuilderImpl errorMessage) {
            this.errorMessage = errorMessage != null ? errorMessage.build() : null;
        }

        @Override
        public final Builder errorMessage(DataSourceErrorMessage errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getProjectId() {
            return projectId;
        }

        public final void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        @Override
        public final Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public final RunStatisticsForAssets.Builder getRunStatisticsForAssets() {
            return runStatisticsForAssets != null ? runStatisticsForAssets.toBuilder() : null;
        }

        public final void setRunStatisticsForAssets(RunStatisticsForAssets.BuilderImpl runStatisticsForAssets) {
            this.runStatisticsForAssets = runStatisticsForAssets != null ? runStatisticsForAssets.build() : null;
        }

        @Override
        public final Builder runStatisticsForAssets(RunStatisticsForAssets runStatisticsForAssets) {
            this.runStatisticsForAssets = runStatisticsForAssets;
            return this;
        }

        public final Instant getStartedAt() {
            return startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DataSourceRunStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getStoppedAt() {
            return stoppedAt;
        }

        public final void setStoppedAt(Instant stoppedAt) {
            this.stoppedAt = stoppedAt;
        }

        @Override
        public final Builder stoppedAt(Instant stoppedAt) {
            this.stoppedAt = stoppedAt;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DataSourceRunType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public GetDataSourceRunResponse build() {
            return new GetDataSourceRunResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
