/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a metadata form.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FormInput implements SdkPojo, Serializable, ToCopyableBuilder<FormInput.Builder, FormInput> {
    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("content")
            .getter(getter(FormInput::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()).build();

    private static final SdkField<String> FORM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("formName").getter(getter(FormInput::formName)).setter(setter(Builder::formName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formName").build()).build();

    private static final SdkField<String> TYPE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("typeIdentifier").getter(getter(FormInput::typeIdentifier)).setter(setter(Builder::typeIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeIdentifier").build()).build();

    private static final SdkField<String> TYPE_REVISION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("typeRevision").getter(getter(FormInput::typeRevision)).setter(setter(Builder::typeRevision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeRevision").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_FIELD,
            FORM_NAME_FIELD, TYPE_IDENTIFIER_FIELD, TYPE_REVISION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String content;

    private final String formName;

    private final String typeIdentifier;

    private final String typeRevision;

    private FormInput(BuilderImpl builder) {
        this.content = builder.content;
        this.formName = builder.formName;
        this.typeIdentifier = builder.typeIdentifier;
        this.typeRevision = builder.typeRevision;
    }

    /**
     * <p>
     * The content of the metadata form.
     * </p>
     * 
     * @return The content of the metadata form.
     */
    public final String content() {
        return content;
    }

    /**
     * <p>
     * The name of the metadata form.
     * </p>
     * 
     * @return The name of the metadata form.
     */
    public final String formName() {
        return formName;
    }

    /**
     * <p>
     * The ID of the metadata form type.
     * </p>
     * 
     * @return The ID of the metadata form type.
     */
    public final String typeIdentifier() {
        return typeIdentifier;
    }

    /**
     * <p>
     * The revision of the metadata form type.
     * </p>
     * 
     * @return The revision of the metadata form type.
     */
    public final String typeRevision() {
        return typeRevision;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(formName());
        hashCode = 31 * hashCode + Objects.hashCode(typeIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(typeRevision());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FormInput)) {
            return false;
        }
        FormInput other = (FormInput) obj;
        return Objects.equals(content(), other.content()) && Objects.equals(formName(), other.formName())
                && Objects.equals(typeIdentifier(), other.typeIdentifier())
                && Objects.equals(typeRevision(), other.typeRevision());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FormInput").add("Content", content()).add("FormName", formName())
                .add("TypeIdentifier", typeIdentifier()).add("TypeRevision", typeRevision()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "content":
            return Optional.ofNullable(clazz.cast(content()));
        case "formName":
            return Optional.ofNullable(clazz.cast(formName()));
        case "typeIdentifier":
            return Optional.ofNullable(clazz.cast(typeIdentifier()));
        case "typeRevision":
            return Optional.ofNullable(clazz.cast(typeRevision()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FormInput, T> g) {
        return obj -> g.apply((FormInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FormInput> {
        /**
         * <p>
         * The content of the metadata form.
         * </p>
         * 
         * @param content
         *        The content of the metadata form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);

        /**
         * <p>
         * The name of the metadata form.
         * </p>
         * 
         * @param formName
         *        The name of the metadata form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder formName(String formName);

        /**
         * <p>
         * The ID of the metadata form type.
         * </p>
         * 
         * @param typeIdentifier
         *        The ID of the metadata form type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeIdentifier(String typeIdentifier);

        /**
         * <p>
         * The revision of the metadata form type.
         * </p>
         * 
         * @param typeRevision
         *        The revision of the metadata form type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeRevision(String typeRevision);
    }

    static final class BuilderImpl implements Builder {
        private String content;

        private String formName;

        private String typeIdentifier;

        private String typeRevision;

        private BuilderImpl() {
        }

        private BuilderImpl(FormInput model) {
            content(model.content);
            formName(model.formName);
            typeIdentifier(model.typeIdentifier);
            typeRevision(model.typeRevision);
        }

        public final String getContent() {
            return content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final String getFormName() {
            return formName;
        }

        public final void setFormName(String formName) {
            this.formName = formName;
        }

        @Override
        public final Builder formName(String formName) {
            this.formName = formName;
            return this;
        }

        public final String getTypeIdentifier() {
            return typeIdentifier;
        }

        public final void setTypeIdentifier(String typeIdentifier) {
            this.typeIdentifier = typeIdentifier;
        }

        @Override
        public final Builder typeIdentifier(String typeIdentifier) {
            this.typeIdentifier = typeIdentifier;
            return this;
        }

        public final String getTypeRevision() {
            return typeRevision;
        }

        public final void setTypeRevision(String typeRevision) {
            this.typeRevision = typeRevision;
        }

        @Override
        public final Builder typeRevision(String typeRevision) {
            this.typeRevision = typeRevision;
            return this;
        }

        @Override
        public FormInput build() {
            return new FormInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
