/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataProductItem implements SdkPojo, Serializable, ToCopyableBuilder<DataProductItem.Builder, DataProductItem> {
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainId").getter(getter(DataProductItem::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()).build();

    private static final SdkField<String> ITEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("itemId")
            .getter(getter(DataProductItem::itemId)).setter(setter(Builder::itemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("itemId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DOMAIN_ID_FIELD, ITEM_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String domainId;

    private final String itemId;

    private DataProductItem(BuilderImpl builder) {
        this.domainId = builder.domainId;
        this.itemId = builder.itemId;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String itemId() {
        return itemId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(itemId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataProductItem)) {
            return false;
        }
        DataProductItem other = (DataProductItem) obj;
        return Objects.equals(domainId(), other.domainId()) && Objects.equals(itemId(), other.itemId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataProductItem").add("DomainId", domainId()).add("ItemId", itemId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "itemId":
            return Optional.ofNullable(clazz.cast(itemId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataProductItem, T> g) {
        return obj -> g.apply((DataProductItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataProductItem> {
        /**
         * <p/>
         * 
         * @param domainId
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p/>
         * 
         * @param itemId
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder itemId(String itemId);
    }

    static final class BuilderImpl implements Builder {
        private String domainId;

        private String itemId;

        private BuilderImpl() {
        }

        private BuilderImpl(DataProductItem model) {
            domainId(model.domainId);
            itemId(model.itemId);
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getItemId() {
            return itemId;
        }

        public final void setItemId(String itemId) {
            this.itemId = itemId;
        }

        @Override
        public final Builder itemId(String itemId) {
            this.itemId = itemId;
            return this;
        }

        @Override
        public DataProductItem build() {
            return new DataProductItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
