/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The level of detail included in each aspect of your DataSync <a
 * href="https://docs.aws.amazon.com/datasync/latest/userguide/creating-task-reports.html">task report</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReportOverrides implements SdkPojo, Serializable, ToCopyableBuilder<ReportOverrides.Builder, ReportOverrides> {
    private static final SdkField<ReportOverride> TRANSFERRED_FIELD = SdkField.<ReportOverride> builder(MarshallingType.SDK_POJO)
            .memberName("Transferred").getter(getter(ReportOverrides::transferred)).setter(setter(Builder::transferred))
            .constructor(ReportOverride::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Transferred").build()).build();

    private static final SdkField<ReportOverride> VERIFIED_FIELD = SdkField.<ReportOverride> builder(MarshallingType.SDK_POJO)
            .memberName("Verified").getter(getter(ReportOverrides::verified)).setter(setter(Builder::verified))
            .constructor(ReportOverride::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Verified").build()).build();

    private static final SdkField<ReportOverride> DELETED_FIELD = SdkField.<ReportOverride> builder(MarshallingType.SDK_POJO)
            .memberName("Deleted").getter(getter(ReportOverrides::deleted)).setter(setter(Builder::deleted))
            .constructor(ReportOverride::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Deleted").build()).build();

    private static final SdkField<ReportOverride> SKIPPED_FIELD = SdkField.<ReportOverride> builder(MarshallingType.SDK_POJO)
            .memberName("Skipped").getter(getter(ReportOverrides::skipped)).setter(setter(Builder::skipped))
            .constructor(ReportOverride::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Skipped").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSFERRED_FIELD,
            VERIFIED_FIELD, DELETED_FIELD, SKIPPED_FIELD));

    private static final long serialVersionUID = 1L;

    private final ReportOverride transferred;

    private final ReportOverride verified;

    private final ReportOverride deleted;

    private final ReportOverride skipped;

    private ReportOverrides(BuilderImpl builder) {
        this.transferred = builder.transferred;
        this.verified = builder.verified;
        this.deleted = builder.deleted;
        this.skipped = builder.skipped;
    }

    /**
     * <p>
     * Specifies the level of reporting for the files, objects, and directories that DataSync attempted to transfer.
     * </p>
     * 
     * @return Specifies the level of reporting for the files, objects, and directories that DataSync attempted to
     *         transfer.
     */
    public final ReportOverride transferred() {
        return transferred;
    }

    /**
     * <p>
     * Specifies the level of reporting for the files, objects, and directories that DataSync attempted to verify at the
     * end of your transfer. This only applies if you <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/configure-data-verification-options.html">configure
     * your task</a> to verify data during and after the transfer (which DataSync does by default).
     * </p>
     * 
     * @return Specifies the level of reporting for the files, objects, and directories that DataSync attempted to
     *         verify at the end of your transfer. This only applies if you <a
     *         href="https://docs.aws.amazon.com/datasync/latest/userguide/configure-data-verification-options.html"
     *         >configure your task</a> to verify data during and after the transfer (which DataSync does by default).
     */
    public final ReportOverride verified() {
        return verified;
    }

    /**
     * <p>
     * Specifies the level of reporting for the files, objects, and directories that DataSync attempted to delete in
     * your destination location. This only applies if you <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/configure-metadata.html">configure your task</a> to
     * delete data in the destination that isn't in the source.
     * </p>
     * 
     * @return Specifies the level of reporting for the files, objects, and directories that DataSync attempted to
     *         delete in your destination location. This only applies if you <a
     *         href="https://docs.aws.amazon.com/datasync/latest/userguide/configure-metadata.html">configure your
     *         task</a> to delete data in the destination that isn't in the source.
     */
    public final ReportOverride deleted() {
        return deleted;
    }

    /**
     * <p>
     * Specifies the level of reporting for the files, objects, and directories that DataSync attempted to skip during
     * your transfer.
     * </p>
     * 
     * @return Specifies the level of reporting for the files, objects, and directories that DataSync attempted to skip
     *         during your transfer.
     */
    public final ReportOverride skipped() {
        return skipped;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transferred());
        hashCode = 31 * hashCode + Objects.hashCode(verified());
        hashCode = 31 * hashCode + Objects.hashCode(deleted());
        hashCode = 31 * hashCode + Objects.hashCode(skipped());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportOverrides)) {
            return false;
        }
        ReportOverrides other = (ReportOverrides) obj;
        return Objects.equals(transferred(), other.transferred()) && Objects.equals(verified(), other.verified())
                && Objects.equals(deleted(), other.deleted()) && Objects.equals(skipped(), other.skipped());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReportOverrides").add("Transferred", transferred()).add("Verified", verified())
                .add("Deleted", deleted()).add("Skipped", skipped()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Transferred":
            return Optional.ofNullable(clazz.cast(transferred()));
        case "Verified":
            return Optional.ofNullable(clazz.cast(verified()));
        case "Deleted":
            return Optional.ofNullable(clazz.cast(deleted()));
        case "Skipped":
            return Optional.ofNullable(clazz.cast(skipped()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReportOverrides, T> g) {
        return obj -> g.apply((ReportOverrides) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReportOverrides> {
        /**
         * <p>
         * Specifies the level of reporting for the files, objects, and directories that DataSync attempted to transfer.
         * </p>
         * 
         * @param transferred
         *        Specifies the level of reporting for the files, objects, and directories that DataSync attempted to
         *        transfer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transferred(ReportOverride transferred);

        /**
         * <p>
         * Specifies the level of reporting for the files, objects, and directories that DataSync attempted to transfer.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReportOverride.Builder} avoiding the need
         * to create one manually via {@link ReportOverride#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReportOverride.Builder#build()} is called immediately and its
         * result is passed to {@link #transferred(ReportOverride)}.
         * 
         * @param transferred
         *        a consumer that will call methods on {@link ReportOverride.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transferred(ReportOverride)
         */
        default Builder transferred(Consumer<ReportOverride.Builder> transferred) {
            return transferred(ReportOverride.builder().applyMutation(transferred).build());
        }

        /**
         * <p>
         * Specifies the level of reporting for the files, objects, and directories that DataSync attempted to verify at
         * the end of your transfer. This only applies if you <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/configure-data-verification-options.html"
         * >configure your task</a> to verify data during and after the transfer (which DataSync does by default).
         * </p>
         * 
         * @param verified
         *        Specifies the level of reporting for the files, objects, and directories that DataSync attempted to
         *        verify at the end of your transfer. This only applies if you <a href=
         *        "https://docs.aws.amazon.com/datasync/latest/userguide/configure-data-verification-options.html"
         *        >configure your task</a> to verify data during and after the transfer (which DataSync does by
         *        default).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verified(ReportOverride verified);

        /**
         * <p>
         * Specifies the level of reporting for the files, objects, and directories that DataSync attempted to verify at
         * the end of your transfer. This only applies if you <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/configure-data-verification-options.html"
         * >configure your task</a> to verify data during and after the transfer (which DataSync does by default).
         * </p>
         * This is a convenience method that creates an instance of the {@link ReportOverride.Builder} avoiding the need
         * to create one manually via {@link ReportOverride#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReportOverride.Builder#build()} is called immediately and its
         * result is passed to {@link #verified(ReportOverride)}.
         * 
         * @param verified
         *        a consumer that will call methods on {@link ReportOverride.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #verified(ReportOverride)
         */
        default Builder verified(Consumer<ReportOverride.Builder> verified) {
            return verified(ReportOverride.builder().applyMutation(verified).build());
        }

        /**
         * <p>
         * Specifies the level of reporting for the files, objects, and directories that DataSync attempted to delete in
         * your destination location. This only applies if you <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/configure-metadata.html">configure your task</a>
         * to delete data in the destination that isn't in the source.
         * </p>
         * 
         * @param deleted
         *        Specifies the level of reporting for the files, objects, and directories that DataSync attempted to
         *        delete in your destination location. This only applies if you <a
         *        href="https://docs.aws.amazon.com/datasync/latest/userguide/configure-metadata.html">configure your
         *        task</a> to delete data in the destination that isn't in the source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleted(ReportOverride deleted);

        /**
         * <p>
         * Specifies the level of reporting for the files, objects, and directories that DataSync attempted to delete in
         * your destination location. This only applies if you <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/configure-metadata.html">configure your task</a>
         * to delete data in the destination that isn't in the source.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReportOverride.Builder} avoiding the need
         * to create one manually via {@link ReportOverride#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReportOverride.Builder#build()} is called immediately and its
         * result is passed to {@link #deleted(ReportOverride)}.
         * 
         * @param deleted
         *        a consumer that will call methods on {@link ReportOverride.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deleted(ReportOverride)
         */
        default Builder deleted(Consumer<ReportOverride.Builder> deleted) {
            return deleted(ReportOverride.builder().applyMutation(deleted).build());
        }

        /**
         * <p>
         * Specifies the level of reporting for the files, objects, and directories that DataSync attempted to skip
         * during your transfer.
         * </p>
         * 
         * @param skipped
         *        Specifies the level of reporting for the files, objects, and directories that DataSync attempted to
         *        skip during your transfer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skipped(ReportOverride skipped);

        /**
         * <p>
         * Specifies the level of reporting for the files, objects, and directories that DataSync attempted to skip
         * during your transfer.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReportOverride.Builder} avoiding the need
         * to create one manually via {@link ReportOverride#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReportOverride.Builder#build()} is called immediately and its
         * result is passed to {@link #skipped(ReportOverride)}.
         * 
         * @param skipped
         *        a consumer that will call methods on {@link ReportOverride.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #skipped(ReportOverride)
         */
        default Builder skipped(Consumer<ReportOverride.Builder> skipped) {
            return skipped(ReportOverride.builder().applyMutation(skipped).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ReportOverride transferred;

        private ReportOverride verified;

        private ReportOverride deleted;

        private ReportOverride skipped;

        private BuilderImpl() {
        }

        private BuilderImpl(ReportOverrides model) {
            transferred(model.transferred);
            verified(model.verified);
            deleted(model.deleted);
            skipped(model.skipped);
        }

        public final ReportOverride.Builder getTransferred() {
            return transferred != null ? transferred.toBuilder() : null;
        }

        public final void setTransferred(ReportOverride.BuilderImpl transferred) {
            this.transferred = transferred != null ? transferred.build() : null;
        }

        @Override
        public final Builder transferred(ReportOverride transferred) {
            this.transferred = transferred;
            return this;
        }

        public final ReportOverride.Builder getVerified() {
            return verified != null ? verified.toBuilder() : null;
        }

        public final void setVerified(ReportOverride.BuilderImpl verified) {
            this.verified = verified != null ? verified.build() : null;
        }

        @Override
        public final Builder verified(ReportOverride verified) {
            this.verified = verified;
            return this;
        }

        public final ReportOverride.Builder getDeleted() {
            return deleted != null ? deleted.toBuilder() : null;
        }

        public final void setDeleted(ReportOverride.BuilderImpl deleted) {
            this.deleted = deleted != null ? deleted.build() : null;
        }

        @Override
        public final Builder deleted(ReportOverride deleted) {
            this.deleted = deleted;
            return this;
        }

        public final ReportOverride.Builder getSkipped() {
            return skipped != null ? skipped.toBuilder() : null;
        }

        public final void setSkipped(ReportOverride.BuilderImpl skipped) {
            this.skipped = skipped != null ? skipped.build() : null;
        }

        @Override
        public final Builder skipped(ReportOverride skipped) {
            this.skipped = skipped;
            return this;
        }

        @Override
        public ReportOverrides build() {
            return new ReportOverrides(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
