/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies where DataSync uploads your <a
 * href="https://docs.aws.amazon.com/datasync/latest/userguide/creating-task-reports.html">task report</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReportDestination implements SdkPojo, Serializable,
        ToCopyableBuilder<ReportDestination.Builder, ReportDestination> {
    private static final SdkField<ReportDestinationS3> S3_FIELD = SdkField
            .<ReportDestinationS3> builder(MarshallingType.SDK_POJO).memberName("S3").getter(getter(ReportDestination::s3))
            .setter(setter(Builder::s3)).constructor(ReportDestinationS3::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_FIELD));

    private static final long serialVersionUID = 1L;

    private final ReportDestinationS3 s3;

    private ReportDestination(BuilderImpl builder) {
        this.s3 = builder.s3;
    }

    /**
     * <p>
     * Specifies the Amazon S3 bucket where DataSync uploads your task report.
     * </p>
     * 
     * @return Specifies the Amazon S3 bucket where DataSync uploads your task report.
     */
    public final ReportDestinationS3 s3() {
        return s3;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportDestination)) {
            return false;
        }
        ReportDestination other = (ReportDestination) obj;
        return Objects.equals(s3(), other.s3());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReportDestination").add("S3", s3()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3":
            return Optional.ofNullable(clazz.cast(s3()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReportDestination, T> g) {
        return obj -> g.apply((ReportDestination) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReportDestination> {
        /**
         * <p>
         * Specifies the Amazon S3 bucket where DataSync uploads your task report.
         * </p>
         * 
         * @param s3
         *        Specifies the Amazon S3 bucket where DataSync uploads your task report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3(ReportDestinationS3 s3);

        /**
         * <p>
         * Specifies the Amazon S3 bucket where DataSync uploads your task report.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReportDestinationS3.Builder} avoiding the
         * need to create one manually via {@link ReportDestinationS3#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReportDestinationS3.Builder#build()} is called immediately and
         * its result is passed to {@link #s3(ReportDestinationS3)}.
         * 
         * @param s3
         *        a consumer that will call methods on {@link ReportDestinationS3.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3(ReportDestinationS3)
         */
        default Builder s3(Consumer<ReportDestinationS3.Builder> s3) {
            return s3(ReportDestinationS3.builder().applyMutation(s3).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ReportDestinationS3 s3;

        private BuilderImpl() {
        }

        private BuilderImpl(ReportDestination model) {
            s3(model.s3);
        }

        public final ReportDestinationS3.Builder getS3() {
            return s3 != null ? s3.toBuilder() : null;
        }

        public final void setS3(ReportDestinationS3.BuilderImpl s3) {
            this.s3 = s3 != null ? s3.build() : null;
        }

        @Override
        public final Builder s3(ReportDestinationS3 s3) {
            this.s3 = s3;
            return this;
        }

        @Override
        public ReportDestination build() {
            return new ReportDestination(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
