/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDiscoveryJobResponse extends DataSyncResponse implements
        ToCopyableBuilder<DescribeDiscoveryJobResponse.Builder, DescribeDiscoveryJobResponse> {
    private static final SdkField<String> STORAGE_SYSTEM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageSystemArn").getter(getter(DescribeDiscoveryJobResponse::storageSystemArn))
            .setter(setter(Builder::storageSystemArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageSystemArn").build()).build();

    private static final SdkField<String> DISCOVERY_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DiscoveryJobArn").getter(getter(DescribeDiscoveryJobResponse::discoveryJobArn))
            .setter(setter(Builder::discoveryJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiscoveryJobArn").build()).build();

    private static final SdkField<Integer> COLLECTION_DURATION_MINUTES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("CollectionDurationMinutes")
            .getter(getter(DescribeDiscoveryJobResponse::collectionDurationMinutes))
            .setter(setter(Builder::collectionDurationMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionDurationMinutes").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeDiscoveryJobResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> JOB_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("JobStartTime").getter(getter(DescribeDiscoveryJobResponse::jobStartTime))
            .setter(setter(Builder::jobStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStartTime").build()).build();

    private static final SdkField<Instant> JOB_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("JobEndTime").getter(getter(DescribeDiscoveryJobResponse::jobEndTime))
            .setter(setter(Builder::jobEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobEndTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_SYSTEM_ARN_FIELD,
            DISCOVERY_JOB_ARN_FIELD, COLLECTION_DURATION_MINUTES_FIELD, STATUS_FIELD, JOB_START_TIME_FIELD, JOB_END_TIME_FIELD));

    private final String storageSystemArn;

    private final String discoveryJobArn;

    private final Integer collectionDurationMinutes;

    private final String status;

    private final Instant jobStartTime;

    private final Instant jobEndTime;

    private DescribeDiscoveryJobResponse(BuilderImpl builder) {
        super(builder);
        this.storageSystemArn = builder.storageSystemArn;
        this.discoveryJobArn = builder.discoveryJobArn;
        this.collectionDurationMinutes = builder.collectionDurationMinutes;
        this.status = builder.status;
        this.jobStartTime = builder.jobStartTime;
        this.jobEndTime = builder.jobEndTime;
    }

    /**
     * <p>
     * The ARN of the on-premises storage system you're running the discovery job on.
     * </p>
     * 
     * @return The ARN of the on-premises storage system you're running the discovery job on.
     */
    public final String storageSystemArn() {
        return storageSystemArn;
    }

    /**
     * <p>
     * The ARN of the discovery job.
     * </p>
     * 
     * @return The ARN of the discovery job.
     */
    public final String discoveryJobArn() {
        return discoveryJobArn;
    }

    /**
     * <p>
     * The number of minutes that the discovery job runs.
     * </p>
     * 
     * @return The number of minutes that the discovery job runs.
     */
    public final Integer collectionDurationMinutes() {
        return collectionDurationMinutes;
    }

    /**
     * <p>
     * Indicates the status of a discovery job. For more information, see <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/discovery-job-statuses.html#discovery-job-statuses-table"
     * >Discovery job statuses</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DiscoveryJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates the status of a discovery job. For more information, see <a href=
     *         "https://docs.aws.amazon.com/datasync/latest/userguide/discovery-job-statuses.html#discovery-job-statuses-table"
     *         >Discovery job statuses</a>.
     * @see DiscoveryJobStatus
     */
    public final DiscoveryJobStatus status() {
        return DiscoveryJobStatus.fromValue(status);
    }

    /**
     * <p>
     * Indicates the status of a discovery job. For more information, see <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/discovery-job-statuses.html#discovery-job-statuses-table"
     * >Discovery job statuses</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DiscoveryJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates the status of a discovery job. For more information, see <a href=
     *         "https://docs.aws.amazon.com/datasync/latest/userguide/discovery-job-statuses.html#discovery-job-statuses-table"
     *         >Discovery job statuses</a>.
     * @see DiscoveryJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The time when the discovery job started.
     * </p>
     * 
     * @return The time when the discovery job started.
     */
    public final Instant jobStartTime() {
        return jobStartTime;
    }

    /**
     * <p>
     * The time when the discovery job ended.
     * </p>
     * 
     * @return The time when the discovery job ended.
     */
    public final Instant jobEndTime() {
        return jobEndTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(storageSystemArn());
        hashCode = 31 * hashCode + Objects.hashCode(discoveryJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(collectionDurationMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(jobStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(jobEndTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDiscoveryJobResponse)) {
            return false;
        }
        DescribeDiscoveryJobResponse other = (DescribeDiscoveryJobResponse) obj;
        return Objects.equals(storageSystemArn(), other.storageSystemArn())
                && Objects.equals(discoveryJobArn(), other.discoveryJobArn())
                && Objects.equals(collectionDurationMinutes(), other.collectionDurationMinutes())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(jobStartTime(), other.jobStartTime()) && Objects.equals(jobEndTime(), other.jobEndTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDiscoveryJobResponse").add("StorageSystemArn", storageSystemArn())
                .add("DiscoveryJobArn", discoveryJobArn()).add("CollectionDurationMinutes", collectionDurationMinutes())
                .add("Status", statusAsString()).add("JobStartTime", jobStartTime()).add("JobEndTime", jobEndTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StorageSystemArn":
            return Optional.ofNullable(clazz.cast(storageSystemArn()));
        case "DiscoveryJobArn":
            return Optional.ofNullable(clazz.cast(discoveryJobArn()));
        case "CollectionDurationMinutes":
            return Optional.ofNullable(clazz.cast(collectionDurationMinutes()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "JobStartTime":
            return Optional.ofNullable(clazz.cast(jobStartTime()));
        case "JobEndTime":
            return Optional.ofNullable(clazz.cast(jobEndTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDiscoveryJobResponse, T> g) {
        return obj -> g.apply((DescribeDiscoveryJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataSyncResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDiscoveryJobResponse> {
        /**
         * <p>
         * The ARN of the on-premises storage system you're running the discovery job on.
         * </p>
         * 
         * @param storageSystemArn
         *        The ARN of the on-premises storage system you're running the discovery job on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageSystemArn(String storageSystemArn);

        /**
         * <p>
         * The ARN of the discovery job.
         * </p>
         * 
         * @param discoveryJobArn
         *        The ARN of the discovery job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder discoveryJobArn(String discoveryJobArn);

        /**
         * <p>
         * The number of minutes that the discovery job runs.
         * </p>
         * 
         * @param collectionDurationMinutes
         *        The number of minutes that the discovery job runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionDurationMinutes(Integer collectionDurationMinutes);

        /**
         * <p>
         * Indicates the status of a discovery job. For more information, see <a href=
         * "https://docs.aws.amazon.com/datasync/latest/userguide/discovery-job-statuses.html#discovery-job-statuses-table"
         * >Discovery job statuses</a>.
         * </p>
         * 
         * @param status
         *        Indicates the status of a discovery job. For more information, see <a href=
         *        "https://docs.aws.amazon.com/datasync/latest/userguide/discovery-job-statuses.html#discovery-job-statuses-table"
         *        >Discovery job statuses</a>.
         * @see DiscoveryJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiscoveryJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Indicates the status of a discovery job. For more information, see <a href=
         * "https://docs.aws.amazon.com/datasync/latest/userguide/discovery-job-statuses.html#discovery-job-statuses-table"
         * >Discovery job statuses</a>.
         * </p>
         * 
         * @param status
         *        Indicates the status of a discovery job. For more information, see <a href=
         *        "https://docs.aws.amazon.com/datasync/latest/userguide/discovery-job-statuses.html#discovery-job-statuses-table"
         *        >Discovery job statuses</a>.
         * @see DiscoveryJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiscoveryJobStatus
         */
        Builder status(DiscoveryJobStatus status);

        /**
         * <p>
         * The time when the discovery job started.
         * </p>
         * 
         * @param jobStartTime
         *        The time when the discovery job started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobStartTime(Instant jobStartTime);

        /**
         * <p>
         * The time when the discovery job ended.
         * </p>
         * 
         * @param jobEndTime
         *        The time when the discovery job ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobEndTime(Instant jobEndTime);
    }

    static final class BuilderImpl extends DataSyncResponse.BuilderImpl implements Builder {
        private String storageSystemArn;

        private String discoveryJobArn;

        private Integer collectionDurationMinutes;

        private String status;

        private Instant jobStartTime;

        private Instant jobEndTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDiscoveryJobResponse model) {
            super(model);
            storageSystemArn(model.storageSystemArn);
            discoveryJobArn(model.discoveryJobArn);
            collectionDurationMinutes(model.collectionDurationMinutes);
            status(model.status);
            jobStartTime(model.jobStartTime);
            jobEndTime(model.jobEndTime);
        }

        public final String getStorageSystemArn() {
            return storageSystemArn;
        }

        public final void setStorageSystemArn(String storageSystemArn) {
            this.storageSystemArn = storageSystemArn;
        }

        @Override
        public final Builder storageSystemArn(String storageSystemArn) {
            this.storageSystemArn = storageSystemArn;
            return this;
        }

        public final String getDiscoveryJobArn() {
            return discoveryJobArn;
        }

        public final void setDiscoveryJobArn(String discoveryJobArn) {
            this.discoveryJobArn = discoveryJobArn;
        }

        @Override
        public final Builder discoveryJobArn(String discoveryJobArn) {
            this.discoveryJobArn = discoveryJobArn;
            return this;
        }

        public final Integer getCollectionDurationMinutes() {
            return collectionDurationMinutes;
        }

        public final void setCollectionDurationMinutes(Integer collectionDurationMinutes) {
            this.collectionDurationMinutes = collectionDurationMinutes;
        }

        @Override
        public final Builder collectionDurationMinutes(Integer collectionDurationMinutes) {
            this.collectionDurationMinutes = collectionDurationMinutes;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DiscoveryJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getJobStartTime() {
            return jobStartTime;
        }

        public final void setJobStartTime(Instant jobStartTime) {
            this.jobStartTime = jobStartTime;
        }

        @Override
        public final Builder jobStartTime(Instant jobStartTime) {
            this.jobStartTime = jobStartTime;
            return this;
        }

        public final Instant getJobEndTime() {
            return jobEndTime;
        }

        public final void setJobEndTime(Instant jobEndTime) {
            this.jobEndTime = jobEndTime;
        }

        @Override
        public final Builder jobEndTime(Instant jobEndTime) {
            this.jobEndTime = jobEndTime;
            return this;
        }

        @Override
        public DescribeDiscoveryJobResponse build() {
            return new DescribeDiscoveryJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
