/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum NfsVersion {
    AUTOMATIC("AUTOMATIC"),
    NFS3("NFS3"),
    NFS4_0("NFS4_0"),
    NFS4_1("NFS4_1"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private NfsVersion(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NfsVersion fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(NfsVersion.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NfsVersion> knownValues() {
        return Stream.of(NfsVersion.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

