/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendDataSetNotificationRequest extends DataExchangeRequest implements
        ToCopyableBuilder<SendDataSetNotificationRequest.Builder, SendDataSetNotificationRequest> {
    private static final SdkField<ScopeDetails> SCOPE_FIELD = SdkField.<ScopeDetails> builder(MarshallingType.SDK_POJO)
            .memberName("Scope").getter(getter(SendDataSetNotificationRequest::scope)).setter(setter(Builder::scope))
            .constructor(ScopeDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(SendDataSetNotificationRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> COMMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Comment")
            .getter(getter(SendDataSetNotificationRequest::comment)).setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment").build()).build();

    private static final SdkField<String> DATA_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSetId").getter(getter(SendDataSetNotificationRequest::dataSetId)).setter(setter(Builder::dataSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DataSetId").build()).build();

    private static final SdkField<NotificationDetails> DETAILS_FIELD = SdkField
            .<NotificationDetails> builder(MarshallingType.SDK_POJO).memberName("Details")
            .getter(getter(SendDataSetNotificationRequest::details)).setter(setter(Builder::details))
            .constructor(NotificationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Details").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(SendDataSetNotificationRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCOPE_FIELD,
            CLIENT_TOKEN_FIELD, COMMENT_FIELD, DATA_SET_ID_FIELD, DETAILS_FIELD, TYPE_FIELD));

    private final ScopeDetails scope;

    private final String clientToken;

    private final String comment;

    private final String dataSetId;

    private final NotificationDetails details;

    private final String type;

    private SendDataSetNotificationRequest(BuilderImpl builder) {
        super(builder);
        this.scope = builder.scope;
        this.clientToken = builder.clientToken;
        this.comment = builder.comment;
        this.dataSetId = builder.dataSetId;
        this.details = builder.details;
        this.type = builder.type;
    }

    /**
     * <p>
     * Affected scope of this notification such as the underlying resources affected by the notification event.
     * </p>
     * 
     * @return Affected scope of this notification such as the underlying resources affected by the notification event.
     */
    public final ScopeDetails scope() {
        return scope;
    }

    /**
     * <p>
     * Idempotency key for the notification, this key allows us to deduplicate notifications that are sent in quick
     * succession erroneously.
     * </p>
     * 
     * @return Idempotency key for the notification, this key allows us to deduplicate notifications that are sent in
     *         quick succession erroneously.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Free-form text field for providers to add information about their notifications.
     * </p>
     * 
     * @return Free-form text field for providers to add information about their notifications.
     */
    public final String comment() {
        return comment;
    }

    /**
     * <p>
     * Affected data set of the notification.
     * </p>
     * 
     * @return Affected data set of the notification.
     */
    public final String dataSetId() {
        return dataSetId;
    }

    /**
     * <p>
     * Extra details specific to this notification type.
     * </p>
     * 
     * @return Extra details specific to this notification type.
     */
    public final NotificationDetails details() {
        return details;
    }

    /**
     * <p>
     * The type of the notification. Describing the kind of event the notification is alerting you to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link NotificationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the notification. Describing the kind of event the notification is alerting you to.
     * @see NotificationType
     */
    public final NotificationType type() {
        return NotificationType.fromValue(type);
    }

    /**
     * <p>
     * The type of the notification. Describing the kind of event the notification is alerting you to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link NotificationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the notification. Describing the kind of event the notification is alerting you to.
     * @see NotificationType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(scope());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        hashCode = 31 * hashCode + Objects.hashCode(dataSetId());
        hashCode = 31 * hashCode + Objects.hashCode(details());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendDataSetNotificationRequest)) {
            return false;
        }
        SendDataSetNotificationRequest other = (SendDataSetNotificationRequest) obj;
        return Objects.equals(scope(), other.scope()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(comment(), other.comment()) && Objects.equals(dataSetId(), other.dataSetId())
                && Objects.equals(details(), other.details()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SendDataSetNotificationRequest").add("Scope", scope()).add("ClientToken", clientToken())
                .add("Comment", comment()).add("DataSetId", dataSetId()).add("Details", details()).add("Type", typeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Scope":
            return Optional.ofNullable(clazz.cast(scope()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Comment":
            return Optional.ofNullable(clazz.cast(comment()));
        case "DataSetId":
            return Optional.ofNullable(clazz.cast(dataSetId()));
        case "Details":
            return Optional.ofNullable(clazz.cast(details()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendDataSetNotificationRequest, T> g) {
        return obj -> g.apply((SendDataSetNotificationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataExchangeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, SendDataSetNotificationRequest> {
        /**
         * <p>
         * Affected scope of this notification such as the underlying resources affected by the notification event.
         * </p>
         * 
         * @param scope
         *        Affected scope of this notification such as the underlying resources affected by the notification
         *        event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scope(ScopeDetails scope);

        /**
         * <p>
         * Affected scope of this notification such as the underlying resources affected by the notification event.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScopeDetails.Builder} avoiding the need
         * to create one manually via {@link ScopeDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScopeDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #scope(ScopeDetails)}.
         * 
         * @param scope
         *        a consumer that will call methods on {@link ScopeDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scope(ScopeDetails)
         */
        default Builder scope(Consumer<ScopeDetails.Builder> scope) {
            return scope(ScopeDetails.builder().applyMutation(scope).build());
        }

        /**
         * <p>
         * Idempotency key for the notification, this key allows us to deduplicate notifications that are sent in quick
         * succession erroneously.
         * </p>
         * 
         * @param clientToken
         *        Idempotency key for the notification, this key allows us to deduplicate notifications that are sent in
         *        quick succession erroneously.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Free-form text field for providers to add information about their notifications.
         * </p>
         * 
         * @param comment
         *        Free-form text field for providers to add information about their notifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * <p>
         * Affected data set of the notification.
         * </p>
         * 
         * @param dataSetId
         *        Affected data set of the notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetId(String dataSetId);

        /**
         * <p>
         * Extra details specific to this notification type.
         * </p>
         * 
         * @param details
         *        Extra details specific to this notification type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(NotificationDetails details);

        /**
         * <p>
         * Extra details specific to this notification type.
         * </p>
         * This is a convenience method that creates an instance of the {@link NotificationDetails.Builder} avoiding the
         * need to create one manually via {@link NotificationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NotificationDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #details(NotificationDetails)}.
         * 
         * @param details
         *        a consumer that will call methods on {@link NotificationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #details(NotificationDetails)
         */
        default Builder details(Consumer<NotificationDetails.Builder> details) {
            return details(NotificationDetails.builder().applyMutation(details).build());
        }

        /**
         * <p>
         * The type of the notification. Describing the kind of event the notification is alerting you to.
         * </p>
         * 
         * @param type
         *        The type of the notification. Describing the kind of event the notification is alerting you to.
         * @see NotificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the notification. Describing the kind of event the notification is alerting you to.
         * </p>
         * 
         * @param type
         *        The type of the notification. Describing the kind of event the notification is alerting you to.
         * @see NotificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationType
         */
        Builder type(NotificationType type);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataExchangeRequest.BuilderImpl implements Builder {
        private ScopeDetails scope;

        private String clientToken;

        private String comment;

        private String dataSetId;

        private NotificationDetails details;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(SendDataSetNotificationRequest model) {
            super(model);
            scope(model.scope);
            clientToken(model.clientToken);
            comment(model.comment);
            dataSetId(model.dataSetId);
            details(model.details);
            type(model.type);
        }

        public final ScopeDetails.Builder getScope() {
            return scope != null ? scope.toBuilder() : null;
        }

        public final void setScope(ScopeDetails.BuilderImpl scope) {
            this.scope = scope != null ? scope.build() : null;
        }

        @Override
        public final Builder scope(ScopeDetails scope) {
            this.scope = scope;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getComment() {
            return comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final String getDataSetId() {
            return dataSetId;
        }

        public final void setDataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
        }

        @Override
        public final Builder dataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
            return this;
        }

        public final NotificationDetails.Builder getDetails() {
            return details != null ? details.toBuilder() : null;
        }

        public final void setDetails(NotificationDetails.BuilderImpl details) {
            this.details = details != null ? details.build() : null;
        }

        @Override
        public final Builder details(NotificationDetails details) {
            this.details = details;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(NotificationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendDataSetNotificationRequest build() {
            return new SendDataSetNotificationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
