/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the scope of the notifications such as the affected resources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScopeDetails implements SdkPojo, Serializable, ToCopyableBuilder<ScopeDetails.Builder, ScopeDetails> {
    private static final SdkField<List<LakeFormationTagPolicyDetails>> LAKE_FORMATION_TAG_POLICIES_FIELD = SdkField
            .<List<LakeFormationTagPolicyDetails>> builder(MarshallingType.LIST)
            .memberName("LakeFormationTagPolicies")
            .getter(getter(ScopeDetails::lakeFormationTagPolicies))
            .setter(setter(Builder::lakeFormationTagPolicies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LakeFormationTagPolicies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LakeFormationTagPolicyDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(LakeFormationTagPolicyDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<RedshiftDataShareDetails>> REDSHIFT_DATA_SHARES_FIELD = SdkField
            .<List<RedshiftDataShareDetails>> builder(MarshallingType.LIST)
            .memberName("RedshiftDataShares")
            .getter(getter(ScopeDetails::redshiftDataShares))
            .setter(setter(Builder::redshiftDataShares))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedshiftDataShares").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RedshiftDataShareDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(RedshiftDataShareDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<S3DataAccessDetails>> S3_DATA_ACCESSES_FIELD = SdkField
            .<List<S3DataAccessDetails>> builder(MarshallingType.LIST)
            .memberName("S3DataAccesses")
            .getter(getter(ScopeDetails::s3DataAccesses))
            .setter(setter(Builder::s3DataAccesses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3DataAccesses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<S3DataAccessDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(S3DataAccessDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LAKE_FORMATION_TAG_POLICIES_FIELD, REDSHIFT_DATA_SHARES_FIELD, S3_DATA_ACCESSES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<LakeFormationTagPolicyDetails> lakeFormationTagPolicies;

    private final List<RedshiftDataShareDetails> redshiftDataShares;

    private final List<S3DataAccessDetails> s3DataAccesses;

    private ScopeDetails(BuilderImpl builder) {
        this.lakeFormationTagPolicies = builder.lakeFormationTagPolicies;
        this.redshiftDataShares = builder.redshiftDataShares;
        this.s3DataAccesses = builder.s3DataAccesses;
    }

    /**
     * For responses, this returns true if the service returned a value for the LakeFormationTagPolicies property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLakeFormationTagPolicies() {
        return lakeFormationTagPolicies != null && !(lakeFormationTagPolicies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Underlying LF resources that will be affected by this notification.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLakeFormationTagPolicies} method.
     * </p>
     * 
     * @return Underlying LF resources that will be affected by this notification.
     */
    public final List<LakeFormationTagPolicyDetails> lakeFormationTagPolicies() {
        return lakeFormationTagPolicies;
    }

    /**
     * For responses, this returns true if the service returned a value for the RedshiftDataShares property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRedshiftDataShares() {
        return redshiftDataShares != null && !(redshiftDataShares instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Underlying Redshift resources that will be affected by this notification.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRedshiftDataShares} method.
     * </p>
     * 
     * @return Underlying Redshift resources that will be affected by this notification.
     */
    public final List<RedshiftDataShareDetails> redshiftDataShares() {
        return redshiftDataShares;
    }

    /**
     * For responses, this returns true if the service returned a value for the S3DataAccesses property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasS3DataAccesses() {
        return s3DataAccesses != null && !(s3DataAccesses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Underlying S3 resources that will be affected by this notification.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasS3DataAccesses} method.
     * </p>
     * 
     * @return Underlying S3 resources that will be affected by this notification.
     */
    public final List<S3DataAccessDetails> s3DataAccesses() {
        return s3DataAccesses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasLakeFormationTagPolicies() ? lakeFormationTagPolicies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRedshiftDataShares() ? redshiftDataShares() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasS3DataAccesses() ? s3DataAccesses() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScopeDetails)) {
            return false;
        }
        ScopeDetails other = (ScopeDetails) obj;
        return hasLakeFormationTagPolicies() == other.hasLakeFormationTagPolicies()
                && Objects.equals(lakeFormationTagPolicies(), other.lakeFormationTagPolicies())
                && hasRedshiftDataShares() == other.hasRedshiftDataShares()
                && Objects.equals(redshiftDataShares(), other.redshiftDataShares())
                && hasS3DataAccesses() == other.hasS3DataAccesses() && Objects.equals(s3DataAccesses(), other.s3DataAccesses());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScopeDetails")
                .add("LakeFormationTagPolicies", hasLakeFormationTagPolicies() ? lakeFormationTagPolicies() : null)
                .add("RedshiftDataShares", hasRedshiftDataShares() ? redshiftDataShares() : null)
                .add("S3DataAccesses", hasS3DataAccesses() ? s3DataAccesses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LakeFormationTagPolicies":
            return Optional.ofNullable(clazz.cast(lakeFormationTagPolicies()));
        case "RedshiftDataShares":
            return Optional.ofNullable(clazz.cast(redshiftDataShares()));
        case "S3DataAccesses":
            return Optional.ofNullable(clazz.cast(s3DataAccesses()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScopeDetails, T> g) {
        return obj -> g.apply((ScopeDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScopeDetails> {
        /**
         * <p>
         * Underlying LF resources that will be affected by this notification.
         * </p>
         * 
         * @param lakeFormationTagPolicies
         *        Underlying LF resources that will be affected by this notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lakeFormationTagPolicies(Collection<LakeFormationTagPolicyDetails> lakeFormationTagPolicies);

        /**
         * <p>
         * Underlying LF resources that will be affected by this notification.
         * </p>
         * 
         * @param lakeFormationTagPolicies
         *        Underlying LF resources that will be affected by this notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lakeFormationTagPolicies(LakeFormationTagPolicyDetails... lakeFormationTagPolicies);

        /**
         * <p>
         * Underlying LF resources that will be affected by this notification.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.dataexchange.model.LakeFormationTagPolicyDetails.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.dataexchange.model.LakeFormationTagPolicyDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.dataexchange.model.LakeFormationTagPolicyDetails.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #lakeFormationTagPolicies(List<LakeFormationTagPolicyDetails>)}.
         * 
         * @param lakeFormationTagPolicies
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.dataexchange.model.LakeFormationTagPolicyDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lakeFormationTagPolicies(java.util.Collection<LakeFormationTagPolicyDetails>)
         */
        Builder lakeFormationTagPolicies(Consumer<LakeFormationTagPolicyDetails.Builder>... lakeFormationTagPolicies);

        /**
         * <p>
         * Underlying Redshift resources that will be affected by this notification.
         * </p>
         * 
         * @param redshiftDataShares
         *        Underlying Redshift resources that will be affected by this notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshiftDataShares(Collection<RedshiftDataShareDetails> redshiftDataShares);

        /**
         * <p>
         * Underlying Redshift resources that will be affected by this notification.
         * </p>
         * 
         * @param redshiftDataShares
         *        Underlying Redshift resources that will be affected by this notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshiftDataShares(RedshiftDataShareDetails... redshiftDataShares);

        /**
         * <p>
         * Underlying Redshift resources that will be affected by this notification.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.dataexchange.model.RedshiftDataShareDetails.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.dataexchange.model.RedshiftDataShareDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.dataexchange.model.RedshiftDataShareDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #redshiftDataShares(List<RedshiftDataShareDetails>)}.
         * 
         * @param redshiftDataShares
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.dataexchange.model.RedshiftDataShareDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #redshiftDataShares(java.util.Collection<RedshiftDataShareDetails>)
         */
        Builder redshiftDataShares(Consumer<RedshiftDataShareDetails.Builder>... redshiftDataShares);

        /**
         * <p>
         * Underlying S3 resources that will be affected by this notification.
         * </p>
         * 
         * @param s3DataAccesses
         *        Underlying S3 resources that will be affected by this notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3DataAccesses(Collection<S3DataAccessDetails> s3DataAccesses);

        /**
         * <p>
         * Underlying S3 resources that will be affected by this notification.
         * </p>
         * 
         * @param s3DataAccesses
         *        Underlying S3 resources that will be affected by this notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3DataAccesses(S3DataAccessDetails... s3DataAccesses);

        /**
         * <p>
         * Underlying S3 resources that will be affected by this notification.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.dataexchange.model.S3DataAccessDetails.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.dataexchange.model.S3DataAccessDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.dataexchange.model.S3DataAccessDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #s3DataAccesses(List<S3DataAccessDetails>)}.
         * 
         * @param s3DataAccesses
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.dataexchange.model.S3DataAccessDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3DataAccesses(java.util.Collection<S3DataAccessDetails>)
         */
        Builder s3DataAccesses(Consumer<S3DataAccessDetails.Builder>... s3DataAccesses);
    }

    static final class BuilderImpl implements Builder {
        private List<LakeFormationTagPolicyDetails> lakeFormationTagPolicies = DefaultSdkAutoConstructList.getInstance();

        private List<RedshiftDataShareDetails> redshiftDataShares = DefaultSdkAutoConstructList.getInstance();

        private List<S3DataAccessDetails> s3DataAccesses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ScopeDetails model) {
            lakeFormationTagPolicies(model.lakeFormationTagPolicies);
            redshiftDataShares(model.redshiftDataShares);
            s3DataAccesses(model.s3DataAccesses);
        }

        public final List<LakeFormationTagPolicyDetails.Builder> getLakeFormationTagPolicies() {
            List<LakeFormationTagPolicyDetails.Builder> result = ListOfLakeFormationTagPoliciesCopier
                    .copyToBuilder(this.lakeFormationTagPolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLakeFormationTagPolicies(
                Collection<LakeFormationTagPolicyDetails.BuilderImpl> lakeFormationTagPolicies) {
            this.lakeFormationTagPolicies = ListOfLakeFormationTagPoliciesCopier.copyFromBuilder(lakeFormationTagPolicies);
        }

        @Override
        public final Builder lakeFormationTagPolicies(Collection<LakeFormationTagPolicyDetails> lakeFormationTagPolicies) {
            this.lakeFormationTagPolicies = ListOfLakeFormationTagPoliciesCopier.copy(lakeFormationTagPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lakeFormationTagPolicies(LakeFormationTagPolicyDetails... lakeFormationTagPolicies) {
            lakeFormationTagPolicies(Arrays.asList(lakeFormationTagPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lakeFormationTagPolicies(Consumer<LakeFormationTagPolicyDetails.Builder>... lakeFormationTagPolicies) {
            lakeFormationTagPolicies(Stream.of(lakeFormationTagPolicies)
                    .map(c -> LakeFormationTagPolicyDetails.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<RedshiftDataShareDetails.Builder> getRedshiftDataShares() {
            List<RedshiftDataShareDetails.Builder> result = ListOfRedshiftDataSharesCopier.copyToBuilder(this.redshiftDataShares);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRedshiftDataShares(Collection<RedshiftDataShareDetails.BuilderImpl> redshiftDataShares) {
            this.redshiftDataShares = ListOfRedshiftDataSharesCopier.copyFromBuilder(redshiftDataShares);
        }

        @Override
        public final Builder redshiftDataShares(Collection<RedshiftDataShareDetails> redshiftDataShares) {
            this.redshiftDataShares = ListOfRedshiftDataSharesCopier.copy(redshiftDataShares);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder redshiftDataShares(RedshiftDataShareDetails... redshiftDataShares) {
            redshiftDataShares(Arrays.asList(redshiftDataShares));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder redshiftDataShares(Consumer<RedshiftDataShareDetails.Builder>... redshiftDataShares) {
            redshiftDataShares(Stream.of(redshiftDataShares)
                    .map(c -> RedshiftDataShareDetails.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<S3DataAccessDetails.Builder> getS3DataAccesses() {
            List<S3DataAccessDetails.Builder> result = ListOfS3DataAccessesCopier.copyToBuilder(this.s3DataAccesses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setS3DataAccesses(Collection<S3DataAccessDetails.BuilderImpl> s3DataAccesses) {
            this.s3DataAccesses = ListOfS3DataAccessesCopier.copyFromBuilder(s3DataAccesses);
        }

        @Override
        public final Builder s3DataAccesses(Collection<S3DataAccessDetails> s3DataAccesses) {
            this.s3DataAccesses = ListOfS3DataAccessesCopier.copy(s3DataAccesses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3DataAccesses(S3DataAccessDetails... s3DataAccesses) {
            s3DataAccesses(Arrays.asList(s3DataAccesses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3DataAccesses(Consumer<S3DataAccessDetails.Builder>... s3DataAccesses) {
            s3DataAccesses(Stream.of(s3DataAccesses).map(c -> S3DataAccessDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ScopeDetails build() {
            return new ScopeDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
