/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ListOfS3DataAccessesCopier {
    static List<S3DataAccessDetails> copy(Collection<? extends S3DataAccessDetails> listOfS3DataAccessesParam) {
        List<S3DataAccessDetails> list;
        if (listOfS3DataAccessesParam == null || listOfS3DataAccessesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<S3DataAccessDetails> modifiableList = new ArrayList<>();
            listOfS3DataAccessesParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<S3DataAccessDetails> copyFromBuilder(Collection<? extends S3DataAccessDetails.Builder> listOfS3DataAccessesParam) {
        List<S3DataAccessDetails> list;
        if (listOfS3DataAccessesParam == null || listOfS3DataAccessesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<S3DataAccessDetails> modifiableList = new ArrayList<>();
            listOfS3DataAccessesParam.forEach(entry -> {
                S3DataAccessDetails member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<S3DataAccessDetails.Builder> copyToBuilder(Collection<? extends S3DataAccessDetails> listOfS3DataAccessesParam) {
        List<S3DataAccessDetails.Builder> list;
        if (listOfS3DataAccessesParam == null || listOfS3DataAccessesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<S3DataAccessDetails.Builder> modifiableList = new ArrayList<>();
            listOfS3DataAccessesParam.forEach(entry -> {
                S3DataAccessDetails.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
