/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Extra details specific to the affected scope in this LF data set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LakeFormationTagPolicyDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<LakeFormationTagPolicyDetails.Builder, LakeFormationTagPolicyDetails> {
    private static final SdkField<String> DATABASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Database").getter(getter(LakeFormationTagPolicyDetails::database)).setter(setter(Builder::database))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()).build();

    private static final SdkField<String> TABLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Table")
            .getter(getter(LakeFormationTagPolicyDetails::table)).setter(setter(Builder::table))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Table").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_FIELD, TABLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String database;

    private final String table;

    private LakeFormationTagPolicyDetails(BuilderImpl builder) {
        this.database = builder.database;
        this.table = builder.table;
    }

    /**
     * <p>
     * The underlying Glue database that the notification is referring to.
     * </p>
     * 
     * @return The underlying Glue database that the notification is referring to.
     */
    public final String database() {
        return database;
    }

    /**
     * <p>
     * The underlying Glue table that the notification is referring to.
     * </p>
     * 
     * @return The underlying Glue table that the notification is referring to.
     */
    public final String table() {
        return table;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(database());
        hashCode = 31 * hashCode + Objects.hashCode(table());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LakeFormationTagPolicyDetails)) {
            return false;
        }
        LakeFormationTagPolicyDetails other = (LakeFormationTagPolicyDetails) obj;
        return Objects.equals(database(), other.database()) && Objects.equals(table(), other.table());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LakeFormationTagPolicyDetails").add("Database", database()).add("Table", table()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Database":
            return Optional.ofNullable(clazz.cast(database()));
        case "Table":
            return Optional.ofNullable(clazz.cast(table()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LakeFormationTagPolicyDetails, T> g) {
        return obj -> g.apply((LakeFormationTagPolicyDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LakeFormationTagPolicyDetails> {
        /**
         * <p>
         * The underlying Glue database that the notification is referring to.
         * </p>
         * 
         * @param database
         *        The underlying Glue database that the notification is referring to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder database(String database);

        /**
         * <p>
         * The underlying Glue table that the notification is referring to.
         * </p>
         * 
         * @param table
         *        The underlying Glue table that the notification is referring to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder table(String table);
    }

    static final class BuilderImpl implements Builder {
        private String database;

        private String table;

        private BuilderImpl() {
        }

        private BuilderImpl(LakeFormationTagPolicyDetails model) {
            database(model.database);
            table(model.table);
        }

        public final String getDatabase() {
            return database;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final String getTable() {
            return table;
        }

        public final void setTable(String table) {
            this.table = table;
        }

        @Override
        public final Builder table(String table) {
            this.table = table;
            return this;
        }

        @Override
        public LakeFormationTagPolicyDetails build() {
            return new LakeFormationTagPolicyDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
