/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Extra details specific to the affected scope in this S3 Data Access data set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3DataAccessDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<S3DataAccessDetails.Builder, S3DataAccessDetails> {
    private static final SdkField<List<String>> KEY_PREFIXES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("KeyPrefixes")
            .getter(getter(S3DataAccessDetails::keyPrefixes))
            .setter(setter(Builder::keyPrefixes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyPrefixes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> KEYS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Keys")
            .getter(getter(S3DataAccessDetails::keys))
            .setter(setter(Builder::keys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Keys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(KEY_PREFIXES_FIELD, KEYS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> keyPrefixes;

    private final List<String> keys;

    private S3DataAccessDetails(BuilderImpl builder) {
        this.keyPrefixes = builder.keyPrefixes;
        this.keys = builder.keys;
    }

    /**
     * For responses, this returns true if the service returned a value for the KeyPrefixes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasKeyPrefixes() {
        return keyPrefixes != null && !(keyPrefixes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the key prefixes affected by this notification. This can have up to 50 entries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKeyPrefixes} method.
     * </p>
     * 
     * @return A list of the key prefixes affected by this notification. This can have up to 50 entries.
     */
    public final List<String> keyPrefixes() {
        return keyPrefixes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Keys property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasKeys() {
        return keys != null && !(keys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the keys affected by this notification. This can have up to 50 entries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKeys} method.
     * </p>
     * 
     * @return A list of the keys affected by this notification. This can have up to 50 entries.
     */
    public final List<String> keys() {
        return keys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasKeyPrefixes() ? keyPrefixes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasKeys() ? keys() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3DataAccessDetails)) {
            return false;
        }
        S3DataAccessDetails other = (S3DataAccessDetails) obj;
        return hasKeyPrefixes() == other.hasKeyPrefixes() && Objects.equals(keyPrefixes(), other.keyPrefixes())
                && hasKeys() == other.hasKeys() && Objects.equals(keys(), other.keys());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3DataAccessDetails").add("KeyPrefixes", hasKeyPrefixes() ? keyPrefixes() : null)
                .add("Keys", hasKeys() ? keys() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyPrefixes":
            return Optional.ofNullable(clazz.cast(keyPrefixes()));
        case "Keys":
            return Optional.ofNullable(clazz.cast(keys()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3DataAccessDetails, T> g) {
        return obj -> g.apply((S3DataAccessDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3DataAccessDetails> {
        /**
         * <p>
         * A list of the key prefixes affected by this notification. This can have up to 50 entries.
         * </p>
         * 
         * @param keyPrefixes
         *        A list of the key prefixes affected by this notification. This can have up to 50 entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPrefixes(Collection<String> keyPrefixes);

        /**
         * <p>
         * A list of the key prefixes affected by this notification. This can have up to 50 entries.
         * </p>
         * 
         * @param keyPrefixes
         *        A list of the key prefixes affected by this notification. This can have up to 50 entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPrefixes(String... keyPrefixes);

        /**
         * <p>
         * A list of the keys affected by this notification. This can have up to 50 entries.
         * </p>
         * 
         * @param keys
         *        A list of the keys affected by this notification. This can have up to 50 entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keys(Collection<String> keys);

        /**
         * <p>
         * A list of the keys affected by this notification. This can have up to 50 entries.
         * </p>
         * 
         * @param keys
         *        A list of the keys affected by this notification. This can have up to 50 entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keys(String... keys);
    }

    static final class BuilderImpl implements Builder {
        private List<String> keyPrefixes = DefaultSdkAutoConstructList.getInstance();

        private List<String> keys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(S3DataAccessDetails model) {
            keyPrefixes(model.keyPrefixes);
            keys(model.keys);
        }

        public final Collection<String> getKeyPrefixes() {
            if (keyPrefixes instanceof SdkAutoConstructList) {
                return null;
            }
            return keyPrefixes;
        }

        public final void setKeyPrefixes(Collection<String> keyPrefixes) {
            this.keyPrefixes = ListOf__stringCopier.copy(keyPrefixes);
        }

        @Override
        public final Builder keyPrefixes(Collection<String> keyPrefixes) {
            this.keyPrefixes = ListOf__stringCopier.copy(keyPrefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyPrefixes(String... keyPrefixes) {
            keyPrefixes(Arrays.asList(keyPrefixes));
            return this;
        }

        public final Collection<String> getKeys() {
            if (keys instanceof SdkAutoConstructList) {
                return null;
            }
            return keys;
        }

        public final void setKeys(Collection<String> keys) {
            this.keys = ListOf__stringCopier.copy(keys);
        }

        @Override
        public final Builder keys(Collection<String> keys) {
            this.keys = ListOf__stringCopier.copy(keys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keys(String... keys) {
            keys(Arrays.asList(keys));
            return this;
        }

        @Override
        public S3DataAccessDetails build() {
            return new S3DataAccessDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
