/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Extra details specific to this notification.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NotificationDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<NotificationDetails.Builder, NotificationDetails> {
    private static final SdkField<DataUpdateRequestDetails> DATA_UPDATE_FIELD = SdkField
            .<DataUpdateRequestDetails> builder(MarshallingType.SDK_POJO).memberName("DataUpdate")
            .getter(getter(NotificationDetails::dataUpdate)).setter(setter(Builder::dataUpdate))
            .constructor(DataUpdateRequestDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataUpdate").build()).build();

    private static final SdkField<DeprecationRequestDetails> DEPRECATION_FIELD = SdkField
            .<DeprecationRequestDetails> builder(MarshallingType.SDK_POJO).memberName("Deprecation")
            .getter(getter(NotificationDetails::deprecation)).setter(setter(Builder::deprecation))
            .constructor(DeprecationRequestDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Deprecation").build()).build();

    private static final SdkField<SchemaChangeRequestDetails> SCHEMA_CHANGE_FIELD = SdkField
            .<SchemaChangeRequestDetails> builder(MarshallingType.SDK_POJO).memberName("SchemaChange")
            .getter(getter(NotificationDetails::schemaChange)).setter(setter(Builder::schemaChange))
            .constructor(SchemaChangeRequestDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaChange").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_UPDATE_FIELD,
            DEPRECATION_FIELD, SCHEMA_CHANGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final DataUpdateRequestDetails dataUpdate;

    private final DeprecationRequestDetails deprecation;

    private final SchemaChangeRequestDetails schemaChange;

    private NotificationDetails(BuilderImpl builder) {
        this.dataUpdate = builder.dataUpdate;
        this.deprecation = builder.deprecation;
        this.schemaChange = builder.schemaChange;
    }

    /**
     * <p>
     * Extra details specific to a data update type notification.
     * </p>
     * 
     * @return Extra details specific to a data update type notification.
     */
    public final DataUpdateRequestDetails dataUpdate() {
        return dataUpdate;
    }

    /**
     * <p>
     * Extra details specific to a deprecation type notification.
     * </p>
     * 
     * @return Extra details specific to a deprecation type notification.
     */
    public final DeprecationRequestDetails deprecation() {
        return deprecation;
    }

    /**
     * <p>
     * Extra details specific to a schema change type notification.
     * </p>
     * 
     * @return Extra details specific to a schema change type notification.
     */
    public final SchemaChangeRequestDetails schemaChange() {
        return schemaChange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(deprecation());
        hashCode = 31 * hashCode + Objects.hashCode(schemaChange());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationDetails)) {
            return false;
        }
        NotificationDetails other = (NotificationDetails) obj;
        return Objects.equals(dataUpdate(), other.dataUpdate()) && Objects.equals(deprecation(), other.deprecation())
                && Objects.equals(schemaChange(), other.schemaChange());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NotificationDetails").add("DataUpdate", dataUpdate()).add("Deprecation", deprecation())
                .add("SchemaChange", schemaChange()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataUpdate":
            return Optional.ofNullable(clazz.cast(dataUpdate()));
        case "Deprecation":
            return Optional.ofNullable(clazz.cast(deprecation()));
        case "SchemaChange":
            return Optional.ofNullable(clazz.cast(schemaChange()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NotificationDetails, T> g) {
        return obj -> g.apply((NotificationDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NotificationDetails> {
        /**
         * <p>
         * Extra details specific to a data update type notification.
         * </p>
         * 
         * @param dataUpdate
         *        Extra details specific to a data update type notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataUpdate(DataUpdateRequestDetails dataUpdate);

        /**
         * <p>
         * Extra details specific to a data update type notification.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataUpdateRequestDetails.Builder}
         * avoiding the need to create one manually via {@link DataUpdateRequestDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataUpdateRequestDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #dataUpdate(DataUpdateRequestDetails)}.
         * 
         * @param dataUpdate
         *        a consumer that will call methods on {@link DataUpdateRequestDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataUpdate(DataUpdateRequestDetails)
         */
        default Builder dataUpdate(Consumer<DataUpdateRequestDetails.Builder> dataUpdate) {
            return dataUpdate(DataUpdateRequestDetails.builder().applyMutation(dataUpdate).build());
        }

        /**
         * <p>
         * Extra details specific to a deprecation type notification.
         * </p>
         * 
         * @param deprecation
         *        Extra details specific to a deprecation type notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deprecation(DeprecationRequestDetails deprecation);

        /**
         * <p>
         * Extra details specific to a deprecation type notification.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeprecationRequestDetails.Builder}
         * avoiding the need to create one manually via {@link DeprecationRequestDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeprecationRequestDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #deprecation(DeprecationRequestDetails)}.
         * 
         * @param deprecation
         *        a consumer that will call methods on {@link DeprecationRequestDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deprecation(DeprecationRequestDetails)
         */
        default Builder deprecation(Consumer<DeprecationRequestDetails.Builder> deprecation) {
            return deprecation(DeprecationRequestDetails.builder().applyMutation(deprecation).build());
        }

        /**
         * <p>
         * Extra details specific to a schema change type notification.
         * </p>
         * 
         * @param schemaChange
         *        Extra details specific to a schema change type notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaChange(SchemaChangeRequestDetails schemaChange);

        /**
         * <p>
         * Extra details specific to a schema change type notification.
         * </p>
         * This is a convenience method that creates an instance of the {@link SchemaChangeRequestDetails.Builder}
         * avoiding the need to create one manually via {@link SchemaChangeRequestDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SchemaChangeRequestDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #schemaChange(SchemaChangeRequestDetails)}.
         * 
         * @param schemaChange
         *        a consumer that will call methods on {@link SchemaChangeRequestDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schemaChange(SchemaChangeRequestDetails)
         */
        default Builder schemaChange(Consumer<SchemaChangeRequestDetails.Builder> schemaChange) {
            return schemaChange(SchemaChangeRequestDetails.builder().applyMutation(schemaChange).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DataUpdateRequestDetails dataUpdate;

        private DeprecationRequestDetails deprecation;

        private SchemaChangeRequestDetails schemaChange;

        private BuilderImpl() {
        }

        private BuilderImpl(NotificationDetails model) {
            dataUpdate(model.dataUpdate);
            deprecation(model.deprecation);
            schemaChange(model.schemaChange);
        }

        public final DataUpdateRequestDetails.Builder getDataUpdate() {
            return dataUpdate != null ? dataUpdate.toBuilder() : null;
        }

        public final void setDataUpdate(DataUpdateRequestDetails.BuilderImpl dataUpdate) {
            this.dataUpdate = dataUpdate != null ? dataUpdate.build() : null;
        }

        @Override
        public final Builder dataUpdate(DataUpdateRequestDetails dataUpdate) {
            this.dataUpdate = dataUpdate;
            return this;
        }

        public final DeprecationRequestDetails.Builder getDeprecation() {
            return deprecation != null ? deprecation.toBuilder() : null;
        }

        public final void setDeprecation(DeprecationRequestDetails.BuilderImpl deprecation) {
            this.deprecation = deprecation != null ? deprecation.build() : null;
        }

        @Override
        public final Builder deprecation(DeprecationRequestDetails deprecation) {
            this.deprecation = deprecation;
            return this;
        }

        public final SchemaChangeRequestDetails.Builder getSchemaChange() {
            return schemaChange != null ? schemaChange.toBuilder() : null;
        }

        public final void setSchemaChange(SchemaChangeRequestDetails.BuilderImpl schemaChange) {
            this.schemaChange = schemaChange != null ? schemaChange.build() : null;
        }

        @Override
        public final Builder schemaChange(SchemaChangeRequestDetails schemaChange) {
            this.schemaChange = schemaChange;
            return this;
        }

        @Override
        public NotificationDetails build() {
            return new NotificationDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
