/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The LF-tag policy and permissions that apply to table resources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TableLFTagPolicyAndPermissions implements SdkPojo, Serializable,
        ToCopyableBuilder<TableLFTagPolicyAndPermissions.Builder, TableLFTagPolicyAndPermissions> {
    private static final SdkField<List<LFTag>> EXPRESSION_FIELD = SdkField
            .<List<LFTag>> builder(MarshallingType.LIST)
            .memberName("Expression")
            .getter(getter(TableLFTagPolicyAndPermissions::expression))
            .setter(setter(Builder::expression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expression").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LFTag> builder(MarshallingType.SDK_POJO)
                                            .constructor(LFTag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> PERMISSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Permissions")
            .getter(getter(TableLFTagPolicyAndPermissions::permissionsAsStrings))
            .setter(setter(Builder::permissionsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPRESSION_FIELD,
            PERMISSIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<LFTag> expression;

    private final List<String> permissions;

    private TableLFTagPolicyAndPermissions(BuilderImpl builder) {
        this.expression = builder.expression;
        this.permissions = builder.permissions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Expression property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasExpression() {
        return expression != null && !(expression instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of LF-tag conditions that apply to table resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExpression} method.
     * </p>
     * 
     * @return A list of LF-tag conditions that apply to table resources.
     */
    public final List<LFTag> expression() {
        return expression;
    }

    /**
     * <p>
     * The permissions granted to subscribers on table resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPermissions} method.
     * </p>
     * 
     * @return The permissions granted to subscribers on table resources.
     */
    public final List<TableTagPolicyLFPermission> permissions() {
        return ListOfTableTagPolicyLFPermissionsCopier.copyStringToEnum(permissions);
    }

    /**
     * For responses, this returns true if the service returned a value for the Permissions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPermissions() {
        return permissions != null && !(permissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The permissions granted to subscribers on table resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPermissions} method.
     * </p>
     * 
     * @return The permissions granted to subscribers on table resources.
     */
    public final List<String> permissionsAsStrings() {
        return permissions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasExpression() ? expression() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPermissions() ? permissionsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableLFTagPolicyAndPermissions)) {
            return false;
        }
        TableLFTagPolicyAndPermissions other = (TableLFTagPolicyAndPermissions) obj;
        return hasExpression() == other.hasExpression() && Objects.equals(expression(), other.expression())
                && hasPermissions() == other.hasPermissions()
                && Objects.equals(permissionsAsStrings(), other.permissionsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TableLFTagPolicyAndPermissions").add("Expression", hasExpression() ? expression() : null)
                .add("Permissions", hasPermissions() ? permissionsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Expression":
            return Optional.ofNullable(clazz.cast(expression()));
        case "Permissions":
            return Optional.ofNullable(clazz.cast(permissionsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TableLFTagPolicyAndPermissions, T> g) {
        return obj -> g.apply((TableLFTagPolicyAndPermissions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TableLFTagPolicyAndPermissions> {
        /**
         * <p>
         * A list of LF-tag conditions that apply to table resources.
         * </p>
         * 
         * @param expression
         *        A list of LF-tag conditions that apply to table resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expression(Collection<LFTag> expression);

        /**
         * <p>
         * A list of LF-tag conditions that apply to table resources.
         * </p>
         * 
         * @param expression
         *        A list of LF-tag conditions that apply to table resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expression(LFTag... expression);

        /**
         * <p>
         * A list of LF-tag conditions that apply to table resources.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.dataexchange.model.LFTag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.dataexchange.model.LFTag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.dataexchange.model.LFTag.Builder#build()} is called immediately and
         * its result is passed to {@link #expression(List<LFTag>)}.
         * 
         * @param expression
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.dataexchange.model.LFTag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #expression(java.util.Collection<LFTag>)
         */
        Builder expression(Consumer<LFTag.Builder>... expression);

        /**
         * <p>
         * The permissions granted to subscribers on table resources.
         * </p>
         * 
         * @param permissions
         *        The permissions granted to subscribers on table resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsWithStrings(Collection<String> permissions);

        /**
         * <p>
         * The permissions granted to subscribers on table resources.
         * </p>
         * 
         * @param permissions
         *        The permissions granted to subscribers on table resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsWithStrings(String... permissions);

        /**
         * <p>
         * The permissions granted to subscribers on table resources.
         * </p>
         * 
         * @param permissions
         *        The permissions granted to subscribers on table resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(Collection<TableTagPolicyLFPermission> permissions);

        /**
         * <p>
         * The permissions granted to subscribers on table resources.
         * </p>
         * 
         * @param permissions
         *        The permissions granted to subscribers on table resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(TableTagPolicyLFPermission... permissions);
    }

    static final class BuilderImpl implements Builder {
        private List<LFTag> expression = DefaultSdkAutoConstructList.getInstance();

        private List<String> permissions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TableLFTagPolicyAndPermissions model) {
            expression(model.expression);
            permissionsWithStrings(model.permissions);
        }

        public final List<LFTag.Builder> getExpression() {
            List<LFTag.Builder> result = ListOfLFTagsCopier.copyToBuilder(this.expression);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExpression(Collection<LFTag.BuilderImpl> expression) {
            this.expression = ListOfLFTagsCopier.copyFromBuilder(expression);
        }

        @Override
        public final Builder expression(Collection<LFTag> expression) {
            this.expression = ListOfLFTagsCopier.copy(expression);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expression(LFTag... expression) {
            expression(Arrays.asList(expression));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expression(Consumer<LFTag.Builder>... expression) {
            expression(Stream.of(expression).map(c -> LFTag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getPermissions() {
            if (permissions instanceof SdkAutoConstructList) {
                return null;
            }
            return permissions;
        }

        public final void setPermissions(Collection<String> permissions) {
            this.permissions = ListOfTableTagPolicyLFPermissionsCopier.copy(permissions);
        }

        @Override
        public final Builder permissionsWithStrings(Collection<String> permissions) {
            this.permissions = ListOfTableTagPolicyLFPermissionsCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissionsWithStrings(String... permissions) {
            permissionsWithStrings(Arrays.asList(permissions));
            return this;
        }

        @Override
        public final Builder permissions(Collection<TableTagPolicyLFPermission> permissions) {
            this.permissions = ListOfTableTagPolicyLFPermissionsCopier.copyEnumToString(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(TableTagPolicyLFPermission... permissions) {
            permissions(Arrays.asList(permissions));
            return this;
        }

        @Override
        public TableLFTagPolicyAndPermissions build() {
            return new TableLFTagPolicyAndPermissions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
