/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details for the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RequestDetails implements SdkPojo, Serializable, ToCopyableBuilder<RequestDetails.Builder, RequestDetails> {
    private static final SdkField<ExportAssetToSignedUrlRequestDetails> EXPORT_ASSET_TO_SIGNED_URL_FIELD = SdkField
            .<ExportAssetToSignedUrlRequestDetails> builder(MarshallingType.SDK_POJO).memberName("ExportAssetToSignedUrl")
            .getter(getter(RequestDetails::exportAssetToSignedUrl)).setter(setter(Builder::exportAssetToSignedUrl))
            .constructor(ExportAssetToSignedUrlRequestDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportAssetToSignedUrl").build())
            .build();

    private static final SdkField<ExportAssetsToS3RequestDetails> EXPORT_ASSETS_TO_S3_FIELD = SdkField
            .<ExportAssetsToS3RequestDetails> builder(MarshallingType.SDK_POJO).memberName("ExportAssetsToS3")
            .getter(getter(RequestDetails::exportAssetsToS3)).setter(setter(Builder::exportAssetsToS3))
            .constructor(ExportAssetsToS3RequestDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportAssetsToS3").build()).build();

    private static final SdkField<ExportRevisionsToS3RequestDetails> EXPORT_REVISIONS_TO_S3_FIELD = SdkField
            .<ExportRevisionsToS3RequestDetails> builder(MarshallingType.SDK_POJO).memberName("ExportRevisionsToS3")
            .getter(getter(RequestDetails::exportRevisionsToS3)).setter(setter(Builder::exportRevisionsToS3))
            .constructor(ExportRevisionsToS3RequestDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportRevisionsToS3").build())
            .build();

    private static final SdkField<ImportAssetFromSignedUrlRequestDetails> IMPORT_ASSET_FROM_SIGNED_URL_FIELD = SdkField
            .<ImportAssetFromSignedUrlRequestDetails> builder(MarshallingType.SDK_POJO).memberName("ImportAssetFromSignedUrl")
            .getter(getter(RequestDetails::importAssetFromSignedUrl)).setter(setter(Builder::importAssetFromSignedUrl))
            .constructor(ImportAssetFromSignedUrlRequestDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportAssetFromSignedUrl").build())
            .build();

    private static final SdkField<ImportAssetsFromS3RequestDetails> IMPORT_ASSETS_FROM_S3_FIELD = SdkField
            .<ImportAssetsFromS3RequestDetails> builder(MarshallingType.SDK_POJO).memberName("ImportAssetsFromS3")
            .getter(getter(RequestDetails::importAssetsFromS3)).setter(setter(Builder::importAssetsFromS3))
            .constructor(ImportAssetsFromS3RequestDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportAssetsFromS3").build())
            .build();

    private static final SdkField<ImportAssetsFromRedshiftDataSharesRequestDetails> IMPORT_ASSETS_FROM_REDSHIFT_DATA_SHARES_FIELD = SdkField
            .<ImportAssetsFromRedshiftDataSharesRequestDetails> builder(MarshallingType.SDK_POJO)
            .memberName("ImportAssetsFromRedshiftDataShares")
            .getter(getter(RequestDetails::importAssetsFromRedshiftDataShares))
            .setter(setter(Builder::importAssetsFromRedshiftDataShares))
            .constructor(ImportAssetsFromRedshiftDataSharesRequestDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportAssetsFromRedshiftDataShares")
                    .build()).build();

    private static final SdkField<ImportAssetFromApiGatewayApiRequestDetails> IMPORT_ASSET_FROM_API_GATEWAY_API_FIELD = SdkField
            .<ImportAssetFromApiGatewayApiRequestDetails> builder(MarshallingType.SDK_POJO)
            .memberName("ImportAssetFromApiGatewayApi")
            .getter(getter(RequestDetails::importAssetFromApiGatewayApi))
            .setter(setter(Builder::importAssetFromApiGatewayApi))
            .constructor(ImportAssetFromApiGatewayApiRequestDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportAssetFromApiGatewayApi")
                    .build()).build();

    private static final SdkField<CreateS3DataAccessFromS3BucketRequestDetails> CREATE_S3_DATA_ACCESS_FROM_S3_BUCKET_FIELD = SdkField
            .<CreateS3DataAccessFromS3BucketRequestDetails> builder(MarshallingType.SDK_POJO)
            .memberName("CreateS3DataAccessFromS3Bucket")
            .getter(getter(RequestDetails::createS3DataAccessFromS3Bucket))
            .setter(setter(Builder::createS3DataAccessFromS3Bucket))
            .constructor(CreateS3DataAccessFromS3BucketRequestDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateS3DataAccessFromS3Bucket")
                    .build()).build();

    private static final SdkField<ImportAssetsFromLakeFormationTagPolicyRequestDetails> IMPORT_ASSETS_FROM_LAKE_FORMATION_TAG_POLICY_FIELD = SdkField
            .<ImportAssetsFromLakeFormationTagPolicyRequestDetails> builder(MarshallingType.SDK_POJO)
            .memberName("ImportAssetsFromLakeFormationTagPolicy")
            .getter(getter(RequestDetails::importAssetsFromLakeFormationTagPolicy))
            .setter(setter(Builder::importAssetsFromLakeFormationTagPolicy))
            .constructor(ImportAssetsFromLakeFormationTagPolicyRequestDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ImportAssetsFromLakeFormationTagPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            EXPORT_ASSET_TO_SIGNED_URL_FIELD, EXPORT_ASSETS_TO_S3_FIELD, EXPORT_REVISIONS_TO_S3_FIELD,
            IMPORT_ASSET_FROM_SIGNED_URL_FIELD, IMPORT_ASSETS_FROM_S3_FIELD, IMPORT_ASSETS_FROM_REDSHIFT_DATA_SHARES_FIELD,
            IMPORT_ASSET_FROM_API_GATEWAY_API_FIELD, CREATE_S3_DATA_ACCESS_FROM_S3_BUCKET_FIELD,
            IMPORT_ASSETS_FROM_LAKE_FORMATION_TAG_POLICY_FIELD));

    private static final long serialVersionUID = 1L;

    private final ExportAssetToSignedUrlRequestDetails exportAssetToSignedUrl;

    private final ExportAssetsToS3RequestDetails exportAssetsToS3;

    private final ExportRevisionsToS3RequestDetails exportRevisionsToS3;

    private final ImportAssetFromSignedUrlRequestDetails importAssetFromSignedUrl;

    private final ImportAssetsFromS3RequestDetails importAssetsFromS3;

    private final ImportAssetsFromRedshiftDataSharesRequestDetails importAssetsFromRedshiftDataShares;

    private final ImportAssetFromApiGatewayApiRequestDetails importAssetFromApiGatewayApi;

    private final CreateS3DataAccessFromS3BucketRequestDetails createS3DataAccessFromS3Bucket;

    private final ImportAssetsFromLakeFormationTagPolicyRequestDetails importAssetsFromLakeFormationTagPolicy;

    private RequestDetails(BuilderImpl builder) {
        this.exportAssetToSignedUrl = builder.exportAssetToSignedUrl;
        this.exportAssetsToS3 = builder.exportAssetsToS3;
        this.exportRevisionsToS3 = builder.exportRevisionsToS3;
        this.importAssetFromSignedUrl = builder.importAssetFromSignedUrl;
        this.importAssetsFromS3 = builder.importAssetsFromS3;
        this.importAssetsFromRedshiftDataShares = builder.importAssetsFromRedshiftDataShares;
        this.importAssetFromApiGatewayApi = builder.importAssetFromApiGatewayApi;
        this.createS3DataAccessFromS3Bucket = builder.createS3DataAccessFromS3Bucket;
        this.importAssetsFromLakeFormationTagPolicy = builder.importAssetsFromLakeFormationTagPolicy;
    }

    /**
     * <p>
     * Details about the export to signed URL request.
     * </p>
     * 
     * @return Details about the export to signed URL request.
     */
    public final ExportAssetToSignedUrlRequestDetails exportAssetToSignedUrl() {
        return exportAssetToSignedUrl;
    }

    /**
     * <p>
     * Details about the export to Amazon S3 request.
     * </p>
     * 
     * @return Details about the export to Amazon S3 request.
     */
    public final ExportAssetsToS3RequestDetails exportAssetsToS3() {
        return exportAssetsToS3;
    }

    /**
     * <p>
     * Details about the export to Amazon S3 request.
     * </p>
     * 
     * @return Details about the export to Amazon S3 request.
     */
    public final ExportRevisionsToS3RequestDetails exportRevisionsToS3() {
        return exportRevisionsToS3;
    }

    /**
     * <p>
     * Details about the import from Amazon S3 request.
     * </p>
     * 
     * @return Details about the import from Amazon S3 request.
     */
    public final ImportAssetFromSignedUrlRequestDetails importAssetFromSignedUrl() {
        return importAssetFromSignedUrl;
    }

    /**
     * <p>
     * Details about the import asset from API Gateway API request.
     * </p>
     * 
     * @return Details about the import asset from API Gateway API request.
     */
    public final ImportAssetsFromS3RequestDetails importAssetsFromS3() {
        return importAssetsFromS3;
    }

    /**
     * <p>
     * Details from an import from Amazon Redshift datashare request.
     * </p>
     * 
     * @return Details from an import from Amazon Redshift datashare request.
     */
    public final ImportAssetsFromRedshiftDataSharesRequestDetails importAssetsFromRedshiftDataShares() {
        return importAssetsFromRedshiftDataShares;
    }

    /**
     * <p>
     * Details about the import from signed URL request.
     * </p>
     * 
     * @return Details about the import from signed URL request.
     */
    public final ImportAssetFromApiGatewayApiRequestDetails importAssetFromApiGatewayApi() {
        return importAssetFromApiGatewayApi;
    }

    /**
     * <p>
     * Details of the request to create S3 data access from the Amazon S3 bucket.
     * </p>
     * 
     * @return Details of the request to create S3 data access from the Amazon S3 bucket.
     */
    public final CreateS3DataAccessFromS3BucketRequestDetails createS3DataAccessFromS3Bucket() {
        return createS3DataAccessFromS3Bucket;
    }

    /**
     * <p>
     * Request details for the ImportAssetsFromLakeFormationTagPolicy job.
     * </p>
     * 
     * @return Request details for the ImportAssetsFromLakeFormationTagPolicy job.
     */
    public final ImportAssetsFromLakeFormationTagPolicyRequestDetails importAssetsFromLakeFormationTagPolicy() {
        return importAssetsFromLakeFormationTagPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(exportAssetToSignedUrl());
        hashCode = 31 * hashCode + Objects.hashCode(exportAssetsToS3());
        hashCode = 31 * hashCode + Objects.hashCode(exportRevisionsToS3());
        hashCode = 31 * hashCode + Objects.hashCode(importAssetFromSignedUrl());
        hashCode = 31 * hashCode + Objects.hashCode(importAssetsFromS3());
        hashCode = 31 * hashCode + Objects.hashCode(importAssetsFromRedshiftDataShares());
        hashCode = 31 * hashCode + Objects.hashCode(importAssetFromApiGatewayApi());
        hashCode = 31 * hashCode + Objects.hashCode(createS3DataAccessFromS3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(importAssetsFromLakeFormationTagPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestDetails)) {
            return false;
        }
        RequestDetails other = (RequestDetails) obj;
        return Objects.equals(exportAssetToSignedUrl(), other.exportAssetToSignedUrl())
                && Objects.equals(exportAssetsToS3(), other.exportAssetsToS3())
                && Objects.equals(exportRevisionsToS3(), other.exportRevisionsToS3())
                && Objects.equals(importAssetFromSignedUrl(), other.importAssetFromSignedUrl())
                && Objects.equals(importAssetsFromS3(), other.importAssetsFromS3())
                && Objects.equals(importAssetsFromRedshiftDataShares(), other.importAssetsFromRedshiftDataShares())
                && Objects.equals(importAssetFromApiGatewayApi(), other.importAssetFromApiGatewayApi())
                && Objects.equals(createS3DataAccessFromS3Bucket(), other.createS3DataAccessFromS3Bucket())
                && Objects.equals(importAssetsFromLakeFormationTagPolicy(), other.importAssetsFromLakeFormationTagPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RequestDetails").add("ExportAssetToSignedUrl", exportAssetToSignedUrl())
                .add("ExportAssetsToS3", exportAssetsToS3()).add("ExportRevisionsToS3", exportRevisionsToS3())
                .add("ImportAssetFromSignedUrl", importAssetFromSignedUrl()).add("ImportAssetsFromS3", importAssetsFromS3())
                .add("ImportAssetsFromRedshiftDataShares", importAssetsFromRedshiftDataShares())
                .add("ImportAssetFromApiGatewayApi", importAssetFromApiGatewayApi())
                .add("CreateS3DataAccessFromS3Bucket", createS3DataAccessFromS3Bucket())
                .add("ImportAssetsFromLakeFormationTagPolicy", importAssetsFromLakeFormationTagPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExportAssetToSignedUrl":
            return Optional.ofNullable(clazz.cast(exportAssetToSignedUrl()));
        case "ExportAssetsToS3":
            return Optional.ofNullable(clazz.cast(exportAssetsToS3()));
        case "ExportRevisionsToS3":
            return Optional.ofNullable(clazz.cast(exportRevisionsToS3()));
        case "ImportAssetFromSignedUrl":
            return Optional.ofNullable(clazz.cast(importAssetFromSignedUrl()));
        case "ImportAssetsFromS3":
            return Optional.ofNullable(clazz.cast(importAssetsFromS3()));
        case "ImportAssetsFromRedshiftDataShares":
            return Optional.ofNullable(clazz.cast(importAssetsFromRedshiftDataShares()));
        case "ImportAssetFromApiGatewayApi":
            return Optional.ofNullable(clazz.cast(importAssetFromApiGatewayApi()));
        case "CreateS3DataAccessFromS3Bucket":
            return Optional.ofNullable(clazz.cast(createS3DataAccessFromS3Bucket()));
        case "ImportAssetsFromLakeFormationTagPolicy":
            return Optional.ofNullable(clazz.cast(importAssetsFromLakeFormationTagPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RequestDetails, T> g) {
        return obj -> g.apply((RequestDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RequestDetails> {
        /**
         * <p>
         * Details about the export to signed URL request.
         * </p>
         * 
         * @param exportAssetToSignedUrl
         *        Details about the export to signed URL request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportAssetToSignedUrl(ExportAssetToSignedUrlRequestDetails exportAssetToSignedUrl);

        /**
         * <p>
         * Details about the export to signed URL request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ExportAssetToSignedUrlRequestDetails.Builder} avoiding the need to create one manually via
         * {@link ExportAssetToSignedUrlRequestDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExportAssetToSignedUrlRequestDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #exportAssetToSignedUrl(ExportAssetToSignedUrlRequestDetails)}.
         * 
         * @param exportAssetToSignedUrl
         *        a consumer that will call methods on {@link ExportAssetToSignedUrlRequestDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportAssetToSignedUrl(ExportAssetToSignedUrlRequestDetails)
         */
        default Builder exportAssetToSignedUrl(Consumer<ExportAssetToSignedUrlRequestDetails.Builder> exportAssetToSignedUrl) {
            return exportAssetToSignedUrl(ExportAssetToSignedUrlRequestDetails.builder().applyMutation(exportAssetToSignedUrl)
                    .build());
        }

        /**
         * <p>
         * Details about the export to Amazon S3 request.
         * </p>
         * 
         * @param exportAssetsToS3
         *        Details about the export to Amazon S3 request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportAssetsToS3(ExportAssetsToS3RequestDetails exportAssetsToS3);

        /**
         * <p>
         * Details about the export to Amazon S3 request.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExportAssetsToS3RequestDetails.Builder}
         * avoiding the need to create one manually via {@link ExportAssetsToS3RequestDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExportAssetsToS3RequestDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #exportAssetsToS3(ExportAssetsToS3RequestDetails)}.
         * 
         * @param exportAssetsToS3
         *        a consumer that will call methods on {@link ExportAssetsToS3RequestDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportAssetsToS3(ExportAssetsToS3RequestDetails)
         */
        default Builder exportAssetsToS3(Consumer<ExportAssetsToS3RequestDetails.Builder> exportAssetsToS3) {
            return exportAssetsToS3(ExportAssetsToS3RequestDetails.builder().applyMutation(exportAssetsToS3).build());
        }

        /**
         * <p>
         * Details about the export to Amazon S3 request.
         * </p>
         * 
         * @param exportRevisionsToS3
         *        Details about the export to Amazon S3 request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportRevisionsToS3(ExportRevisionsToS3RequestDetails exportRevisionsToS3);

        /**
         * <p>
         * Details about the export to Amazon S3 request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ExportRevisionsToS3RequestDetails.Builder} avoiding the need to create one manually via
         * {@link ExportRevisionsToS3RequestDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExportRevisionsToS3RequestDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #exportRevisionsToS3(ExportRevisionsToS3RequestDetails)}.
         * 
         * @param exportRevisionsToS3
         *        a consumer that will call methods on {@link ExportRevisionsToS3RequestDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportRevisionsToS3(ExportRevisionsToS3RequestDetails)
         */
        default Builder exportRevisionsToS3(Consumer<ExportRevisionsToS3RequestDetails.Builder> exportRevisionsToS3) {
            return exportRevisionsToS3(ExportRevisionsToS3RequestDetails.builder().applyMutation(exportRevisionsToS3).build());
        }

        /**
         * <p>
         * Details about the import from Amazon S3 request.
         * </p>
         * 
         * @param importAssetFromSignedUrl
         *        Details about the import from Amazon S3 request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importAssetFromSignedUrl(ImportAssetFromSignedUrlRequestDetails importAssetFromSignedUrl);

        /**
         * <p>
         * Details about the import from Amazon S3 request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ImportAssetFromSignedUrlRequestDetails.Builder} avoiding the need to create one manually via
         * {@link ImportAssetFromSignedUrlRequestDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImportAssetFromSignedUrlRequestDetails.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #importAssetFromSignedUrl(ImportAssetFromSignedUrlRequestDetails)}.
         * 
         * @param importAssetFromSignedUrl
         *        a consumer that will call methods on {@link ImportAssetFromSignedUrlRequestDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #importAssetFromSignedUrl(ImportAssetFromSignedUrlRequestDetails)
         */
        default Builder importAssetFromSignedUrl(Consumer<ImportAssetFromSignedUrlRequestDetails.Builder> importAssetFromSignedUrl) {
            return importAssetFromSignedUrl(ImportAssetFromSignedUrlRequestDetails.builder()
                    .applyMutation(importAssetFromSignedUrl).build());
        }

        /**
         * <p>
         * Details about the import asset from API Gateway API request.
         * </p>
         * 
         * @param importAssetsFromS3
         *        Details about the import asset from API Gateway API request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importAssetsFromS3(ImportAssetsFromS3RequestDetails importAssetsFromS3);

        /**
         * <p>
         * Details about the import asset from API Gateway API request.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImportAssetsFromS3RequestDetails.Builder}
         * avoiding the need to create one manually via {@link ImportAssetsFromS3RequestDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImportAssetsFromS3RequestDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #importAssetsFromS3(ImportAssetsFromS3RequestDetails)}.
         * 
         * @param importAssetsFromS3
         *        a consumer that will call methods on {@link ImportAssetsFromS3RequestDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #importAssetsFromS3(ImportAssetsFromS3RequestDetails)
         */
        default Builder importAssetsFromS3(Consumer<ImportAssetsFromS3RequestDetails.Builder> importAssetsFromS3) {
            return importAssetsFromS3(ImportAssetsFromS3RequestDetails.builder().applyMutation(importAssetsFromS3).build());
        }

        /**
         * <p>
         * Details from an import from Amazon Redshift datashare request.
         * </p>
         * 
         * @param importAssetsFromRedshiftDataShares
         *        Details from an import from Amazon Redshift datashare request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importAssetsFromRedshiftDataShares(
                ImportAssetsFromRedshiftDataSharesRequestDetails importAssetsFromRedshiftDataShares);

        /**
         * <p>
         * Details from an import from Amazon Redshift datashare request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ImportAssetsFromRedshiftDataSharesRequestDetails.Builder} avoiding the need to create one manually via
         * {@link ImportAssetsFromRedshiftDataSharesRequestDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImportAssetsFromRedshiftDataSharesRequestDetails.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #importAssetsFromRedshiftDataShares(ImportAssetsFromRedshiftDataSharesRequestDetails)}.
         * 
         * @param importAssetsFromRedshiftDataShares
         *        a consumer that will call methods on {@link ImportAssetsFromRedshiftDataSharesRequestDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #importAssetsFromRedshiftDataShares(ImportAssetsFromRedshiftDataSharesRequestDetails)
         */
        default Builder importAssetsFromRedshiftDataShares(
                Consumer<ImportAssetsFromRedshiftDataSharesRequestDetails.Builder> importAssetsFromRedshiftDataShares) {
            return importAssetsFromRedshiftDataShares(ImportAssetsFromRedshiftDataSharesRequestDetails.builder()
                    .applyMutation(importAssetsFromRedshiftDataShares).build());
        }

        /**
         * <p>
         * Details about the import from signed URL request.
         * </p>
         * 
         * @param importAssetFromApiGatewayApi
         *        Details about the import from signed URL request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importAssetFromApiGatewayApi(ImportAssetFromApiGatewayApiRequestDetails importAssetFromApiGatewayApi);

        /**
         * <p>
         * Details about the import from signed URL request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ImportAssetFromApiGatewayApiRequestDetails.Builder} avoiding the need to create one manually via
         * {@link ImportAssetFromApiGatewayApiRequestDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImportAssetFromApiGatewayApiRequestDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #importAssetFromApiGatewayApi(ImportAssetFromApiGatewayApiRequestDetails)}.
         * 
         * @param importAssetFromApiGatewayApi
         *        a consumer that will call methods on {@link ImportAssetFromApiGatewayApiRequestDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #importAssetFromApiGatewayApi(ImportAssetFromApiGatewayApiRequestDetails)
         */
        default Builder importAssetFromApiGatewayApi(
                Consumer<ImportAssetFromApiGatewayApiRequestDetails.Builder> importAssetFromApiGatewayApi) {
            return importAssetFromApiGatewayApi(ImportAssetFromApiGatewayApiRequestDetails.builder()
                    .applyMutation(importAssetFromApiGatewayApi).build());
        }

        /**
         * <p>
         * Details of the request to create S3 data access from the Amazon S3 bucket.
         * </p>
         * 
         * @param createS3DataAccessFromS3Bucket
         *        Details of the request to create S3 data access from the Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createS3DataAccessFromS3Bucket(CreateS3DataAccessFromS3BucketRequestDetails createS3DataAccessFromS3Bucket);

        /**
         * <p>
         * Details of the request to create S3 data access from the Amazon S3 bucket.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CreateS3DataAccessFromS3BucketRequestDetails.Builder} avoiding the need to create one manually via
         * {@link CreateS3DataAccessFromS3BucketRequestDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CreateS3DataAccessFromS3BucketRequestDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #createS3DataAccessFromS3Bucket(CreateS3DataAccessFromS3BucketRequestDetails)}.
         * 
         * @param createS3DataAccessFromS3Bucket
         *        a consumer that will call methods on {@link CreateS3DataAccessFromS3BucketRequestDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createS3DataAccessFromS3Bucket(CreateS3DataAccessFromS3BucketRequestDetails)
         */
        default Builder createS3DataAccessFromS3Bucket(
                Consumer<CreateS3DataAccessFromS3BucketRequestDetails.Builder> createS3DataAccessFromS3Bucket) {
            return createS3DataAccessFromS3Bucket(CreateS3DataAccessFromS3BucketRequestDetails.builder()
                    .applyMutation(createS3DataAccessFromS3Bucket).build());
        }

        /**
         * <p>
         * Request details for the ImportAssetsFromLakeFormationTagPolicy job.
         * </p>
         * 
         * @param importAssetsFromLakeFormationTagPolicy
         *        Request details for the ImportAssetsFromLakeFormationTagPolicy job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importAssetsFromLakeFormationTagPolicy(
                ImportAssetsFromLakeFormationTagPolicyRequestDetails importAssetsFromLakeFormationTagPolicy);

        /**
         * <p>
         * Request details for the ImportAssetsFromLakeFormationTagPolicy job.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ImportAssetsFromLakeFormationTagPolicyRequestDetails.Builder} avoiding the need to create one manually
         * via {@link ImportAssetsFromLakeFormationTagPolicyRequestDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link ImportAssetsFromLakeFormationTagPolicyRequestDetails.Builder#build()} is called immediately and its
         * result is passed to
         * {@link #importAssetsFromLakeFormationTagPolicy(ImportAssetsFromLakeFormationTagPolicyRequestDetails)}.
         * 
         * @param importAssetsFromLakeFormationTagPolicy
         *        a consumer that will call methods on
         *        {@link ImportAssetsFromLakeFormationTagPolicyRequestDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #importAssetsFromLakeFormationTagPolicy(ImportAssetsFromLakeFormationTagPolicyRequestDetails)
         */
        default Builder importAssetsFromLakeFormationTagPolicy(
                Consumer<ImportAssetsFromLakeFormationTagPolicyRequestDetails.Builder> importAssetsFromLakeFormationTagPolicy) {
            return importAssetsFromLakeFormationTagPolicy(ImportAssetsFromLakeFormationTagPolicyRequestDetails.builder()
                    .applyMutation(importAssetsFromLakeFormationTagPolicy).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ExportAssetToSignedUrlRequestDetails exportAssetToSignedUrl;

        private ExportAssetsToS3RequestDetails exportAssetsToS3;

        private ExportRevisionsToS3RequestDetails exportRevisionsToS3;

        private ImportAssetFromSignedUrlRequestDetails importAssetFromSignedUrl;

        private ImportAssetsFromS3RequestDetails importAssetsFromS3;

        private ImportAssetsFromRedshiftDataSharesRequestDetails importAssetsFromRedshiftDataShares;

        private ImportAssetFromApiGatewayApiRequestDetails importAssetFromApiGatewayApi;

        private CreateS3DataAccessFromS3BucketRequestDetails createS3DataAccessFromS3Bucket;

        private ImportAssetsFromLakeFormationTagPolicyRequestDetails importAssetsFromLakeFormationTagPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(RequestDetails model) {
            exportAssetToSignedUrl(model.exportAssetToSignedUrl);
            exportAssetsToS3(model.exportAssetsToS3);
            exportRevisionsToS3(model.exportRevisionsToS3);
            importAssetFromSignedUrl(model.importAssetFromSignedUrl);
            importAssetsFromS3(model.importAssetsFromS3);
            importAssetsFromRedshiftDataShares(model.importAssetsFromRedshiftDataShares);
            importAssetFromApiGatewayApi(model.importAssetFromApiGatewayApi);
            createS3DataAccessFromS3Bucket(model.createS3DataAccessFromS3Bucket);
            importAssetsFromLakeFormationTagPolicy(model.importAssetsFromLakeFormationTagPolicy);
        }

        public final ExportAssetToSignedUrlRequestDetails.Builder getExportAssetToSignedUrl() {
            return exportAssetToSignedUrl != null ? exportAssetToSignedUrl.toBuilder() : null;
        }

        public final void setExportAssetToSignedUrl(ExportAssetToSignedUrlRequestDetails.BuilderImpl exportAssetToSignedUrl) {
            this.exportAssetToSignedUrl = exportAssetToSignedUrl != null ? exportAssetToSignedUrl.build() : null;
        }

        @Override
        public final Builder exportAssetToSignedUrl(ExportAssetToSignedUrlRequestDetails exportAssetToSignedUrl) {
            this.exportAssetToSignedUrl = exportAssetToSignedUrl;
            return this;
        }

        public final ExportAssetsToS3RequestDetails.Builder getExportAssetsToS3() {
            return exportAssetsToS3 != null ? exportAssetsToS3.toBuilder() : null;
        }

        public final void setExportAssetsToS3(ExportAssetsToS3RequestDetails.BuilderImpl exportAssetsToS3) {
            this.exportAssetsToS3 = exportAssetsToS3 != null ? exportAssetsToS3.build() : null;
        }

        @Override
        public final Builder exportAssetsToS3(ExportAssetsToS3RequestDetails exportAssetsToS3) {
            this.exportAssetsToS3 = exportAssetsToS3;
            return this;
        }

        public final ExportRevisionsToS3RequestDetails.Builder getExportRevisionsToS3() {
            return exportRevisionsToS3 != null ? exportRevisionsToS3.toBuilder() : null;
        }

        public final void setExportRevisionsToS3(ExportRevisionsToS3RequestDetails.BuilderImpl exportRevisionsToS3) {
            this.exportRevisionsToS3 = exportRevisionsToS3 != null ? exportRevisionsToS3.build() : null;
        }

        @Override
        public final Builder exportRevisionsToS3(ExportRevisionsToS3RequestDetails exportRevisionsToS3) {
            this.exportRevisionsToS3 = exportRevisionsToS3;
            return this;
        }

        public final ImportAssetFromSignedUrlRequestDetails.Builder getImportAssetFromSignedUrl() {
            return importAssetFromSignedUrl != null ? importAssetFromSignedUrl.toBuilder() : null;
        }

        public final void setImportAssetFromSignedUrl(ImportAssetFromSignedUrlRequestDetails.BuilderImpl importAssetFromSignedUrl) {
            this.importAssetFromSignedUrl = importAssetFromSignedUrl != null ? importAssetFromSignedUrl.build() : null;
        }

        @Override
        public final Builder importAssetFromSignedUrl(ImportAssetFromSignedUrlRequestDetails importAssetFromSignedUrl) {
            this.importAssetFromSignedUrl = importAssetFromSignedUrl;
            return this;
        }

        public final ImportAssetsFromS3RequestDetails.Builder getImportAssetsFromS3() {
            return importAssetsFromS3 != null ? importAssetsFromS3.toBuilder() : null;
        }

        public final void setImportAssetsFromS3(ImportAssetsFromS3RequestDetails.BuilderImpl importAssetsFromS3) {
            this.importAssetsFromS3 = importAssetsFromS3 != null ? importAssetsFromS3.build() : null;
        }

        @Override
        public final Builder importAssetsFromS3(ImportAssetsFromS3RequestDetails importAssetsFromS3) {
            this.importAssetsFromS3 = importAssetsFromS3;
            return this;
        }

        public final ImportAssetsFromRedshiftDataSharesRequestDetails.Builder getImportAssetsFromRedshiftDataShares() {
            return importAssetsFromRedshiftDataShares != null ? importAssetsFromRedshiftDataShares.toBuilder() : null;
        }

        public final void setImportAssetsFromRedshiftDataShares(
                ImportAssetsFromRedshiftDataSharesRequestDetails.BuilderImpl importAssetsFromRedshiftDataShares) {
            this.importAssetsFromRedshiftDataShares = importAssetsFromRedshiftDataShares != null ? importAssetsFromRedshiftDataShares
                    .build() : null;
        }

        @Override
        public final Builder importAssetsFromRedshiftDataShares(
                ImportAssetsFromRedshiftDataSharesRequestDetails importAssetsFromRedshiftDataShares) {
            this.importAssetsFromRedshiftDataShares = importAssetsFromRedshiftDataShares;
            return this;
        }

        public final ImportAssetFromApiGatewayApiRequestDetails.Builder getImportAssetFromApiGatewayApi() {
            return importAssetFromApiGatewayApi != null ? importAssetFromApiGatewayApi.toBuilder() : null;
        }

        public final void setImportAssetFromApiGatewayApi(
                ImportAssetFromApiGatewayApiRequestDetails.BuilderImpl importAssetFromApiGatewayApi) {
            this.importAssetFromApiGatewayApi = importAssetFromApiGatewayApi != null ? importAssetFromApiGatewayApi.build()
                    : null;
        }

        @Override
        public final Builder importAssetFromApiGatewayApi(ImportAssetFromApiGatewayApiRequestDetails importAssetFromApiGatewayApi) {
            this.importAssetFromApiGatewayApi = importAssetFromApiGatewayApi;
            return this;
        }

        public final CreateS3DataAccessFromS3BucketRequestDetails.Builder getCreateS3DataAccessFromS3Bucket() {
            return createS3DataAccessFromS3Bucket != null ? createS3DataAccessFromS3Bucket.toBuilder() : null;
        }

        public final void setCreateS3DataAccessFromS3Bucket(
                CreateS3DataAccessFromS3BucketRequestDetails.BuilderImpl createS3DataAccessFromS3Bucket) {
            this.createS3DataAccessFromS3Bucket = createS3DataAccessFromS3Bucket != null ? createS3DataAccessFromS3Bucket.build()
                    : null;
        }

        @Override
        public final Builder createS3DataAccessFromS3Bucket(
                CreateS3DataAccessFromS3BucketRequestDetails createS3DataAccessFromS3Bucket) {
            this.createS3DataAccessFromS3Bucket = createS3DataAccessFromS3Bucket;
            return this;
        }

        public final ImportAssetsFromLakeFormationTagPolicyRequestDetails.Builder getImportAssetsFromLakeFormationTagPolicy() {
            return importAssetsFromLakeFormationTagPolicy != null ? importAssetsFromLakeFormationTagPolicy.toBuilder() : null;
        }

        public final void setImportAssetsFromLakeFormationTagPolicy(
                ImportAssetsFromLakeFormationTagPolicyRequestDetails.BuilderImpl importAssetsFromLakeFormationTagPolicy) {
            this.importAssetsFromLakeFormationTagPolicy = importAssetsFromLakeFormationTagPolicy != null ? importAssetsFromLakeFormationTagPolicy
                    .build() : null;
        }

        @Override
        public final Builder importAssetsFromLakeFormationTagPolicy(
                ImportAssetsFromLakeFormationTagPolicyRequestDetails importAssetsFromLakeFormationTagPolicy) {
            this.importAssetsFromLakeFormationTagPolicy = importAssetsFromLakeFormationTagPolicy;
            return this;
        }

        @Override
        public RequestDetails build() {
            return new RequestDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
