/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Extra details specific to the affected scope in this Redshift data set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RedshiftDataShareDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<RedshiftDataShareDetails.Builder, RedshiftDataShareDetails> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(RedshiftDataShareDetails::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> DATABASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Database").getter(getter(RedshiftDataShareDetails::database)).setter(setter(Builder::database))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()).build();

    private static final SdkField<String> FUNCTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Function").getter(getter(RedshiftDataShareDetails::function)).setter(setter(Builder::function))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Function").build()).build();

    private static final SdkField<String> TABLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Table")
            .getter(getter(RedshiftDataShareDetails::table)).setter(setter(Builder::table))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Table").build()).build();

    private static final SdkField<String> SCHEMA_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Schema")
            .getter(getter(RedshiftDataShareDetails::schema)).setter(setter(Builder::schema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schema").build()).build();

    private static final SdkField<String> VIEW_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("View")
            .getter(getter(RedshiftDataShareDetails::view)).setter(setter(Builder::view))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("View").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, DATABASE_FIELD,
            FUNCTION_FIELD, TABLE_FIELD, SCHEMA_FIELD, VIEW_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String database;

    private final String function;

    private final String table;

    private final String schema;

    private final String view;

    private RedshiftDataShareDetails(BuilderImpl builder) {
        this.arn = builder.arn;
        this.database = builder.database;
        this.function = builder.function;
        this.table = builder.table;
        this.schema = builder.schema;
        this.view = builder.view;
    }

    /**
     * <p>
     * The ARN of the underlying Redshift data share that is being affected by this notification.
     * </p>
     * 
     * @return The ARN of the underlying Redshift data share that is being affected by this notification.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The database name in the Redshift data share that is being affected by this notification.
     * </p>
     * 
     * @return The database name in the Redshift data share that is being affected by this notification.
     */
    public final String database() {
        return database;
    }

    /**
     * <p>
     * A function name in the Redshift database that is being affected by this notification.
     * </p>
     * 
     * @return A function name in the Redshift database that is being affected by this notification.
     */
    public final String function() {
        return function;
    }

    /**
     * <p>
     * A table name in the Redshift database that is being affected by this notification.
     * </p>
     * 
     * @return A table name in the Redshift database that is being affected by this notification.
     */
    public final String table() {
        return table;
    }

    /**
     * <p>
     * A schema name in the Redshift database that is being affected by this notification.
     * </p>
     * 
     * @return A schema name in the Redshift database that is being affected by this notification.
     */
    public final String schema() {
        return schema;
    }

    /**
     * <p>
     * A view name in the Redshift database that is being affected by this notification.
     * </p>
     * 
     * @return A view name in the Redshift database that is being affected by this notification.
     */
    public final String view() {
        return view;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(database());
        hashCode = 31 * hashCode + Objects.hashCode(function());
        hashCode = 31 * hashCode + Objects.hashCode(table());
        hashCode = 31 * hashCode + Objects.hashCode(schema());
        hashCode = 31 * hashCode + Objects.hashCode(view());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftDataShareDetails)) {
            return false;
        }
        RedshiftDataShareDetails other = (RedshiftDataShareDetails) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(database(), other.database())
                && Objects.equals(function(), other.function()) && Objects.equals(table(), other.table())
                && Objects.equals(schema(), other.schema()) && Objects.equals(view(), other.view());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RedshiftDataShareDetails").add("Arn", arn()).add("Database", database())
                .add("Function", function()).add("Table", table()).add("Schema", schema()).add("View", view()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Database":
            return Optional.ofNullable(clazz.cast(database()));
        case "Function":
            return Optional.ofNullable(clazz.cast(function()));
        case "Table":
            return Optional.ofNullable(clazz.cast(table()));
        case "Schema":
            return Optional.ofNullable(clazz.cast(schema()));
        case "View":
            return Optional.ofNullable(clazz.cast(view()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RedshiftDataShareDetails, T> g) {
        return obj -> g.apply((RedshiftDataShareDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RedshiftDataShareDetails> {
        /**
         * <p>
         * The ARN of the underlying Redshift data share that is being affected by this notification.
         * </p>
         * 
         * @param arn
         *        The ARN of the underlying Redshift data share that is being affected by this notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The database name in the Redshift data share that is being affected by this notification.
         * </p>
         * 
         * @param database
         *        The database name in the Redshift data share that is being affected by this notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder database(String database);

        /**
         * <p>
         * A function name in the Redshift database that is being affected by this notification.
         * </p>
         * 
         * @param function
         *        A function name in the Redshift database that is being affected by this notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder function(String function);

        /**
         * <p>
         * A table name in the Redshift database that is being affected by this notification.
         * </p>
         * 
         * @param table
         *        A table name in the Redshift database that is being affected by this notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder table(String table);

        /**
         * <p>
         * A schema name in the Redshift database that is being affected by this notification.
         * </p>
         * 
         * @param schema
         *        A schema name in the Redshift database that is being affected by this notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schema(String schema);

        /**
         * <p>
         * A view name in the Redshift database that is being affected by this notification.
         * </p>
         * 
         * @param view
         *        A view name in the Redshift database that is being affected by this notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder view(String view);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String database;

        private String function;

        private String table;

        private String schema;

        private String view;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftDataShareDetails model) {
            arn(model.arn);
            database(model.database);
            function(model.function);
            table(model.table);
            schema(model.schema);
            view(model.view);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDatabase() {
            return database;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final String getFunction() {
            return function;
        }

        public final void setFunction(String function) {
            this.function = function;
        }

        @Override
        public final Builder function(String function) {
            this.function = function;
            return this;
        }

        public final String getTable() {
            return table;
        }

        public final void setTable(String table) {
            this.table = table;
        }

        @Override
        public final Builder table(String table) {
            this.table = table;
            return this;
        }

        public final String getSchema() {
            return schema;
        }

        public final void setSchema(String schema) {
            this.schema = schema;
        }

        @Override
        public final Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public final String getView() {
            return view;
        }

        public final void setView(String view) {
            this.view = view;
        }

        @Override
        public final Builder view(String view) {
            this.view = view;
            return this;
        }

        @Override
        public RedshiftDataShareDetails build() {
            return new RedshiftDataShareDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
