/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details from an import from Amazon S3 response.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportAssetsFromS3ResponseDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ImportAssetsFromS3ResponseDetails.Builder, ImportAssetsFromS3ResponseDetails> {
    private static final SdkField<List<AssetSourceEntry>> ASSET_SOURCES_FIELD = SdkField
            .<List<AssetSourceEntry>> builder(MarshallingType.LIST)
            .memberName("AssetSources")
            .getter(getter(ImportAssetsFromS3ResponseDetails::assetSources))
            .setter(setter(Builder::assetSources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssetSources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetSourceEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetSourceEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DATA_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSetId").getter(getter(ImportAssetsFromS3ResponseDetails::dataSetId))
            .setter(setter(Builder::dataSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetId").build()).build();

    private static final SdkField<String> REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RevisionId").getter(getter(ImportAssetsFromS3ResponseDetails::revisionId))
            .setter(setter(Builder::revisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevisionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_SOURCES_FIELD,
            DATA_SET_ID_FIELD, REVISION_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<AssetSourceEntry> assetSources;

    private final String dataSetId;

    private final String revisionId;

    private ImportAssetsFromS3ResponseDetails(BuilderImpl builder) {
        this.assetSources = builder.assetSources;
        this.dataSetId = builder.dataSetId;
        this.revisionId = builder.revisionId;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssetSources property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssetSources() {
        return assetSources != null && !(assetSources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Is a list of Amazon S3 bucket and object key pairs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssetSources} method.
     * </p>
     * 
     * @return Is a list of Amazon S3 bucket and object key pairs.
     */
    public final List<AssetSourceEntry> assetSources() {
        return assetSources;
    }

    /**
     * <p>
     * The unique identifier for the data set associated with this import job.
     * </p>
     * 
     * @return The unique identifier for the data set associated with this import job.
     */
    public final String dataSetId() {
        return dataSetId;
    }

    /**
     * <p>
     * The unique identifier for the revision associated with this import response.
     * </p>
     * 
     * @return The unique identifier for the revision associated with this import response.
     */
    public final String revisionId() {
        return revisionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAssetSources() ? assetSources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dataSetId());
        hashCode = 31 * hashCode + Objects.hashCode(revisionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportAssetsFromS3ResponseDetails)) {
            return false;
        }
        ImportAssetsFromS3ResponseDetails other = (ImportAssetsFromS3ResponseDetails) obj;
        return hasAssetSources() == other.hasAssetSources() && Objects.equals(assetSources(), other.assetSources())
                && Objects.equals(dataSetId(), other.dataSetId()) && Objects.equals(revisionId(), other.revisionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportAssetsFromS3ResponseDetails")
                .add("AssetSources", hasAssetSources() ? assetSources() : null).add("DataSetId", dataSetId())
                .add("RevisionId", revisionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssetSources":
            return Optional.ofNullable(clazz.cast(assetSources()));
        case "DataSetId":
            return Optional.ofNullable(clazz.cast(dataSetId()));
        case "RevisionId":
            return Optional.ofNullable(clazz.cast(revisionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportAssetsFromS3ResponseDetails, T> g) {
        return obj -> g.apply((ImportAssetsFromS3ResponseDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImportAssetsFromS3ResponseDetails> {
        /**
         * <p>
         * Is a list of Amazon S3 bucket and object key pairs.
         * </p>
         * 
         * @param assetSources
         *        Is a list of Amazon S3 bucket and object key pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetSources(Collection<AssetSourceEntry> assetSources);

        /**
         * <p>
         * Is a list of Amazon S3 bucket and object key pairs.
         * </p>
         * 
         * @param assetSources
         *        Is a list of Amazon S3 bucket and object key pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetSources(AssetSourceEntry... assetSources);

        /**
         * <p>
         * Is a list of Amazon S3 bucket and object key pairs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.dataexchange.model.AssetSourceEntry.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.dataexchange.model.AssetSourceEntry#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.dataexchange.model.AssetSourceEntry.Builder#build()} is called
         * immediately and its result is passed to {@link #assetSources(List<AssetSourceEntry>)}.
         * 
         * @param assetSources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.dataexchange.model.AssetSourceEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetSources(java.util.Collection<AssetSourceEntry>)
         */
        Builder assetSources(Consumer<AssetSourceEntry.Builder>... assetSources);

        /**
         * <p>
         * The unique identifier for the data set associated with this import job.
         * </p>
         * 
         * @param dataSetId
         *        The unique identifier for the data set associated with this import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetId(String dataSetId);

        /**
         * <p>
         * The unique identifier for the revision associated with this import response.
         * </p>
         * 
         * @param revisionId
         *        The unique identifier for the revision associated with this import response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionId(String revisionId);
    }

    static final class BuilderImpl implements Builder {
        private List<AssetSourceEntry> assetSources = DefaultSdkAutoConstructList.getInstance();

        private String dataSetId;

        private String revisionId;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportAssetsFromS3ResponseDetails model) {
            assetSources(model.assetSources);
            dataSetId(model.dataSetId);
            revisionId(model.revisionId);
        }

        public final List<AssetSourceEntry.Builder> getAssetSources() {
            List<AssetSourceEntry.Builder> result = ListOfAssetSourceEntryCopier.copyToBuilder(this.assetSources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetSources(Collection<AssetSourceEntry.BuilderImpl> assetSources) {
            this.assetSources = ListOfAssetSourceEntryCopier.copyFromBuilder(assetSources);
        }

        @Override
        public final Builder assetSources(Collection<AssetSourceEntry> assetSources) {
            this.assetSources = ListOfAssetSourceEntryCopier.copy(assetSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetSources(AssetSourceEntry... assetSources) {
            assetSources(Arrays.asList(assetSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetSources(Consumer<AssetSourceEntry.Builder>... assetSources) {
            assetSources(Stream.of(assetSources).map(c -> AssetSourceEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getDataSetId() {
            return dataSetId;
        }

        public final void setDataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
        }

        @Override
        public final Builder dataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
            return this;
        }

        public final String getRevisionId() {
            return revisionId;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        @Override
        public ImportAssetsFromS3ResponseDetails build() {
            return new ImportAssetsFromS3ResponseDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
