/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of the export to signed URL response.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportAssetToSignedUrlResponseDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ExportAssetToSignedUrlResponseDetails.Builder, ExportAssetToSignedUrlResponseDetails> {
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssetId").getter(getter(ExportAssetToSignedUrlResponseDetails::assetId))
            .setter(setter(Builder::assetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssetId").build()).build();

    private static final SdkField<String> DATA_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSetId").getter(getter(ExportAssetToSignedUrlResponseDetails::dataSetId))
            .setter(setter(Builder::dataSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetId").build()).build();

    private static final SdkField<String> REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RevisionId").getter(getter(ExportAssetToSignedUrlResponseDetails::revisionId))
            .setter(setter(Builder::revisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevisionId").build()).build();

    private static final SdkField<String> SIGNED_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SignedUrl").getter(getter(ExportAssetToSignedUrlResponseDetails::signedUrl))
            .setter(setter(Builder::signedUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SignedUrl").build()).build();

    private static final SdkField<Instant> SIGNED_URL_EXPIRES_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("SignedUrlExpiresAt")
            .getter(getter(ExportAssetToSignedUrlResponseDetails::signedUrlExpiresAt))
            .setter(setter(Builder::signedUrlExpiresAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SignedUrlExpiresAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_ID_FIELD,
            DATA_SET_ID_FIELD, REVISION_ID_FIELD, SIGNED_URL_FIELD, SIGNED_URL_EXPIRES_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String assetId;

    private final String dataSetId;

    private final String revisionId;

    private final String signedUrl;

    private final Instant signedUrlExpiresAt;

    private ExportAssetToSignedUrlResponseDetails(BuilderImpl builder) {
        this.assetId = builder.assetId;
        this.dataSetId = builder.dataSetId;
        this.revisionId = builder.revisionId;
        this.signedUrl = builder.signedUrl;
        this.signedUrlExpiresAt = builder.signedUrlExpiresAt;
    }

    /**
     * <p>
     * The unique identifier for the asset associated with this export job.
     * </p>
     * 
     * @return The unique identifier for the asset associated with this export job.
     */
    public final String assetId() {
        return assetId;
    }

    /**
     * <p>
     * The unique identifier for the data set associated with this export job.
     * </p>
     * 
     * @return The unique identifier for the data set associated with this export job.
     */
    public final String dataSetId() {
        return dataSetId;
    }

    /**
     * <p>
     * The unique identifier for the revision associated with this export response.
     * </p>
     * 
     * @return The unique identifier for the revision associated with this export response.
     */
    public final String revisionId() {
        return revisionId;
    }

    /**
     * <p>
     * The signed URL for the export request.
     * </p>
     * 
     * @return The signed URL for the export request.
     */
    public final String signedUrl() {
        return signedUrl;
    }

    /**
     * <p>
     * The date and time that the signed URL expires, in ISO 8601 format.
     * </p>
     * 
     * @return The date and time that the signed URL expires, in ISO 8601 format.
     */
    public final Instant signedUrlExpiresAt() {
        return signedUrlExpiresAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(assetId());
        hashCode = 31 * hashCode + Objects.hashCode(dataSetId());
        hashCode = 31 * hashCode + Objects.hashCode(revisionId());
        hashCode = 31 * hashCode + Objects.hashCode(signedUrl());
        hashCode = 31 * hashCode + Objects.hashCode(signedUrlExpiresAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportAssetToSignedUrlResponseDetails)) {
            return false;
        }
        ExportAssetToSignedUrlResponseDetails other = (ExportAssetToSignedUrlResponseDetails) obj;
        return Objects.equals(assetId(), other.assetId()) && Objects.equals(dataSetId(), other.dataSetId())
                && Objects.equals(revisionId(), other.revisionId()) && Objects.equals(signedUrl(), other.signedUrl())
                && Objects.equals(signedUrlExpiresAt(), other.signedUrlExpiresAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportAssetToSignedUrlResponseDetails").add("AssetId", assetId()).add("DataSetId", dataSetId())
                .add("RevisionId", revisionId()).add("SignedUrl", signedUrl()).add("SignedUrlExpiresAt", signedUrlExpiresAt())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssetId":
            return Optional.ofNullable(clazz.cast(assetId()));
        case "DataSetId":
            return Optional.ofNullable(clazz.cast(dataSetId()));
        case "RevisionId":
            return Optional.ofNullable(clazz.cast(revisionId()));
        case "SignedUrl":
            return Optional.ofNullable(clazz.cast(signedUrl()));
        case "SignedUrlExpiresAt":
            return Optional.ofNullable(clazz.cast(signedUrlExpiresAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportAssetToSignedUrlResponseDetails, T> g) {
        return obj -> g.apply((ExportAssetToSignedUrlResponseDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExportAssetToSignedUrlResponseDetails> {
        /**
         * <p>
         * The unique identifier for the asset associated with this export job.
         * </p>
         * 
         * @param assetId
         *        The unique identifier for the asset associated with this export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetId(String assetId);

        /**
         * <p>
         * The unique identifier for the data set associated with this export job.
         * </p>
         * 
         * @param dataSetId
         *        The unique identifier for the data set associated with this export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetId(String dataSetId);

        /**
         * <p>
         * The unique identifier for the revision associated with this export response.
         * </p>
         * 
         * @param revisionId
         *        The unique identifier for the revision associated with this export response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionId(String revisionId);

        /**
         * <p>
         * The signed URL for the export request.
         * </p>
         * 
         * @param signedUrl
         *        The signed URL for the export request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signedUrl(String signedUrl);

        /**
         * <p>
         * The date and time that the signed URL expires, in ISO 8601 format.
         * </p>
         * 
         * @param signedUrlExpiresAt
         *        The date and time that the signed URL expires, in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signedUrlExpiresAt(Instant signedUrlExpiresAt);
    }

    static final class BuilderImpl implements Builder {
        private String assetId;

        private String dataSetId;

        private String revisionId;

        private String signedUrl;

        private Instant signedUrlExpiresAt;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportAssetToSignedUrlResponseDetails model) {
            assetId(model.assetId);
            dataSetId(model.dataSetId);
            revisionId(model.revisionId);
            signedUrl(model.signedUrl);
            signedUrlExpiresAt(model.signedUrlExpiresAt);
        }

        public final String getAssetId() {
            return assetId;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final String getDataSetId() {
            return dataSetId;
        }

        public final void setDataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
        }

        @Override
        public final Builder dataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
            return this;
        }

        public final String getRevisionId() {
            return revisionId;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final String getSignedUrl() {
            return signedUrl;
        }

        public final void setSignedUrl(String signedUrl) {
            this.signedUrl = signedUrl;
        }

        @Override
        public final Builder signedUrl(String signedUrl) {
            this.signedUrl = signedUrl;
            return this;
        }

        public final Instant getSignedUrlExpiresAt() {
            return signedUrlExpiresAt;
        }

        public final void setSignedUrlExpiresAt(Instant signedUrlExpiresAt) {
            this.signedUrlExpiresAt = signedUrlExpiresAt;
        }

        @Override
        public final Builder signedUrlExpiresAt(Instant signedUrlExpiresAt) {
            this.signedUrlExpiresAt = signedUrlExpiresAt;
            return this;
        }

        @Override
        public ExportAssetToSignedUrlResponseDetails build() {
            return new ExportAssetToSignedUrlResponseDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
