/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the job error.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Details implements SdkPojo, Serializable, ToCopyableBuilder<Details.Builder, Details> {
    private static final SdkField<ImportAssetFromSignedUrlJobErrorDetails> IMPORT_ASSET_FROM_SIGNED_URL_JOB_ERROR_DETAILS_FIELD = SdkField
            .<ImportAssetFromSignedUrlJobErrorDetails> builder(MarshallingType.SDK_POJO)
            .memberName("ImportAssetFromSignedUrlJobErrorDetails")
            .getter(getter(Details::importAssetFromSignedUrlJobErrorDetails))
            .setter(setter(Builder::importAssetFromSignedUrlJobErrorDetails))
            .constructor(ImportAssetFromSignedUrlJobErrorDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ImportAssetFromSignedUrlJobErrorDetails").build()).build();

    private static final SdkField<List<AssetSourceEntry>> IMPORT_ASSETS_FROM_S3_JOB_ERROR_DETAILS_FIELD = SdkField
            .<List<AssetSourceEntry>> builder(MarshallingType.LIST)
            .memberName("ImportAssetsFromS3JobErrorDetails")
            .getter(getter(Details::importAssetsFromS3JobErrorDetails))
            .setter(setter(Builder::importAssetsFromS3JobErrorDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportAssetsFromS3JobErrorDetails")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetSourceEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetSourceEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            IMPORT_ASSET_FROM_SIGNED_URL_JOB_ERROR_DETAILS_FIELD, IMPORT_ASSETS_FROM_S3_JOB_ERROR_DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final ImportAssetFromSignedUrlJobErrorDetails importAssetFromSignedUrlJobErrorDetails;

    private final List<AssetSourceEntry> importAssetsFromS3JobErrorDetails;

    private Details(BuilderImpl builder) {
        this.importAssetFromSignedUrlJobErrorDetails = builder.importAssetFromSignedUrlJobErrorDetails;
        this.importAssetsFromS3JobErrorDetails = builder.importAssetsFromS3JobErrorDetails;
    }

    /**
     * <p>
     * Information about the job error.
     * </p>
     * 
     * @return Information about the job error.
     */
    public final ImportAssetFromSignedUrlJobErrorDetails importAssetFromSignedUrlJobErrorDetails() {
        return importAssetFromSignedUrlJobErrorDetails;
    }

    /**
     * For responses, this returns true if the service returned a value for the ImportAssetsFromS3JobErrorDetails
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasImportAssetsFromS3JobErrorDetails() {
        return importAssetsFromS3JobErrorDetails != null && !(importAssetsFromS3JobErrorDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details about the job error.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImportAssetsFromS3JobErrorDetails}
     * method.
     * </p>
     * 
     * @return Details about the job error.
     */
    public final List<AssetSourceEntry> importAssetsFromS3JobErrorDetails() {
        return importAssetsFromS3JobErrorDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(importAssetFromSignedUrlJobErrorDetails());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasImportAssetsFromS3JobErrorDetails() ? importAssetsFromS3JobErrorDetails() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Details)) {
            return false;
        }
        Details other = (Details) obj;
        return Objects.equals(importAssetFromSignedUrlJobErrorDetails(), other.importAssetFromSignedUrlJobErrorDetails())
                && hasImportAssetsFromS3JobErrorDetails() == other.hasImportAssetsFromS3JobErrorDetails()
                && Objects.equals(importAssetsFromS3JobErrorDetails(), other.importAssetsFromS3JobErrorDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("Details")
                .add("ImportAssetFromSignedUrlJobErrorDetails", importAssetFromSignedUrlJobErrorDetails())
                .add("ImportAssetsFromS3JobErrorDetails",
                        hasImportAssetsFromS3JobErrorDetails() ? importAssetsFromS3JobErrorDetails() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImportAssetFromSignedUrlJobErrorDetails":
            return Optional.ofNullable(clazz.cast(importAssetFromSignedUrlJobErrorDetails()));
        case "ImportAssetsFromS3JobErrorDetails":
            return Optional.ofNullable(clazz.cast(importAssetsFromS3JobErrorDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Details, T> g) {
        return obj -> g.apply((Details) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Details> {
        /**
         * <p>
         * Information about the job error.
         * </p>
         * 
         * @param importAssetFromSignedUrlJobErrorDetails
         *        Information about the job error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importAssetFromSignedUrlJobErrorDetails(
                ImportAssetFromSignedUrlJobErrorDetails importAssetFromSignedUrlJobErrorDetails);

        /**
         * <p>
         * Information about the job error.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ImportAssetFromSignedUrlJobErrorDetails.Builder} avoiding the need to create one manually via
         * {@link ImportAssetFromSignedUrlJobErrorDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImportAssetFromSignedUrlJobErrorDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #importAssetFromSignedUrlJobErrorDetails(ImportAssetFromSignedUrlJobErrorDetails)}.
         * 
         * @param importAssetFromSignedUrlJobErrorDetails
         *        a consumer that will call methods on {@link ImportAssetFromSignedUrlJobErrorDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #importAssetFromSignedUrlJobErrorDetails(ImportAssetFromSignedUrlJobErrorDetails)
         */
        default Builder importAssetFromSignedUrlJobErrorDetails(
                Consumer<ImportAssetFromSignedUrlJobErrorDetails.Builder> importAssetFromSignedUrlJobErrorDetails) {
            return importAssetFromSignedUrlJobErrorDetails(ImportAssetFromSignedUrlJobErrorDetails.builder()
                    .applyMutation(importAssetFromSignedUrlJobErrorDetails).build());
        }

        /**
         * <p>
         * Details about the job error.
         * </p>
         * 
         * @param importAssetsFromS3JobErrorDetails
         *        Details about the job error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importAssetsFromS3JobErrorDetails(Collection<AssetSourceEntry> importAssetsFromS3JobErrorDetails);

        /**
         * <p>
         * Details about the job error.
         * </p>
         * 
         * @param importAssetsFromS3JobErrorDetails
         *        Details about the job error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importAssetsFromS3JobErrorDetails(AssetSourceEntry... importAssetsFromS3JobErrorDetails);

        /**
         * <p>
         * Details about the job error.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.dataexchange.model.AssetSourceEntry.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.dataexchange.model.AssetSourceEntry#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.dataexchange.model.AssetSourceEntry.Builder#build()} is called
         * immediately and its result is passed to {@link #importAssetsFromS3JobErrorDetails(List<AssetSourceEntry>)}.
         * 
         * @param importAssetsFromS3JobErrorDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.dataexchange.model.AssetSourceEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #importAssetsFromS3JobErrorDetails(java.util.Collection<AssetSourceEntry>)
         */
        Builder importAssetsFromS3JobErrorDetails(Consumer<AssetSourceEntry.Builder>... importAssetsFromS3JobErrorDetails);
    }

    static final class BuilderImpl implements Builder {
        private ImportAssetFromSignedUrlJobErrorDetails importAssetFromSignedUrlJobErrorDetails;

        private List<AssetSourceEntry> importAssetsFromS3JobErrorDetails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Details model) {
            importAssetFromSignedUrlJobErrorDetails(model.importAssetFromSignedUrlJobErrorDetails);
            importAssetsFromS3JobErrorDetails(model.importAssetsFromS3JobErrorDetails);
        }

        public final ImportAssetFromSignedUrlJobErrorDetails.Builder getImportAssetFromSignedUrlJobErrorDetails() {
            return importAssetFromSignedUrlJobErrorDetails != null ? importAssetFromSignedUrlJobErrorDetails.toBuilder() : null;
        }

        public final void setImportAssetFromSignedUrlJobErrorDetails(
                ImportAssetFromSignedUrlJobErrorDetails.BuilderImpl importAssetFromSignedUrlJobErrorDetails) {
            this.importAssetFromSignedUrlJobErrorDetails = importAssetFromSignedUrlJobErrorDetails != null ? importAssetFromSignedUrlJobErrorDetails
                    .build() : null;
        }

        @Override
        public final Builder importAssetFromSignedUrlJobErrorDetails(
                ImportAssetFromSignedUrlJobErrorDetails importAssetFromSignedUrlJobErrorDetails) {
            this.importAssetFromSignedUrlJobErrorDetails = importAssetFromSignedUrlJobErrorDetails;
            return this;
        }

        public final List<AssetSourceEntry.Builder> getImportAssetsFromS3JobErrorDetails() {
            List<AssetSourceEntry.Builder> result = ListOfAssetSourceEntryCopier
                    .copyToBuilder(this.importAssetsFromS3JobErrorDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImportAssetsFromS3JobErrorDetails(
                Collection<AssetSourceEntry.BuilderImpl> importAssetsFromS3JobErrorDetails) {
            this.importAssetsFromS3JobErrorDetails = ListOfAssetSourceEntryCopier
                    .copyFromBuilder(importAssetsFromS3JobErrorDetails);
        }

        @Override
        public final Builder importAssetsFromS3JobErrorDetails(Collection<AssetSourceEntry> importAssetsFromS3JobErrorDetails) {
            this.importAssetsFromS3JobErrorDetails = ListOfAssetSourceEntryCopier.copy(importAssetsFromS3JobErrorDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importAssetsFromS3JobErrorDetails(AssetSourceEntry... importAssetsFromS3JobErrorDetails) {
            importAssetsFromS3JobErrorDetails(Arrays.asList(importAssetsFromS3JobErrorDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importAssetsFromS3JobErrorDetails(
                Consumer<AssetSourceEntry.Builder>... importAssetsFromS3JobErrorDetails) {
            importAssetsFromS3JobErrorDetails(Stream.of(importAssetsFromS3JobErrorDetails)
                    .map(c -> AssetSourceEntry.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Details build() {
            return new Details(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
