/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the response of the operation to create an S3 data access from an S3 bucket.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateS3DataAccessFromS3BucketResponseDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<CreateS3DataAccessFromS3BucketResponseDetails.Builder, CreateS3DataAccessFromS3BucketResponseDetails> {
    private static final SdkField<S3DataAccessAssetSourceEntry> ASSET_SOURCE_FIELD = SdkField
            .<S3DataAccessAssetSourceEntry> builder(MarshallingType.SDK_POJO).memberName("AssetSource")
            .getter(getter(CreateS3DataAccessFromS3BucketResponseDetails::assetSource)).setter(setter(Builder::assetSource))
            .constructor(S3DataAccessAssetSourceEntry::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssetSource").build()).build();

    private static final SdkField<String> DATA_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSetId").getter(getter(CreateS3DataAccessFromS3BucketResponseDetails::dataSetId))
            .setter(setter(Builder::dataSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetId").build()).build();

    private static final SdkField<String> REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RevisionId").getter(getter(CreateS3DataAccessFromS3BucketResponseDetails::revisionId))
            .setter(setter(Builder::revisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevisionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_SOURCE_FIELD,
            DATA_SET_ID_FIELD, REVISION_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final S3DataAccessAssetSourceEntry assetSource;

    private final String dataSetId;

    private final String revisionId;

    private CreateS3DataAccessFromS3BucketResponseDetails(BuilderImpl builder) {
        this.assetSource = builder.assetSource;
        this.dataSetId = builder.dataSetId;
        this.revisionId = builder.revisionId;
    }

    /**
     * <p>
     * Details about the asset source from an Amazon S3 bucket.
     * </p>
     * 
     * @return Details about the asset source from an Amazon S3 bucket.
     */
    public final S3DataAccessAssetSourceEntry assetSource() {
        return assetSource;
    }

    /**
     * <p>
     * The unique identifier for this data set.
     * </p>
     * 
     * @return The unique identifier for this data set.
     */
    public final String dataSetId() {
        return dataSetId;
    }

    /**
     * <p>
     * The unique identifier for the revision.
     * </p>
     * 
     * @return The unique identifier for the revision.
     */
    public final String revisionId() {
        return revisionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(assetSource());
        hashCode = 31 * hashCode + Objects.hashCode(dataSetId());
        hashCode = 31 * hashCode + Objects.hashCode(revisionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateS3DataAccessFromS3BucketResponseDetails)) {
            return false;
        }
        CreateS3DataAccessFromS3BucketResponseDetails other = (CreateS3DataAccessFromS3BucketResponseDetails) obj;
        return Objects.equals(assetSource(), other.assetSource()) && Objects.equals(dataSetId(), other.dataSetId())
                && Objects.equals(revisionId(), other.revisionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateS3DataAccessFromS3BucketResponseDetails").add("AssetSource", assetSource())
                .add("DataSetId", dataSetId()).add("RevisionId", revisionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssetSource":
            return Optional.ofNullable(clazz.cast(assetSource()));
        case "DataSetId":
            return Optional.ofNullable(clazz.cast(dataSetId()));
        case "RevisionId":
            return Optional.ofNullable(clazz.cast(revisionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateS3DataAccessFromS3BucketResponseDetails, T> g) {
        return obj -> g.apply((CreateS3DataAccessFromS3BucketResponseDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateS3DataAccessFromS3BucketResponseDetails> {
        /**
         * <p>
         * Details about the asset source from an Amazon S3 bucket.
         * </p>
         * 
         * @param assetSource
         *        Details about the asset source from an Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetSource(S3DataAccessAssetSourceEntry assetSource);

        /**
         * <p>
         * Details about the asset source from an Amazon S3 bucket.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3DataAccessAssetSourceEntry.Builder}
         * avoiding the need to create one manually via {@link S3DataAccessAssetSourceEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3DataAccessAssetSourceEntry.Builder#build()} is called
         * immediately and its result is passed to {@link #assetSource(S3DataAccessAssetSourceEntry)}.
         * 
         * @param assetSource
         *        a consumer that will call methods on {@link S3DataAccessAssetSourceEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetSource(S3DataAccessAssetSourceEntry)
         */
        default Builder assetSource(Consumer<S3DataAccessAssetSourceEntry.Builder> assetSource) {
            return assetSource(S3DataAccessAssetSourceEntry.builder().applyMutation(assetSource).build());
        }

        /**
         * <p>
         * The unique identifier for this data set.
         * </p>
         * 
         * @param dataSetId
         *        The unique identifier for this data set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetId(String dataSetId);

        /**
         * <p>
         * The unique identifier for the revision.
         * </p>
         * 
         * @param revisionId
         *        The unique identifier for the revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionId(String revisionId);
    }

    static final class BuilderImpl implements Builder {
        private S3DataAccessAssetSourceEntry assetSource;

        private String dataSetId;

        private String revisionId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateS3DataAccessFromS3BucketResponseDetails model) {
            assetSource(model.assetSource);
            dataSetId(model.dataSetId);
            revisionId(model.revisionId);
        }

        public final S3DataAccessAssetSourceEntry.Builder getAssetSource() {
            return assetSource != null ? assetSource.toBuilder() : null;
        }

        public final void setAssetSource(S3DataAccessAssetSourceEntry.BuilderImpl assetSource) {
            this.assetSource = assetSource != null ? assetSource.build() : null;
        }

        @Override
        public final Builder assetSource(S3DataAccessAssetSourceEntry assetSource) {
            this.assetSource = assetSource;
            return this;
        }

        public final String getDataSetId() {
            return dataSetId;
        }

        public final void setDataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
        }

        @Override
        public final Builder dataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
            return this;
        }

        public final String getRevisionId() {
            return revisionId;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        @Override
        public CreateS3DataAccessFromS3BucketResponseDetails build() {
            return new CreateS3DataAccessFromS3BucketResponseDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
